/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2014  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.24 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software has been licensed to  ARM LIMITED whose registered office
is situated at  110 Fulbourn Road,  Cambridge CB1 9NJ,  England solely
for  the  purposes  of  creating  libraries  for  ARM7, ARM9, Cortex-M
series,  and   Cortex-R4   processor-based  devices,  sublicensed  and
distributed as part of the  MDK-ARM  Professional  under the terms and
conditions  of  the   End  User  License  supplied  with  the  MDK-ARM
Professional. 
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
File        : GUIDRV_TemplateI_SetFuncXXX.c
Purpose     : Display driver, Controller specific functions
----------------------------------------------------------------------
Currently known controllers supported by this module:

- Xx XXX:            XXXX
---------------------------END-OF-HEADER------------------------------
*/

#include <stddef.h>

#include "GUI_Private.h"
#include "GUIDRV_TemplateI_Private.h"

#if (!defined(WIN32) | defined(LCD_SIMCONTROLLER))

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/
/*********************************************************************
*
*       _Init
*/
static void _Init(GUI_DEVICE * pDevice) {
  GUI_USE_PARA(pDevice);
  //
  // TBD: Controller specific initialization
  //
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       GUIDRV_TemplateI_SetFuncXXX
*/
void GUIDRV_TemplateI_SetFuncXXX(GUI_DEVICE * pDevice) {
  DRIVER_CONTEXT * pContext;
  
  pContext = (DRIVER_CONTEXT *)pDevice->u.pContext;
  if (pContext) {
    pContext->pfInit = _Init;
  }
}

#else

void GUIDRV_TemplateI_SetController_C(void);   // Avoid empty object files
void GUIDRV_TemplateI_SetController_C(void) {}

#endif

/*************************** End of file ****************************/
