/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2014  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.24 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software has been licensed to  ARM LIMITED whose registered office
is situated at  110 Fulbourn Road,  Cambridge CB1 9NJ,  England solely
for  the  purposes  of  creating  libraries  for  ARM7, ARM9, Cortex-M
series,  and   Cortex-R4   processor-based  devices,  sublicensed  and
distributed as part of the  MDK-ARM  Professional  under the terms and
conditions  of  the   End  User  License  supplied  with  the  MDK-ARM
Professional. 
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
File        : Logo_MasterCard.c
Purpose     : Bitmap file
---------------------------END-OF-HEADER------------------------------
*/

#include <stdlib.h>

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/*   Palette
The following are the entries of the palette table.
Every entry is a 32-bit value (of which 24 bits are actually used)
the lower   8 bits represent the Red component,
the middle  8 bits represent the Green component,
the highest 8 bits (of the 24 bits used) represent the Blue component
as follows:   0xBBGGRR
*/

static GUI_CONST_STORAGE GUI_COLOR ColorsLogo_MasterCard[] = {
     0x522020,0x521018,0x4A1018,0x4A1010
    ,0x411018,0x411818,0x391820,0x311831
    ,0x291831,0x311829,0x411820,0x392029
    ,0x392031,0x411010,0x4A0810,0x410810
    ,0x390810,0x291020,0x201039,0x181062
    ,0x101883,0x10189C,0x0818B4,0x0820BD
    ,0x10187B,0x410808,0x390010,0x292941
    ,0x204162,0x295A8B,0x297BAC,0x2983B4
    ,0x298BBD,0x298BCD,0x205A8B,0x293141
    ,0x391829,0x310818,0x200831,0x181862
    ,0x08189C,0x0020CD,0x0020DE,0x0020E6
    ,0x18186A,0x390818,0x311018,0x202941
    ,0x204A73,0x2083BD,0x29ACEE,0x29B4F6
    ,0x29BDFF,0x29B4FF,0x208BBD,0x296283
    ,0x310810,0x291031,0x10188B,0x0818C5
    ,0x0020D5,0x101894,0x291039,0x293152
    ,0x2073A4,0x29A4DE,0x391018,0x20104A
    ,0x0818A4,0x0818AC,0x2994CD,0x209CD5
    ,0x315273,0x310820,0x290829,0x310008
    ,0x20294A,0x2073AC,0x31314A,0x0020BD
    ,0x0020C5,0x101862,0x291829,0x205A83
    ,0x29739C,0x4A0808,0x311020,0x201829
    ,0x312039,0x1020A4,0x20A4E6,0x105AE6
    ,0x293962,0x410008,0x290818,0x0018DE
    ,0x186AE6,0x29395A,0x0831DE,0x20A4F6
    ,0x20A4EE,0x29ACF6,0x299CDE,0x29314A
    ,0x0029DE,0x0841E6,0x312031,0x18104A
    ,0x411020,0x0829DE,0x208BEE,0x29628B
    ,0x390808,0x2094EE,0x209CEE,0x392039
    ,0x201041,0x081894,0x084AE6,0x29BDF6
    ,0x313952,0x18105A,0x0839DE,0x1052E6
    ,0x2083EE,0x298BC5,0x393141,0x311839
    ,0x104AE6,0x299CCD,0x391020,0x0820A4
    ,0x294162,0x3141E6,0x4A5AE6,0x415AE6
    ,0x4152E6,0x2941E6,0x3952E6,0x1831DE
    ,0x106AEE,0x20B4F6,0x5AC5F6,0x8BD5F6
    ,0x94DEF6,0x83D5F6,0x4AC5F6,0x39BDF6
    ,0x41BDF6,0x4ABDF6,0x31BDF6,0x296A9C
    ,0x20185A,0x2039D5,0xC5CDEE,0xFFFFFF
    ,0xF6FFF6,0xEEEEF6,0x1031DE,0x3141DE
    ,0xCDD5F6,0xFFFFF6,0x4A62E6,0x294AE6
    ,0x207BEE,0x299CEE,0x2994EE,0x29A4EE
    ,0x73CDF6,0xCDEEFF,0xF6FFFF,0x31B4F6
    ,0xCDEEF6,0xF6F6FF,0x209CDE,0x410818
    ,0x41418B,0xDED5D5,0x626294,0xEEEEEE
    ,0xE6EEF6,0xEEEEFF,0x94BDF6,0x2041DE
    ,0x1839DE,0x1841DE,0x1039DE,0x1041DE
    ,0x184ADE,0x1862E6,0xEEF6F6,0xD5EEF6
    ,0x529CC5,0xD5CDCD,0x412029,0x5A4A62
    ,0xE6E6DE,0x1831E6,0x0018BD,0xA49494
    ,0x5A6AE6,0x8394EE,0xA4ACF6,0xACB4F6
    ,0x949CEE,0x1029DE,0x0820DE,0x7383EE
    ,0x9CA4EE,0xA4ACEE,0x738BEE,0x1829C5
    ,0x948BA4,0xBDD5F6,0x6A83EE,0x2041E6
    ,0x1839E6,0x4152DE,0xA4B4F6,0x94A4EE
    ,0x5A73EE,0x5A73E6,0x6273EE,0x4162E6
    ,0x526AE6,0x6A8BEE,0x7BACC5,0xCDCDCD
    ,0xA4DEF6,0x52C5F6,0x9CDEF6,0x6ACDF6
    ,0x62CDF6,0x62C5F6,0x5A6A83,0xDEF6FF
    ,0x393952,0x0018CD,0x7B6A6A,0xF6F6EE
    ,0x182094,0xD5DEF6,0x6273E6,0xDEDEF6
    ,0xE6EEFF,0x2031AC,0xA49CA4,0xDEEEFF
    ,0x205AE6,0x7B8BEE,0x839CEE,0x3952DE
    ,0xE6E6F6,0xA4CDF6,0xE6E6FF,0xBDB4B4
};

static GUI_CONST_STORAGE GUI_LOGPALETTE PalLogo_MasterCard = {
  256,	/* number of entries */
  0, 	/* No transparency */
  &ColorsLogo_MasterCard[0]
};

static GUI_CONST_STORAGE unsigned char acLogo_MasterCard[] = {
  0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x07, 0x07, 0x08, 0x07, 0x09, 0x0A, 0x04, 0x04, 0x02, 0x02, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x04, 0x04, 0x0A, 0x0B, 0x0B, 0x0C, 0x0C, 0x0B, 0x0A, 0x04, 0x0D, 0x03, 0x02, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x17, 0x17, 0x17, 0x16, 0x15, 0x18, 0x13, 0x12, 0x11, 0x10, 0x0F, 
        0x0F, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x19, 0x1A, 0x11, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20, 0x21, 0x21, 0x1F, 0x1E, 0x22, 0x1C, 0x23, 0x24, 0x10, 0x19, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2B, 0x2B, 0x2A, 0x29, 0x28, 0x2C, 
        0x26, 0x2D, 0x0F, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x34, 0x34, 0x35, 0x33, 0x33, 0x33, 0x33, 0x35, 0x34, 0x34, 0x33, 0x32, 0x36, 0x37, 0x1B, 
        0x2E, 0x0F, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x19, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x3B, 0x3D, 0x3E, 0x25, 0x19, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x10, 0x3F, 0x40, 0x41, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x41, 
        0x1E, 0x3F, 0x42, 0x19, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x2D, 0x43, 0x44, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x45, 0x43, 0x2D, 0x0F, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x10, 0x11, 0x30, 0x46, 0x35, 0x34, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x47, 0x48, 0x0C, 0x0F, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x49, 0x3A, 0x29, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x29, 0x3A, 0x4A, 0x0F, 0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x4B, 0x4C, 0x4D, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x20, 0x4E, 0x0F, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x10, 0x27, 0x4F, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2B, 0x50, 0x51, 0x2D, 0x0E, 0x0E, 0x0F, 0x52, 0x53, 0x33, 0x35, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x54, 0x0A, 0x55, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x56, 0x2C, 0x3C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x3C, 0x2C, 0x2D, 0x10, 0x57, 0x1F, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x58, 0x19, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x11, 0x59, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x44, 0x1C, 0x46, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x35, 0x5A, 0x3F, 0x0F, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x4A, 0x28, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x5B, 0x32, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x41, 0x5C, 0x5D, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x5E, 0x16, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x5F, 0x60, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x61, 0x0F, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x25, 0x14, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x62, 0x63, 0x64, 0x65, 0x65, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x66, 0x67, 0x19, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x10, 0x3A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x68, 0x68, 0x2A, 0x69, 0x65, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x5A, 0x6A, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x6B, 0x3C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x5F, 0x60, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x6C, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x3E, 0x3B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x68, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x62, 0x6E, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x6F, 0x19, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x70, 0x3A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x5F, 0x69, 0x71, 0x72, 0x71, 0x71, 0x71, 0x71, 0x71, 0x71, 0x71, 0x71, 0x63, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x73, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0F, 0x74, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x5F, 0x6E, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x04, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x25, 0x75, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x76, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x78, 0x55, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x79, 0x3C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x7A, 0x5B, 0x7B, 0x7B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x7C, 0x77, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x7D, 0x0F, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x10, 0x28, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x5F, 0x62, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x7E, 0x55, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x7F, 0x3C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x5F, 0x6E, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x54, 0x0D, 0x0E, 0x01,
  0x01, 0x0E, 0x0F, 0x2C, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x7B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x80, 0x6E, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x81, 0x0C, 0x0E, 0x01,
  0x01, 0x0E, 0x82, 0x83, 0x2A, 0x2A, 0x2A, 0x2A, 0x5F, 0x5F, 0x5F, 0x5F, 0x2A, 0x2A, 0x2A, 0x2A, 0x5F, 0x5F, 0x2A, 0x5F, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x69, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x84, 0x55, 0x01,
  0x01, 0x0E, 0x3E, 0x29, 0x2A, 0x2A, 0x2A, 0x85, 0x86, 0x86, 0x87, 0x88, 0x2A, 0x2A, 0x2A, 0x89, 0x86, 0x86, 0x88, 0x8A, 0x8B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x5F, 
        0x5F, 0x8C, 0x77, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x8D, 0x33, 0x8E, 0x8F, 0x90, 0x91, 0x92, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x8D, 0x93, 0x94, 0x95, 0x96, 0x33, 0x97, 0x5D, 0x01,
  0x01, 0x55, 0x98, 0x2A, 0x2A, 0x2A, 0x99, 0x9A, 0x9B, 0x9B, 0x9C, 0x9D, 0x9E, 0x5F, 0x9F, 0xA0, 0x9B, 0x9B, 0x9C, 0xA1, 0xA2, 0x5F, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x6D, 0x88, 0x86, 
        0xA3, 0xA4, 0x72, 0xA5, 0x72, 0x71, 0xA6, 0xA6, 0xA6, 0x72, 0x72, 0x71, 0x72, 0xA5, 0xA7, 0xA7, 0xA7, 0xA7, 0xA7, 0x32, 0x33, 0x33, 0xA8, 0xA9, 0x9B, 0x9B, 0x9B, 0x9B, 0xAA, 0xA9, 0x77, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0xAB, 0xAC, 0xAD, 0xAA, 0x91, 0x8D, 0xAE, 0xAF, 0x01,
  0x01, 0x19, 0x14, 0x2A, 0x2A, 0x2B, 0xB0, 0xB1, 0xAA, 0xAA, 0x9B, 0x9D, 0x9E, 0x5F, 0xB2, 0xB3, 0x9B, 0x9B, 0x9B, 0x9C, 0x89, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0xA2, 0xB4, 0xB5, 
        0xB6, 0xB7, 0xB8, 0xB9, 0xB9, 0xB9, 0xB8, 0xB8, 0xB8, 0xBA, 0xBB, 0xBA, 0xBA, 0xB9, 0xBA, 0xB9, 0xBC, 0xBC, 0xB9, 0xBD, 0x77, 0xA8, 0xBE, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0xBF, 0x33, 0x33, 0x8D, 0x8D, 0x8D, 0x8D, 0x8D, 0x33, 0x33, 0x33, 0x33, 
        0x8D, 0x8D, 0x33, 0x33, 0x8D, 0x8D, 0x33, 0x33, 0x8D, 0x8D, 0x8D, 0x33, 0xC0, 0xC1, 0x9B, 0xAD, 0xA8, 0x8D, 0x33, 0xC2, 0x01,
  0x01, 0x19, 0x45, 0x2A, 0x2A, 0x2A, 0xC3, 0xC4, 0x9B, 0x9B, 0x9B, 0xBE, 0xC5, 0xC6, 0xC7, 0x9B, 0x9B, 0x9B, 0x9B, 0x9D, 0x8B, 0x8B, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xC8, 0xCD, 0x2A, 0x2A, 0xCE, 0x8A, 0xCF, 0xD0, 0xD1, 0xCC, 0xD2, 0xD3, 0xD4, 0x9B, 0x9B, 
        0xD5, 0xD6, 0xD7, 0xD8, 0xB8, 0xD9, 0xC9, 0xDA, 0xDB, 0xDC, 0xB9, 0x9E, 0x9E, 0xB8, 0xDD, 0xDE, 0xDF, 0xB8, 0xE0, 0xE1, 0xE2, 0xE3, 0x9B, 0x9B, 0x9B, 0x9B, 0xBE, 0xBE, 0x9B, 0xE4, 0x33, 0xE5, 0x91, 0xE6, 0xE4, 0xE6, 0xE7, 0x93, 0x33, 0x33, 0x93, 
        0xE8, 0xE9, 0x95, 0x96, 0xE7, 0x95, 0x33, 0x94, 0xA8, 0x8F, 0xE7, 0x93, 0xEA, 0xC1, 0x9B, 0xEB, 0xE5, 0x33, 0x34, 0xEC, 0x02,
  0x01, 0x0F, 0x17, 0x2A, 0x2A, 0xED, 0xEE, 0xEF, 0xAA, 0x9B, 0x9B, 0xBE, 0xD8, 0xF0, 0xC1, 0x9B, 0x9B, 0x9B, 0x9B, 0xF1, 0x8B, 0xD0, 0xB5, 0x9B, 0x9B, 0x9B, 0x9B, 0xB5, 0xC9, 0xCD, 0xCE, 0xF2, 0xF3, 0xAD, 0x9B, 0x9B, 0x9B, 0xF4, 0xF5, 0xF6, 0x9B, 0x9B, 
        0xAA, 0xF7, 0xF8, 0xB8, 0xF9, 0xF1, 0xAA, 0x9B, 0x9B, 0xF4, 0xFA, 0xB7, 0xD8, 0xFB, 0xFC, 0xB5, 0xFD, 0xE1, 0xFE, 0xFF, 0xEE, 0xB3, 0x9B, 0x9B, 0xF1, 0xC7, 0xEE, 0xEE, 0xF6, 0xE5, 0xA8, 0xEB, 0xAA, 0x9B, 0x9B, 0x9B, 0xAD, 0xA9, 0x93, 0x8D, 0x91, 
        0xAD, 0xBE, 0xE4, 0xE4, 0xB4, 0x92, 0x92, 0xA9, 0xAD, 0x9B, 0xAD, 0xD5, 0xEE, 0xB3, 0x9B, 0xAC, 0x93, 0x33, 0x34, 0x48, 0x02,
  0x01, 0x82, 0x2A, 0x2A, 0x2A, 0x44, 0xC7, 0x9B, 0x9B, 0xB3, 0x9B, 0xBE, 0x99, 0xB0, 0x9B, 0xBE, 0xB3, 0x9B, 0x9B, 0xDA, 0xF5, 0xB1, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0xAD, 0xE0, 0x86, 0xFC, 0x9B, 0xAA, 0x9B, 0x9B, 0x9B, 0xA0, 0xF0, 0xE3, 0x9B, 0x9B, 
        0x9B, 0xAC, 0x80, 0xD6, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0xAD, 0xFA, 0xCD, 0xB2, 0x9B, 0x9B, 0xAD, 0xAD, 0xB3, 0xEE, 0xC1, 0x9B, 0xAA, 0x8F, 0x46, 0x21, 0x46, 0x54, 0x48, 0x41, 0xF6, 0xBE, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0xE6, 0xAB, 0xD4, 
        0xB3, 0x9B, 0xAA, 0x9B, 0xAC, 0x8E, 0xEB, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0xB1, 0x9B, 0x9B, 0xE4, 0x33, 0x33, 0x34, 0x6F, 0x02,
  0x01, 0x09, 0x2A, 0x2A, 0x2A, 0x3A, 0xF6, 0x9B, 0xBE, 0xFF, 0xBE, 0xAD, 0xF5, 0xD4, 0x9B, 0xB1, 0xB1, 0x9B, 0x9B, 0xC9, 0xB0, 0xE3, 0xC1, 0xE3, 0xFF, 0xC1, 0x9B, 0x9B, 0x9B, 0xFA, 0xD4, 0x9B, 0x9B, 0xAA, 0xB1, 0xE3, 0x9A, 0xDE, 0xB0, 0xC1, 0x9B, 0x9B, 
        0xAD, 0xB6, 0x8A, 0xA0, 0x9B, 0x9B, 0xC4, 0xFF, 0xC4, 0x9B, 0x9B, 0xD5, 0xD3, 0xB2, 0x9B, 0x9B, 0x9B, 0x9B, 0xB1, 0xEE, 0xBE, 0x9B, 0xA9, 0x94, 0x33, 0x33, 0x33, 0x33, 0x32, 0x94, 0xC7, 0xB3, 0xB1, 0xC1, 0xB1, 0xB3, 0x9B, 0x9B, 0xA9, 0x95, 0xEE, 
        0xBE, 0x9B, 0x9B, 0x9B, 0xE4, 0xE3, 0xBE, 0x9B, 0x9B, 0x9B, 0xA1, 0x9B, 0x9B, 0x9B, 0x9B, 0xE6, 0x33, 0x33, 0x34, 0x54, 0x0A,
  0x02, 0x3E, 0x2A, 0x2A, 0x2A, 0x2C, 0xE3, 0x9B, 0xB3, 0xC7, 0xBE, 0xAA, 0xB2, 0xE3, 0xBE, 0xC7, 0xB3, 0x9B, 0xAD, 0xE0, 0x98, 0xEC, 0x5C, 0x5C, 0x4E, 0xC2, 0xFF, 0x9B, 0x9B, 0xF6, 0xFF, 0x9B, 0x9B, 0xC4, 0x5C, 0x98, 0x18, 0x5F, 0xC3, 0xC4, 0x9B, 0xEB, 
        0xEA, 0xF5, 0xF2, 0xBE, 0x9B, 0xFD, 0xB0, 0x3E, 0xC3, 0xC4, 0x9B, 0xAC, 0xF5, 0xD4, 0x9B, 0x9B, 0x9B, 0xB1, 0xEE, 0xC7, 0x9B, 0x9B, 0xE4, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0xC0, 0xEC, 0xC3, 0xEC, 0xC3, 0x7E, 0xC3, 0xBE, 0x9B, 0xA9, 0xC0, 0xF6, 
        0x9B, 0x9B, 0x9B, 0xC4, 0xF6, 0xE3, 0x9B, 0xAA, 0xD5, 0xB2, 0xC3, 0xFF, 0xA1, 0x9B, 0x9B, 0x91, 0x33, 0x33, 0x34, 0x1E, 0x0A,
  0x02, 0x39, 0x2A, 0x2A, 0x3C, 0x5C, 0xC4, 0x9B, 0xC4, 0xEE, 0xBE, 0xAA, 0xEE, 0xC4, 0xF1, 0xEE, 0x9B, 0x9B, 0xFC, 0x87, 0x9E, 0xFB, 0xFA, 0xCB, 0x9A, 0xF6, 0xC1, 0x9B, 0x9B, 0xC7, 0xFF, 0x9B, 0x9B, 0xAD, 0xD0, 0xA2, 0x9E, 0x6D, 0xEE, 0xB3, 0x9B, 0xD5, 
        0xD3, 0xD3, 0xFF, 0x9B, 0x9B, 0xD5, 0xFA, 0xFA, 0xEE, 0xC4, 0x9B, 0xAC, 0xF5, 0xF6, 0x9B, 0x9B, 0x9A, 0xEA, 0x0C, 0xF6, 0x9B, 0x9B, 0x8F, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x81, 0xE9, 0xFD, 0xA0, 0xE3, 0xC7, 0xBE, 0x9B, 0xA9, 0xC0, 0xFF, 
        0x9B, 0x9B, 0xBF, 0xC3, 0xC3, 0xBE, 0x9B, 0xA9, 0x94, 0x81, 0x6F, 0xC3, 0xB3, 0x9B, 0x9B, 0xE8, 0x8D, 0x33, 0x35, 0x1F, 0x00,
  0x01, 0x3E, 0x2A, 0x2A, 0x3B, 0xC3, 0x9B, 0xAA, 0xB1, 0xEE, 0xBE, 0xBE, 0xFF, 0x9B, 0xD0, 0xEE, 0x9B, 0x9B, 0xF1, 0x89, 0xD2, 0xB5, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0xAD, 0xB2, 0xEE, 0xEF, 0x9B, 0x9B, 0x9B, 0xAD, 0xC9, 0xD3, 0xC7, 0x9B, 0x9B, 0xFD, 
        0xBA, 0xF5, 0xC4, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0xD5, 0xB0, 0xE3, 0x9B, 0x9B, 0xE1, 0xBA, 0x98, 0xFF, 0x9B, 0x9B, 0x91, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x94, 0xA9, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0xE4, 0xEA, 0xC1, 
        0x9B, 0xAD, 0x8E, 0x1E, 0xC7, 0x9B, 0x9B, 0xE4, 0x33, 0x33, 0x32, 0xC3, 0xB1, 0x9B, 0x9B, 0x95, 0x33, 0x33, 0x35, 0x1E, 0x00,
  0x01, 0x24, 0x2A, 0x2A, 0x16, 0xEE, 0x9B, 0xAA, 0xE3, 0xC3, 0xBE, 0x9B, 0xBE, 0xAA, 0xB2, 0xC7, 0x9B, 0x9B, 0x9A, 0x87, 0xFC, 0x9B, 0x9B, 0x9B, 0xB3, 0xB3, 0x9B, 0x9B, 0xF4, 0xD9, 0xC2, 0xF6, 0x9B, 0x9B, 0x9B, 0x9B, 0xF4, 0xB2, 0xFF, 0x9B, 0x9B, 0xCB, 
        0x6D, 0xB0, 0xB3, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0xAD, 0xB6, 0xB0, 0xB1, 0x9B, 0xAA, 0xDF, 0xC5, 0x4E, 0xFF, 0x9B, 0x9B, 0x91, 0x33, 0x33, 0x33, 0x33, 0x33, 0x96, 0xE4, 0x9B, 0x9B, 0x9B, 0x9B, 0xA1, 0x9B, 0x9B, 0x9B, 0x8F, 0xEA, 0xB3, 
        0x9B, 0xA9, 0x94, 0x1E, 0xF6, 0x9B, 0x9B, 0x90, 0x33, 0x33, 0xAB, 0xEE, 0xC4, 0x9B, 0xEB, 0x33, 0x33, 0x33, 0x34, 0x1E, 0x0A,
  0x01, 0x82, 0x3C, 0x2B, 0x3D, 0xC7, 0x9B, 0x9B, 0xD0, 0xC3, 0xBE, 0x9B, 0x9B, 0xF7, 0xB0, 0xF6, 0x9B, 0x9B, 0xD1, 0xF6, 0x9B, 0x9B, 0x9A, 0xEA, 0x7E, 0xEE, 0x9B, 0x9B, 0xF3, 0x87, 0xF0, 0x0C, 0xEE, 0xE3, 0x9B, 0x9B, 0x9B, 0xC7, 0xC1, 0x9B, 0xAA, 0xFA, 
        0xCD, 0xEC, 0xEF, 0x9B, 0xBE, 0xF6, 0xEE, 0xEE, 0xEE, 0xEE, 0xB2, 0x99, 0xC3, 0xC4, 0x9B, 0xA9, 0x7B, 0x9E, 0x3F, 0xFF, 0x9B, 0x9B, 0xA9, 0x96, 0x33, 0x33, 0x33, 0x8D, 0xE2, 0xC4, 0x9B, 0xAA, 0xFF, 0xEE, 0xC3, 0xF6, 0x9B, 0x9B, 0xE9, 0xEE, 0x9B, 
        0x9B, 0xA9, 0x34, 0xEA, 0xF6, 0x9B, 0x9B, 0x90, 0x33, 0x33, 0xAB, 0xEE, 0xB3, 0x9B, 0xAC, 0x8D, 0x33, 0x33, 0x34, 0x97, 0x01,
  0x01, 0xAF, 0x29, 0x2B, 0x14, 0xF6, 0xAA, 0x9B, 0xCF, 0xC3, 0xBE, 0x9B, 0x9B, 0xCB, 0xB0, 0xFF, 0x9B, 0x9B, 0xD4, 0xFF, 0x9B, 0x9B, 0xC9, 0xD3, 0xF0, 0xEE, 0x9B, 0x9B, 0xA0, 0xA3, 0x9E, 0xF5, 0x98, 0x00, 0xB1, 0x9B, 0xAA, 0xF6, 0xC4, 0x9B, 0xAD, 0xF9, 
        0xCD, 0xEC, 0xB3, 0x9B, 0xBE, 0xD4, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xD3, 0xEE, 0xEF, 0x9B, 0xE4, 0xBA, 0xCD, 0x3F, 0xC7, 0x9B, 0x9B, 0xAA, 0x91, 0x8D, 0x8D, 0x33, 0x8E, 0xD4, 0xC4, 0x9B, 0xA9, 0x66, 0x46, 0xC3, 0xFF, 0x9B, 0x9B, 0xE2, 0xEE, 0x9B, 
        0x9B, 0xE4, 0x34, 0xEA, 0xF6, 0x9B, 0x9B, 0xA9, 0x94, 0x33, 0x8E, 0xFF, 0x9B, 0x9B, 0xE4, 0x8D, 0x33, 0x33, 0x34, 0x48, 0x01,
  0x01, 0x0D, 0x16, 0x2B, 0x5C, 0xE3, 0xAA, 0x9B, 0xD9, 0xEC, 0xBE, 0x9B, 0xF4, 0xA2, 0xB0, 0xB1, 0x9B, 0x9B, 0xEE, 0xFF, 0x9B, 0x9B, 0xF1, 0xC9, 0xD0, 0xC4, 0x9B, 0x9B, 0xCB, 0xFA, 0xCB, 0xDB, 0xC9, 0xD4, 0xB3, 0x9B, 0xBE, 0xC7, 0xB3, 0x9B, 0x9B, 0xFC, 
        0xD0, 0x48, 0xFF, 0x9B, 0x9B, 0xAD, 0xCB, 0xDB, 0xF9, 0xCA, 0xFD, 0xFB, 0xC7, 0x9B, 0x9B, 0xB6, 0x9E, 0x9E, 0x14, 0x00, 0xB3, 0x9B, 0x9B, 0x9B, 0xA9, 0xA9, 0xB4, 0xAA, 0xF6, 0xC4, 0x9B, 0xAA, 0x90, 0x8F, 0xE3, 0xBE, 0x9B, 0xAA, 0xC0, 0xF6, 0x9B, 
        0x9B, 0x91, 0x34, 0x6F, 0xEE, 0x9B, 0x9B, 0x9B, 0xEB, 0xA9, 0xAD, 0x9B, 0x9B, 0x9B, 0x8F, 0x8D, 0x33, 0x33, 0x34, 0xEC, 0x01,
  0x01, 0x55, 0x3A, 0x2B, 0xC3, 0xB1, 0x9B, 0xAA, 0x99, 0xEC, 0xB3, 0x9B, 0x9A, 0xC5, 0xEA, 0xB3, 0x9B, 0xAA, 0xC3, 0xF6, 0x9B, 0x9B, 0x9B, 0xAA, 0x9B, 0x9B, 0x9B, 0x9B, 0xFF, 0x9A, 0x9B, 0x9B, 0xAA, 0xBE, 0x9B, 0x9B, 0xC4, 0xEE, 0xBE, 0x9B, 0x9B, 0x9B, 
        0xA0, 0xB0, 0xEE, 0xB3, 0x9B, 0x9B, 0x9B, 0x9B, 0xAD, 0x9B, 0xA0, 0xF5, 0xF6, 0x9B, 0xAA, 0xFA, 0xCD, 0x6D, 0xD3, 0x07, 0xFF, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0xEE, 0xB1, 0x9B, 0x9B, 0xAA, 0xAA, 0x9B, 0x9B, 0x9B, 0xEB, 0xC0, 0xFF, 0x9B, 
        0x9B, 0xE8, 0x34, 0x54, 0xC3, 0xBE, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0xAA, 0xE7, 0x95, 0xA8, 0x93, 0x33, 0x7E, 0x01,
  0x01, 0x55, 0x79, 0xED, 0xC3, 0xB3, 0xBE, 0xA0, 0x3C, 0x4E, 0xC4, 0xAD, 0xF9, 0x29, 0xEE, 0xEF, 0xBE, 0xF1, 0xF0, 0xC3, 0xC4, 0xAA, 0x9B, 0x9B, 0xE3, 0xE3, 0x9B, 0xAD, 0xEE, 0xE3, 0x9B, 0xAA, 0x9B, 0x9B, 0xAA, 0xF1, 0xFB, 0x98, 0xE3, 0x9B, 0x9B, 0x9B, 
        0xB6, 0xCD, 0x58, 0xEE, 0xB3, 0x9B, 0x9B, 0x9B, 0x9B, 0xAA, 0xB6, 0xF0, 0xC1, 0x9B, 0xF7, 0xDC, 0xCE, 0xCD, 0xCE, 0xF0, 0x00, 0xFF, 0xBE, 0x9B, 0x9B, 0x9B, 0xAA, 0xE4, 0x7E, 0xC7, 0x9B, 0x9B, 0x9B, 0xAD, 0xB1, 0xB3, 0x9B, 0xE4, 0xEA, 0xE3, 0x9B, 
        0xAA, 0x94, 0x33, 0x41, 0x4E, 0xC7, 0xB3, 0x9B, 0x9B, 0xAA, 0xC4, 0xBE, 0x9B, 0xEB, 0x92, 0xE8, 0x91, 0x92, 0x32, 0x6C, 0x01,
  0x01, 0x0E, 0x3E, 0x44, 0x00, 0xEE, 0xEE, 0xFB, 0x29, 0x7F, 0xEE, 0xB2, 0xC5, 0xC6, 0xC3, 0xC7, 0xEE, 0xD9, 0x17, 0x3E, 0xEE, 0xF6, 0xFF, 0xF6, 0xB0, 0xC3, 0xC7, 0xB2, 0xEC, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xD4, 0xB0, 0x2A, 0x2C, 0xC3, 0xF6, 0xC1, 0xFF, 
        0xA3, 0x2A, 0x45, 0x58, 0xEE, 0xC7, 0xE3, 0xC1, 0xE3, 0xF6, 0x99, 0x5C, 0xC7, 0xF6, 0xF2, 0xD8, 0xCE, 0x9E, 0xB8, 0x71, 0x48, 0xC2, 0xEE, 0xFF, 0xC4, 0xC4, 0xE3, 0x94, 0x1D, 0xC2, 0xC7, 0xB1, 0xE3, 0xE2, 0xEE, 0xC7, 0xFF, 0x95, 0xC3, 0xC7, 0xFF, 
        0xE2, 0x77, 0x33, 0x33, 0x1F, 0xC2, 0xEE, 0xC1, 0xB1, 0xE2, 0xEE, 0xF6, 0xE3, 0xE9, 0xAB, 0x94, 0xE5, 0x96, 0x20, 0x55, 0x01,
  0x01, 0x0E, 0x6C, 0x3A, 0x3D, 0x3A, 0x44, 0x2A, 0x2A, 0x45, 0x15, 0x3B, 0x2B, 0x3C, 0x15, 0x28, 0x44, 0x3C, 0x2A, 0x3C, 0x18, 0x2C, 0x18, 0x16, 0x17, 0x3A, 0xF0, 0x16, 0x45, 0x14, 0x2C, 0x2C, 0x2C, 0x3A, 0xC6, 0x2A, 0x2A, 0x3C, 0x18, 0x6B, 0x13, 0x3D, 
        0x2A, 0x2A, 0x69, 0xBA, 0xF5, 0x1C, 0x61, 0x84, 0x5C, 0xF5, 0xBC, 0x97, 0x30, 0x5C, 0xF5, 0x80, 0x80, 0x7B, 0x60, 0x65, 0x33, 0x7D, 0x48, 0x61, 0x84, 0x48, 0x54, 0x32, 0x33, 0x1E, 0x61, 0x84, 0x6F, 0x46, 0x1E, 0x48, 0x1D, 0x41, 0x97, 0x48, 0x48, 
        0x1F, 0x33, 0x33, 0x33, 0x33, 0x7D, 0x30, 0x61, 0x48, 0x7D, 0x1E, 0x48, 0x84, 0x20, 0x33, 0x33, 0x8D, 0x33, 0x48, 0x55, 0x01,
  0x01, 0x0E, 0x0F, 0x18, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2B, 0x2A, 0x2A, 0x2A, 0x2B, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x3C, 0x2A, 0x2A, 
        0x2A, 0x5F, 0x7C, 0x65, 0x63, 0x65, 0x32, 0x32, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x33, 0x33, 0x33, 0x33, 0x32, 0x32, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x32, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x7E, 0x0E, 0x01,
  0x01, 0x0E, 0x55, 0x7F, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x5F, 0x7B, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x1F, 0x02, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x19, 0x16, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x62, 0x72, 0x65, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x34, 0x48, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x55, 0x98, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x6D, 0x62, 0x6D, 0x62, 0x62, 0x6D, 0x62, 0x62, 0x62, 0x69, 0x69, 0x69, 0x69, 0x72, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x41, 0x0A, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x2D, 0x45, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x5F, 0x80, 0x65, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x35, 0x6F, 0x55, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x3E, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x71, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x46, 0x08, 0x0F, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x19, 0x15, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x7B, 0xA4, 0x7C, 0x7C, 0x7C, 0xA4, 0xA4, 0xA4, 0xA4, 0xA4, 0x7C, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x34, 0x48, 0x67, 0x09, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x55, 0x39, 0x17, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x69, 0x33, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x4D, 0x67, 0x48, 0x78, 0x03, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x5F, 0x60, 0x33, 0x77, 0x77, 0x77, 0x77, 0x77, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x41, 0x7E, 0x0C, 0xEC, 0x0C, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x55, 0x3A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x7B, 0x60, 0x60, 0x60, 0x60, 0xA4, 0x63, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0xEC, 0x55, 0x0E, 0x0E, 0x55, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x82, 0x15, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x5F, 0x5B, 0x65, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x6F, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xAF, 0x45, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x5B, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x37, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x07, 0x45, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x5F, 0x5B, 0x65, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x54, 0x0D, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xAF, 0x3D, 0x3C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x15, 0x30, 0x41, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x48, 0x03, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xAF, 0x2C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2B, 0x18, 0x6C, 0x0F, 0xEC, 0x41, 0x34, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x48, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x55, 0x43, 0x17, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x16, 0x43, 0x55, 0x0E, 0x0E, 0x55, 0x24, 0x54, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x7D, 0x0C, 0x55, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x49, 0x3A, 0x3C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x3C, 0x15, 0x49, 0x55, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x1D, 0x41, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x34, 0x32, 0x6F, 0x24, 0x55, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x55, 0x07, 0x15, 0x3C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x3C, 0x15, 0x07, 0x55, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x55, 0x6C, 0x97, 0x41, 0x35, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x32, 0x54, 0x0C, 0x55, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x55, 0xAF, 0x3E, 0x3D, 0x29, 0x2B, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2B, 0x2B, 
        0x3C, 0x3D, 0x3E, 0xAF, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x73, 0x97, 0x41, 0x34, 0x34, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x34, 
        0x32, 0x97, 0xEC, 0x02, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x55, 0x55, 0xAF, 0x98, 0x3A, 0x17, 0x3C, 0x2A, 0x2A, 0x2A, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x3C, 0x17, 0x3D, 0x13, 
        0x2D, 0x55, 0x55, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x55, 0x04, 0xEC, 0x54, 0x81, 0x32, 0x35, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x81, 0x1E, 0x84, 
        0x0A, 0x55, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x55, 0x0F, 0x49, 0x3E, 0x2C, 0x14, 0x15, 0x45, 0x17, 0x17, 0x17, 0x17, 0x16, 0x15, 0x3A, 0x2C, 0x43, 0x82, 0x0F, 0x55, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x55, 0x03, 0xC2, 0xEC, 0x1D, 0x54, 0x20, 0x81, 0x32, 0x32, 0x33, 0x33, 0x32, 0x41, 0x20, 0x54, 0x37, 0xEC, 0xC2, 0x03, 0x55, 
        0x55, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01,
  0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0D, 0x04, 0x04, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x0E, 0x55, 0x0E, 0x02, 0x02, 0xC2, 0xC2, 0xC2, 0x02, 0x02, 0x55, 0x55, 0x55, 0x03, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01
};

extern GUI_CONST_STORAGE GUI_BITMAP bmLogo_MasterCard;

GUI_CONST_STORAGE GUI_BITMAP bmLogo_MasterCard = {
  104, /* XSize */
  63, /* YSize */
  104, /* BytesPerLine */
  8, /* BitsPerPixel */
  acLogo_MasterCard,  /* Pointer to picture data (indices) */
  &PalLogo_MasterCard  /* Pointer to palette */
};

/* *** End of file *** */
