/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2014  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.24 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software has been licensed to  ARM LIMITED whose registered office
is situated at  110 Fulbourn Road,  Cambridge CB1 9NJ,  England solely
for  the  purposes  of  creating  libraries  for  ARM7, ARM9, Cortex-M
series,  and   Cortex-R4   processor-based  devices,  sublicensed  and
distributed as part of the  MDK-ARM  Professional  under the terms and
conditions  of  the   End  User  License  supplied  with  the  MDK-ARM
Professional. 
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
File        : Logo_Maestro.c
Purpose     : Bitmap file
---------------------------END-OF-HEADER------------------------------
*/

#include <stdlib.h>

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/*   Palette
The following are the entries of the palette table.
Every entry is a 32-bit value (of which 24 bits are actually used)
the lower   8 bits represent the Red component,
the middle  8 bits represent the Green component,
the highest 8 bits (of the 24 bits used) represent the Blue component
as follows:   0xBBGGRR
*/

static GUI_CONST_STORAGE GUI_COLOR ColorsLogo_Maestro[] = {
     0xFFFFFF,0xF6F6E6,0xF6E6CD,0xEED5AC
    ,0xDEC583,0xD5AC62,0xCD9C41,0xC58B20
    ,0xC58B10,0xC59429,0xCD9C39,0xD5AC5A
    ,0xDEBD7B,0xE6D5AC,0xEEE6C5,0xF6EEE6
    ,0xEEEEF6,0xD5D5F6,0xBDBDEE,0x9494E6
    ,0x737BE6,0x5A5ADE,0x414ADE,0x3139DE
    ,0x3939DE,0x4141DE,0x949CE6,0xB4B4EE
    ,0xE6E6FF,0xEEDEBD,0xDEBD83,0xBD8308
    ,0xBD8300,0xDEB473,0xEEDEC5,0xFFF6F6
    ,0xF6F6FF,0xCDCDF6,0x8B8BE6,0x5A62DE
    ,0x3941D5,0x2931D5,0x2929D5,0x2029D5
    ,0x8B94EE,0xC5C5EE,0xFFFFF6,0xF6EED5
    ,0xCD9431,0xBD7B00,0x9C9CE6,0x4A4ADE
    ,0x8B94E6,0xFFF6EE,0xC59431,0xF6EEDE
    ,0xEEEEFF,0x9494EE,0x838BE6,0xE6CD9C
    ,0xCD9429,0x4141D5,0x414AD5,0x9C9CEE
    ,0xD5B46A,0xBD8310,0xCDA44A,0x6A73E6
    ,0x3131D5,0xD5DEF6,0xC58B18,0xE6CD94
    ,0xACB4EE,0x3139D5,0xDEC594,0xDEC58B
    ,0xACACE6,0xBD7B08,0x6A527B,0xEEF6FF
    ,0xC58310,0x7B5A62,0x3131C5,0x2931CD
    ,0xEED5B4,0x946A31,0x946A41,0x52419C
    ,0xC58300,0xAC7B20,0x4A41AC,0xA47331
    ,0x3131CD,0xE6C594,0x8B6A4A,0x6A5A73
    ,0x3939BD,0x949CEE,0xAC7320,0x4139B4
    ,0x3939D5,0x2931DE,0x8383E6,0xF6E6D5
    ,0x5A4A8B,0x7B5A6A,0x7B83E6,0x3939C5
    ,0xB47B10,0xA47329,0x524A9C,0x62527B
    ,0xD5A44A,0xCDA441,0xBD8B10,0xCD9C31
    ,0x3139C5,0x3941DE,0x6A6ADE,0x4A52DE
    ,0xDEDEF6,0xEEE6CD,0xB47B29,0xDECDA4
    ,0x2029DE,0x2929C5,0x7B73CD,0xE6CDA4
    ,0xB47300,0x8B625A,0xEEEEEE,0xB47B00
    ,0x946A5A,0xDEB46A,0x9C6A39,0x9C7339
    ,0x9C7331,0x62528B,0x41298B,0xBD9C9C
    ,0x6262DE,0xA4A4E6,0xA46A08,0xA48383
    ,0x9C5A00,0xBDA4A4,0xF6F6EE,0xCDA452
    ,0xD5B462,0xE6CD8B,0xDEBD6A,0xCD9420
    ,0xD5AC52,0xE6C57B,0xC5BDBD,0x52317B
    ,0xD5BDBD,0x6A6AE6,0x7B7BE6,0x2939D5
    ,0x626ADE,0x945208,0xC5ACAC,0x8B5229
    ,0xF6F6F6,0xC58B29,0xBD8339,0xF6E6DE
    ,0xE6D5B4,0x5252E6,0x62416A,0xDED5CD
    ,0xBDC5F6,0x3131BD,0x948BBD,0xDEE6F6
    ,0xC59C31,0x834A10,0xD5CDCD,0xDED5D5
    ,0xF6EEEE,0xA46208,0xA48373,0xE6DEDE
    ,0xB47B18,0x9C6A62,0xBD8320,0xC59C5A
    ,0x7B5262,0xEEE6DE,0xA4ACEE,0x39208B
    ,0xBDA494,0xACACEE,0x737BDE,0x834A20
    ,0xBDA49C,0xD5AC4A,0x8B5A31,0xB49C94
    ,0x9C6208,0x946A6A,0xC5B4B4,0xB48B8B
    ,0xA4837B,0x9C7373,0xD5C5BD,0xAC6A00
    ,0xD5C5B4,0xC5ACA4,0x9C7362,0xA46218
    ,0xD5C5C5,0xCDB4B4,0xAC8383,0xA48B94
    ,0x9C736A,0xE6DED5,0xCDC5D5,0x412062
    ,0xE6E6EE,0x9C94BD,0xB4948B,0xAC948B
    ,0x8B5239,0xA47B73,0xC59452,0xE6D5D5
    ,0xAC8B8B,0x945A18,0x9C6210,0x9C5A08
    ,0x8B5A52,0xEEE6E6,0xD5B483,0xE6D5BD
    ,0xA46A10,0xA46200,0x733910,0x8B5231
    ,0xB47B39,0x4A317B,0x31209C,0xB49483
    ,0x8373AC,0x41399C,0x2929CD,0x5A395A
    ,0xDECDCD,0x946A62,0xCDBDB4,0xE6E6F6
    ,0x62529C,0x41297B,0x522941,0x94624A
};

static GUI_CONST_STORAGE GUI_LOGPALETTE PalLogo_Maestro = {
  256,	/* number of entries */
  0, 	/* No transparency */
  &ColorsLogo_Maestro[0]
};

static GUI_CONST_STORAGE unsigned char acLogo_Maestro[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x08, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x17, 0x18, 0x19, 0x15, 0x14, 0x1A, 0x1B, 0x11, 0x1C, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x1E, 0x06, 0x07, 0x1F, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x1F, 0x07, 0x06, 0x21, 0x22, 0x23, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2A, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0x2B, 0x2A, 0x29, 0x19, 0x15, 0x2C, 0x2D, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x2F, 0x04, 0x30, 0x20, 0x31, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x31, 0x31, 0x07, 
        0x1E, 0x22, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x32, 0x33, 0x2A, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2A, 0x2B, 0x2B, 0x16, 
        0x34, 0x11, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x0C, 0x36, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x07, 0x0C, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x39, 0x19, 0x29, 0x2A, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2A, 
        0x2A, 0x33, 0x3A, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x3B, 0x3C, 0x31, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x31, 0x07, 0x3B, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x1B, 0x3D, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x2B, 0x3E, 0x3F, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0x40, 0x41, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x41, 0x42, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x43, 0x44, 0x2A, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x2A, 0x29, 0x14, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x03, 0x46, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x20, 0x31, 0x46, 0x47, 0x2E, 0x00, 0x48, 0x19, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0x49, 0x1B, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4A, 0x46, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x41, 0x4B, 0x4C, 0x49, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x49, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x4B, 0x31, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4D, 0x4E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0x39, 0x4F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x50, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4D, 0x51, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x44, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x4B, 0x31, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x51, 0x52, 0x53, 0x53, 0x53, 0x53, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0x34, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x46, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x55, 0x56, 0x56, 0x56, 0x56, 0x56, 0x57, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x49, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x07, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x59, 0x5A, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x49, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x35, 0x40, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x5B, 0x5C, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0x43, 0x38, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x5D, 0x1F, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x5E, 0x4E, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x60, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x61, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x35, 0x07, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x62, 0x63, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2A, 0x64, 0x1C, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x2E, 0x0C, 0x31, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x58, 0x4E, 0x2B, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0x66, 0x24, 0x00, 0x00,
  0x00, 0x00, 0x67, 0x09, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x31, 0x68, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x5C, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3D, 0x11, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x69, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2A, 0x6A, 0x00, 0x00,
  0x00, 0x00, 0x30, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x5B, 0x6B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0x3D, 0x24, 0x00,
  0x00, 0x1D, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x6C, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x5B, 0x6E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0x1B, 0x00,
  0x00, 0x0C, 0x31, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 
        0x6F, 0x6B, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x52, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2A, 0x2A, 0x2A, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0x66, 0x24,
  0x0F, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x1F, 0x0A, 0x70, 0x70, 0x70, 0x70, 0x71, 0x72, 0x20, 0x20, 0x20, 0x09, 0x70, 0x70, 0x70, 0x70, 0x70, 0x73, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4D, 
        0x74, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x75, 0x76, 0x76, 0x76, 0x33, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x77, 0x78,
  0x79, 0x07, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7A, 0x22, 0x35, 0x35, 0x35, 0x35, 0x2F, 0x30, 0x20, 0x20, 0x6C, 0x7B, 0x35, 0x35, 0x35, 0x35, 0x35, 0x4A, 0x31, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x6D, 
        0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x2B, 0x29, 0x29, 0x29, 0x7D, 0x7E, 0x4F, 0x38, 0x4F, 0x66, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x64, 0x25,
  0x7F, 0x1F, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x80, 0x81, 0x82, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0A, 0x20, 0x83, 0x84, 0x82, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x85, 0x31, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x6C, 
        0x86, 0x86, 0x86, 0x86, 0x86, 0x87, 0x87, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x88, 0x89, 0x2A, 0x29, 0x29, 0x8A, 0x8B, 0x00, 0x00, 0x38, 0x8C, 0x2B, 0x29, 0x29, 0x2B, 0x2B, 0x2B, 0x29, 0x29, 0x2A, 0x29, 0x29, 0x29, 0x29, 
        0x2A, 0x2A, 0x29, 0x29, 0x2A, 0x2A, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2A, 0x8D,
  0x0C, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x8E, 0x8F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x20, 0x90, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x71, 0x20, 0x46, 0x93, 0x21, 0x4B, 0x47, 0x4B, 0x94, 0x07, 0x31, 0x20, 0x20, 
        0x20, 0x20, 0x1F, 0x73, 0x0C, 0x47, 0x95, 0x96, 0x97, 0x31, 0x20, 0x20, 0x20, 0x31, 0x46, 0x98, 0x99, 0x95, 0x9A, 0x61, 0x6A, 0x19, 0x9B, 0x9C, 0x00, 0x00, 0x38, 0x3A, 0x27, 0x29, 0x75, 0x9D, 0x9D, 0x76, 0x44, 0x28, 0x9E, 0x6A, 0x49, 0x2B, 0x9F, 
        0x8C, 0x61, 0x48, 0x48, 0x3F, 0xA0, 0x49, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2A, 0x66,
  0x98, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xA1, 0xA2, 0x00, 0x00, 0x23, 0x00, 0x00, 0x92, 0x71, 0x80, 0xA3, 0xA4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0xA5, 0xA6, 0xA7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x04, 0x31, 0x20, 
        0x20, 0x07, 0xA8, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x35, 0x1E, 0x1F, 0x20, 0x1F, 0x40, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xA9, 0xAA, 0xAB, 0x00, 0x00, 0x00, 0x00, 0xAC, 0xAD, 0xAE, 0x00, 0x00, 0x24, 0x14, 0x78, 0x00, 0x38, 0x28, 0x9D, 0x78, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x8C, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0x15,
  0xB0, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xB1, 0xB2, 0x00, 0x00, 0xB3, 0xB4, 0x00, 0x35, 0x70, 0xB5, 0xB6, 0x00, 0x00, 0xB7, 0x82, 0x00, 0x00, 0x22, 0xB8, 0xB9, 0xA4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x36, 0x20, 
        0xBA, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x42, 0x31, 0xBB, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x3D, 0xBC, 0xBD, 0x00, 0x00, 0x00, 0x00, 0xBE, 0xBF, 0xC0, 0x00, 0x00, 0x38, 0x1C, 0x00, 0x00, 0xC1, 0xC2, 0x1C, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x77, 0x2A, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x33,
  0x08, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x31, 0xC3, 0x82, 0x00, 0x00, 0xC4, 0xB4, 0x00, 0x35, 0xC5, 0xC6, 0xB3, 0x00, 0x00, 0xC7, 0xB4, 0x00, 0x00, 0x3B, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xB6, 0xCE, 0x23, 0x00, 0x00, 0x0C, 0xCF, 
        0xD0, 0x00, 0x00, 0x00, 0xD1, 0xD2, 0x8F, 0xB7, 0x00, 0x00, 0x54, 0xD3, 0xD4, 0x00, 0x00, 0x00, 0xD5, 0xD6, 0xB6, 0xD7, 0x9E, 0xAD, 0xD8, 0xA4, 0x00, 0x00, 0xD9, 0xDA, 0x9D, 0xDB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0xA4, 0xDC, 0xDD, 0x23, 0x00, 0x00, 
        0x00, 0xB3, 0xDE, 0xDF, 0xB3, 0x00, 0x00, 0x00, 0x12, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x49,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x80, 0xE0, 0x00, 0x00, 0xA4, 0xE1, 0x82, 0x00, 0x2E, 0xE2, 0xCC, 0xA4, 0x00, 0xE3, 0xE4, 0x00, 0x00, 0x00, 0x85, 0xB5, 0xE5, 0xE6, 0xE7, 0xC8, 0xE7, 0xB1, 0xE8, 0xE9, 0x00, 0x00, 0xEA, 0x86, 
        0xA4, 0x00, 0x00, 0xEB, 0xEC, 0xED, 0xEE, 0xC7, 0x00, 0x00, 0x79, 0xEF, 0xB7, 0x00, 0x00, 0x00, 0xF0, 0xE7, 0xE5, 0xF1, 0x2A, 0xF2, 0xF3, 0x00, 0x00, 0x00, 0xF4, 0xF5, 0xF6, 0xF7, 0x92, 0x00, 0x00, 0x00, 0xF8, 0xD8, 0xF9, 0xFA, 0x00, 0x00, 0x00, 
        0xFB, 0xFC, 0xFD, 0xFE, 0xE8, 0x00, 0x00, 0x00, 0x38, 0x49, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xB5, 0xD8, 0x00, 0x00, 0x0F, 0xFF, 0xBD, 0x00, 0x2E, 0xE1, 0xB3, 0x00, 0x2E, 0xB6, 0xA2, 0x00, 0x00, 0x00, 0x06, 0x31, 0x1F, 0x0A, 0x4B, 0x03, 0x22, 0x0E, 0xB3, 0x00, 0x00, 0x00, 0xBB, 0xDE, 
        0x00, 0x00, 0x00, 0x1D, 0x4B, 0x4B, 0xEA, 0xF8, 0x00, 0x00, 0xD9, 0xE0, 0xB2, 0x00, 0x00, 0x00, 0x79, 0x21, 0xF0, 0x63, 0x29, 0xFD, 0xD5, 0x00, 0x00, 0x00, 0x19, 0x29, 0xAD, 0xBC, 0x00, 0x00, 0x00, 0x24, 0x5A, 0xF2, 0xBC, 0xB7, 0x00, 0x00, 0x24, 
        0x66, 0x2B, 0x65, 0xAD, 0xFE, 0xBD, 0x00, 0x00, 0x00, 0x77, 0x2A, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xC8, 0xDE, 0x00, 0x00, 0x67, 0x55, 0xE3, 0x00, 0xA4, 0xA2, 0x00, 0x00, 0x2F, 0x55, 0xB2, 0x00, 0x00, 0x00, 0x07, 0x1F, 0x4B, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD2, 0xD5, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xA3, 0xCC, 0xA4, 0x00, 0x00, 0x00, 0x2E, 0xAB, 0x7E, 0x2B, 0xDB, 0xF8, 0x00, 0x00, 0xFB, 0x29, 0x29, 0xF2, 0xC9, 0x00, 0x00, 0x00, 0x12, 0x2B, 0x7D, 0x81, 0xB4, 0x00, 0x00, 0xFB, 
        0x77, 0x29, 0x29, 0xF6, 0xFE, 0xB7, 0x00, 0x00, 0x00, 0x77, 0x2A, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29,
  0x08, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 0xE5, 0xFA, 0x00, 0x00, 0x54, 0xE5, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xC3, 0x82, 0x00, 0x00, 0x2F, 0xB8, 0x7B, 0x00, 0x00, 0xA4, 0xB3, 0xD5, 0xA2, 0xE9, 0x00, 0x00, 0x2E, 0xC6, 0xB2, 
        0x00, 0x00, 0x23, 0xE9, 0xDC, 0xDC, 0xDC, 0xDC, 0xB7, 0xE9, 0x47, 0xEC, 0xEE, 0xF9, 0xB3, 0xA4, 0x00, 0x00, 0x00, 0x24, 0x15, 0xF7, 0xA4, 0x00, 0x00, 0x12, 0x2B, 0x29, 0x8A, 0xC7, 0x00, 0x00, 0x00, 0x66, 0x2B, 0xF2, 0xD8, 0x23, 0x00, 0x00, 0x11, 
        0x75, 0x29, 0x29, 0xF6, 0xF7, 0x92, 0x00, 0x00, 0x00, 0x3D, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x49,
  0x97, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 0xA3, 0xF8, 0x00, 0x00, 0x4B, 0xB1, 0xD4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA5, 0xE0, 0x00, 0x00, 0x00, 0x0D, 0x56, 0x82, 0x00, 0x00, 0x4A, 0x55, 0xE5, 0xEE, 0xB3, 0x00, 0x00, 0x37, 0xC3, 0xD4, 
        0x00, 0x00, 0xD9, 0xF9, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0x56, 0x46, 0x20, 0xC8, 0xEE, 0xE0, 0xCC, 0xB7, 0x00, 0x00, 0x00, 0xAE, 0xBC, 0x00, 0x00, 0x00, 0x3F, 0x2B, 0x7C, 0xF1, 0xFA, 0x00, 0x00, 0x10, 0x27, 0x2A, 0xF2, 0xD2, 0xA4, 0x00, 0x00, 0x78, 
        0x16, 0x29, 0x29, 0x7D, 0xCD, 0x00, 0x00, 0x00, 0x1C, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x19,
  0x42, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x31, 0xE8, 0xE9, 0x00, 0x00, 0x05, 0xA1, 0x9A, 0x00, 0x00, 0x00, 0x00, 0x03, 0x8E, 0xD2, 0x00, 0x00, 0x00, 0xC0, 0xD6, 0x00, 0x00, 0x00, 0x06, 0x20, 0x20, 0xF0, 0x00, 0x00, 0x00, 0x54, 0xEE, 0xD1, 
        0x00, 0x00, 0x01, 0x93, 0x83, 0x31, 0x31, 0x31, 0x20, 0x46, 0x1F, 0x20, 0x20, 0x20, 0xB5, 0xEE, 0x81, 0xB4, 0x00, 0x00, 0x91, 0x8F, 0x00, 0x00, 0x00, 0x66, 0x2B, 0x7C, 0xAA, 0xAB, 0x00, 0x00, 0x11, 0x28, 0x29, 0xF2, 0xE8, 0xE9, 0x00, 0x00, 0x24, 
        0x66, 0x2B, 0x2A, 0x77, 0xB7, 0x00, 0x00, 0x00, 0xBE, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2A, 0x15,
  0x05, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x80, 0xF9, 0xA4, 0x00, 0x00, 0x0A, 0xA1, 0xA2, 0x00, 0x00, 0x00, 0x35, 0x0B, 0xC8, 0xDE, 0x00, 0x00, 0x2E, 0xB6, 0xE4, 0x00, 0x00, 0x00, 0x47, 0x36, 0x0B, 0xD9, 0x00, 0x00, 0x00, 0x47, 0xB1, 0xCD, 
        0x00, 0x00, 0x00, 0x37, 0x0C, 0x0B, 0x70, 0x0B, 0x4B, 0x1D, 0x09, 0x0C, 0x40, 0x98, 0x42, 0xE2, 0xD5, 0x00, 0x00, 0x00, 0xD7, 0xC7, 0x00, 0x00, 0x00, 0x11, 0x39, 0x14, 0xBC, 0xBD, 0x00, 0x00, 0xAC, 0x49, 0x29, 0xAD, 0xC3, 0xF8, 0x00, 0x00, 0x00, 
        0x1C, 0x13, 0x26, 0x78, 0x00, 0x00, 0x00, 0x1C, 0x8C, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2A, 0x43,
  0x47, 0x1F, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xB5, 0xE4, 0x00, 0x00, 0x35, 0x08, 0xE7, 0x91, 0x00, 0x00, 0x00, 0x03, 0x50, 0xE5, 0xD5, 0x00, 0x00, 0x37, 0x5B, 0x81, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x85, 0xB5, 0xEE, 
        0xD5, 0xA4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x86, 0xBD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x9B, 0xD6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xC9, 0xA4, 0x00, 0x00, 0x1A, 0x2A, 0x29, 0x29, 0xDB, 0x81, 0xB4, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x14, 0x3E, 0x9E, 0x77, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2A, 0x1A,
  0x1D, 0x46, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xA1, 0xCA, 0x00, 0x00, 0x67, 0x20, 0x90, 0xC7, 0x00, 0x00, 0x00, 0x0B, 0x58, 0xA3, 0xF8, 0x00, 0x00, 0x79, 0x59, 0xEE, 0xC7, 0x00, 0x00, 0x00, 0x00, 0xB4, 0xC4, 0x2E, 0x00, 0x92, 0x42, 0x31, 0xB1, 
        0xC3, 0xC7, 0xA4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA8, 0x81, 0xB4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x9D, 0xFD, 0xE0, 0xE9, 0x00, 0x00, 0x00, 0x24, 0xF4, 0xD6, 0x00, 0x00, 0x00, 0x14, 0x2B, 0x29, 0x29, 0xF2, 0xFE, 0xCC, 0xB7, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x9E, 0x29, 0x8C, 0x13, 0xA0, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x49, 0x12,
  0x37, 0x30, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xB1, 0xE8, 0x84, 0xD2, 0x36, 0x20, 0x8E, 0xE0, 0x84, 0x84, 0xE2, 0x1F, 0x20, 0xEE, 0x81, 0x84, 0x84, 0x0A, 0x1F, 0xA1, 0xEE, 0xE8, 0xD6, 0xDE, 0xD2, 0xD3, 0xEE, 0x84, 0x84, 0xE2, 0x08, 0x20, 0x20, 
        0xA1, 0xEE, 0xC3, 0xF9, 0xCB, 0xC0, 0xDE, 0xCC, 0xF0, 0x6C, 0xEE, 0x81, 0xCD, 0xD6, 0xDE, 0xDE, 0xE1, 0xFF, 0x63, 0x2A, 0xAD, 0xFE, 0xC3, 0xCC, 0xC4, 0xDF, 0xF4, 0xF5, 0xE8, 0xC9, 0xC9, 0xF4, 0x49, 0x29, 0x29, 0x29, 0x29, 0xF2, 0xFE, 0xFE, 0xD8, 
        0xC4, 0xD5, 0xA2, 0xD7, 0x4E, 0x63, 0x2A, 0x29, 0x44, 0x77, 0x49, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x16, 0x45,
  0x23, 0x0B, 0x31, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x80, 0x8E, 0x8E, 0xCF, 0x20, 0x20, 0x83, 0x8E, 0x8E, 0x8E, 0x83, 0x20, 0x20, 0x8E, 0x8E, 0x8E, 0x8E, 0x20, 0x20, 0x31, 0xCF, 0xE5, 0xA1, 0xC8, 0x80, 0x83, 0x8E, 0x8E, 0x8E, 0x83, 0x20, 0x20, 0x20, 
        0x20, 0x31, 0x8E, 0xE7, 0xA1, 0xE7, 0xB5, 0x8E, 0x31, 0x58, 0x8E, 0xB5, 0xE7, 0xE7, 0xC8, 0xB5, 0xCF, 0x6D, 0x2A, 0x29, 0x29, 0xAD, 0x8A, 0xFD, 0x8A, 0xF2, 0x7D, 0x7D, 0xF2, 0xF2, 0xF2, 0x7D, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x52, 0xF2, 0xFD, 
        0xDB, 0xF1, 0xFD, 0xF2, 0x7D, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2A, 0xA0, 0x38,
  0x00, 0x0D, 0x31, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 0x58, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 
        0x6D, 0x4E, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0xF5, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x65, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x65, 
        0x7C, 0x65, 0x65, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0xBE, 0x00,
  0x00, 0x0F, 0x41, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x6D, 0x60, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x78, 0x00,
  0x00, 0x00, 0x94, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x1F, 0x4E, 0x7C, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x65, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2A, 0x76, 0x00, 0x00,
  0x00, 0x00, 0x54, 0x08, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x6D, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x53, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x49, 0x1B, 0x00, 0x00,
  0x00, 0x00, 0x35, 0x0B, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x5B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0xA0, 0x38, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x22, 0x31, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x41, 0x68, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0x12, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x21, 0x1F, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x6C, 0x5B, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x51, 0x5C, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2A, 0x14, 0xB7, 0xB7, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x67, 0x3C, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x59, 0x60, 0x74, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x5C, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x16, 0x2D, 0x8F, 0x8F, 0x24, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x41, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x5E, 0x5C, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x12, 0x00, 0xA2, 0xA2, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x85, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x4D, 0x5F, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0x14, 0x24, 0x00, 0xA4, 0xA4, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0B, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x20, 0x31, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x51, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0x9D, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x73, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 0x7A, 0x5A, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2A, 0x16, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0B, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x6D, 0x6B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2A, 0xA0, 0xAF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x06, 0x31, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x31, 0x06, 0x7E, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0x15, 0xFB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x21, 0x1F, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x1F, 0x0B, 0x35, 0x24, 0x9E, 0x44, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x9E, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x04, 0x46, 0x31, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x20, 0x20, 0x1F, 0x04, 0x01, 0x00, 0x00, 0x38, 0x3F, 0x29, 0x2A, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x2B, 0x49, 0x26, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x93, 0x41, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x20, 0x20, 0x1F, 0x93, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x43, 0x29, 0x2A, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x27, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3B, 0x46, 0x31, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
        0x20, 0x31, 0x46, 0x04, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x8D, 0x3E, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x2A, 0x2B, 0x49, 0x8D, 0xFB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3B, 0x0A, 0x41, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x1F, 
        0x0A, 0x04, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x32, 0x15, 0x44, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2A, 0x2A, 0x29, 
        0x77, 0xBE, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x0D, 0x98, 0x46, 0x31, 0x31, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x31, 0x31, 0x72, 0x0B, 0x3B, 
        0x37, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFB, 0x1B, 0x14, 0x64, 0x2B, 0x2B, 0x2A, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0x2B, 0x2B, 0x28, 0xA0, 0x1B, 
        0xFB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x1D, 0x4B, 0x98, 0x0A, 0xA5, 0x46, 0x41, 0x1F, 0x1F, 0x1F, 0x72, 0x46, 0xA5, 0x30, 0x93, 0x1E, 0x54, 0x35, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x2D, 0x39, 0x14, 0x77, 0x19, 0x64, 0x49, 0x44, 0x44, 0x44, 0x44, 0x64, 0x75, 0x15, 0x76, 0x61, 0x2D, 0x24, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

extern GUI_CONST_STORAGE GUI_BITMAP bmLogo_Maestro;

GUI_CONST_STORAGE GUI_BITMAP bmLogo_Maestro = {
  102, /* XSize */
  61, /* YSize */
  102, /* BytesPerLine */
  8, /* BitsPerPixel */
  acLogo_Maestro,  /* Pointer to picture data (indices) */
  &PalLogo_Maestro  /* Pointer to palette */
};

/* *** End of file *** */
