/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2014  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.24 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software has been licensed to  ARM LIMITED whose registered office
is situated at  110 Fulbourn Road,  Cambridge CB1 9NJ,  England solely
for  the  purposes  of  creating  libraries  for  ARM7, ARM9, Cortex-M
series,  and   Cortex-R4   processor-based  devices,  sublicensed  and
distributed as part of the  MDK-ARM  Professional  under the terms and
conditions  of  the   End  User  License  supplied  with  the  MDK-ARM
Professional. 
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
File        : Logo_ECCard.c
Purpose     : Bitmap file
---------------------------END-OF-HEADER------------------------------
*/

#include <stdlib.h>

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/*   Palette
The following are the entries of the palette table.
Every entry is a 32-bit value (of which 24 bits are actually used)
the lower   8 bits represent the Red component,
the middle  8 bits represent the Green component,
the highest 8 bits (of the 24 bits used) represent the Blue component
as follows:   0xBBGGRR
*/

static GUI_CONST_STORAGE GUI_COLOR ColorsLogo_ECCard[] = {
     0xFFFFFF,0xFFFFF6,0xF6EEDE,0xDEBD9C
    ,0xCD8331,0xCD6200,0xCD7310,0xDE9C4A
    ,0xEED5BD,0xFFF6F6,0xF6F6F6,0xE6DEBD
    ,0xD5A452,0xCD7308,0xCD6A00,0xCD6A08
    ,0xCD8320,0xCD7318,0xCD7B29,0xDEB48B
    ,0xEEEEE6,0xE6DEB4,0xD5944A,0xCD6A10
    ,0xD58B39,0xD5AC6A,0xE6CD9C,0xE6D5A4
    ,0xE6BD8B,0xDE9C5A,0xD58329,0xF6EEE6
    ,0xD5A44A,0xCD7B20,0xDEA46A,0xE6D5B4
    ,0xF6F6E6,0xCD9439,0xE6C59C,0xFFF6E6
    ,0xDECD9C,0xEEE6CD,0xF6F6EE,0xE6D5AC
    ,0xDE9441,0xEEC583,0xCD9431,0xE6AC8B
    ,0xD58320,0xEED5CD,0xCD7B18,0xDEB483
    ,0xEEEEEE,0xF6F6FF,0xF6EED5,0xEEC59C
    ,0xE6AC62,0xEEAC62,0xD5AC62,0xDEAC62
    ,0xCDAC62,0xCDA462,0xAC8362,0x736262
    ,0x625A5A,0x736A94,0x7B8BEE,0x6A7BFF
    ,0x7383FF,0xA4C5FF,0xF6D5BD,0xE6A45A
    ,0xC56200,0x9C5A00,0x523900,0x201000
    ,0x180000,0x291031,0x2929DE,0x1831FF
    ,0x2039FF,0xE6FFFF,0xF6E6DE,0xA45A00
    ,0x4A3100,0x180800,0x290000,0x310000
    ,0x312031,0x3131DE,0x3131FF,0x3139FF
    ,0xE6C5AC,0xCD7331,0x6A4100,0xDEAC8B
    ,0xCD6210,0xBD6200,0x412900,0x200000
    ,0xCD6208,0xB46200,0x392000,0x292031
    ,0xDEAC83,0x202031,0x2931FF,0x2939FF
    ,0xD5AC73,0xCD8329,0x4A52FF,0x7B7BFF
    ,0x838BFF,0x737BFF,0x3939FF,0xCD6A18
    ,0xE6B48B,0xFFF6EE,0xEEDECD,0xCD8B4A
    ,0x394AFF,0x94A4FF,0xDEE6FF,0xEEEEFF
    ,0xCDCDFF,0xEEE6D5,0xCD8B52,0x415AFF
    ,0xC5CDFF,0xD5DEFF,0x4152FF,0xE6DED5
    ,0x4A5AFF,0xE6D5C5,0xDEDEFF,0x1839FF
    ,0x2041FF,0x6283FF,0xE6F6FF,0xD5A45A
    ,0xD5A473,0x9CA4FF,0x7B8BFF,0xA4ACFF
    ,0xCD7B31,0xB47B31,0x4A3918,0x101010
    ,0x29294A,0xD5E6FF,0xCDE6FF,0xDEEEFF
    ,0xDEC5AC,0xEEDED5,0xD5D5D5,0x6262C5
    ,0x2929BD,0x3131CD,0x3131F6,0x5A73FF
    ,0x315AFF,0x395AFF,0x3962FF,0x8B9CFF
    ,0xEEFFFF,0xE6E6FF,0x626AFF,0xF6E6D5
    ,0xEEDEC5,0xDECDC5,0x6A5AC5,0x3129C5
    ,0x3131C5,0x3131BD,0xDEA473,0xCD8339
    ,0xBD7B31,0x523131,0x181031,0x201831
    ,0x291831,0x291829,0x292941,0x201829
    ,0x3131D5,0xE6D5CD,0xD57320,0xEEC5B4
    ,0xBDC5FF,0xD5D5FF,0xD58B41,0xE6D5BD
    ,0xDEC59C,0xCD8B39,0x2941FF,0x738BFF
    ,0xACBDFF,0xBDCDFF,0x9CB4FF,0x3941FF
    ,0x2031FF,0xCD7320,0x3152FF,0x3162FF
    ,0x412000,0x522900,0xDEAC6A,0x834100
    ,0x311000,0xD5A46A,0xB45A00,0x733900
    ,0xDEC594,0xDE945A,0xD59462,0xE6945A
    ,0xDE9462,0xD5945A,0xD59C62,0xCD8B5A
    ,0x947B5A,0x6A5A5A,0x625252,0x736273
    ,0x7B7BE6,0xF6FFFF,0xEEE6DE,0xFFE6DE
    ,0xDED5D5,0xDED5DE,0xCDCDCD,0x8B8B8B
    ,0xDEDEDE,0xACACAC,0xC5C5C5,0x9C9C9C
    ,0xE6E6E6,0xA4A4A4,0x414141,0x737373
    ,0x949494,0xEEF6FF,0x4A4A4A,0xF6DECD
    ,0xBDBDBD,0xB4B4B4,0x6A6A6A,0xB4CDFF
    ,0x8BA4FF,0xA4B4FF,0xDEDEF6,0xDEAC73
    ,0xA4948B,0x525252,0x5A5A5A,0x838383
};

static GUI_CONST_STORAGE GUI_LOGPALETTE PalLogo_ECCard = {
  256,	/* number of entries */
  0, 	/* No transparency */
  &ColorsLogo_ECCard[0]
};

static GUI_CONST_STORAGE unsigned char acLogo_ECCard[] = {
  0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x06, 0x07, 0x08, 0x09, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x0F, 0x05, 0x12, 0x13, 0x14, 0x00, 0x00,
  0x01, 0x15, 0x16, 0x17, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 
        0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1C, 0x1D, 0x1E, 0x0F, 0x0F, 0x13, 0x1F, 0x00,
  0x02, 0x20, 0x0F, 0x21, 0x22, 0x23, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x1A, 0x25, 0x05, 0x21, 0x26, 0x27,
  0x28, 0x0D, 0x17, 0x22, 0x29, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2A, 0x2B, 0x12, 0x0F, 0x2C, 0x2D,
  0x2E, 0x0E, 0x18, 0x23, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x2F, 0x05, 0x06, 0x30,
  0x0E, 0x0F, 0x19, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x32, 0x05, 0x05,
  0x05, 0x17, 0x33, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0A, 0x09, 0x09, 0x09, 0x09, 0x0A, 0x0A, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0A, 0x34, 0x34, 0x34, 0x0A, 0x35, 
        0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x36, 0x37, 0x19, 0x38, 0x39, 0x3A, 0x3B, 0x38, 0x39, 0x39, 0x39, 0x3A, 0x3B, 0x3C, 0x3B, 0x39, 0x39, 0x39, 0x3A, 0x3C, 0x3A, 0x39, 0x3A, 0x3D, 0x3E, 0x3F, 0x40, 0x40, 0x40, 0x41, 0x42, 
        0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x44, 0x45, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x46, 0x47, 0x11, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4C, 0x4C, 0x4C, 0x4D, 0x4E, 
        0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x50, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x22, 0x17, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x53, 0x54, 0x55, 0x56, 0x57, 0x57, 0x57, 0x57, 0x58, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x01, 0x5C, 0x5D, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x48, 0x5E, 0x4B, 0x56, 0x57, 0x57, 0x57, 0x57, 0x57, 0x58, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x61, 0x62, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x58, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x64, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x63, 0x67, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x68, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x56, 0x58, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x56, 0x58, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x4C, 0x69, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x4C, 0x69, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x6A, 0x6A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x68, 0x64, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0F, 0x11, 0x06, 0x0F, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x63, 0x69, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x6B, 0x6B, 0x6B, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x21, 0x22, 0x33, 0x6C, 0x6D, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x56, 0x67, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5B, 0x6E, 0x6F, 0x70, 0x71, 0x72, 0x6A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x73, 0x74, 0x1F, 0x75, 0x76, 0x77, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x56, 0x58, 0x59, 
        0x5A, 0x5A, 0x6A, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x78, 0x4F, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x21, 0x31, 0x00, 0x00, 0x7D, 0x7E, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x63, 0x67, 0x59, 
        0x5A, 0x5A, 0x6A, 0x7F, 0x80, 0x00, 0x00, 0x81, 0x82, 0x4F, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x12, 0x83, 0x00, 0x00, 0x7D, 0x7E, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x56, 0x58, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x81, 0x82, 0x4F, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x12, 0x83, 0x00, 0x00, 0x7D, 0x7E, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x63, 0x67, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x81, 0x82, 0x4F, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x12, 0x83, 0x00, 0x00, 0x7D, 0x7E, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x56, 0x67, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x81, 0x82, 0x4F, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x12, 0x83, 0x00, 0x00, 0x7D, 0x7E, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x63, 0x69, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x81, 0x82, 0x4F, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x12, 0x83, 0x00, 0x00, 0x7D, 0x7E, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x56, 0x67, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x81, 0x82, 0x4F, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x12, 0x83, 0x00, 0x00, 0x7D, 0x7E, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x58, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x81, 0x82, 0x4F, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x21, 0x85, 0x0A, 0x0A, 0x76, 0x77, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x58, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x86, 0x7F, 0x87, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x88, 0x89, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x17, 0x8B, 0x68, 0x68, 0x8C, 0x6D, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x56, 0x58, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x7B, 0x8D, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8F, 0x35, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0F, 0x17, 0x17, 0x17, 0x0F, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x63, 0x67, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x00, 0x35, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x58, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x63, 0x67, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x63, 0x69, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x56, 0x58, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x58, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x58, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x56, 0x67, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0x66, 0x4C, 0x63, 0x63, 0x63, 0x63, 0x63, 0x4C, 0x69, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x68, 0x64, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0F, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x91, 0x92, 0x93, 0x93, 0x93, 0x93, 0x93, 0x93, 0x93, 0x94, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x35, 0x95, 0x96, 0x96, 0x96, 0x96, 0x96, 0x96, 0x96, 0x96, 0x96, 0x96, 0x96, 0x96, 0x96, 0x96, 0x97, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x64, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x11, 0x98, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x9A, 0x9B, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9D, 0x9E, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x7A, 0x9F, 0xA0, 0xA0, 0xA0, 0x7F, 0xA1, 0xA0, 0xA0, 0xA0, 0x7F, 0x7F, 0xA0, 0xA0, 0x84, 0xA2, 0xA3, 0xA4, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x12, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA5, 0xA6, 0x6A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x81, 0x82, 0x4F, 0x6A, 0x6A, 0x5A, 0x6A, 0x6A, 0x6A, 0x6A, 0x5A, 0x5A, 0x6A, 0x6A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x12, 0x83, 0x00, 0x00, 0x09, 0xA7, 0xA8, 0xA8, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAC, 0xAC, 0xAC, 0xAC, 0xAD, 0xAC, 0x9E, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x81, 0x82, 0x4F, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x68, 0x64, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x12, 0x83, 0x00, 0x00, 0x02, 0xAE, 0xAF, 0x90, 0x90, 0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB4, 0xB3, 0xB4, 0xB5, 0xB6, 0x59, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x81, 0x82, 0x4F, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x68, 0x64, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x12, 0x83, 0x00, 0x00, 0x7D, 0x7E, 0x05, 0x05, 0x05, 0x65, 0x66, 0x4C, 0x63, 0x56, 0x56, 0x63, 0x56, 0x56, 0xB7, 0xB8, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x81, 0x82, 0x4F, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x12, 0x83, 0x00, 0x00, 0x7D, 0x7E, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x63, 0xB7, 0xB8, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x81, 0x82, 0x4F, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x12, 0x83, 0x00, 0x00, 0x7D, 0x7E, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x56, 0xB7, 0xB8, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x81, 0x82, 0x4F, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x12, 0x83, 0x00, 0x00, 0x7D, 0x7E, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0xB5, 0xB8, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x81, 0x82, 0x4F, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x12, 0xB9, 0x00, 0x00, 0x7D, 0x7E, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0xB5, 0xB8, 
        0x5A, 0x5A, 0x6A, 0x84, 0x80, 0x00, 0x00, 0x81, 0x82, 0x4F, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xBA, 0xBB, 0x09, 0x00, 0x99, 0x7E, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x56, 0xB5, 0xB8, 
        0x5A, 0x5A, 0x6A, 0x7F, 0xBC, 0x35, 0x00, 0xBD, 0x82, 0x4F, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0E, 0xBE, 0x5C, 0xBF, 0xC0, 0xC1, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x63, 0xB7, 0xB8, 
        0x5A, 0x5A, 0x6A, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x64, 0xC9, 0x90, 0x12, 0x06, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x67, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0xCA, 0xCB, 0xCA, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x56, 0x67, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x6A, 0xC8, 0x6A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x56, 0x67, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x63, 0x67, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x68, 0x64, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x4C, 0x69, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5F, 0x60, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0x66, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x4C, 0x69, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x33, 0x0F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0xCC, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x63, 0x69, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x01, 0x2B, 0x6D, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x65, 0xCD, 0x63, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x58, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xCE, 0x11, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x48, 0xCF, 0xD0, 0x63, 0x56, 0x56, 0x56, 0x56, 0x63, 0xB4, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xA8, 0xD1, 0x21, 0x0F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xD2, 0xD3, 0xD0, 0x4C, 0x4C, 0x4C, 0x4C, 0x4C, 0x4D, 0x59, 
        0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5B, 0x44, 0x51, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x7D, 0xD4, 0xD1, 0xD5, 0xD6, 0xD5, 0xD5, 0xD7, 0xD7, 0xD6, 0xD8, 0xD5, 0xD6, 0xD9, 0xD5, 0xD9, 0xD5, 0xD7, 0xD5, 0xD6, 0xDA, 0xD5, 0xDB, 0xDC, 0xDD, 0xDE, 0xDE, 0xDE, 0xDE, 0xDF, 0xE0, 
        0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x8F, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2A, 0x14, 0x52, 0xE2, 0x52, 0x52, 0xE3, 0xE3, 0x52, 0x52, 0x52, 0xE2, 0x52, 0x52, 0x52, 0x52, 0xE3, 0x52, 0xE2, 0xE2, 0x52, 0x52, 0xE2, 0xE4, 0x9A, 0x9A, 0x9A, 0x9A, 0xE5, 0x86, 
        0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x7B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x34, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE6, 0xE7, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xE6, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xE9, 0xE9, 
        0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xEA, 0xEB, 0xEC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x2A, 0x2A, 0x01, 0xED, 0xEE, 0x9A, 0x00, 0x34, 0x34, 0x00, 0x00, 0x0A, 0x34, 0x0A, 0xE8, 0xEF, 0xF0, 0xEC, 0x0A, 0x0A, 0x0A, 0x0A, 0x34, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xF0, 0xF0, 
        0x0A, 0x0A, 0x34, 0x0A, 0x00, 0x00, 0x00, 0xE1, 0x7B, 0xF1, 0x00, 0x0A, 0x34, 0x0A, 0x00, 0x00, 0x34, 0x34, 0x0A, 0xEB, 0xF2, 0xEA, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF3, 0x74, 0x13, 0x76, 0xEB, 0xEE, 0xE6, 0xE6, 0xEB, 0xED, 0x9A, 0xEC, 0xE9, 0xF0, 0xF4, 0xF5, 0xF2, 0xF6, 0xF5, 0xF5, 0xF5, 0xF4, 0xEA, 0xEB, 0xE9, 0xE8, 0xE6, 0xE9, 0xED, 0xE9, 0x9A, 0xED, 0xE9, 
        0xEC, 0xF5, 0xEB, 0xF4, 0x34, 0x00, 0x35, 0xF7, 0xF8, 0xF9, 0xFA, 0xE6, 0xEB, 0xED, 0xE8, 0xE8, 0xED, 0xEB, 0xEA, 0xF0, 0xF2, 0xF0, 0xEB, 0x9A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x2A, 0x33, 0x04, 0x04, 0xFB, 0xFC, 0xF2, 0xF4, 0xEF, 0xFD, 0xFE, 0xF0, 0xEB, 0xFE, 0xFE, 0xFE, 0xE7, 0xEE, 0xFE, 0xFF, 0xFD, 0xFE, 0xEF, 0xF6, 0xFD, 0xFD, 0xEB, 0xF0, 0xF2, 0xFD, 0xFD, 0xE9, 0xF6, 0xFF, 
        0xF5, 0xFD, 0xFD, 0xF6, 0xEA, 0x00, 0x81, 0x9F, 0x84, 0xA6, 0xE0, 0x41, 0xFD, 0xEE, 0xEB, 0xED, 0xFD, 0xFE, 0xEF, 0xE7, 0xEE, 0x40, 0xEE, 0xF0, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x02, 0x8B, 0x16, 0x07, 0x07, 0xFC, 0xF2, 0xF5, 0xF2, 0xEF, 0xEF, 0xF6, 0xF6, 0xFE, 0xF0, 0xFD, 0xF0, 0xFE, 0xEF, 0xE7, 0xEE, 0xEF, 0xEB, 0xEE, 0xEF, 0xFE, 0xEF, 0xFF, 0xF2, 0xEF, 0xEE, 0xF0, 0xFE, 0xEF, 
        0xF0, 0xF2, 0xE7, 0xEF, 0xF5, 0x0A, 0x8F, 0xA0, 0xA3, 0x43, 0xE0, 0x41, 0xEF, 0xEE, 0xFF, 0xEF, 0xF2, 0xEF, 0xE7, 0xFF, 0xEE, 0xED, 0xEE, 0xEF, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x36, 0x0C, 0x32, 0x21, 0x07, 0xFC, 0xF2, 0xE9, 0xEE, 0xEE, 0xEE, 0xFE, 0xFE, 0xF6, 0x9A, 0xE6, 0xEA, 0x40, 0xFF, 0xF0, 0xF2, 0xF4, 0xF4, 0xEE, 0xEB, 0xF6, 0xEF, 0xFF, 0xFE, 0xF0, 0xF2, 0xE7, 0x40, 0xEF, 
        0xF0, 0xFD, 0xF4, 0x9A, 0xEC, 0x00, 0x8D, 0xA0, 0xC5, 0x81, 0xBD, 0xF5, 0xF6, 0xB7, 0xEF, 0xED, 0xEE, 0xEF, 0xEA, 0xF0, 0xF2, 0xE6, 0xEE, 0xEF, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x36, 0x0C, 0x04, 0x6C, 0x98, 0xF0, 0xEE, 0xE9, 0xEE, 0xFE, 0xE7, 0xED, 0xF6, 0xF6, 0xE8, 0xE8, 0xEA, 0x40, 0xE7, 0xE7, 0xFD, 0xE6, 0xF4, 0xEE, 0xEB, 0xF6, 0xEF, 0xFF, 0x40, 0xF0, 0xF2, 0xE7, 0x40, 0xEF, 
        0xF0, 0xFD, 0xEA, 0xEC, 0x34, 0x00, 0x8D, 0xA0, 0x80, 0x34, 0xE6, 0xF6, 0xF2, 0x58, 0xEF, 0xEC, 0xF0, 0xF2, 0xE7, 0xE7, 0xF2, 0xE6, 0xEE, 0xEF, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x36, 0x8B, 0x8B, 0x03, 0x13, 0xFC, 0xF2, 0xE9, 0xF2, 0xE7, 0xED, 0xE7, 0xF6, 0xFE, 0xED, 0xEE, 0xF0, 0x40, 0xFF, 0xE7, 0xFD, 0xE6, 0xEA, 0xF2, 0xF0, 0xF6, 0xEF, 0xFF, 0x40, 0xF0, 0xF2, 0xE7, 0x40, 0xEF, 
        0xF0, 0xFD, 0xEB, 0x40, 0xED, 0x0A, 0x8D, 0xCA, 0x8D, 0x44, 0x9B, 0xFE, 0xF0, 0xFD, 0xEF, 0xE7, 0xFF, 0xFF, 0x40, 0xEF, 0xF2, 0xE6, 0xEE, 0xEF, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xD1, 0x18, 0x16, 0x8B, 0xFC, 0xF2, 0xF4, 0xFE, 0xFE, 0xFE, 0xEF, 0xEF, 0xFD, 0xEF, 0xEE, 0xED, 0xF6, 0xF6, 0xFF, 0xFD, 0xE6, 0x9A, 0xFE, 0x40, 0xFD, 0xFF, 0xE7, 0x40, 0xEB, 0xFD, 0xF0, 0xFE, 0xEF, 
        0xED, 0xEE, 0x40, 0xFD, 0xE9, 0x0A, 0xC4, 0xA0, 0x9F, 0x84, 0x9B, 0xFE, 0x40, 0xEE, 0xFF, 0xEF, 0xFE, 0xEF, 0xF6, 0xEF, 0xFD, 0xE6, 0xF2, 0xFF, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x09, 0x2B, 0x8B, 0x0C, 0x26, 0xF5, 0xEF, 0x9A, 0xED, 0xF6, 0xEF, 0xF4, 0xEA, 0xEF, 0xF6, 0xE7, 0x9A, 0xF0, 0xFF, 0xF0, 0xE7, 0xE8, 0x34, 0xED, 0xF6, 0xEF, 0xEA, 0xF5, 0xF0, 0xF4, 0xE7, 0xF5, 0xE7, 0xEB, 
        0xE6, 0xEF, 0xF6, 0xE7, 0x9A, 0x00, 0x7A, 0xC3, 0x9F, 0x8E, 0xEA, 0xF0, 0xF6, 0x40, 0xE9, 0xF4, 0xEF, 0xEF, 0xED, 0xE9, 0xFF, 0x9A, 0xFF, 0xED, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x05, 0x05,
  0x05, 0x17, 0x33, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2A, 0x36, 0x7D, 0x2A, 0x34, 0xE8, 0x0A, 0x34, 0x9A, 0xE8, 0x0A, 0x0A, 0xE8, 0x9A, 0xEC, 0x0A, 0xEC, 0xE8, 0xEC, 0xEC, 0x0A, 0x00, 0x34, 0x9A, 0xE8, 0x0A, 0x34, 0xE8, 0x34, 0xEC, 0x34, 0xEC, 0xEC, 
        0x0A, 0xE8, 0x9A, 0xEC, 0x00, 0x00, 0x00, 0x97, 0x81, 0x7A, 0x34, 0xEC, 0xE8, 0x9A, 0xEC, 0x0A, 0xE8, 0xE8, 0x34, 0x34, 0xE8, 0x0A, 0xE8, 0xEC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x32, 0x05, 0x05,
  0x05, 0x0F, 0x22, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x0F, 0x05, 0x05,
  0x6D, 0x05, 0x04, 0x2B, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xCE, 0x05, 0x06, 0x32,
  0x2B, 0x21, 0x0F, 0x8B, 0x76, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x03, 0x11, 0x0F, 0x2C, 0x2D,
  0x75, 0x33, 0x0F, 0x0F, 0x16, 0x23, 0xE3, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x75, 0xA7, 0x13, 0x12, 0x0E, 0x04, 0x23, 0x09,
  0x00, 0x29, 0x22, 0x17, 0x05, 0xC9, 0x0C, 0x6C, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 
        0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x5F, 0xD1, 0x90, 0x0F, 0x05, 0x04, 0x15, 0x00, 0x00,
  0x00, 0x00, 0x99, 0x68, 0x04, 0x06, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x64, 0x17, 0x25, 0x23, 0x0A, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x52, 0x1C, 0x25, 0x0D, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x11, 0x0C, 0x1A, 0x09, 0x00, 0x00, 0x00
};

extern GUI_CONST_STORAGE GUI_BITMAP bmLogo_ECCard;

GUI_CONST_STORAGE GUI_BITMAP bmLogo_ECCard = {
  75, /* XSize */
  83, /* YSize */
  75, /* BytesPerLine */
  8, /* BitsPerPixel */
  acLogo_ECCard,  /* Pointer to picture data (indices) */
  &PalLogo_ECCard  /* Pointer to palette */
};

/* *** End of file *** */
