/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2014  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.24 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software has been licensed to  ARM LIMITED whose registered office
is situated at  110 Fulbourn Road,  Cambridge CB1 9NJ,  England solely
for  the  purposes  of  creating  libraries  for  ARM7, ARM9, Cortex-M
series,  and   Cortex-R4   processor-based  devices,  sublicensed  and
distributed as part of the  MDK-ARM  Professional  under the terms and
conditions  of  the   End  User  License  supplied  with  the  MDK-ARM
Professional. 
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
File        : AA4_24.c
Purpose     : Font file
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI.H"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/* The following line needs to be included in any file selecting the
   font. A good place would be GUIConf.H
*/
extern GUI_CONST_STORAGE GUI_FONT GUI_FontAA4_24;

/* Start of unicode area <Basic Latin> */
GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0020[ 72] = { /* code 0020, SPACE */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0021[ 72] = { /* code 0021, EXCLAMATION MARK */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0022[ 96] = { /* code 0022, QUOTATION MARK */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x0F, 0xF0,
  0x0F, 0xF0, 0x0F, 0xF0,
  0x0F, 0xF0, 0x0F, 0xF0,
  0x0C, 0xC0, 0x0C, 0xC0,
  0x0A, 0xA0, 0x0A, 0xA0,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0023[144] = { /* code 0023, NUMBER SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFE, 0x00, 0x2F, 0xE0,
  0x00, 0x04, 0xFC, 0x00, 0x5F, 0xC0,
  0x00, 0x08, 0xF8, 0x00, 0x8F, 0x80,
  0x00, 0x0B, 0xF5, 0x00, 0xCF, 0x50,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x5F, 0xB0, 0x05, 0xFB, 0x00,
  0x00, 0x8F, 0x70, 0x08, 0xF7, 0x00,
  0x00, 0xBF, 0x30, 0x0C, 0xF3, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x05, 0xFC, 0x00, 0x5F, 0xB0, 0x00,
  0x08, 0xF8, 0x00, 0x8F, 0x80, 0x00,
  0x0C, 0xF5, 0x00, 0xCF, 0x40, 0x00,
  0x0E, 0xF2, 0x00, 0xEF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0024[144] = { /* code 0024, DOLLAR SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x3B, 0xEF, 0xEA, 0x20, 0x00,
  0x04, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x0C, 0xFA, 0x2F, 0x2C, 0xFA, 0x00,
  0x0F, 0xF0, 0x0F, 0x02, 0xFE, 0x00,
  0x0E, 0xF3, 0x0F, 0x00, 0x00, 0x00,
  0x09, 0xFE, 0x8F, 0x00, 0x00, 0x00,
  0x00, 0x9F, 0xFF, 0xC5, 0x00, 0x00,
  0x00, 0x02, 0x9F, 0xFF, 0xC0, 0x00,
  0x00, 0x00, 0x0F, 0x3B, 0xF8, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0xFD, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0xFF, 0x00,
  0x0E, 0xF2, 0x0F, 0x02, 0xFE, 0x00,
  0x0B, 0xFC, 0x2F, 0x2C, 0xFA, 0x00,
  0x02, 0xEF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0x3A, 0xEF, 0xEA, 0x20, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0025[240] = { /* code 0025, PERCENT SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x7D, 0xFD, 0x50, 0x00, 0x00, 0x3F, 0xD0, 0x00, 0x00,
  0x05, 0xFA, 0x0A, 0xF5, 0x00, 0x00, 0xCF, 0x40, 0x00, 0x00,
  0x0C, 0xF2, 0x02, 0xFC, 0x00, 0x05, 0xFC, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0xFF, 0x00, 0x0D, 0xF2, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0xFF, 0x00, 0x8F, 0x90, 0x00, 0x00, 0x00,
  0x0C, 0xF2, 0x02, 0xFC, 0x00, 0xEE, 0x00, 0x00, 0x00, 0x00,
  0x05, 0xFA, 0x0A, 0xF5, 0x0A, 0xF7, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x6D, 0xFD, 0x50, 0x3F, 0xD0, 0x7D, 0xFD, 0x50, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xCF, 0x45, 0xFA, 0x0A, 0xF5, 0x00,
  0x00, 0x00, 0x00, 0x06, 0xFB, 0x0C, 0xF2, 0x02, 0xFC, 0x00,
  0x00, 0x00, 0x00, 0x0D, 0xF2, 0x0F, 0xF0, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x8F, 0x80, 0x0F, 0xF0, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x02, 0xEE, 0x00, 0x0C, 0xF2, 0x02, 0xFC, 0x00,
  0x00, 0x00, 0x0A, 0xF6, 0x00, 0x05, 0xFA, 0x0A, 0xF5, 0x00,
  0x00, 0x00, 0x4F, 0xC0, 0x00, 0x00, 0x6D, 0xFD, 0x50, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0026[168] = { /* code 0026, AMPERSAND */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x4B, 0xFF, 0xC5, 0x00, 0x00,
  0x00, 0x06, 0xFF, 0xFF, 0xFF, 0x60, 0x00,
  0x00, 0x0D, 0xF7, 0x00, 0x9F, 0xE0, 0x00,
  0x00, 0x0F, 0xF0, 0x00, 0x0F, 0xE0, 0x00,
  0x00, 0x0B, 0xF4, 0x00, 0x9F, 0x70, 0x00,
  0x00, 0x03, 0xFE, 0x8D, 0xE7, 0x00, 0x00,
  0x00, 0x02, 0xCF, 0xF9, 0x20, 0x00, 0x00,
  0x00, 0x6E, 0xFC, 0xFA, 0x00, 0x00, 0x00,
  0x04, 0xFE, 0x30, 0xCF, 0xA0, 0x2C, 0x90,
  0x0C, 0xF4, 0x00, 0x0E, 0xFA, 0x7F, 0xB0,
  0x0F, 0xF0, 0x00, 0x03, 0xFF, 0xFF, 0x30,
  0x0E, 0xF5, 0x00, 0x00, 0x7F, 0xF6, 0x00,
  0x09, 0xFE, 0x40, 0x06, 0xDF, 0xFB, 0x20,
  0x00, 0xCF, 0xFF, 0xFF, 0xFA, 0x3E, 0xE8,
  0x00, 0x08, 0xDF, 0xFB, 0x50, 0x00, 0xC6,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0027[ 48] = { /* code 0027, APOSTROPHE */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0C, 0xC0,
  0x0A, 0xA0,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0028[ 96] = { /* code 0028, LEFT PARENTHESIS */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x6C, 0x00,
  0x00, 0x03, 0xF2, 0x00,
  0x00, 0x0C, 0xA0, 0x00,
  0x00, 0x7F, 0x20, 0x00,
  0x00, 0xDC, 0x00, 0x00,
  0x05, 0xF8, 0x00, 0x00,
  0x0A, 0xF4, 0x00, 0x00,
  0x0C, 0xF2, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00,
  0x0C, 0xF2, 0x00, 0x00,
  0x0A, 0xF5, 0x00, 0x00,
  0x05, 0xF9, 0x00, 0x00,
  0x00, 0xDC, 0x00, 0x00,
  0x00, 0x6F, 0x30, 0x00,
  0x00, 0x0C, 0xA0, 0x00,
  0x00, 0x03, 0xF2, 0x00,
  0x00, 0x00, 0x6B, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0029[ 96] = { /* code 0029, RIGHT PARENTHESIS */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x0C, 0x60, 0x00, 0x00,
  0x02, 0xF3, 0x00, 0x00,
  0x00, 0xAC, 0x00, 0x00,
  0x00, 0x2F, 0x70, 0x00,
  0x00, 0x0C, 0xD0, 0x00,
  0x00, 0x08, 0xF5, 0x00,
  0x00, 0x04, 0xFA, 0x00,
  0x00, 0x02, 0xFC, 0x00,
  0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0xFF, 0x00,
  0x00, 0x02, 0xFC, 0x00,
  0x00, 0x05, 0xFA, 0x00,
  0x00, 0x09, 0xF5, 0x00,
  0x00, 0x0C, 0xD0, 0x00,
  0x00, 0x3F, 0x60, 0x00,
  0x00, 0xAC, 0x00, 0x00,
  0x02, 0xF3, 0x00, 0x00,
  0x0B, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_002A[ 96] = { /* code 002A, ASTERISK */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x32, 0x0D, 0xC0, 0x23,
  0xCF, 0xCD, 0xDC, 0xFC,
  0x24, 0xBF, 0xFB, 0x52,
  0x06, 0xFA, 0xAF, 0x60,
  0x09, 0xC0, 0x0C, 0x90,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_002B[144] = { /* code 002B, PLUS SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_002C[ 72] = { /* code 002C, COMMA */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0x0F, 0x00,
  0x00, 0x7B, 0x00,
  0x00, 0xC0, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_002D[ 96] = { /* code 002D, HYPHEN-MINUS */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_002E[ 72] = { /* code 002E, FULL STOP */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_002F[ 72] = { /* code 002F, SOLIDUS */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x02, 0xFD,
  0x00, 0x06, 0xFA,
  0x00, 0x0B, 0xF6,
  0x00, 0x0E, 0xF0,
  0x00, 0x3F, 0xC0,
  0x00, 0x7F, 0x90,
  0x00, 0xCF, 0x50,
  0x00, 0xFF, 0x00,
  0x04, 0xFC, 0x00,
  0x09, 0xF8, 0x00,
  0x0C, 0xF3, 0x00,
  0x0F, 0xE0, 0x00,
  0x5F, 0xB0, 0x00,
  0xAF, 0x70, 0x00,
  0xDF, 0x20, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0030[144] = { /* code 0030, DIGIT ZERO */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0xDF, 0xFC, 0x80, 0x00,
  0x00, 0xCF, 0xFF, 0xFF, 0xFC, 0x00,
  0x04, 0xFE, 0x60, 0x06, 0xEF, 0x30,
  0x09, 0xF7, 0x00, 0x00, 0x6F, 0x80,
  0x0C, 0xF4, 0x00, 0x00, 0x0F, 0xC0,
  0x0E, 0xF0, 0x00, 0x00, 0x0F, 0xE0,
  0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF0,
  0x0E, 0xF0, 0x00, 0x00, 0x0F, 0xE0,
  0x0C, 0xF4, 0x00, 0x00, 0x4F, 0xC0,
  0x09, 0xF8, 0x00, 0x00, 0x8F, 0x90,
  0x03, 0xFE, 0x60, 0x06, 0xEF, 0x40,
  0x00, 0xCF, 0xFF, 0xFF, 0xFC, 0x00,
  0x00, 0x07, 0xCE, 0xFD, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0031[144] = { /* code 0031, DIGIT ONE */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xAF, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0xFF, 0x00, 0x00,
  0x00, 0x8E, 0xFB, 0xFF, 0x00, 0x00,
  0x00, 0xFD, 0x60, 0xFF, 0x00, 0x00,
  0x00, 0x60, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0032[144] = { /* code 0032, DIGIT TWO */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0xCF, 0xFD, 0x90, 0x00,
  0x00, 0xCF, 0xFF, 0xFF, 0xFC, 0x00,
  0x0A, 0xFC, 0x30, 0x05, 0xEF, 0xA0,
  0x0E, 0xF0, 0x00, 0x00, 0x4F, 0xE0,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0,
  0x00, 0x00, 0x00, 0x00, 0xBF, 0x50,
  0x00, 0x00, 0x00, 0x06, 0xFA, 0x00,
  0x00, 0x00, 0x00, 0x6F, 0xA0, 0x00,
  0x00, 0x00, 0x09, 0xFA, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x80, 0x00, 0x00,
  0x00, 0x3E, 0xE5, 0x00, 0x00, 0x00,
  0x02, 0xEE, 0x30, 0x00, 0x00, 0x00,
  0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0033[144] = { /* code 0033, DIGIT THREE */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x09, 0xDF, 0xEA, 0x20, 0x00,
  0x00, 0xCF, 0xFF, 0xFF, 0xE3, 0x00,
  0x08, 0xFC, 0x30, 0x2B, 0xFC, 0x00,
  0x0D, 0xF2, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFE, 0x00,
  0x00, 0x00, 0x00, 0x3C, 0xF8, 0x00,
  0x00, 0x00, 0x0F, 0xFF, 0x90, 0x00,
  0x00, 0x00, 0x4C, 0xCF, 0xF9, 0x00,
  0x00, 0x00, 0x00, 0x02, 0xCF, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x2F, 0xE0,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0E, 0xF2, 0x00, 0x00, 0x4F, 0xD0,
  0x09, 0xFC, 0x20, 0x04, 0xCF, 0x80,
  0x00, 0xCF, 0xFF, 0xFF, 0xFA, 0x00,
  0x00, 0x08, 0xDF, 0xFC, 0x60, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0034[144] = { /* code 0034, DIGIT FOUR */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x06, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x3F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0xDF, 0xF0, 0x00,
  0x00, 0x00, 0x0C, 0xEF, 0xF0, 0x00,
  0x00, 0x00, 0x8F, 0x6F, 0xF0, 0x00,
  0x00, 0x05, 0xFA, 0x0F, 0xF0, 0x00,
  0x00, 0x2E, 0xC0, 0x0F, 0xF0, 0x00,
  0x00, 0xCF, 0x30, 0x0F, 0xF0, 0x00,
  0x0A, 0xF7, 0x00, 0x0F, 0xF0, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0035[144] = { /* code 0035, DIGIT FIVE */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x2F, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0xAF, 0x70, 0x00, 0x00, 0x00,
  0x00, 0xDF, 0x30, 0x00, 0x00, 0x00,
  0x02, 0xFE, 0x00, 0x00, 0x00, 0x00,
  0x06, 0xFC, 0x8D, 0xFD, 0x80, 0x00,
  0x0A, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x0D, 0xF5, 0x00, 0x03, 0xCF, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x3F, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0E, 0xF2, 0x00, 0x00, 0x5F, 0xB0,
  0x0A, 0xFC, 0x20, 0x03, 0xCF, 0x50,
  0x00, 0xCF, 0xFF, 0xFF, 0xFA, 0x00,
  0x00, 0x08, 0xDF, 0xFC, 0x50, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0036[144] = { /* code 0036, DIGIT SIX */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x02, 0xAE, 0xFE, 0xA0, 0x00,
  0x00, 0x3E, 0xFF, 0xFF, 0xFE, 0x00,
  0x00, 0xDF, 0x70, 0x03, 0xCF, 0xA0,
  0x06, 0xFC, 0x00, 0x00, 0x2F, 0xE0,
  0x0B, 0xF5, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0xF0, 0x8D, 0xFE, 0x90, 0x00,
  0x0F, 0xFA, 0xFF, 0xFF, 0xFC, 0x00,
  0x0F, 0xFE, 0x60, 0x03, 0xCF, 0x80,
  0x0F, 0xF6, 0x00, 0x00, 0x4F, 0xD0,
  0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF0,
  0x0C, 0xF0, 0x00, 0x00, 0x0F, 0xF0,
  0x09, 0xF8, 0x00, 0x00, 0x5F, 0xC0,
  0x02, 0xFE, 0x50, 0x03, 0xCF, 0x60,
  0x00, 0x6F, 0xFF, 0xFF, 0xFA, 0x00,
  0x00, 0x04, 0xBF, 0xFD, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0037[144] = { /* code 0037, DIGIT SEVEN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x00, 0x00, 0x00, 0x00, 0xCF, 0x30,
  0x00, 0x00, 0x00, 0x08, 0xF7, 0x00,
  0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00,
  0x00, 0x00, 0x00, 0xCF, 0x20, 0x00,
  0x00, 0x00, 0x06, 0xFA, 0x00, 0x00,
  0x00, 0x00, 0x0D, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0x30, 0x00, 0x00,
  0x00, 0x02, 0xFD, 0x00, 0x00, 0x00,
  0x00, 0x07, 0xF9, 0x00, 0x00, 0x00,
  0x00, 0x0B, 0xF5, 0x00, 0x00, 0x00,
  0x00, 0x0D, 0xF3, 0x00, 0x00, 0x00,
  0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0038[144] = { /* code 0038, DIGIT EIGHT */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xCF, 0xFB, 0x30, 0x00,
  0x00, 0x4F, 0xFF, 0xFF, 0xF3, 0x00,
  0x00, 0xCF, 0x80, 0x08, 0xFC, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xEF, 0x00, 0x00, 0xFE, 0x00,
  0x00, 0x9F, 0x80, 0x08, 0xF9, 0x00,
  0x00, 0x09, 0xEF, 0xFF, 0x90, 0x00,
  0x00, 0x5D, 0xFF, 0xFF, 0xC4, 0x00,
  0x05, 0xFC, 0x30, 0x03, 0xCF, 0x50,
  0x0D, 0xF2, 0x00, 0x00, 0x2F, 0xC0,
  0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF0,
  0x0E, 0xF0, 0x00, 0x00, 0x2F, 0xE0,
  0x0A, 0xFB, 0x40, 0x03, 0xCF, 0xA0,
  0x00, 0xCF, 0xFF, 0xFF, 0xFE, 0x20,
  0x00, 0x09, 0xDF, 0xFE, 0xA3, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0039[144] = { /* code 0039, DIGIT NINE */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0xDF, 0xFB, 0x40, 0x00,
  0x00, 0xAF, 0xFF, 0xFF, 0xF6, 0x00,
  0x06, 0xFE, 0x50, 0x03, 0xCF, 0x20,
  0x0C, 0xF5, 0x00, 0x00, 0x5F, 0x90,
  0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xC0,
  0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF0,
  0x0D, 0xF4, 0x00, 0x00, 0x6F, 0xF0,
  0x08, 0xFC, 0x30, 0x06, 0xEF, 0xF0,
  0x00, 0xCF, 0xFF, 0xFF, 0xAF, 0xF0,
  0x00, 0x08, 0xEF, 0xD8, 0x0F, 0xC0,
  0x00, 0x00, 0x00, 0x00, 0x5F, 0xB0,
  0x0E, 0xF2, 0x00, 0x00, 0x9F, 0x60,
  0x0A, 0xFC, 0x20, 0x26, 0xED, 0x00,
  0x02, 0xEF, 0xFF, 0xFF, 0xE3, 0x00,
  0x00, 0x2A, 0xEF, 0xEA, 0x20, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_003A[ 72] = { /* code 003A, COLON */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_003B[ 72] = { /* code 003B, SEMICOLON */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0x0F, 0x00,
  0x00, 0x7B, 0x00,
  0x00, 0xC0, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_003C[144] = { /* code 003C, LESS-THAN SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0xC0,
  0x00, 0x00, 0x00, 0x04, 0xCF, 0xF0,
  0x00, 0x00, 0x04, 0xCF, 0xFA, 0x40,
  0x00, 0x04, 0xCF, 0xE8, 0x20, 0x00,
  0x04, 0xCF, 0xD6, 0x00, 0x00, 0x00,
  0x0F, 0xF8, 0x00, 0x00, 0x00, 0x00,
  0x04, 0xCF, 0xD6, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xCF, 0xE8, 0x20, 0x00,
  0x00, 0x00, 0x04, 0xCF, 0xFA, 0x40,
  0x00, 0x00, 0x00, 0x04, 0xCF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x04, 0xC0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_003D[144] = { /* code 003D, EQUALS SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_003E[144] = { /* code 003E, GREATER-THAN SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0x40, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFC, 0x40, 0x00, 0x00, 0x00,
  0x04, 0xAF, 0xFC, 0x40, 0x00, 0x00,
  0x00, 0x02, 0x8E, 0xFC, 0x40, 0x00,
  0x00, 0x00, 0x00, 0x6D, 0xFC, 0x40,
  0x00, 0x00, 0x00, 0x00, 0x8F, 0xF0,
  0x00, 0x00, 0x00, 0x6D, 0xFC, 0x40,
  0x00, 0x02, 0x8E, 0xFC, 0x40, 0x00,
  0x04, 0xAF, 0xFC, 0x40, 0x00, 0x00,
  0x0F, 0xFC, 0x40, 0x00, 0x00, 0x00,
  0x0C, 0x40, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_003F[144] = { /* code 003F, QUESTION MARK */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0xCF, 0xFD, 0x90, 0x00,
  0x00, 0xCF, 0xFF, 0xFF, 0xFE, 0x30,
  0x0A, 0xFC, 0x50, 0x05, 0xCF, 0xC0,
  0x0E, 0xF3, 0x00, 0x00, 0x2F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x2F, 0xE0,
  0x00, 0x00, 0x00, 0x00, 0xCF, 0x80,
  0x00, 0x00, 0x00, 0x3D, 0xFA, 0x00,
  0x00, 0x00, 0x02, 0xEF, 0xA0, 0x00,
  0x00, 0x00, 0x0A, 0xFA, 0x00, 0x00,
  0x00, 0x00, 0x0E, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0040[264] = { /* code 0040, COMMERCIAL AT */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x07, 0xCE, 0xFF, 0xFC, 0x82, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0xFC, 0x62, 0x00, 0x25, 0xCF, 0xFC, 0x00, 0x00,
  0x00, 0x0C, 0xFE, 0x40, 0x00, 0x00, 0x00, 0x04, 0xEF, 0xB0, 0x00,
  0x00, 0x7F, 0xE3, 0x00, 0x8D, 0xFD, 0x50, 0xFD, 0x3F, 0xF4, 0x00,
  0x00, 0xEF, 0x40, 0x0C, 0xFF, 0xFF, 0xFA, 0xFA, 0x08, 0xFA, 0x00,
  0x06, 0xFC, 0x00, 0xBF, 0xC4, 0x02, 0xCF, 0xF6, 0x03, 0xFD, 0x00,
  0x0B, 0xF6, 0x04, 0xFE, 0x00, 0x00, 0x2F, 0xF2, 0x00, 0xFF, 0x00,
  0x0D, 0xF2, 0x0B, 0xF7, 0x00, 0x00, 0x0F, 0xD0, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x0E, 0xF2, 0x00, 0x00, 0x2F, 0xA0, 0x04, 0xFC, 0x00,
  0x0F, 0xF0, 0x0F, 0xF0, 0x00, 0x00, 0x8F, 0x70, 0x0A, 0xF8, 0x00,
  0x0E, 0xF2, 0x0E, 0xF2, 0x00, 0x03, 0xEF, 0x30, 0x4F, 0xE0, 0x00,
  0x0B, 0xF6, 0x0A, 0xFC, 0x20, 0x6E, 0xFF, 0x06, 0xEF, 0x60, 0x00,
  0x06, 0xFD, 0x02, 0xEF, 0xFF, 0xFC, 0xFF, 0xFF, 0xF6, 0x00, 0x00,
  0x00, 0xEF, 0xA0, 0x3B, 0xFE, 0x80, 0x8F, 0xFB, 0x46, 0xFC, 0x00,
  0x00, 0x5F, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8F, 0xE2, 0x00,
  0x00, 0x06, 0xFF, 0xEA, 0x52, 0x00, 0x04, 0x7D, 0xFE, 0x30, 0x00,
  0x00, 0x00, 0x4D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x49, 0xCE, 0xFF, 0xFC, 0x93, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0041[168] = { /* code 0041, LATIN CAPITAL LETTER A */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0E, 0xFE, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0xFF, 0x60, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0xAF, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0xFE, 0x0E, 0xF0, 0x00, 0x00,
  0x00, 0x07, 0xFA, 0x0A, 0xF7, 0x00, 0x00,
  0x00, 0x0C, 0xF5, 0x05, 0xFC, 0x00, 0x00,
  0x00, 0x2F, 0xE0, 0x00, 0xEF, 0x20, 0x00,
  0x00, 0x7F, 0xA0, 0x00, 0xAF, 0x70, 0x00,
  0x00, 0xDF, 0xFF, 0xFF, 0xFF, 0xD0, 0x00,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0x00,
  0x09, 0xF5, 0x00, 0x00, 0x05, 0xF9, 0x00,
  0x0D, 0xE0, 0x00, 0x00, 0x00, 0xED, 0x00,
  0x4F, 0xA0, 0x00, 0x00, 0x00, 0xAF, 0x40,
  0xAF, 0x50, 0x00, 0x00, 0x00, 0x5F, 0xA0,
  0xEE, 0x00, 0x00, 0x00, 0x00, 0x0E, 0xE0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0042[168] = { /* code 0042, LATIN CAPITAL LETTER B */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xEB, 0x30, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x2A, 0xFC, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0xFE, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x2A, 0xF8, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x90, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xC4, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x07, 0xEF, 0x50,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x4F, 0xC0,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x3F, 0xE0,
  0x00, 0xFF, 0x00, 0x00, 0x04, 0xCF, 0xA0,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFC, 0x90, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0043[192] = { /* code 0043, LATIN CAPITAL LETTER C */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x2A, 0xCF, 0xFC, 0x80, 0x00, 0x00,
  0x00, 0x08, 0xFF, 0xFF, 0xFF, 0xFE, 0x30, 0x00,
  0x00, 0x8F, 0xF8, 0x30, 0x03, 0xBF, 0xE2, 0x00,
  0x02, 0xFF, 0x30, 0x00, 0x00, 0x0B, 0xFA, 0x00,
  0x09, 0xFA, 0x00, 0x00, 0x00, 0x02, 0xC8, 0x00,
  0x0C, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x62, 0x00,
  0x09, 0xFA, 0x00, 0x00, 0x00, 0x05, 0xFD, 0x00,
  0x02, 0xFF, 0x30, 0x00, 0x00, 0x0D, 0xF8, 0x00,
  0x00, 0x9F, 0xE8, 0x20, 0x05, 0xDF, 0xD0, 0x00,
  0x00, 0x0A, 0xFF, 0xFF, 0xFF, 0xFD, 0x30, 0x00,
  0x00, 0x00, 0x4B, 0xEF, 0xFC, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0044[192] = { /* code 0044, LATIN CAPITAL LETTER D */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFC, 0x70, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x05, 0xDF, 0xC0, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x0E, 0xF4, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x08, 0xFA, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x03, 0xFC, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x04, 0xFC, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x08, 0xFA, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x0E, 0xF4, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x06, 0xDF, 0xC0, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFC, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0045[168] = { /* code 0045, LATIN CAPITAL LETTER E */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0046[168] = { /* code 0046, LATIN CAPITAL LETTER F */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0047[192] = { /* code 0047, LATIN CAPITAL LETTER G */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x28, 0xCF, 0xFF, 0xC8, 0x00, 0x00,
  0x00, 0x06, 0xEF, 0xFF, 0xFF, 0xFF, 0xE3, 0x00,
  0x00, 0x6F, 0xFB, 0x50, 0x00, 0x5C, 0xFE, 0x00,
  0x00, 0xEF, 0x60, 0x00, 0x00, 0x00, 0xBF, 0x80,
  0x07, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x3B, 0x50,
  0x0C, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0C, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x07, 0xFB, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0xEF, 0x60, 0x00, 0x00, 0x00, 0x2F, 0xF0,
  0x00, 0x6F, 0xFC, 0x50, 0x00, 0x5A, 0xFF, 0xE0,
  0x00, 0x05, 0xEF, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0x00, 0x00, 0x07, 0xCE, 0xFF, 0xC9, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0048[168] = { /* code 0048, LATIN CAPITAL LETTER H */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0049[ 72] = { /* code 0049, LATIN CAPITAL LETTER I */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_004A[144] = { /* code 004A, LATIN CAPITAL LETTER J */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x0C, 0xF0, 0x00, 0x0F, 0xF0, 0x00,
  0x0F, 0xF3, 0x00, 0x2F, 0xE0, 0x00,
  0x0B, 0xFB, 0x00, 0xAF, 0xB0, 0x00,
  0x04, 0xFF, 0xFF, 0xFF, 0x40, 0x00,
  0x00, 0x5C, 0xFF, 0xB4, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_004B[168] = { /* code 004B, LATIN CAPITAL LETTER K */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x07, 0xFF, 0xA0,
  0x00, 0xFF, 0x00, 0x00, 0x4F, 0xFA, 0x00,
  0x00, 0xFF, 0x00, 0x03, 0xEF, 0xC0, 0x00,
  0x00, 0xFF, 0x00, 0x0C, 0xFC, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0xCF, 0xD0, 0x00, 0x00,
  0x00, 0xFF, 0x09, 0xFE, 0x30, 0x00, 0x00,
  0x00, 0xFF, 0x6F, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0xFF, 0xF6, 0xBF, 0xF3, 0x00, 0x00,
  0x00, 0xFF, 0x60, 0x0C, 0xFD, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x03, 0xEF, 0xB0, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x5F, 0xF7, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x08, 0xFE, 0x30,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0xBF, 0xC0,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x0D, 0xFA,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_004C[144] = { /* code 004C, LATIN CAPITAL LETTER L */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_004D[216] = { /* code 004D, LATIN CAPITAL LETTER M */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0E, 0xC8, 0x30, 0x00, 0x00, 0x00, 0x38, 0xCE, 0x00,
  0x0F, 0xFF, 0xA0, 0x00, 0x00, 0x00, 0xAF, 0xFF, 0x00,
  0x0F, 0xFC, 0xE0, 0x00, 0x00, 0x00, 0xEC, 0xFF, 0x00,
  0x0F, 0xF7, 0xF5, 0x00, 0x00, 0x05, 0xF7, 0xFF, 0x00,
  0x0F, 0xF2, 0xFA, 0x00, 0x00, 0x0A, 0xF2, 0xFF, 0x00,
  0x0F, 0xF0, 0xCE, 0x00, 0x00, 0x0E, 0xC0, 0xFF, 0x00,
  0x0F, 0xF0, 0x7F, 0x60, 0x00, 0x6F, 0x70, 0xFF, 0x00,
  0x0F, 0xF0, 0x2F, 0xB0, 0x00, 0xBF, 0x20, 0xFF, 0x00,
  0x0F, 0xF0, 0x0C, 0xF0, 0x00, 0xFC, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x07, 0xF6, 0x06, 0xF7, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x02, 0xFB, 0x0B, 0xF2, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0xCF, 0x2F, 0xC0, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x7F, 0xCF, 0x70, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x2F, 0xFF, 0x20, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x0C, 0xFC, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_004E[168] = { /* code 004E, LATIN CAPITAL LETTER N */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF7, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xFE, 0x20, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xFF, 0xC0, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF9, 0xF7, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0xDE, 0x20, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x5F, 0xB0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x0B, 0xF5, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0xEE, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x5F, 0xB0, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0B, 0xF4, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x02, 0xED, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x7F, 0x9F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x0C, 0xFF, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x02, 0xEF, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x8F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_004F[192] = { /* code 004F, LATIN CAPITAL LETTER O */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x2A, 0xDF, 0xFD, 0xA2, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0x60, 0x00,
  0x00, 0x6F, 0xFA, 0x30, 0x03, 0xAF, 0xF6, 0x00,
  0x02, 0xFF, 0x60, 0x00, 0x00, 0x06, 0xFE, 0x20,
  0x09, 0xFA, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x80,
  0x0C, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xC0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0C, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xC0,
  0x09, 0xFA, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x90,
  0x02, 0xFF, 0x60, 0x00, 0x00, 0x06, 0xFE, 0x20,
  0x00, 0x6F, 0xFA, 0x30, 0x03, 0xAF, 0xF7, 0x00,
  0x00, 0x06, 0xFF, 0xFF, 0xFF, 0xFF, 0x70, 0x00,
  0x00, 0x00, 0x29, 0xDF, 0xFD, 0x92, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0050[168] = { /* code 0050, LATIN CAPITAL LETTER P */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFD, 0xA2, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x20,
  0x00, 0xFF, 0x00, 0x00, 0x03, 0xCF, 0xA0,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x2F, 0xE0,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x3F, 0xD0,
  0x00, 0xFF, 0x00, 0x00, 0x05, 0xCF, 0xA0,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFC, 0x90, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0051[192] = { /* code 0051, LATIN CAPITAL LETTER Q */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x2A, 0xDF, 0xFD, 0xA2, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0x7F, 0xFA, 0x30, 0x03, 0xAF, 0xF8, 0x00,
  0x02, 0xEF, 0x60, 0x00, 0x00, 0x06, 0xFF, 0x20,
  0x08, 0xFA, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x90,
  0x0C, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xC0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0C, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xC0,
  0x08, 0xFA, 0x00, 0x00, 0x44, 0x00, 0xAF, 0x60,
  0x02, 0xEF, 0x60, 0x00, 0xCF, 0xC7, 0xFD, 0x00,
  0x00, 0x6F, 0xFA, 0x30, 0x09, 0xFF, 0xE3, 0x00,
  0x00, 0x06, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x00, 0x2A, 0xDF, 0xFD, 0xA6, 0xDF, 0xC0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xA0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0052[192] = { /* code 0052, LATIN CAPITAL LETTER R */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xC4, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x40, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x02, 0xBF, 0xB0, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x03, 0xCF, 0xB0, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x30, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFE, 0xB3, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x07, 0xFC, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xCF, 0xC0, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x3F, 0xF7, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x09, 0xFE, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0xEF, 0x80, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xE2, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x0D, 0xFA, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0053[168] = { /* code 0053, LATIN CAPITAL LETTER S */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x8C, 0xFF, 0xFC, 0x70, 0x00,
  0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x00, 0xAF, 0xC5, 0x00, 0x05, 0xCF, 0xA0,
  0x00, 0xFF, 0x20, 0x00, 0x00, 0x2F, 0xE0,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xAF, 0xC5, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0C, 0xFF, 0xFC, 0x84, 0x00, 0x00,
  0x00, 0x00, 0x5A, 0xEF, 0xFF, 0xE5, 0x00,
  0x00, 0x00, 0x00, 0x02, 0x6A, 0xFF, 0x50,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xC0,
  0x0F, 0xF2, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0B, 0xF8, 0x00, 0x00, 0x00, 0x3F, 0xE0,
  0x04, 0xFF, 0xB4, 0x00, 0x06, 0xDF, 0x80,
  0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x00, 0x02, 0xAC, 0xFF, 0xFB, 0x60, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0054[144] = { /* code 0054, LATIN CAPITAL LETTER T */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0055[168] = { /* code 0055, LATIN CAPITAL LETTER U */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0D, 0xF3, 0x00, 0x00, 0x00, 0x4F, 0xD0,
  0x0A, 0xF9, 0x00, 0x00, 0x00, 0xAF, 0xB0,
  0x03, 0xFF, 0x93, 0x00, 0x38, 0xFF, 0x40,
  0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0xF6, 0x00,
  0x00, 0x02, 0xAD, 0xFF, 0xEB, 0x40, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0056[168] = { /* code 0056, LATIN CAPITAL LETTER V */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x3F, 0xD0,
  0x9F, 0x90, 0x00, 0x00, 0x00, 0x9F, 0x90,
  0x3F, 0xD0, 0x00, 0x00, 0x00, 0xDF, 0x30,
  0x0D, 0xF3, 0x00, 0x00, 0x03, 0xFD, 0x00,
  0x09, 0xF9, 0x00, 0x00, 0x09, 0xF9, 0x00,
  0x03, 0xFD, 0x00, 0x00, 0x0D, 0xF3, 0x00,
  0x00, 0xDF, 0x30, 0x00, 0x3F, 0xD0, 0x00,
  0x00, 0x9F, 0x90, 0x00, 0x9F, 0x90, 0x00,
  0x00, 0x3F, 0xD0, 0x00, 0xDF, 0x30, 0x00,
  0x00, 0x0D, 0xF3, 0x03, 0xFD, 0x00, 0x00,
  0x00, 0x09, 0xF9, 0x09, 0xF9, 0x00, 0x00,
  0x00, 0x03, 0xFD, 0x0D, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0xDF, 0x6F, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xFF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0057[264] = { /* code 0057, LATIN CAPITAL LETTER W */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0x20, 0x00, 0x00, 0x2F, 0xFF, 0x20, 0x00, 0x00, 0x3F, 0xD0,
  0xAF, 0x70, 0x00, 0x00, 0x6F, 0xFF, 0x60, 0x00, 0x00, 0x7F, 0xA0,
  0x5F, 0xB0, 0x00, 0x00, 0xBF, 0xAF, 0xA0, 0x00, 0x00, 0xBF, 0x50,
  0x0F, 0xE0, 0x00, 0x00, 0xEF, 0x0F, 0xE0, 0x00, 0x00, 0xEF, 0x00,
  0x0C, 0xF4, 0x00, 0x03, 0xFC, 0x0C, 0xF3, 0x00, 0x04, 0xFC, 0x00,
  0x08, 0xF8, 0x00, 0x08, 0xF8, 0x07, 0xF7, 0x00, 0x08, 0xF8, 0x00,
  0x04, 0xFC, 0x00, 0x0C, 0xF4, 0x03, 0xFC, 0x00, 0x0C, 0xF4, 0x00,
  0x00, 0xFF, 0x00, 0x0F, 0xE0, 0x00, 0xEF, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0xBF, 0x50, 0x5F, 0xB0, 0x00, 0xAF, 0x50, 0x5F, 0xB0, 0x00,
  0x00, 0x7F, 0xA0, 0x9F, 0x70, 0x00, 0x6F, 0x90, 0x9F, 0x70, 0x00,
  0x00, 0x3F, 0xD0, 0xCF, 0x20, 0x00, 0x2F, 0xC0, 0xDF, 0x30, 0x00,
  0x00, 0x0D, 0xF4, 0xFD, 0x00, 0x00, 0x0D, 0xF4, 0xFE, 0x00, 0x00,
  0x00, 0x0A, 0xFC, 0xF9, 0x00, 0x00, 0x09, 0xFC, 0xFA, 0x00, 0x00,
  0x00, 0x06, 0xFF, 0xF5, 0x00, 0x00, 0x05, 0xFF, 0xF6, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0058[168] = { /* code 0058, LATIN CAPITAL LETTER X */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0xFC, 0x00, 0x00, 0x00, 0xCF, 0xA0,
  0x00, 0xDF, 0x80, 0x00, 0x08, 0xFD, 0x00,
  0x00, 0x3F, 0xF3, 0x00, 0x3F, 0xF3, 0x00,
  0x00, 0x07, 0xFC, 0x00, 0xCF, 0x70, 0x00,
  0x00, 0x00, 0xBF, 0x67, 0xFB, 0x00, 0x00,
  0x00, 0x00, 0x0E, 0xDE, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x04, 0xFF, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x08, 0xFF, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xCC, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0xEF, 0x77, 0xFE, 0x00, 0x00,
  0x00, 0x0B, 0xFC, 0x00, 0xCF, 0xB0, 0x00,
  0x00, 0x7F, 0xE2, 0x00, 0x2E, 0xF7, 0x00,
  0x03, 0xFF, 0x60, 0x00, 0x06, 0xFF, 0x30,
  0x0D, 0xFA, 0x00, 0x00, 0x00, 0xAF, 0xD0,
  0xAF, 0xC0, 0x00, 0x00, 0x00, 0x0C, 0xFA,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0059[168] = { /* code 0059, LATIN CAPITAL LETTER Y */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0xC0, 0x00, 0x00, 0x00, 0x0C, 0xFB,
  0x0D, 0xF8, 0x00, 0x00, 0x00, 0x7F, 0xD0,
  0x04, 0xFF, 0x30, 0x00, 0x03, 0xFF, 0x40,
  0x00, 0x9F, 0xC0, 0x00, 0x0C, 0xF9, 0x00,
  0x00, 0x0C, 0xF9, 0x00, 0x8F, 0xC0, 0x00,
  0x00, 0x03, 0xFE, 0x00, 0xEF, 0x30, 0x00,
  0x00, 0x00, 0x8F, 0x99, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0xFF, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x02, 0xFF, 0x20, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_005A[168] = { /* code 005A, LATIN CAPITAL LETTER Z */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x2E, 0xE0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xCF, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0xF6, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x04, 0xFC, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x2E, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x7F, 0xA0, 0x00, 0x00, 0x00, 0x00,
  0x04, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2E, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_005B[ 72] = { /* code 005B, LEFT SQUARE BRACKET */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xF0,
  0x0F, 0xFF, 0xF0,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xFF, 0xF0,
  0x0F, 0xFF, 0xF0,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_005C[ 72] = { /* code 005C, REVERSE SOLIDUS */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0xDF, 0x20, 0x00,
  0xAF, 0x60, 0x00,
  0x6F, 0xB0, 0x00,
  0x0F, 0xE0, 0x00,
  0x0C, 0xF3, 0x00,
  0x09, 0xF7, 0x00,
  0x05, 0xFC, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xCF, 0x40,
  0x00, 0x8F, 0x90,
  0x00, 0x3F, 0xC0,
  0x00, 0x0E, 0xF0,
  0x00, 0x0B, 0xF5,
  0x00, 0x07, 0xFA,
  0x00, 0x02, 0xFD,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_005D[ 72] = { /* code 005D, RIGHT SQUARE BRACKET */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xF0,
  0x0F, 0xFF, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x0F, 0xFF, 0xF0,
  0x0F, 0xFF, 0xF0,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_005E[ 96] = { /* code 005E, CIRCUMFLEX ACCENT */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x3F, 0xF3, 0x00,
  0x00, 0x9F, 0xF9, 0x00,
  0x00, 0xED, 0xDE, 0x00,
  0x05, 0xF9, 0x9F, 0x50,
  0x0B, 0xF3, 0x3F, 0xB0,
  0x0F, 0xD0, 0x0D, 0xF0,
  0x7F, 0x90, 0x09, 0xF7,
  0xCF, 0x30, 0x03, 0xFC,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_005F[144] = { /* code 005F, LOW LINE */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0060[ 96] = { /* code 0060, GRAVE ACCENT */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x0B, 0xF3, 0x00, 0x00,
  0x00, 0xE9, 0x00, 0x00,
  0x00, 0x5D, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0061[144] = { /* code 0061, LATIN SMALL LETTER A */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x4B, 0xEF, 0xFD, 0x80, 0x00,
  0x0A, 0xFF, 0xFF, 0xFF, 0xF9, 0x00,
  0x0F, 0xF7, 0x00, 0x09, 0xFE, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x02, 0x7C, 0xCD, 0xFF, 0x00,
  0x00, 0xBF, 0xFF, 0xFF, 0xFF, 0x00,
  0x0A, 0xFD, 0xA8, 0x52, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x04, 0xFF, 0x00,
  0x0F, 0xF7, 0x00, 0x6E, 0xFF, 0x00,
  0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0x50,
  0x00, 0x9E, 0xFE, 0xB5, 0x4F, 0xC0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0062[144] = { /* code 0062, LATIN SMALL LETTER B */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0xAF, 0xEA, 0x00, 0x00,
  0x0F, 0xFC, 0xFF, 0xFF, 0xC0, 0x00,
  0x0F, 0xFE, 0x40, 0x4E, 0xF7, 0x00,
  0x0F, 0xF6, 0x00, 0x06, 0xFC, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF5, 0x00, 0x06, 0xFC, 0x00,
  0x0F, 0xFE, 0x40, 0x4E, 0xF6, 0x00,
  0x0F, 0xFB, 0xFF, 0xFF, 0xC0, 0x00,
  0x0F, 0xF0, 0xAF, 0xE9, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0063[144] = { /* code 0063, LATIN SMALL LETTER C */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0xCF, 0xFB, 0x20, 0x00,
  0x00, 0xCF, 0xFF, 0xFF, 0xE0, 0x00,
  0x06, 0xFE, 0x50, 0x2C, 0xFA, 0x00,
  0x0C, 0xF6, 0x00, 0x02, 0xFD, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0xF6, 0x00, 0x02, 0xFE, 0x00,
  0x06, 0xFE, 0x40, 0x2C, 0xFA, 0x00,
  0x00, 0xCF, 0xFF, 0xFF, 0xC0, 0x00,
  0x00, 0x08, 0xDF, 0xEA, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0064[144] = { /* code 0064, LATIN SMALL LETTER D */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x0A, 0xEF, 0xA0, 0xFF, 0x00,
  0x00, 0xCF, 0xFF, 0xFC, 0xFF, 0x00,
  0x07, 0xFE, 0x40, 0x4E, 0xFF, 0x00,
  0x0C, 0xF5, 0x00, 0x06, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0C, 0xF6, 0x00, 0x05, 0xFF, 0x00,
  0x06, 0xFE, 0x40, 0x4E, 0xFF, 0x00,
  0x00, 0xCF, 0xFF, 0xFB, 0xFF, 0x00,
  0x00, 0x09, 0xEF, 0xA0, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0065[144] = { /* code 0065, LATIN SMALL LETTER E */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x06, 0xCF, 0xFC, 0x60, 0x00,
  0x00, 0xAF, 0xFF, 0xFF, 0xFA, 0x00,
  0x05, 0xFC, 0x50, 0x04, 0xCF, 0x60,
  0x0B, 0xF2, 0x00, 0x00, 0x2F, 0xC0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0xF7, 0x00, 0x00, 0x00, 0x00,
  0x06, 0xFE, 0x70, 0x02, 0x9F, 0xC0,
  0x00, 0xAF, 0xFF, 0xFF, 0xFE, 0x30,
  0x00, 0x06, 0xCF, 0xFD, 0xA2, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0066[ 72] = { /* code 0066, LATIN SMALL LETTER F */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x2B, 0xFF,
  0x00, 0xCF, 0xFF,
  0x00, 0xFF, 0x30,
  0x00, 0xFF, 0x00,
  0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0067[144] = { /* code 0067, LATIN SMALL LETTER G */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0xEF, 0xA0, 0xFF, 0x00,
  0x00, 0xCF, 0xFF, 0xFB, 0xFF, 0x00,
  0x06, 0xFE, 0x40, 0x4E, 0xFF, 0x00,
  0x0C, 0xF6, 0x00, 0x06, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0C, 0xF6, 0x00, 0x06, 0xFF, 0x00,
  0x06, 0xFE, 0x40, 0x4E, 0xFF, 0x00,
  0x00, 0xCF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x0A, 0xEF, 0xC5, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFC, 0x00,
  0x0F, 0xF7, 0x00, 0x2C, 0xFA, 0x00,
  0x09, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0x8C, 0xFF, 0xDA, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0068[144] = { /* code 0068, LATIN SMALL LETTER H */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x8E, 0xFD, 0x70, 0x00,
  0x0F, 0xFB, 0xFF, 0xFF, 0xF8, 0x00,
  0x0F, 0xFE, 0x50, 0x0A, 0xFC, 0x00,
  0x0F, 0xF5, 0x00, 0x02, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0069[ 72] = { /* code 0069, LATIN SMALL LETTER I */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_006A[ 48] = { /* code 006A, LATIN SMALL LETTER J */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x3F, 0xF0,
  0xFF, 0xB0,
  0xFC, 0x30,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_006B[120] = { /* code 006B, LATIN SMALL LETTER K */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x0A, 0xF6,
  0x0F, 0xF0, 0x00, 0xAF, 0xA0,
  0x0F, 0xF0, 0x0A, 0xFA, 0x00,
  0x0F, 0xF0, 0xAF, 0xA0, 0x00,
  0x0F, 0xFA, 0xFF, 0x50, 0x00,
  0x0F, 0xFF, 0xDF, 0xD0, 0x00,
  0x0F, 0xF6, 0x2F, 0xF8, 0x00,
  0x0F, 0xF0, 0x08, 0xFE, 0x00,
  0x0F, 0xF0, 0x00, 0xCF, 0x90,
  0x0F, 0xF0, 0x00, 0x4F, 0xF2,
  0x0F, 0xF0, 0x00, 0x09, 0xFC,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_006C[ 48] = { /* code 006C, LATIN SMALL LETTER L */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_006D[192] = { /* code 006D, LATIN SMALL LETTER M */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x9F, 0xE9, 0x00, 0xAF, 0xFA, 0x00,
  0x0F, 0xF9, 0xFF, 0xFF, 0x6C, 0xFF, 0xFF, 0xA0,
  0x0F, 0xFC, 0x20, 0x8F, 0xFC, 0x20, 0x8F, 0xE0,
  0x0F, 0xF5, 0x00, 0x0F, 0xF3, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_006E[144] = { /* code 006E, LATIN SMALL LETTER N */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0xAE, 0xFD, 0x80, 0x00,
  0x0F, 0xFD, 0xFF, 0xFF, 0xF8, 0x00,
  0x0F, 0xFE, 0x50, 0x0A, 0xFD, 0x00,
  0x0F, 0xF5, 0x00, 0x02, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_006F[144] = { /* code 006F, LATIN SMALL LETTER O */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x06, 0xCF, 0xFC, 0x60, 0x00,
  0x00, 0xAF, 0xFF, 0xFF, 0xFA, 0x00,
  0x06, 0xFE, 0x60, 0x07, 0xEF, 0x60,
  0x0C, 0xF7, 0x00, 0x00, 0x7F, 0xC0,
  0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF0,
  0x0C, 0xF7, 0x00, 0x00, 0x7F, 0xC0,
  0x06, 0xFE, 0x70, 0x07, 0xEF, 0x60,
  0x00, 0xAF, 0xFF, 0xFF, 0xFA, 0x00,
  0x00, 0x06, 0xCF, 0xFC, 0x60, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0070[144] = { /* code 0070, LATIN SMALL LETTER P */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0xAF, 0xEA, 0x00, 0x00,
  0x0F, 0xF9, 0xFF, 0xFF, 0xC0, 0x00,
  0x0F, 0xFE, 0x40, 0x4E, 0xF7, 0x00,
  0x0F, 0xF6, 0x00, 0x06, 0xFC, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF5, 0x00, 0x06, 0xFB, 0x00,
  0x0F, 0xFE, 0x40, 0x4E, 0xF6, 0x00,
  0x0F, 0xFC, 0xFF, 0xFF, 0xC0, 0x00,
  0x0F, 0xF0, 0xCF, 0xD8, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0071[144] = { /* code 0071, LATIN SMALL LETTER Q */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0xEF, 0x90, 0xFF, 0x00,
  0x00, 0xCF, 0xFF, 0xF9, 0xFF, 0x00,
  0x07, 0xFE, 0x40, 0x4E, 0xFF, 0x00,
  0x0C, 0xF6, 0x00, 0x06, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0C, 0xF6, 0x00, 0x05, 0xFF, 0x00,
  0x06, 0xFE, 0x40, 0x4E, 0xFF, 0x00,
  0x00, 0xAF, 0xFF, 0xFC, 0xFF, 0x00,
  0x00, 0x08, 0xDF, 0xC0, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0072[ 96] = { /* code 0072, LATIN SMALL LETTER R */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF2, 0xDF, 0xC0,
  0x0F, 0xFC, 0xFF, 0xA0,
  0x0F, 0xFC, 0x20, 0x00,
  0x0F, 0xF5, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0073[144] = { /* code 0073, LATIN SMALL LETTER S */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x5C, 0xFF, 0xEB, 0x50, 0x00,
  0x06, 0xFF, 0xFF, 0xFF, 0xF6, 0x00,
  0x0E, 0xF7, 0x00, 0x07, 0xFD, 0x00,
  0x0F, 0xF7, 0x00, 0x00, 0x00, 0x00,
  0x09, 0xFF, 0xEA, 0x74, 0x00, 0x00,
  0x00, 0x8E, 0xFF, 0xFF, 0xE3, 0x00,
  0x00, 0x00, 0x48, 0xCE, 0xFD, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x0D, 0xF5, 0x00, 0x07, 0xFD, 0x00,
  0x05, 0xFF, 0xFF, 0xFF, 0xF5, 0x00,
  0x00, 0x5B, 0xFF, 0xFB, 0x40, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0074[ 72] = { /* code 0074, LATIN SMALL LETTER T */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x80, 0x00,
  0x0E, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF3, 0x00,
  0x0D, 0xFF, 0xE0,
  0x05, 0xDF, 0xE0,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0075[144] = { /* code 0075, LATIN SMALL LETTER U */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0F, 0xF2, 0x00, 0x05, 0xFF, 0x00,
  0x0D, 0xFA, 0x00, 0x5E, 0xFF, 0x00,
  0x08, 0xFF, 0xFF, 0xFA, 0xFF, 0x00,
  0x00, 0x7D, 0xFE, 0xA0, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0076[144] = { /* code 0076, LATIN SMALL LETTER V */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFD, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xAF, 0x60, 0x00, 0x00, 0x6F, 0xA0,
  0x3F, 0xD0, 0x00, 0x00, 0xDF, 0x20,
  0x0C, 0xF5, 0x00, 0x04, 0xFC, 0x00,
  0x04, 0xFC, 0x00, 0x0C, 0xF4, 0x00,
  0x00, 0xCF, 0x40, 0x3F, 0xC0, 0x00,
  0x00, 0x6F, 0xB0, 0xAF, 0x40, 0x00,
  0x00, 0x0D, 0xF6, 0xFD, 0x00, 0x00,
  0x00, 0x06, 0xFF, 0xF6, 0x00, 0x00,
  0x00, 0x00, 0xEF, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x8F, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0077[192] = { /* code 0077, LATIN SMALL LETTER W */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFB, 0x00, 0x00, 0x5F, 0x60, 0x00, 0x0B, 0xF0,
  0xDF, 0x00, 0x00, 0xAF, 0xA0, 0x00, 0x0F, 0xD0,
  0x7F, 0x70, 0x00, 0xEF, 0xE0, 0x00, 0x7F, 0x80,
  0x0F, 0xC0, 0x03, 0xFC, 0xF4, 0x00, 0xCF, 0x20,
  0x0A, 0xF3, 0x09, 0xF4, 0xF9, 0x03, 0xFA, 0x00,
  0x03, 0xF9, 0x0C, 0xD0, 0xDD, 0x09, 0xF4, 0x00,
  0x00, 0xCD, 0x2F, 0xA0, 0xAF, 0x2D, 0xD0, 0x00,
  0x00, 0x6F, 0xAF, 0x50, 0x6F, 0xBF, 0x70, 0x00,
  0x00, 0x0E, 0xFF, 0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x09, 0xFC, 0x00, 0x0C, 0xFA, 0x00, 0x00,
  0x00, 0x02, 0xF9, 0x00, 0x09, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0078[120] = { /* code 0078, LATIN SMALL LETTER X */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0xB0, 0x00, 0x0B, 0xFB,
  0x0D, 0xF6, 0x00, 0x6F, 0xE0,
  0x04, 0xFE, 0x22, 0xEF, 0x40,
  0x00, 0x9F, 0x77, 0xF9, 0x00,
  0x00, 0x0C, 0xDD, 0xC0, 0x00,
  0x00, 0x07, 0xFF, 0x60, 0x00,
  0x00, 0x2E, 0xDE, 0xD0, 0x00,
  0x00, 0xCF, 0x67, 0xFB, 0x00,
  0x08, 0xFD, 0x00, 0xCF, 0x50,
  0x4F, 0xF6, 0x00, 0x3F, 0xE0,
  0xDF, 0xD0, 0x00, 0x0A, 0xFB,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_0079[144] = { /* code 0079, LATIN SMALL LETTER Y */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2F, 0xD0, 0x00, 0x02, 0xFD, 0x00,
  0x0C, 0xF5, 0x00, 0x06, 0xFA, 0x00,
  0x06, 0xFC, 0x00, 0x0B, 0xF6, 0x00,
  0x00, 0xDF, 0x20, 0x0E, 0xF0, 0x00,
  0x00, 0x8F, 0x90, 0x3F, 0xC0, 0x00,
  0x00, 0x2F, 0xE0, 0x8F, 0x90, 0x00,
  0x00, 0x0A, 0xF6, 0xCF, 0x40, 0x00,
  0x00, 0x04, 0xFC, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xDF, 0xFB, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x2F, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0x8F, 0xD0, 0x00, 0x00,
  0x00, 0x04, 0xEF, 0x50, 0x00, 0x00,
  0x0F, 0xFF, 0xFA, 0x00, 0x00, 0x00,
  0x0D, 0xFD, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_007A[120] = { /* code 007A, LATIN SMALL LETTER Z */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xCF, 0xE0,
  0x00, 0x00, 0x0C, 0xFE, 0x30,
  0x00, 0x00, 0xCF, 0xC3, 0x00,
  0x00, 0x3E, 0xFC, 0x00, 0x00,
  0x03, 0xEF, 0xB0, 0x00, 0x00,
  0x3E, 0xFA, 0x00, 0x00, 0x00,
  0xEF, 0xA0, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_007B[ 96] = { /* code 007B, LEFT CURLY BRACKET */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x0B, 0xFF, 0x00,
  0x00, 0xCF, 0xFF, 0x00,
  0x00, 0xFF, 0x50, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x02, 0xFE, 0x00, 0x00,
  0x0A, 0xF9, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00,
  0x0B, 0xF8, 0x00, 0x00,
  0x03, 0xFC, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xEF, 0x50, 0x00,
  0x00, 0xAF, 0xFF, 0x00,
  0x00, 0x0A, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_007C[ 72] = { /* code 007C, VERTICAL LINE */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_007D[ 96] = { /* code 007D, RIGHT CURLY BRACKET */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFB, 0x00, 0x00,
  0x0F, 0xFF, 0xB0, 0x00,
  0x00, 0x4F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0E, 0xF2, 0x00,
  0x00, 0x09, 0xFA, 0x00,
  0x00, 0x00, 0x9F, 0xF0,
  0x00, 0x00, 0x9F, 0xF0,
  0x00, 0x09, 0xFB, 0x00,
  0x00, 0x0E, 0xF3, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x5F, 0xF0, 0x00,
  0x0F, 0xFF, 0xA0, 0x00,
  0x0F, 0xFB, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA4_24_007E[144] = { /* code 007E, TILDE */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xAF, 0xD8, 0x00, 0x00, 0x60,
  0x0C, 0xFF, 0xFF, 0xD4, 0x07, 0xF0,
  0x0F, 0x60, 0x4C, 0xFF, 0xFF, 0xB0,
  0x06, 0x00, 0x00, 0x7D, 0xFA, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO GUI_FontAA4_24_CharInfo[95] = {
   {   6,   6,  3, acGUI_FontAA4_24_0020 } /* code 0020 */
  ,{   6,   6,  3, acGUI_FontAA4_24_0021 } /* code 0021 */
  ,{   7,   7,  4, acGUI_FontAA4_24_0022 } /* code 0022 */
  ,{  12,  12,  6, acGUI_FontAA4_24_0023 } /* code 0023 */
  ,{  12,  12,  6, acGUI_FontAA4_24_0024 } /* code 0024 */
  ,{  19,  19, 10, acGUI_FontAA4_24_0025 } /* code 0025 */
  ,{  14,  14,  7, acGUI_FontAA4_24_0026 } /* code 0026 */
  ,{   4,   4,  2, acGUI_FontAA4_24_0027 } /* code 0027 */
  ,{   7,   7,  4, acGUI_FontAA4_24_0028 } /* code 0028 */
  ,{   7,   7,  4, acGUI_FontAA4_24_0029 } /* code 0029 */
  ,{   8,   8,  4, acGUI_FontAA4_24_002A } /* code 002A */
  ,{  12,  12,  6, acGUI_FontAA4_24_002B } /* code 002B */
  ,{   6,   6,  3, acGUI_FontAA4_24_002C } /* code 002C */
  ,{   7,   7,  4, acGUI_FontAA4_24_002D } /* code 002D */
  ,{   6,   6,  3, acGUI_FontAA4_24_002E } /* code 002E */
  ,{   6,   6,  3, acGUI_FontAA4_24_002F } /* code 002F */
  ,{  12,  12,  6, acGUI_FontAA4_24_0030 } /* code 0030 */
  ,{  12,  12,  6, acGUI_FontAA4_24_0031 } /* code 0031 */
  ,{  12,  12,  6, acGUI_FontAA4_24_0032 } /* code 0032 */
  ,{  12,  12,  6, acGUI_FontAA4_24_0033 } /* code 0033 */
  ,{  12,  12,  6, acGUI_FontAA4_24_0034 } /* code 0034 */
  ,{  12,  12,  6, acGUI_FontAA4_24_0035 } /* code 0035 */
  ,{  12,  12,  6, acGUI_FontAA4_24_0036 } /* code 0036 */
  ,{  12,  12,  6, acGUI_FontAA4_24_0037 } /* code 0037 */
  ,{  12,  12,  6, acGUI_FontAA4_24_0038 } /* code 0038 */
  ,{  12,  12,  6, acGUI_FontAA4_24_0039 } /* code 0039 */
  ,{   6,   6,  3, acGUI_FontAA4_24_003A } /* code 003A */
  ,{   6,   6,  3, acGUI_FontAA4_24_003B } /* code 003B */
  ,{  12,  12,  6, acGUI_FontAA4_24_003C } /* code 003C */
  ,{  12,  12,  6, acGUI_FontAA4_24_003D } /* code 003D */
  ,{  12,  12,  6, acGUI_FontAA4_24_003E } /* code 003E */
  ,{  12,  12,  6, acGUI_FontAA4_24_003F } /* code 003F */
  ,{  21,  21, 11, acGUI_FontAA4_24_0040 } /* code 0040 */
  ,{  13,  13,  7, acGUI_FontAA4_24_0041 } /* code 0041 */
  ,{  14,  14,  7, acGUI_FontAA4_24_0042 } /* code 0042 */
  ,{  15,  15,  8, acGUI_FontAA4_24_0043 } /* code 0043 */
  ,{  15,  15,  8, acGUI_FontAA4_24_0044 } /* code 0044 */
  ,{  14,  14,  7, acGUI_FontAA4_24_0045 } /* code 0045 */
  ,{  13,  13,  7, acGUI_FontAA4_24_0046 } /* code 0046 */
  ,{  16,  16,  8, acGUI_FontAA4_24_0047 } /* code 0047 */
  ,{  14,  14,  7, acGUI_FontAA4_24_0048 } /* code 0048 */
  ,{   6,   6,  3, acGUI_FontAA4_24_0049 } /* code 0049 */
  ,{  11,  11,  6, acGUI_FontAA4_24_004A } /* code 004A */
  ,{  14,  14,  7, acGUI_FontAA4_24_004B } /* code 004B */
  ,{  12,  12,  6, acGUI_FontAA4_24_004C } /* code 004C */
  ,{  17,  17,  9, acGUI_FontAA4_24_004D } /* code 004D */
  ,{  14,  14,  7, acGUI_FontAA4_24_004E } /* code 004E */
  ,{  16,  16,  8, acGUI_FontAA4_24_004F } /* code 004F */
  ,{  14,  14,  7, acGUI_FontAA4_24_0050 } /* code 0050 */
  ,{  16,  16,  8, acGUI_FontAA4_24_0051 } /* code 0051 */
  ,{  15,  15,  8, acGUI_FontAA4_24_0052 } /* code 0052 */
  ,{  14,  14,  7, acGUI_FontAA4_24_0053 } /* code 0053 */
  ,{  12,  12,  6, acGUI_FontAA4_24_0054 } /* code 0054 */
  ,{  14,  14,  7, acGUI_FontAA4_24_0055 } /* code 0055 */
  ,{  13,  13,  7, acGUI_FontAA4_24_0056 } /* code 0056 */
  ,{  21,  21, 11, acGUI_FontAA4_24_0057 } /* code 0057 */
  ,{  14,  14,  7, acGUI_FontAA4_24_0058 } /* code 0058 */
  ,{  14,  14,  7, acGUI_FontAA4_24_0059 } /* code 0059 */
  ,{  13,  13,  7, acGUI_FontAA4_24_005A } /* code 005A */
  ,{   6,   6,  3, acGUI_FontAA4_24_005B } /* code 005B */
  ,{   6,   6,  3, acGUI_FontAA4_24_005C } /* code 005C */
  ,{   6,   6,  3, acGUI_FontAA4_24_005D } /* code 005D */
  ,{   8,   8,  4, acGUI_FontAA4_24_005E } /* code 005E */
  ,{  12,  12,  6, acGUI_FontAA4_24_005F } /* code 005F */
  ,{   7,   7,  4, acGUI_FontAA4_24_0060 } /* code 0060 */
  ,{  12,  12,  6, acGUI_FontAA4_24_0061 } /* code 0061 */
  ,{  11,  11,  6, acGUI_FontAA4_24_0062 } /* code 0062 */
  ,{  11,  11,  6, acGUI_FontAA4_24_0063 } /* code 0063 */
  ,{  11,  11,  6, acGUI_FontAA4_24_0064 } /* code 0064 */
  ,{  12,  12,  6, acGUI_FontAA4_24_0065 } /* code 0065 */
  ,{   6,   6,  3, acGUI_FontAA4_24_0066 } /* code 0066 */
  ,{  11,  11,  6, acGUI_FontAA4_24_0067 } /* code 0067 */
  ,{  11,  11,  6, acGUI_FontAA4_24_0068 } /* code 0068 */
  ,{   5,   5,  3, acGUI_FontAA4_24_0069 } /* code 0069 */
  ,{   4,   4,  2, acGUI_FontAA4_24_006A } /* code 006A */
  ,{  10,  10,  5, acGUI_FontAA4_24_006B } /* code 006B */
  ,{   4,   4,  2, acGUI_FontAA4_24_006C } /* code 006C */
  ,{  16,  16,  8, acGUI_FontAA4_24_006D } /* code 006D */
  ,{  11,  11,  6, acGUI_FontAA4_24_006E } /* code 006E */
  ,{  12,  12,  6, acGUI_FontAA4_24_006F } /* code 006F */
  ,{  11,  11,  6, acGUI_FontAA4_24_0070 } /* code 0070 */
  ,{  11,  11,  6, acGUI_FontAA4_24_0071 } /* code 0071 */
  ,{   7,   7,  4, acGUI_FontAA4_24_0072 } /* code 0072 */
  ,{  11,  11,  6, acGUI_FontAA4_24_0073 } /* code 0073 */
  ,{   6,   6,  3, acGUI_FontAA4_24_0074 } /* code 0074 */
  ,{  11,  11,  6, acGUI_FontAA4_24_0075 } /* code 0075 */
  ,{  11,  11,  6, acGUI_FontAA4_24_0076 } /* code 0076 */
  ,{  16,  16,  8, acGUI_FontAA4_24_0077 } /* code 0077 *//**/
  ,{  10,  10,  5, acGUI_FontAA4_24_0078 } /* code 0078 */
  ,{  11,  11,  6, acGUI_FontAA4_24_0079 } /* code 0079 */
  ,{   9,   9,  5, acGUI_FontAA4_24_007A } /* code 007A */
  ,{   7,   7,  4, acGUI_FontAA4_24_007B } /* code 007B */
  ,{   6,   6,  3, acGUI_FontAA4_24_007C } /* code 007C */
  ,{   7,   7,  4, acGUI_FontAA4_24_007D } /* code 007D */
  ,{  12,  12,  6, acGUI_FontAA4_24_007E } /* code 007E */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontAA4_24_Prop1 = {
   0x0020 /* first character */
  ,0x007E /* last character  */
  ,&GUI_FontAA4_24_CharInfo[  0] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP *)0 /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_FontAA4_24 = {
   GUI_FONTTYPE_PROP_AA4 /* type of font    */
  ,24 /* height of font  */
  ,24 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_FontAA4_24_Prop1}
  ,19 /* Baseline */
  ,11 /* Height of lowercase characters */
  ,15 /* Height of capital characters */
};

