/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2014  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.24 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software has been licensed to  ARM LIMITED whose registered office
is situated at  110 Fulbourn Road,  Cambridge CB1 9NJ,  England solely
for  the  purposes  of  creating  libraries  for  ARM7, ARM9, Cortex-M
series,  and   Cortex-R4   processor-based  devices,  sublicensed  and
distributed as part of the  MDK-ARM  Professional  under the terms and
conditions  of  the   End  User  License  supplied  with  the  MDK-ARM
Professional. 
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
File        : AA2_32.c
Purpose     : Font file
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI.H"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/* The following line needs to be included in any file selecting the
   font. A good place would be GUIConf.H
*/
extern GUI_CONST_STORAGE GUI_FONT GUI_FontAA2_32;

/* Start of unicode area <Basic Latin> */
GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0020[ 64] = { /* code 0020, SPACE */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0021[ 64] = { /* code 0021, EXCLAMATION MARK */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0B, 0xE0,
  0x0B, 0xE0,
  0x0B, 0xE0,
  0x0B, 0xE0,
  0x07, 0xD0,
  0x07, 0xD0,
  0x07, 0xD0,
  0x03, 0xC0,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0022[128] = { /* code 0022, QUOTATION MARK */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x3F, 0xC3, 0xFC, 0x00,
  0x3F, 0xC3, 0xFC, 0x00,
  0x3F, 0xC3, 0xFC, 0x00,
  0x3F, 0xC3, 0xFC, 0x00,
  0x2F, 0x82, 0xF8, 0x00,
  0x2F, 0x82, 0xF8, 0x00,
  0x1F, 0x81, 0xF8, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0023[128] = { /* code 0023, NUMBER SIGN */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x3F, 0x03, 0xF0,
  0x00, 0x7E, 0x07, 0xE0,
  0x00, 0xBE, 0x0B, 0xE0,
  0x00, 0xBD, 0x0B, 0xD0,
  0x00, 0xFC, 0x0F, 0xC0,
  0xFF, 0xFF, 0xFF, 0xFC,
  0xFF, 0xFF, 0xFF, 0xFC,
  0xFF, 0xFF, 0xFF, 0xFC,
  0x02, 0xF4, 0x2F, 0x40,
  0x02, 0xF0, 0x2F, 0x00,
  0x03, 0xF0, 0x3F, 0x00,
  0x07, 0xE0, 0x7E, 0x00,
  0xFF, 0xFF, 0xFF, 0xFC,
  0xFF, 0xFF, 0xFF, 0xFC,
  0xFF, 0xFF, 0xFF, 0xFC,
  0x0F, 0xC0, 0xFC, 0x00,
  0x1F, 0x81, 0xF8, 0x00,
  0x2F, 0x82, 0xF8, 0x00,
  0x2F, 0x42, 0xF4, 0x00,
  0x3F, 0x03, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0024[128] = { /* code 0024, DOLLAR SIGN */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x03, 0xC0, 0x00,
  0x00, 0x6F, 0xF8, 0x00,
  0x01, 0xFF, 0xFF, 0x40,
  0x07, 0xFF, 0xFF, 0xC0,
  0x0B, 0xE7, 0xDF, 0xE0,
  0x0F, 0xD3, 0xC7, 0xF0,
  0x0F, 0xC3, 0xC0, 0x00,
  0x0F, 0xE3, 0xC0, 0x00,
  0x0B, 0xFB, 0xC0, 0x00,
  0x07, 0xFF, 0xE4, 0x00,
  0x01, 0xFF, 0xFE, 0x40,
  0x00, 0x6F, 0xFF, 0xC0,
  0x00, 0x07, 0xFF, 0xE0,
  0x00, 0x03, 0xCB, 0xE0,
  0x00, 0x03, 0xC3, 0xF0,
  0x0F, 0xC3, 0xC3, 0xF0,
  0x0B, 0xE3, 0xC3, 0xE0,
  0x07, 0xF7, 0xCB, 0xE0,
  0x03, 0xFF, 0xFF, 0xC0,
  0x01, 0xFF, 0xFF, 0x40,
  0x00, 0x2F, 0xE8, 0x00,
  0x00, 0x03, 0xC0, 0x00,
  0x00, 0x03, 0xC0, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0025[192] = { /* code 0025, PERCENT SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0xFE, 0x00, 0x02, 0xF4, 0x00,
  0x0F, 0xFF, 0xC0, 0x03, 0xF0, 0x00,
  0x2F, 0x8B, 0xE0, 0x0B, 0xE0, 0x00,
  0x2F, 0x03, 0xE0, 0x0F, 0xC0, 0x00,
  0x3F, 0x03, 0xF0, 0x2F, 0x80, 0x00,
  0x3F, 0x03, 0xF0, 0x3F, 0x00, 0x00,
  0x2F, 0x03, 0xE0, 0xBE, 0x00, 0x00,
  0x2F, 0x8B, 0xE0, 0xFC, 0x00, 0x00,
  0x0F, 0xFF, 0xC1, 0xF8, 0x00, 0x00,
  0x02, 0xFE, 0x02, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xC0, 0xBF, 0x80,
  0x00, 0x00, 0x1F, 0x83, 0xFF, 0xF0,
  0x00, 0x00, 0x2F, 0x4B, 0xE2, 0xF8,
  0x00, 0x00, 0x7E, 0x0B, 0xC0, 0xF8,
  0x00, 0x00, 0xBD, 0x0F, 0xC0, 0xFC,
  0x00, 0x01, 0xF8, 0x0F, 0xC0, 0xFC,
  0x00, 0x02, 0xF4, 0x0B, 0xC0, 0xF8,
  0x00, 0x07, 0xE0, 0x0B, 0xE2, 0xF8,
  0x00, 0x0B, 0xD0, 0x03, 0xFF, 0xF0,
  0x00, 0x0F, 0x80, 0x00, 0xBF, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0026[160] = { /* code 0026, AMPERSAND */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1B, 0xF9, 0x00, 0x00,
  0x00, 0xBF, 0xFF, 0x80, 0x00,
  0x02, 0xFF, 0xFF, 0xE0, 0x00,
  0x03, 0xFD, 0x2F, 0xE0, 0x00,
  0x03, 0xFC, 0x0F, 0xF0, 0x00,
  0x02, 0xFD, 0x1F, 0xE0, 0x00,
  0x01, 0xFF, 0x7F, 0xD0, 0x00,
  0x00, 0xBF, 0xFF, 0x80, 0x00,
  0x00, 0x2F, 0xF9, 0x00, 0x00,
  0x00, 0xBF, 0xF8, 0x00, 0x00,
  0x07, 0xFF, 0xFD, 0x04, 0x00,
  0x0F, 0xFA, 0xFF, 0x1F, 0xD0,
  0x2F, 0xE0, 0xBF, 0xAF, 0xC0,
  0x3F, 0xC0, 0x7F, 0xFF, 0x80,
  0x3F, 0xC0, 0x2F, 0xFF, 0x40,
  0x3F, 0xD0, 0x0B, 0xFF, 0x40,
  0x2F, 0xE0, 0x6F, 0xFF, 0xE0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xF8,
  0x07, 0xFF, 0xFF, 0x9B, 0xE0,
  0x00, 0x6F, 0xE8, 0x02, 0x90,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0027[ 64] = { /* code 0027, APOSTROPHE */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x3F, 0xC0,
  0x3F, 0xC0,
  0x3F, 0xC0,
  0x3F, 0xC0,
  0x2F, 0x80,
  0x2F, 0x80,
  0x1F, 0x80,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0028[ 96] = { /* code 0028, LEFT PARENTHESIS */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x7E, 0x00,
  0x00, 0xBD, 0x00,
  0x02, 0xFC, 0x00,
  0x03, 0xF8, 0x00,
  0x07, 0xF4, 0x00,
  0x0B, 0xF0, 0x00,
  0x0F, 0xE0, 0x00,
  0x1F, 0xE0, 0x00,
  0x2F, 0xD0, 0x00,
  0x2F, 0xD0, 0x00,
  0x3F, 0xC0, 0x00,
  0x3F, 0xC0, 0x00,
  0x3F, 0xC0, 0x00,
  0x3F, 0xC0, 0x00,
  0x3F, 0xC0, 0x00,
  0x2F, 0xD0, 0x00,
  0x2F, 0xD0, 0x00,
  0x1F, 0xE0, 0x00,
  0x0F, 0xE0, 0x00,
  0x0B, 0xF0, 0x00,
  0x07, 0xF4, 0x00,
  0x02, 0xF8, 0x00,
  0x02, 0xFC, 0x00,
  0x00, 0xBD, 0x00,
  0x00, 0x7E, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0029[ 96] = { /* code 0029, RIGHT PARENTHESIS */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x2F, 0x40, 0x00,
  0x1F, 0x80, 0x00,
  0x0F, 0xE0, 0x00,
  0x0B, 0xF0, 0x00,
  0x07, 0xF4, 0x00,
  0x03, 0xF8, 0x00,
  0x02, 0xFC, 0x00,
  0x02, 0xFD, 0x00,
  0x01, 0xFE, 0x00,
  0x01, 0xFE, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFE, 0x00,
  0x01, 0xFE, 0x00,
  0x01, 0xFE, 0x00,
  0x02, 0xFD, 0x00,
  0x02, 0xFC, 0x00,
  0x03, 0xF8, 0x00,
  0x07, 0xF4, 0x00,
  0x0B, 0xE0, 0x00,
  0x0B, 0xE0, 0x00,
  0x1F, 0x80, 0x00,
  0x2F, 0x40, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_002A[ 96] = { /* code 002A, ASTERISK */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0xF0, 0x00,
  0x00, 0xF0, 0x00,
  0xA4, 0xA1, 0xA0,
  0xBF, 0xFB, 0xE0,
  0x1A, 0xFA, 0x40,
  0x07, 0xFD, 0x00,
  0x1F, 0x9F, 0x40,
  0x2E, 0x0B, 0x80,
  0x18, 0x02, 0x40,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_002B[128] = { /* code 002B, PLUS SIGN */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x3F, 0xFF, 0xFF, 0xFC,
  0x3F, 0xFF, 0xFF, 0xFC,
  0x3F, 0xFF, 0xFF, 0xFC,
  0x3F, 0xFF, 0xFF, 0xFC,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_002C[ 64] = { /* code 002C, COMMA */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x00, 0xE0,
  0x02, 0xE0,
  0x0B, 0xC0,
  0x06, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_002D[ 96] = { /* code 002D, HYPHEN-MINUS */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3F, 0xFF, 0xC0,
  0x3F, 0xFF, 0xC0,
  0x3F, 0xFF, 0xC0,
  0x3F, 0xFF, 0xC0,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_002E[ 64] = { /* code 002E, FULL STOP */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_002F[ 64] = { /* code 002F, SOLIDUS */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x3E,
  0x00, 0x7E,
  0x00, 0xBD,
  0x00, 0xBC,
  0x00, 0xF8,
  0x01, 0xF8,
  0x02, 0xF4,
  0x02, 0xF0,
  0x03, 0xE0,
  0x07, 0xE0,
  0x0B, 0xD0,
  0x0B, 0xC0,
  0x0F, 0x80,
  0x1F, 0x80,
  0x2F, 0x40,
  0x2F, 0x00,
  0x3E, 0x00,
  0x7E, 0x00,
  0xBD, 0x00,
  0xBC, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0030[128] = { /* code 0030, DIGIT ZERO */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x6F, 0xE4, 0x00,
  0x02, 0xFF, 0xFE, 0x00,
  0x07, 0xFF, 0xFF, 0x40,
  0x0F, 0xF4, 0x7F, 0xC0,
  0x1F, 0xE0, 0x2F, 0xD0,
  0x2F, 0xD0, 0x1F, 0xE0,
  0x2F, 0xD0, 0x1F, 0xE0,
  0x2F, 0xC0, 0x0F, 0xE0,
  0x3F, 0xC0, 0x0F, 0xF0,
  0x3F, 0xC0, 0x0F, 0xF0,
  0x3F, 0xC0, 0x0F, 0xF0,
  0x3F, 0xC0, 0x0F, 0xF0,
  0x3F, 0xC0, 0x0F, 0xE0,
  0x2F, 0xC0, 0x1F, 0xE0,
  0x2F, 0xD0, 0x1F, 0xE0,
  0x1F, 0xE0, 0x2F, 0xD0,
  0x0F, 0xF4, 0x7F, 0x80,
  0x07, 0xFF, 0xFF, 0x40,
  0x02, 0xFF, 0xFE, 0x00,
  0x00, 0x6F, 0xE4, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0031[128] = { /* code 0031, DIGIT ONE */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xFC, 0x00,
  0x00, 0x03, 0xFC, 0x00,
  0x00, 0x0B, 0xFC, 0x00,
  0x00, 0x6F, 0xFC, 0x00,
  0x06, 0xFF, 0xFC, 0x00,
  0x0F, 0xFF, 0xFC, 0x00,
  0x0F, 0xF7, 0xFC, 0x00,
  0x0F, 0x83, 0xFC, 0x00,
  0x09, 0x03, 0xFC, 0x00,
  0x00, 0x03, 0xFC, 0x00,
  0x00, 0x03, 0xFC, 0x00,
  0x00, 0x03, 0xFC, 0x00,
  0x00, 0x03, 0xFC, 0x00,
  0x00, 0x03, 0xFC, 0x00,
  0x00, 0x03, 0xFC, 0x00,
  0x00, 0x03, 0xFC, 0x00,
  0x00, 0x03, 0xFC, 0x00,
  0x00, 0x03, 0xFC, 0x00,
  0x00, 0x03, 0xFC, 0x00,
  0x00, 0x03, 0xFC, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0032[128] = { /* code 0032, DIGIT TWO */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x6F, 0xE8, 0x00,
  0x06, 0xFF, 0xFF, 0x40,
  0x0F, 0xFF, 0xFF, 0xC0,
  0x2F, 0xE4, 0x2F, 0xE0,
  0x2F, 0xD0, 0x1F, 0xE0,
  0x2A, 0xC0, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x2F, 0xE0,
  0x00, 0x00, 0x7F, 0xD0,
  0x00, 0x00, 0xBF, 0x80,
  0x00, 0x02, 0xFE, 0x00,
  0x00, 0x0B, 0xFD, 0x00,
  0x00, 0x2F, 0xF4, 0x00,
  0x00, 0xBF, 0xD0, 0x00,
  0x02, 0xFF, 0x40, 0x00,
  0x07, 0xFD, 0x00, 0x00,
  0x0F, 0xF4, 0x00, 0x00,
  0x1F, 0xFF, 0xFF, 0xF0,
  0x2F, 0xFF, 0xFF, 0xF0,
  0x3F, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0033[128] = { /* code 0033, DIGIT THREE */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0xAF, 0xA4, 0x00,
  0x07, 0xFF, 0xFD, 0x00,
  0x1F, 0xFF, 0xFF, 0x40,
  0x2F, 0xE0, 0xBF, 0x80,
  0x2A, 0xC0, 0x3F, 0xC0,
  0x00, 0x00, 0x3F, 0x80,
  0x00, 0x00, 0xBF, 0x80,
  0x00, 0x0B, 0xFE, 0x00,
  0x00, 0x0B, 0xF8, 0x00,
  0x00, 0x0F, 0xFF, 0x40,
  0x00, 0x00, 0x7F, 0xD0,
  0x00, 0x00, 0x1F, 0xE0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0,
  0x2A, 0xC0, 0x0F, 0xF0,
  0x2F, 0xD0, 0x1F, 0xE0,
  0x1F, 0xF4, 0x7F, 0xD0,
  0x0B, 0xFF, 0xFF, 0x80,
  0x02, 0xFF, 0xFE, 0x00,
  0x00, 0x6F, 0xE4, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0034[128] = { /* code 0034, DIGIT FOUR */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x00,
  0x00, 0x01, 0xFF, 0x00,
  0x00, 0x03, 0xFF, 0x00,
  0x00, 0x0B, 0xFF, 0x00,
  0x00, 0x1F, 0xFF, 0x00,
  0x00, 0x3F, 0xFF, 0x00,
  0x00, 0xBD, 0xFF, 0x00,
  0x01, 0xF8, 0xFF, 0x00,
  0x03, 0xF0, 0xFF, 0x00,
  0x0B, 0xD0, 0xFF, 0x00,
  0x1F, 0x80, 0xFF, 0x00,
  0x3F, 0x00, 0xFF, 0x00,
  0xBD, 0x00, 0xFF, 0x00,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0035[128] = { /* code 0035, DIGIT FIVE */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x03, 0xFF, 0xFF, 0xC0,
  0x07, 0xFF, 0xFF, 0xC0,
  0x0B, 0xFF, 0xFF, 0xC0,
  0x0B, 0xE0, 0x00, 0x00,
  0x0F, 0xE0, 0x00, 0x00,
  0x0F, 0xD0, 0x00, 0x00,
  0x1F, 0xEB, 0xE8, 0x00,
  0x2F, 0xFF, 0xFE, 0x00,
  0x2F, 0xFF, 0xFF, 0x80,
  0x2B, 0xD0, 0x7F, 0xD0,
  0x00, 0x00, 0x2F, 0xE0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xE0,
  0x2B, 0xC0, 0x2F, 0xE0,
  0x2F, 0xE4, 0x7F, 0xC0,
  0x1F, 0xFF, 0xFF, 0x40,
  0x07, 0xFF, 0xFE, 0x00,
  0x00, 0xAF, 0xE4, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0036[128] = { /* code 0036, DIGIT SIX */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x1B, 0xF9, 0x00,
  0x01, 0xBF, 0xFF, 0x40,
  0x03, 0xFF, 0xFF, 0xD0,
  0x0B, 0xF4, 0x2F, 0xE0,
  0x1F, 0xE0, 0x0E, 0xA0,
  0x2F, 0xC0, 0x00, 0x00,
  0x2F, 0xC0, 0x00, 0x00,
  0x2F, 0x9B, 0xE8, 0x00,
  0x3F, 0xBF, 0xFE, 0x40,
  0x3F, 0xFF, 0xFF, 0x80,
  0x3F, 0xF4, 0x7F, 0xD0,
  0x3F, 0xD0, 0x1F, 0xE0,
  0x3F, 0xC0, 0x0F, 0xF0,
  0x2F, 0xC0, 0x0F, 0xF0,
  0x2F, 0xC0, 0x0F, 0xF0,
  0x1F, 0xE0, 0x1F, 0xE0,
  0x0B, 0xF4, 0x6F, 0xD0,
  0x07, 0xFF, 0xFF, 0x80,
  0x01, 0xFF, 0xFE, 0x00,
  0x00, 0x2B, 0xE4, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0037[128] = { /* code 0037, DIGIT SEVEN */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x3F, 0xFF, 0xFF, 0xF0,
  0x3F, 0xFF, 0xFF, 0xF0,
  0x3F, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x2F, 0xE0,
  0x00, 0x00, 0xBF, 0x80,
  0x00, 0x01, 0xFE, 0x00,
  0x00, 0x03, 0xFD, 0x00,
  0x00, 0x0B, 0xF8, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x2F, 0xE0, 0x00,
  0x00, 0x3F, 0xC0, 0x00,
  0x00, 0x7F, 0x80, 0x00,
  0x00, 0xBF, 0x40, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x01, 0xFE, 0x00, 0x00,
  0x02, 0xFE, 0x00, 0x00,
  0x02, 0xFD, 0x00, 0x00,
  0x02, 0xFD, 0x00, 0x00,
  0x03, 0xFC, 0x00, 0x00,
  0x03, 0xFC, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0038[128] = { /* code 0038, DIGIT EIGHT */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0xAF, 0xE8, 0x00,
  0x07, 0xFF, 0xFF, 0x40,
  0x1F, 0xFF, 0xFF, 0xD0,
  0x2F, 0xE4, 0x2F, 0xE0,
  0x3F, 0xC0, 0x0F, 0xF0,
  0x3F, 0xC0, 0x0F, 0xF0,
  0x2F, 0xC0, 0x0F, 0xE0,
  0x1F, 0xE0, 0x2F, 0xD0,
  0x07, 0xFF, 0xFF, 0x40,
  0x01, 0xBF, 0xF9, 0x00,
  0x07, 0xFF, 0xFF, 0x40,
  0x1F, 0xE4, 0x7F, 0xD0,
  0x2F, 0xD0, 0x1F, 0xE0,
  0x3F, 0xC0, 0x0F, 0xF0,
  0x3F, 0xC0, 0x0F, 0xF0,
  0x2F, 0xD0, 0x1F, 0xE0,
  0x2F, 0xF4, 0x6F, 0xE0,
  0x0F, 0xFF, 0xFF, 0xC0,
  0x06, 0xFF, 0xFE, 0x40,
  0x00, 0x6F, 0xE4, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0039[128] = { /* code 0039, DIGIT NINE */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x6F, 0xA0, 0x00,
  0x02, 0xFF, 0xFD, 0x00,
  0x0B, 0xFF, 0xFF, 0x40,
  0x1F, 0xE0, 0x7F, 0x80,
  0x2F, 0xD0, 0x2F, 0xD0,
  0x3F, 0xC0, 0x0F, 0xE0,
  0x3F, 0xC0, 0x0F, 0xE0,
  0x3F, 0xC0, 0x0F, 0xF0,
  0x2F, 0xD0, 0x1F, 0xF0,
  0x1F, 0xF4, 0x7F, 0xF0,
  0x0B, 0xFF, 0xFF, 0xF0,
  0x06, 0xFF, 0xFB, 0xF0,
  0x00, 0xAF, 0x9B, 0xE0,
  0x00, 0x00, 0x0F, 0xE0,
  0x00, 0x00, 0x0F, 0xE0,
  0x2A, 0xC0, 0x2F, 0xD0,
  0x2F, 0xE0, 0x7F, 0x80,
  0x1F, 0xFF, 0xFF, 0x00,
  0x0B, 0xFF, 0xF9, 0x00,
  0x01, 0xBF, 0x90, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_003A[ 96] = { /* code 003A, COLON */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_003B[ 96] = { /* code 003B, SEMICOLON */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x00, 0x38, 0x00,
  0x00, 0xB8, 0x00,
  0x02, 0xF0, 0x00,
  0x01, 0x80, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_003C[128] = { /* code 003C, LESS-THAN SIGN */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x60,
  0x00, 0x00, 0x06, 0xF0,
  0x00, 0x00, 0xBF, 0xF0,
  0x00, 0x0B, 0xFF, 0xF0,
  0x01, 0xBF, 0xFE, 0x90,
  0x1B, 0xFF, 0xE4, 0x00,
  0x3F, 0xF9, 0x00, 0x00,
  0x3F, 0xD0, 0x00, 0x00,
  0x3F, 0xF9, 0x00, 0x00,
  0x1B, 0xFF, 0xE4, 0x00,
  0x01, 0xBF, 0xFF, 0x90,
  0x00, 0x0B, 0xFF, 0xF0,
  0x00, 0x00, 0xBF, 0xF0,
  0x00, 0x00, 0x06, 0xF0,
  0x00, 0x00, 0x00, 0x60,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_003D[128] = { /* code 003D, EQUALS SIGN */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x3F, 0xFF, 0xFF, 0xFC,
  0x3F, 0xFF, 0xFF, 0xFC,
  0x3F, 0xFF, 0xFF, 0xFC,
  0x3F, 0xFF, 0xFF, 0xFC,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x3F, 0xFF, 0xFF, 0xFC,
  0x3F, 0xFF, 0xFF, 0xFC,
  0x3F, 0xFF, 0xFF, 0xFC,
  0x3F, 0xFF, 0xFF, 0xFC,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_003E[128] = { /* code 003E, GREATER-THAN SIGN */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x24, 0x00, 0x00, 0x00,
  0x3E, 0x40, 0x00, 0x00,
  0x3F, 0xF8, 0x00, 0x00,
  0x3F, 0xFF, 0x80, 0x00,
  0x1A, 0xFF, 0xF9, 0x00,
  0x00, 0x6F, 0xFF, 0x90,
  0x00, 0x01, 0xBF, 0xF0,
  0x00, 0x00, 0x1F, 0xF0,
  0x00, 0x01, 0xBF, 0xF0,
  0x00, 0x6F, 0xFF, 0x90,
  0x1B, 0xFF, 0xF9, 0x00,
  0x3F, 0xFF, 0x80, 0x00,
  0x3F, 0xF8, 0x00, 0x00,
  0x3E, 0x40, 0x00, 0x00,
  0x24, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_003F[160] = { /* code 003F, QUESTION MARK */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x6B, 0xE9, 0x00, 0x00,
  0x02, 0xFF, 0xFF, 0x80, 0x00,
  0x0B, 0xFF, 0xFF, 0xE0, 0x00,
  0x1F, 0xF8, 0x1B, 0xF8, 0x00,
  0x2F, 0xE0, 0x07, 0xF8, 0x00,
  0x3F, 0xC0, 0x03, 0xFC, 0x00,
  0x00, 0x00, 0x07, 0xF8, 0x00,
  0x00, 0x00, 0x1F, 0xF8, 0x00,
  0x00, 0x00, 0x7F, 0xE0, 0x00,
  0x00, 0x02, 0xFF, 0x80, 0x00,
  0x00, 0x07, 0xFE, 0x00, 0x00,
  0x00, 0x0B, 0xF8, 0x00, 0x00,
  0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0040[224] = { /* code 0040, COMMERCIAL AT */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1A, 0xFF, 0xA4, 0x00, 0x00,
  0x00, 0x01, 0xBF, 0xFF, 0xFE, 0x40, 0x00,
  0x00, 0x0B, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0x2F, 0xE9, 0x00, 0x6F, 0xF8, 0x00,
  0x00, 0xBF, 0x80, 0x00, 0x02, 0xFD, 0x00,
  0x02, 0xFD, 0x1B, 0xE2, 0xFC, 0xBE, 0x00,
  0x03, 0xF4, 0x7F, 0xFB, 0xF8, 0x3F, 0x40,
  0x0B, 0xE0, 0xFF, 0xFF, 0xF8, 0x2F, 0x80,
  0x0F, 0xD2, 0xF8, 0x2F, 0xF4, 0x1F, 0x80,
  0x1F, 0x83, 0xF0, 0x1F, 0xF4, 0x0F, 0xC0,
  0x2F, 0x87, 0xE0, 0x0F, 0xF0, 0x0F, 0xC0,
  0x2F, 0x4B, 0xD0, 0x0F, 0xE0, 0x0F, 0xC0,
  0x3F, 0x0F, 0xC0, 0x0F, 0xE0, 0x1F, 0x80,
  0x3F, 0x0F, 0xC0, 0x1F, 0xE0, 0x2F, 0x40,
  0x3F, 0x0F, 0xC0, 0x2F, 0xD0, 0x7F, 0x00,
  0x3F, 0x0F, 0xD0, 0x3F, 0xC1, 0xFE, 0x00,
  0x2F, 0x4B, 0xE0, 0xBF, 0xC7, 0xF8, 0x00,
  0x2F, 0x47, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x1F, 0x82, 0xFF, 0xAF, 0xFF, 0x80, 0x00,
  0x0F, 0xD0, 0xBE, 0x1B, 0xE8, 0x00, 0x00,
  0x0B, 0xE0, 0x00, 0x00, 0x00, 0x0F, 0xE0,
  0x03, 0xF8, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0x01, 0xFE, 0x40, 0x00, 0x01, 0xBF, 0x80,
  0x00, 0xBF, 0xE5, 0x00, 0x5B, 0xFE, 0x00,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x02, 0xFF, 0xFF, 0xFF, 0x90, 0x00,
  0x00, 0x00, 0x1A, 0xFF, 0xE9, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0041[160] = { /* code 0041, LATIN CAPITAL LETTER A */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0x40, 0x00,
  0x00, 0x0B, 0xFF, 0x80, 0x00,
  0x00, 0x0F, 0xFF, 0xC0, 0x00,
  0x00, 0x1F, 0xFF, 0xD0, 0x00,
  0x00, 0x2F, 0xEF, 0xE0, 0x00,
  0x00, 0x3F, 0xCF, 0xF0, 0x00,
  0x00, 0x7F, 0x8B, 0xF4, 0x00,
  0x00, 0xBF, 0x47, 0xF8, 0x00,
  0x00, 0xFF, 0x03, 0xFC, 0x00,
  0x01, 0xFE, 0x02, 0xFD, 0x00,
  0x02, 0xFD, 0x01, 0xFE, 0x00,
  0x03, 0xFC, 0x00, 0xFF, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0x40,
  0x0B, 0xFF, 0xFF, 0xFF, 0x80,
  0x0F, 0xFF, 0xFF, 0xFF, 0xC0,
  0x1F, 0xE0, 0x00, 0x2F, 0xD0,
  0x2F, 0xD0, 0x00, 0x1F, 0xE0,
  0x3F, 0xC0, 0x00, 0x0F, 0xF0,
  0x7F, 0x80, 0x00, 0x0B, 0xF4,
  0xBF, 0x40, 0x00, 0x07, 0xF8,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0042[160] = { /* code 0042, LATIN CAPITAL LETTER B */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xFF, 0xE8, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0x40,
  0x0F, 0xFF, 0xFF, 0xFF, 0xD0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xE0,
  0x0F, 0xF0, 0x00, 0x6F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xE0,
  0x0F, 0xF0, 0x00, 0x6F, 0xE0,
  0x0F, 0xFF, 0xFF, 0xFF, 0x80,
  0x0F, 0xFF, 0xFF, 0xFE, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0x90,
  0x0F, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xF0, 0x00, 0x1B, 0xF8,
  0x0F, 0xF0, 0x00, 0x03, 0xFC,
  0x0F, 0xF0, 0x00, 0x03, 0xFC,
  0x0F, 0xF0, 0x00, 0x1B, 0xF8,
  0x0F, 0xFF, 0xFF, 0xFF, 0xF8,
  0x0F, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xD0,
  0x0F, 0xFF, 0xFF, 0xFA, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0043[160] = { /* code 0043, LATIN CAPITAL LETTER C */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x06, 0xBF, 0xA4, 0x00,
  0x00, 0x2F, 0xFF, 0xFE, 0x40,
  0x01, 0xFF, 0xFF, 0xFF, 0xD0,
  0x03, 0xFF, 0xFF, 0xFF, 0xE0,
  0x0B, 0xFE, 0x40, 0x6F, 0xF4,
  0x1F, 0xF4, 0x00, 0x0B, 0xF8,
  0x2F, 0xE0, 0x00, 0x02, 0x90,
  0x2F, 0xD0, 0x00, 0x00, 0x00,
  0x3F, 0xC0, 0x00, 0x00, 0x00,
  0x3F, 0xC0, 0x00, 0x00, 0x00,
  0x3F, 0xC0, 0x00, 0x00, 0x00,
  0x3F, 0xC0, 0x00, 0x00, 0x00,
  0x2F, 0xD0, 0x00, 0x02, 0x90,
  0x2F, 0xE0, 0x00, 0x0B, 0xF8,
  0x1F, 0xF4, 0x00, 0x1F, 0xF8,
  0x0B, 0xFE, 0x40, 0xBF, 0xF0,
  0x07, 0xFF, 0xFF, 0xFF, 0xE0,
  0x01, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x6F, 0xFF, 0xFE, 0x00,
  0x00, 0x06, 0xBF, 0xA0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0044[160] = { /* code 0044, LATIN CAPITAL LETTER D */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xFF, 0xA0, 0x00,
  0x0F, 0xFF, 0xFF, 0xFE, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0x80,
  0x0F, 0xFF, 0xFF, 0xFF, 0xD0,
  0x0F, 0xF0, 0x01, 0xBF, 0xF0,
  0x0F, 0xF0, 0x00, 0x1F, 0xF4,
  0x0F, 0xF0, 0x00, 0x0B, 0xF8,
  0x0F, 0xF0, 0x00, 0x07, 0xF8,
  0x0F, 0xF0, 0x00, 0x03, 0xFC,
  0x0F, 0xF0, 0x00, 0x03, 0xFC,
  0x0F, 0xF0, 0x00, 0x03, 0xFC,
  0x0F, 0xF0, 0x00, 0x03, 0xFC,
  0x0F, 0xF0, 0x00, 0x07, 0xF8,
  0x0F, 0xF0, 0x00, 0x0B, 0xF8,
  0x0F, 0xF0, 0x00, 0x1F, 0xF4,
  0x0F, 0xF0, 0x00, 0x7F, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xD0,
  0x0F, 0xFF, 0xFF, 0xFF, 0x80,
  0x0F, 0xFF, 0xFF, 0xFE, 0x00,
  0x0F, 0xFF, 0xFF, 0xA0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0045[160] = { /* code 0045, LATIN CAPITAL LETTER E */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xC0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xC0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xC0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xC0,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xC0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xC0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xC0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xC0,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0046[160] = { /* code 0046, LATIN CAPITAL LETTER F */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xFF, 0xFC, 0x00,
  0x0F, 0xFF, 0xFF, 0xFC, 0x00,
  0x0F, 0xFF, 0xFF, 0xFC, 0x00,
  0x0F, 0xFF, 0xFF, 0xFC, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0047[192] = { /* code 0047, LATIN CAPITAL LETTER G */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x06, 0xBF, 0xA4, 0x00, 0x00,
  0x00, 0x2F, 0xFF, 0xFF, 0x40, 0x00,
  0x01, 0xFF, 0xFF, 0xFF, 0xD0, 0x00,
  0x03, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,
  0x0B, 0xFE, 0x40, 0x6F, 0xF8, 0x00,
  0x0F, 0xF8, 0x00, 0x0B, 0xF8, 0x00,
  0x2F, 0xE0, 0x00, 0x06, 0x90, 0x00,
  0x2F, 0xD0, 0x00, 0x00, 0x00, 0x00,
  0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00,
  0x3F, 0xC0, 0x03, 0xFF, 0xFC, 0x00,
  0x3F, 0xC0, 0x03, 0xFF, 0xFC, 0x00,
  0x3F, 0xC0, 0x03, 0xFF, 0xFC, 0x00,
  0x2F, 0xD0, 0x03, 0xFF, 0xFC, 0x00,
  0x1F, 0xE0, 0x00, 0x03, 0xFC, 0x00,
  0x0F, 0xF8, 0x00, 0x03, 0xFC, 0x00,
  0x0B, 0xFE, 0x40, 0x6F, 0xFC, 0x00,
  0x03, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x01, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0x2F, 0xFF, 0xFE, 0x40, 0x00,
  0x00, 0x06, 0xBF, 0xA4, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0048[160] = { /* code 0048, LATIN CAPITAL LETTER H */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0049[ 64] = { /* code 0049, LATIN CAPITAL LETTER I */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_004A[128] = { /* code 004A, LATIN CAPITAL LETTER J */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xC0,
  0x00, 0x00, 0x3F, 0xC0,
  0x00, 0x00, 0x3F, 0xC0,
  0x00, 0x00, 0x3F, 0xC0,
  0x00, 0x00, 0x3F, 0xC0,
  0x00, 0x00, 0x3F, 0xC0,
  0x00, 0x00, 0x3F, 0xC0,
  0x00, 0x00, 0x3F, 0xC0,
  0x00, 0x00, 0x3F, 0xC0,
  0x00, 0x00, 0x3F, 0xC0,
  0x00, 0x00, 0x3F, 0xC0,
  0x00, 0x00, 0x3F, 0xC0,
  0x00, 0x00, 0x3F, 0xC0,
  0xFF, 0x00, 0x3F, 0xC0,
  0xFF, 0x40, 0x7F, 0xC0,
  0xBF, 0x80, 0xBF, 0x80,
  0x7F, 0xFF, 0xFF, 0x40,
  0x2F, 0xFF, 0xFE, 0x00,
  0x1F, 0xFF, 0xF9, 0x00,
  0x02, 0xBF, 0x90, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_004B[160] = { /* code 004B, LATIN CAPITAL LETTER K */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x1F, 0xFD,
  0x0F, 0xF0, 0x00, 0x7F, 0xF4,
  0x0F, 0xF0, 0x01, 0xFF, 0xD0,
  0x0F, 0xF0, 0x07, 0xFF, 0x40,
  0x0F, 0xF0, 0x1F, 0xFD, 0x00,
  0x0F, 0xF0, 0x7F, 0xF4, 0x00,
  0x0F, 0xF1, 0xFF, 0xD0, 0x00,
  0x0F, 0xF3, 0xFF, 0x40, 0x00,
  0x0F, 0xFB, 0xFF, 0x40, 0x00,
  0x0F, 0xFF, 0xFF, 0xC0, 0x00,
  0x0F, 0xFF, 0xEF, 0xE0, 0x00,
  0x0F, 0xFF, 0x5F, 0xF4, 0x00,
  0x0F, 0xFD, 0x0B, 0xF8, 0x00,
  0x0F, 0xF4, 0x03, 0xFE, 0x00,
  0x0F, 0xF0, 0x01, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0xBF, 0x80,
  0x0F, 0xF0, 0x00, 0x7F, 0xD0,
  0x0F, 0xF0, 0x00, 0x2F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0B, 0xF8,
  0x0F, 0xF0, 0x00, 0x07, 0xFD,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_004C[160] = { /* code 004C, LATIN CAPITAL LETTER L */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_004D[192] = { /* code 004D, LATIN CAPITAL LETTER M */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x3F, 0xFD, 0x00, 0x1F, 0xFF, 0x00,
  0x3F, 0xFE, 0x00, 0x2F, 0xFF, 0x00,
  0x3F, 0xFE, 0x00, 0x2F, 0xFF, 0x00,
  0x3F, 0xFF, 0x00, 0x3F, 0xFF, 0x00,
  0x3F, 0xFF, 0x40, 0x7F, 0xFF, 0x00,
  0x3F, 0xEF, 0x80, 0xBE, 0xFF, 0x00,
  0x3F, 0xEF, 0x80, 0xBE, 0xFF, 0x00,
  0x3F, 0xEB, 0xC0, 0xFA, 0xFF, 0x00,
  0x3F, 0xDB, 0xD1, 0xF9, 0xFF, 0x00,
  0x3F, 0xD7, 0xE2, 0xF5, 0xFF, 0x00,
  0x3F, 0xD3, 0xE2, 0xF1, 0xFF, 0x00,
  0x3F, 0xD2, 0xF3, 0xE1, 0xFF, 0x00,
  0x3F, 0xD2, 0xFB, 0xE1, 0xFF, 0x00,
  0x3F, 0xD1, 0xFF, 0xD1, 0xFF, 0x00,
  0x3F, 0xD1, 0xFF, 0xD1, 0xFF, 0x00,
  0x3F, 0xD0, 0xFF, 0xC1, 0xFF, 0x00,
  0x3F, 0xC0, 0xBF, 0x80, 0xFF, 0x00,
  0x3F, 0xC0, 0xBF, 0x80, 0xFF, 0x00,
  0x3F, 0xC0, 0x7F, 0x40, 0xFF, 0x00,
  0x3F, 0xC0, 0x3F, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_004E[160] = { /* code 004E, LATIN CAPITAL LETTER N */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF8, 0x00, 0x0F, 0xF0,
  0x0F, 0xFC, 0x00, 0x0F, 0xF0,
  0x0F, 0xFE, 0x00, 0x0F, 0xF0,
  0x0F, 0xFF, 0x00, 0x0F, 0xF0,
  0x0F, 0xFF, 0x80, 0x0F, 0xF0,
  0x0F, 0xFF, 0xD0, 0x0F, 0xF0,
  0x0F, 0xFB, 0xE0, 0x0F, 0xF0,
  0x0F, 0xF7, 0xF4, 0x0F, 0xF0,
  0x0F, 0xF2, 0xFC, 0x0F, 0xF0,
  0x0F, 0xF0, 0xFE, 0x0F, 0xF0,
  0x0F, 0xF0, 0xBF, 0x0F, 0xF0,
  0x0F, 0xF0, 0x3F, 0x8F, 0xF0,
  0x0F, 0xF0, 0x1F, 0xDF, 0xF0,
  0x0F, 0xF0, 0x0B, 0xEF, 0xF0,
  0x0F, 0xF0, 0x07, 0xFF, 0xF0,
  0x0F, 0xF0, 0x02, 0xFF, 0xF0,
  0x0F, 0xF0, 0x01, 0xFF, 0xF0,
  0x0F, 0xF0, 0x00, 0xBF, 0xF0,
  0x0F, 0xF0, 0x00, 0x3F, 0xF0,
  0x0F, 0xF0, 0x00, 0x2F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_004F[192] = { /* code 004F, LATIN CAPITAL LETTER O */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x06, 0xBF, 0xA4, 0x00, 0x00,
  0x00, 0x6F, 0xFF, 0xFE, 0x40, 0x00,
  0x01, 0xFF, 0xFF, 0xFF, 0xD0, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xF4, 0x00,
  0x0B, 0xFE, 0x40, 0x6F, 0xF8, 0x00,
  0x1F, 0xF8, 0x00, 0x0B, 0xFD, 0x00,
  0x2F, 0xE0, 0x00, 0x02, 0xFE, 0x00,
  0x2F, 0xD0, 0x00, 0x01, 0xFE, 0x00,
  0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x00,
  0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x00,
  0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x00,
  0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x00,
  0x2F, 0xD0, 0x00, 0x01, 0xFE, 0x00,
  0x2F, 0xE0, 0x00, 0x02, 0xFE, 0x00,
  0x1F, 0xF8, 0x00, 0x0B, 0xFD, 0x00,
  0x0B, 0xFE, 0x40, 0x6F, 0xF8, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xF4, 0x00,
  0x01, 0xFF, 0xFF, 0xFF, 0xD0, 0x00,
  0x00, 0x6F, 0xFF, 0xFE, 0x40, 0x00,
  0x00, 0x06, 0xBF, 0xA4, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0050[160] = { /* code 0050, LATIN CAPITAL LETTER P */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xFF, 0xA0, 0x00,
  0x0F, 0xFF, 0xFF, 0xFD, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0x80,
  0x0F, 0xF0, 0x01, 0xBF, 0x80,
  0x0F, 0xF0, 0x00, 0x3F, 0xC0,
  0x0F, 0xF0, 0x00, 0x3F, 0xC0,
  0x0F, 0xF0, 0x01, 0xBF, 0x80,
  0x0F, 0xFF, 0xFF, 0xFF, 0x80,
  0x0F, 0xFF, 0xFF, 0xFF, 0x00,
  0x0F, 0xFF, 0xFF, 0xF9, 0x00,
  0x0F, 0xFF, 0xFE, 0x90, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0051[192] = { /* code 0051, LATIN CAPITAL LETTER Q */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x06, 0xBF, 0xA4, 0x00, 0x00,
  0x00, 0x6F, 0xFF, 0xFE, 0x40, 0x00,
  0x01, 0xFF, 0xFF, 0xFF, 0xD0, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xF4, 0x00,
  0x0B, 0xFE, 0x40, 0x6F, 0xF8, 0x00,
  0x1F, 0xF8, 0x00, 0x0B, 0xFD, 0x00,
  0x2F, 0xE0, 0x00, 0x02, 0xFE, 0x00,
  0x2F, 0xD0, 0x00, 0x01, 0xFE, 0x00,
  0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x00,
  0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x00,
  0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x00,
  0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x00,
  0x2F, 0xD0, 0x00, 0x01, 0xFE, 0x00,
  0x2F, 0xE0, 0x06, 0x82, 0xFE, 0x00,
  0x1F, 0xF8, 0x0B, 0xFB, 0xFD, 0x00,
  0x0B, 0xFE, 0x41, 0xFF, 0xFC, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x01, 0xFF, 0xFF, 0xFF, 0xF4, 0x00,
  0x00, 0x6F, 0xFF, 0xFF, 0xFE, 0x40,
  0x00, 0x06, 0xBF, 0xE5, 0xFF, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0x40,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0052[160] = { /* code 0052, LATIN CAPITAL LETTER R */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xFF, 0xE8, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0x40,
  0x0F, 0xFF, 0xFF, 0xFF, 0xC0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xE0,
  0x0F, 0xF0, 0x00, 0x2F, 0xE0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x6F, 0xE0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xD0,
  0x0F, 0xFF, 0xFF, 0xFF, 0x80,
  0x0F, 0xFF, 0xFF, 0xFE, 0x00,
  0x0F, 0xFF, 0xFF, 0xE0, 0x00,
  0x0F, 0xF0, 0x1F, 0xF8, 0x00,
  0x0F, 0xF0, 0x07, 0xFE, 0x00,
  0x0F, 0xF0, 0x01, 0xFF, 0x80,
  0x0F, 0xF0, 0x00, 0xBF, 0xC0,
  0x0F, 0xF0, 0x00, 0x2F, 0xE0,
  0x0F, 0xF0, 0x00, 0x1F, 0xF4,
  0x0F, 0xF0, 0x00, 0x0B, 0xFC,
  0x0F, 0xF0, 0x00, 0x02, 0xFE,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0053[160] = { /* code 0053, LATIN CAPITAL LETTER S */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1B, 0xFE, 0x40, 0x00,
  0x01, 0xFF, 0xFF, 0xE0, 0x00,
  0x03, 0xFF, 0xFF, 0xF8, 0x00,
  0x0B, 0xFF, 0xFF, 0xFD, 0x00,
  0x0F, 0xF8, 0x06, 0xFE, 0x00,
  0x0F, 0xF0, 0x00, 0xFF, 0x00,
  0x0B, 0xF8, 0x00, 0x00, 0x00,
  0x0B, 0xFF, 0xA4, 0x00, 0x00,
  0x02, 0xFF, 0xFF, 0x90, 0x00,
  0x00, 0xBF, 0xFF, 0xF9, 0x00,
  0x00, 0x1B, 0xFF, 0xFE, 0x00,
  0x00, 0x00, 0x6B, 0xFF, 0x80,
  0x00, 0x00, 0x00, 0xBF, 0x80,
  0x3F, 0xC0, 0x00, 0x3F, 0xC0,
  0x2F, 0xE0, 0x00, 0x7F, 0xC0,
  0x1F, 0xF9, 0x01, 0xFF, 0x80,
  0x0F, 0xFF, 0xFF, 0xFF, 0x40,
  0x07, 0xFF, 0xFF, 0xFE, 0x00,
  0x01, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x1B, 0xFE, 0x90, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0054[160] = { /* code 0054, LATIN CAPITAL LETTER T */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x3F, 0xFF, 0xFF, 0xFF, 0xC0,
  0x3F, 0xFF, 0xFF, 0xFF, 0xC0,
  0x3F, 0xFF, 0xFF, 0xFF, 0xC0,
  0x3F, 0xFF, 0xFF, 0xFF, 0xC0,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0055[160] = { /* code 0055, LATIN CAPITAL LETTER U */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF4, 0x00, 0x1F, 0xF0,
  0x0B, 0xF8, 0x00, 0x2F, 0xE0,
  0x0B, 0xFE, 0x40, 0xBF, 0xE0,
  0x07, 0xFF, 0xFF, 0xFF, 0xD0,
  0x02, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0xBF, 0xFF, 0xFE, 0x00,
  0x00, 0x0A, 0xFF, 0xA4, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0056[160] = { /* code 0056, LATIN CAPITAL LETTER V */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0x40, 0x00, 0x7F, 0x80,
  0xBF, 0x80, 0x00, 0xBF, 0x80,
  0x7F, 0x80, 0x00, 0xBF, 0x40,
  0x3F, 0xC0, 0x00, 0xFF, 0x00,
  0x2F, 0xD0, 0x01, 0xFE, 0x00,
  0x1F, 0xE0, 0x02, 0xFD, 0x00,
  0x0F, 0xE0, 0x02, 0xFC, 0x00,
  0x0B, 0xF0, 0x03, 0xF8, 0x00,
  0x07, 0xF4, 0x07, 0xF4, 0x00,
  0x03, 0xF8, 0x0B, 0xF0, 0x00,
  0x02, 0xF8, 0x0B, 0xE0, 0x00,
  0x02, 0xFC, 0x0F, 0xE0, 0x00,
  0x01, 0xFD, 0x1F, 0xD0, 0x00,
  0x00, 0xFE, 0x2F, 0x80, 0x00,
  0x00, 0xBE, 0x2F, 0x80, 0x00,
  0x00, 0x7F, 0x7F, 0x40, 0x00,
  0x00, 0x3F, 0xBF, 0x00, 0x00,
  0x00, 0x2F, 0xFE, 0x00, 0x00,
  0x00, 0x1F, 0xFD, 0x00, 0x00,
  0x00, 0x0F, 0xFC, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0057[224] = { /* code 0057, LATIN CAPITAL LETTER W */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0x00, 0x0B, 0xF8, 0x00, 0x7F, 0x80,
  0xBF, 0x40, 0x0F, 0xFC, 0x00, 0x7F, 0x80,
  0xBF, 0x80, 0x1F, 0xFD, 0x00, 0xBF, 0x80,
  0x7F, 0x80, 0x2F, 0xFE, 0x00, 0xBF, 0x40,
  0x3F, 0x80, 0x2F, 0xBE, 0x00, 0xBF, 0x00,
  0x2F, 0xC0, 0x3F, 0x7F, 0x00, 0xFE, 0x00,
  0x2F, 0xC0, 0x7E, 0x2F, 0x40, 0xFE, 0x00,
  0x1F, 0xD0, 0xBE, 0x2F, 0x81, 0xFD, 0x00,
  0x1F, 0xD0, 0xBD, 0x1F, 0x81, 0xFD, 0x00,
  0x0F, 0xE0, 0xFC, 0x1F, 0xC2, 0xFC, 0x00,
  0x0B, 0xE1, 0xF8, 0x0F, 0xD2, 0xF8, 0x00,
  0x0B, 0xE2, 0xF8, 0x0B, 0xD2, 0xF8, 0x00,
  0x07, 0xF2, 0xF4, 0x07, 0xE3, 0xF4, 0x00,
  0x07, 0xF7, 0xF0, 0x07, 0xF3, 0xF0, 0x00,
  0x03, 0xF7, 0xE0, 0x03, 0xF7, 0xF0, 0x00,
  0x02, 0xFF, 0xE0, 0x02, 0xFB, 0xE0, 0x00,
  0x02, 0xFF, 0xD0, 0x02, 0xFF, 0xE0, 0x00,
  0x01, 0xFF, 0xC0, 0x01, 0xFF, 0xD0, 0x00,
  0x00, 0xFF, 0x80, 0x00, 0xFF, 0xC0, 0x00,
  0x00, 0xFF, 0x80, 0x00, 0xBF, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0058[160] = { /* code 0058, LATIN CAPITAL LETTER X */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x1F, 0xF4, 0x01, 0xFF, 0x40,
  0x0B, 0xF8, 0x02, 0xFE, 0x00,
  0x03, 0xFC, 0x03, 0xFC, 0x00,
  0x01, 0xFE, 0x0B, 0xF4, 0x00,
  0x00, 0xBF, 0x0F, 0xE0, 0x00,
  0x00, 0x7F, 0xAF, 0xD0, 0x00,
  0x00, 0x2F, 0xFF, 0x80, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0B, 0xFD, 0x00, 0x00,
  0x00, 0x07, 0xFD, 0x00, 0x00,
  0x00, 0x0B, 0xFE, 0x00, 0x00,
  0x00, 0x2F, 0xFF, 0x40, 0x00,
  0x00, 0x3F, 0xAF, 0xC0, 0x00,
  0x00, 0xBF, 0x5F, 0xE0, 0x00,
  0x01, 0xFE, 0x0B, 0xF4, 0x00,
  0x02, 0xFD, 0x07, 0xF8, 0x00,
  0x07, 0xF8, 0x02, 0xFD, 0x00,
  0x0F, 0xF4, 0x01, 0xFF, 0x00,
  0x2F, 0xE0, 0x00, 0xBF, 0x80,
  0x7F, 0xD0, 0x00, 0x7F, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0059[160] = { /* code 0059, LATIN CAPITAL LETTER Y */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x40, 0x00, 0x1F, 0xF0,
  0xBF, 0xC0, 0x00, 0x2F, 0xE0,
  0x2F, 0xE0, 0x00, 0xBF, 0x80,
  0x1F, 0xF4, 0x00, 0xFF, 0x40,
  0x0B, 0xF8, 0x02, 0xFE, 0x00,
  0x02, 0xFD, 0x07, 0xF8, 0x00,
  0x01, 0xFF, 0x0B, 0xF4, 0x00,
  0x00, 0xBF, 0xAF, 0xE0, 0x00,
  0x00, 0x3F, 0xFF, 0xC0, 0x00,
  0x00, 0x1F, 0xFF, 0x40, 0x00,
  0x00, 0x0B, 0xFE, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_005A[160] = { /* code 005A, LATIN CAPITAL LETTER Z */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x3F, 0xFF, 0xFF, 0xFF, 0x00,
  0x3F, 0xFF, 0xFF, 0xFF, 0x00,
  0x3F, 0xFF, 0xFF, 0xFF, 0x00,
  0x3F, 0xFF, 0xFF, 0xFE, 0x00,
  0x00, 0x00, 0x0B, 0xF8, 0x00,
  0x00, 0x00, 0x1F, 0xE0, 0x00,
  0x00, 0x00, 0x7F, 0xC0, 0x00,
  0x00, 0x00, 0xFF, 0x40, 0x00,
  0x00, 0x02, 0xFD, 0x00, 0x00,
  0x00, 0x0B, 0xF8, 0x00, 0x00,
  0x00, 0x2F, 0xE0, 0x00, 0x00,
  0x00, 0x7F, 0x80, 0x00, 0x00,
  0x01, 0xFE, 0x00, 0x00, 0x00,
  0x03, 0xFD, 0x00, 0x00, 0x00,
  0x0B, 0xF4, 0x00, 0x00, 0x00,
  0x2F, 0xD0, 0x00, 0x00, 0x00,
  0xBF, 0xFF, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_005B[ 96] = { /* code 005B, LEFT SQUARE BRACKET */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xC0,
  0x0F, 0xFF, 0xC0,
  0x0F, 0xFF, 0xC0,
  0x0F, 0xFF, 0xC0,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xFF, 0xC0,
  0x0F, 0xFF, 0xC0,
  0x0F, 0xFF, 0xC0,
  0x0F, 0xFF, 0xC0,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_005C[ 64] = { /* code 005C, REVERSE SOLIDUS */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0xBC, 0x00,
  0xBD, 0x00,
  0x7E, 0x00,
  0x3E, 0x00,
  0x2F, 0x00,
  0x2F, 0x40,
  0x1F, 0x80,
  0x0F, 0x80,
  0x0B, 0xC0,
  0x0B, 0xD0,
  0x07, 0xE0,
  0x03, 0xE0,
  0x02, 0xF0,
  0x02, 0xF4,
  0x01, 0xF8,
  0x00, 0xF8,
  0x00, 0xBC,
  0x00, 0xBD,
  0x00, 0x7E,
  0x00, 0x3E,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_005D[ 96] = { /* code 005D, RIGHT SQUARE BRACKET */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0xFF, 0xFC, 0x00,
  0xFF, 0xFC, 0x00,
  0xFF, 0xFC, 0x00,
  0xFF, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0x03, 0xFC, 0x00,
  0xFF, 0xFC, 0x00,
  0xFF, 0xFC, 0x00,
  0xFF, 0xFC, 0x00,
  0xFF, 0xFC, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_005E[128] = { /* code 005E, CIRCUMFLEX ACCENT */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x2F, 0x80, 0x00,
  0x00, 0x3F, 0xC0, 0x00,
  0x00, 0xBF, 0xE0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x02, 0xFA, 0xF8, 0x00,
  0x03, 0xF5, 0xFC, 0x00,
  0x07, 0xF0, 0xFD, 0x00,
  0x0B, 0xE0, 0xBE, 0x00,
  0x1F, 0xD0, 0x7F, 0x40,
  0x2F, 0xC0, 0x3F, 0x80,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_005F[128] = { /* code 005F, LOW LINE */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFC,
  0xFF, 0xFF, 0xFF, 0xFC,
  0xFF, 0xFF, 0xFF, 0xFC,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0060[ 96] = { /* code 0060, GRAVE ACCENT */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0xBF, 0x40, 0x00,
  0x2F, 0x80, 0x00,
  0x0B, 0xD0, 0x00,
  0x02, 0xE0, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0061[128] = { /* code 0061, LATIN SMALL LETTER A */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x01, 0xAF, 0xE8, 0x00,
  0x07, 0xFF, 0xFE, 0x00,
  0x0F, 0xFF, 0xFF, 0x80,
  0x2F, 0x80, 0xBF, 0x80,
  0x2F, 0x40, 0x3F, 0xC0,
  0x00, 0x00, 0x3F, 0xC0,
  0x00, 0x06, 0xBF, 0xC0,
  0x02, 0xBF, 0xFF, 0xC0,
  0x0F, 0xF9, 0x7F, 0xC0,
  0x2F, 0xD0, 0x3F, 0xC0,
  0x3F, 0xC0, 0x7F, 0xC0,
  0x3F, 0xE1, 0xBF, 0xC0,
  0x2F, 0xFF, 0xFF, 0xC0,
  0x1F, 0xFF, 0xAF, 0xD0,
  0x06, 0xFA, 0x0F, 0xE0,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0062[160] = { /* code 0062, LATIN SMALL LETTER B */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF1, 0xBE, 0x80, 0x00,
  0x0F, 0xFB, 0xFF, 0xE0, 0x00,
  0x0F, 0xFF, 0xFF, 0xF8, 0x00,
  0x0F, 0xFD, 0x07, 0xFD, 0x00,
  0x0F, 0xF8, 0x02, 0xFE, 0x00,
  0x0F, 0xF4, 0x01, 0xFE, 0x00,
  0x0F, 0xF0, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0xFF, 0x00,
  0x0F, 0xF4, 0x01, 0xFE, 0x00,
  0x0F, 0xF8, 0x02, 0xFE, 0x00,
  0x0F, 0xFE, 0x07, 0xFD, 0x00,
  0x0F, 0xFF, 0xFF, 0xF8, 0x00,
  0x0F, 0xFB, 0xFF, 0xE0, 0x00,
  0x0F, 0xF1, 0xBE, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0063[128] = { /* code 0063, LATIN SMALL LETTER C */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x6F, 0xE9, 0x00,
  0x02, 0xFF, 0xFF, 0x40,
  0x0B, 0xFF, 0xFF, 0xD0,
  0x1F, 0xF4, 0x2F, 0xE0,
  0x2F, 0xE0, 0x0A, 0x40,
  0x2F, 0xC0, 0x00, 0x00,
  0x3F, 0xC0, 0x00, 0x00,
  0x3F, 0xC0, 0x00, 0x00,
  0x3F, 0xC0, 0x00, 0x00,
  0x2F, 0xD0, 0x00, 0x00,
  0x2F, 0xE0, 0x0A, 0x40,
  0x1F, 0xF4, 0x2F, 0xE0,
  0x0B, 0xFF, 0xFF, 0xD0,
  0x02, 0xFF, 0xFF, 0x80,
  0x00, 0x6F, 0xE9, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0064[160] = { /* code 0064, LATIN SMALL LETTER D */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xFC, 0x00,
  0x00, 0x00, 0x03, 0xFC, 0x00,
  0x00, 0x00, 0x03, 0xFC, 0x00,
  0x00, 0x00, 0x03, 0xFC, 0x00,
  0x00, 0x00, 0x03, 0xFC, 0x00,
  0x00, 0xAF, 0x93, 0xFC, 0x00,
  0x02, 0xFF, 0xFB, 0xFC, 0x00,
  0x0B, 0xFF, 0xFF, 0xFC, 0x00,
  0x1F, 0xF8, 0x1F, 0xFC, 0x00,
  0x2F, 0xE0, 0x0B, 0xFC, 0x00,
  0x2F, 0xD0, 0x07, 0xFC, 0x00,
  0x3F, 0xC0, 0x03, 0xFC, 0x00,
  0x3F, 0xC0, 0x03, 0xFC, 0x00,
  0x3F, 0xC0, 0x03, 0xFC, 0x00,
  0x2F, 0xD0, 0x07, 0xFC, 0x00,
  0x2F, 0xE0, 0x0B, 0xFC, 0x00,
  0x1F, 0xF8, 0x2F, 0xFC, 0x00,
  0x0B, 0xFF, 0xFF, 0xFC, 0x00,
  0x02, 0xFF, 0xFB, 0xFC, 0x00,
  0x00, 0xAF, 0x93, 0xFC, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0065[128] = { /* code 0065, LATIN SMALL LETTER E */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x6F, 0xE4, 0x00,
  0x02, 0xFF, 0xFE, 0x00,
  0x0B, 0xFF, 0xFF, 0x80,
  0x0F, 0xF4, 0x7F, 0xC0,
  0x2F, 0xD0, 0x1F, 0xD0,
  0x2F, 0xC0, 0x0F, 0xE0,
  0x3F, 0xFF, 0xFF, 0xE0,
  0x3F, 0xFF, 0xFF, 0xF0,
  0x3F, 0xFF, 0xFF, 0xF0,
  0x2F, 0xC0, 0x00, 0x00,
  0x2F, 0xD0, 0x00, 0x00,
  0x1F, 0xF4, 0x1A, 0x40,
  0x0B, 0xFF, 0xFF, 0xE0,
  0x02, 0xFF, 0xFF, 0x80,
  0x00, 0x6F, 0xE9, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0066[ 96] = { /* code 0066, LATIN SMALL LETTER F */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x01, 0xBF, 0x80,
  0x07, 0xFF, 0xC0,
  0x0B, 0xFF, 0xC0,
  0x0F, 0xF4, 0x00,
  0x0F, 0xF0, 0x00,
  0xFF, 0xFF, 0xC0,
  0xFF, 0xFF, 0xC0,
  0xFF, 0xFF, 0xC0,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0067[160] = { /* code 0067, LATIN SMALL LETTER G */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xAF, 0x93, 0xFC, 0x00,
  0x02, 0xFF, 0xF7, 0xFC, 0x00,
  0x0B, 0xFF, 0xFF, 0xFC, 0x00,
  0x1F, 0xF4, 0x2F, 0xFC, 0x00,
  0x2F, 0xE0, 0x0B, 0xFC, 0x00,
  0x2F, 0xD0, 0x07, 0xFC, 0x00,
  0x3F, 0xC0, 0x03, 0xFC, 0x00,
  0x3F, 0xC0, 0x03, 0xFC, 0x00,
  0x3F, 0xC0, 0x03, 0xFC, 0x00,
  0x2F, 0xD0, 0x07, 0xFC, 0x00,
  0x2F, 0xE0, 0x0B, 0xFC, 0x00,
  0x1F, 0xF4, 0x2F, 0xFC, 0x00,
  0x0B, 0xFF, 0xFB, 0xFC, 0x00,
  0x02, 0xFF, 0xF7, 0xFC, 0x00,
  0x00, 0xAF, 0x83, 0xFC, 0x00,
  0x00, 0x00, 0x03, 0xF8, 0x00,
  0x29, 0x00, 0x1B, 0xF8, 0x00,
  0x2F, 0xFF, 0xFF, 0xF0, 0x00,
  0x1B, 0xFF, 0xFF, 0xD0, 0x00,
  0x01, 0xAF, 0xFA, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0068[160] = { /* code 0068, LATIN SMALL LETTER H */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF1, 0xBE, 0x80, 0x00,
  0x0F, 0xFB, 0xFF, 0xE0, 0x00,
  0x0F, 0xFF, 0xFF, 0xF8, 0x00,
  0x0F, 0xFD, 0x0B, 0xF8, 0x00,
  0x0F, 0xF8, 0x07, 0xFC, 0x00,
  0x0F, 0xF4, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0069[ 64] = { /* code 0069, LATIN SMALL LETTER I */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_006A[ 64] = { /* code 006A, LATIN SMALL LETTER J */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x1F, 0xE0,
  0xFF, 0xE0,
  0xFF, 0xD0,
  0xFE, 0x40,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_006B[128] = { /* code 006B, LATIN SMALL LETTER K */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00,
  0x0F, 0xF0, 0x0B, 0xF4,
  0x0F, 0xF0, 0x2F, 0xD0,
  0x0F, 0xF0, 0x7F, 0x40,
  0x0F, 0xF0, 0xFE, 0x00,
  0x0F, 0xF2, 0xF8, 0x00,
  0x0F, 0xF7, 0xE0, 0x00,
  0x0F, 0xFF, 0xF0, 0x00,
  0x0F, 0xFF, 0xF8, 0x00,
  0x0F, 0xFE, 0xFC, 0x00,
  0x0F, 0xF8, 0xFE, 0x00,
  0x0F, 0xF0, 0xBF, 0x40,
  0x0F, 0xF0, 0x7F, 0x80,
  0x0F, 0xF0, 0x2F, 0xD0,
  0x0F, 0xF0, 0x1F, 0xE0,
  0x0F, 0xF0, 0x0B, 0xF4,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_006C[ 64] = { /* code 006C, LATIN SMALL LETTER L */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x0F, 0xF0,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_006D[224] = { /* code 006D, LATIN SMALL LETTER M */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF1, 0xBF, 0x80, 0x6F, 0xA0, 0x00,
  0x0F, 0xFB, 0xFF, 0xE2, 0xFF, 0xF8, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0x0F, 0xFD, 0x0B, 0xFF, 0x42, 0xFE, 0x00,
  0x0F, 0xF8, 0x03, 0xFE, 0x01, 0xFF, 0x00,
  0x0F, 0xF4, 0x03, 0xFD, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_006E[160] = { /* code 006E, LATIN SMALL LETTER N */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF1, 0xBF, 0x80, 0x00,
  0x0F, 0xF7, 0xFF, 0xF0, 0x00,
  0x0F, 0xFF, 0xFF, 0xF8, 0x00,
  0x0F, 0xFD, 0x0B, 0xF8, 0x00,
  0x0F, 0xF8, 0x07, 0xFC, 0x00,
  0x0F, 0xF4, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_006F[160] = { /* code 006F, LATIN SMALL LETTER O */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1B, 0xF9, 0x00, 0x00,
  0x01, 0xFF, 0xFF, 0xD0, 0x00,
  0x07, 0xFF, 0xFF, 0xF4, 0x00,
  0x0F, 0xF8, 0x0B, 0xFC, 0x00,
  0x1F, 0xE0, 0x02, 0xFD, 0x00,
  0x2F, 0xD0, 0x01, 0xFE, 0x00,
  0x3F, 0xC0, 0x00, 0xFF, 0x00,
  0x3F, 0xC0, 0x00, 0xFF, 0x00,
  0x3F, 0xC0, 0x00, 0xFF, 0x00,
  0x2F, 0xD0, 0x01, 0xFE, 0x00,
  0x1F, 0xE0, 0x02, 0xFD, 0x00,
  0x0F, 0xF8, 0x0B, 0xF8, 0x00,
  0x07, 0xFF, 0xFF, 0xF4, 0x00,
  0x01, 0xFF, 0xFF, 0x90, 0x00,
  0x00, 0x1B, 0xF9, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0070[160] = { /* code 0070, LATIN SMALL LETTER P */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF1, 0xBE, 0x80, 0x00,
  0x0F, 0xFB, 0xFF, 0xE0, 0x00,
  0x0F, 0xFF, 0xFF, 0xF8, 0x00,
  0x0F, 0xFE, 0x0B, 0xFD, 0x00,
  0x0F, 0xF8, 0x02, 0xFE, 0x00,
  0x0F, 0xF4, 0x01, 0xFE, 0x00,
  0x0F, 0xF0, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0xFF, 0x00,
  0x0F, 0xF0, 0x00, 0xFF, 0x00,
  0x0F, 0xF4, 0x01, 0xFE, 0x00,
  0x0F, 0xF8, 0x02, 0xFE, 0x00,
  0x0F, 0xFE, 0x07, 0xFD, 0x00,
  0x0F, 0xFF, 0xFF, 0xF8, 0x00,
  0x0F, 0xF7, 0xFF, 0xE0, 0x00,
  0x0F, 0xF1, 0xBE, 0x40, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0071[160] = { /* code 0071, LATIN SMALL LETTER Q */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xAF, 0x93, 0xFC, 0x00,
  0x02, 0xFF, 0xFB, 0xFC, 0x00,
  0x0B, 0xFF, 0xFF, 0xFC, 0x00,
  0x1F, 0xF8, 0x1F, 0xFC, 0x00,
  0x2F, 0xE0, 0x0B, 0xFC, 0x00,
  0x2F, 0xD0, 0x07, 0xFC, 0x00,
  0x3F, 0xC0, 0x03, 0xFC, 0x00,
  0x3F, 0xC0, 0x03, 0xFC, 0x00,
  0x3F, 0xC0, 0x03, 0xFC, 0x00,
  0x2F, 0xD0, 0x07, 0xFC, 0x00,
  0x2F, 0xE0, 0x0B, 0xFC, 0x00,
  0x1F, 0xF4, 0x2F, 0xFC, 0x00,
  0x0B, 0xFF, 0xFF, 0xFC, 0x00,
  0x02, 0xFF, 0xFB, 0xFC, 0x00,
  0x00, 0xAF, 0x93, 0xFC, 0x00,
  0x00, 0x00, 0x03, 0xFC, 0x00,
  0x00, 0x00, 0x03, 0xFC, 0x00,
  0x00, 0x00, 0x03, 0xFC, 0x00,
  0x00, 0x00, 0x03, 0xFC, 0x00,
  0x00, 0x00, 0x03, 0xFC, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0072[ 96] = { /* code 0072, LATIN SMALL LETTER R */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x0F, 0xF2, 0xF8,
  0x0F, 0xFB, 0xF8,
  0x0F, 0xFF, 0xF8,
  0x0F, 0xFD, 0x00,
  0x0F, 0xF8, 0x00,
  0x0F, 0xF4, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0073[128] = { /* code 0073, LATIN SMALL LETTER S */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x01, 0xAF, 0xE9, 0x00,
  0x0B, 0xFF, 0xFF, 0x80,
  0x2F, 0xFF, 0xFF, 0xE0,
  0x3F, 0xD0, 0x1A, 0x40,
  0x3F, 0xD0, 0x00, 0x00,
  0x2F, 0xF9, 0x00, 0x00,
  0x1F, 0xFF, 0xE0, 0x00,
  0x07, 0xFF, 0xFE, 0x00,
  0x00, 0x6F, 0xFF, 0xD0,
  0x00, 0x01, 0xAF, 0xE0,
  0x00, 0x00, 0x0F, 0xF0,
  0x06, 0x90, 0x2F, 0xE0,
  0x2F, 0xFF, 0xFF, 0xD0,
  0x0B, 0xFF, 0xFF, 0x80,
  0x01, 0xAF, 0xE9, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0074[ 96] = { /* code 0074, LATIN SMALL LETTER T */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x60, 0x00,
  0x06, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0xFF, 0xFF, 0xC0,
  0xFF, 0xFF, 0xC0,
  0xFF, 0xFF, 0xC0,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF4, 0x00,
  0x0B, 0xFF, 0x80,
  0x0B, 0xFF, 0x80,
  0x01, 0xBE, 0x80,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0075[160] = { /* code 0075, LATIN SMALL LETTER U */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF0, 0x03, 0xFC, 0x00,
  0x0F, 0xF4, 0x07, 0xFC, 0x00,
  0x0B, 0xF8, 0x1F, 0xFC, 0x00,
  0x0B, 0xFF, 0xFF, 0xFC, 0x00,
  0x02, 0xFF, 0xFB, 0xFC, 0x00,
  0x00, 0xBF, 0x93, 0xFC, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0076[128] = { /* code 0076, LATIN SMALL LETTER V */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x7F, 0x80, 0x0B, 0xF4,
  0x3F, 0x80, 0x0B, 0xF0,
  0x2F, 0xC0, 0x0F, 0xE0,
  0x1F, 0xD0, 0x1F, 0xD0,
  0x0F, 0xE0, 0x2F, 0xC0,
  0x0B, 0xE0, 0x2F, 0x80,
  0x07, 0xF0, 0x3F, 0x40,
  0x03, 0xF4, 0x7F, 0x00,
  0x02, 0xF8, 0x7E, 0x00,
  0x01, 0xF8, 0xBD, 0x00,
  0x00, 0xFD, 0xFC, 0x00,
  0x00, 0xBF, 0xF8, 0x00,
  0x00, 0x7F, 0xF4, 0x00,
  0x00, 0x3F, 0xF0, 0x00,
  0x00, 0x2F, 0xE0, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0077[192] = { /* code 0077, LATIN SMALL LETTER W */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xBE, 0x00, 0x2E, 0x00, 0x2F, 0x80,
  0x7F, 0x00, 0x3F, 0x00, 0x3F, 0x40,
  0x3F, 0x40, 0x7F, 0x40, 0x7F, 0x00,
  0x2F, 0x80, 0xBF, 0x80, 0xBE, 0x00,
  0x1F, 0x80, 0xBB, 0x80, 0xBD, 0x00,
  0x0F, 0xC0, 0xF7, 0xC0, 0xFC, 0x00,
  0x0B, 0xD1, 0xE3, 0xD1, 0xF8, 0x00,
  0x07, 0xE2, 0xE2, 0xE2, 0xF4, 0x00,
  0x03, 0xF2, 0xD1, 0xE3, 0xF0, 0x00,
  0x02, 0xF7, 0xC0, 0xF7, 0xE0, 0x00,
  0x01, 0xFB, 0x80, 0xBB, 0xD0, 0x00,
  0x00, 0xFF, 0x80, 0xBF, 0xC0, 0x00,
  0x00, 0xBF, 0x40, 0x7F, 0x80, 0x00,
  0x00, 0x7F, 0x00, 0x3F, 0x40, 0x00,
  0x00, 0x3E, 0x00, 0x2F, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0078[128] = { /* code 0078, LATIN SMALL LETTER X */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x7F, 0x80, 0x0B, 0xF4,
  0x2F, 0xD0, 0x2F, 0xE0,
  0x0B, 0xF0, 0x3F, 0x80,
  0x07, 0xF8, 0xBF, 0x40,
  0x02, 0xFD, 0xFD, 0x00,
  0x00, 0xBF, 0xF8, 0x00,
  0x00, 0x7F, 0xF0, 0x00,
  0x00, 0x2F, 0xE0, 0x00,
  0x00, 0x7F, 0xF4, 0x00,
  0x00, 0xFF, 0xFC, 0x00,
  0x02, 0xFD, 0xFE, 0x00,
  0x07, 0xF8, 0xBF, 0x40,
  0x0B, 0xF0, 0x3F, 0x80,
  0x2F, 0xD0, 0x2F, 0xE0,
  0x7F, 0x80, 0x0B, 0xF4,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_0079[128] = { /* code 0079, LATIN SMALL LETTER Y */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0xFE, 0x00, 0x02, 0xFC,
  0xBF, 0x40, 0x07, 0xF8,
  0x7F, 0x80, 0x0B, 0xF4,
  0x2F, 0x80, 0x0B, 0xE0,
  0x2F, 0xD0, 0x1F, 0xE0,
  0x0F, 0xE0, 0x2F, 0xC0,
  0x0B, 0xE0, 0x2F, 0x80,
  0x07, 0xF4, 0x7F, 0x40,
  0x03, 0xF4, 0x7E, 0x00,
  0x02, 0xF8, 0xBE, 0x00,
  0x01, 0xFD, 0xFC, 0x00,
  0x00, 0xBE, 0xF8, 0x00,
  0x00, 0x7F, 0xF4, 0x00,
  0x00, 0x3F, 0xF0, 0x00,
  0x00, 0x2F, 0xE0, 0x00,
  0x00, 0x2F, 0xD0, 0x00,
  0x00, 0xBF, 0x80, 0x00,
  0x3F, 0xFF, 0x40, 0x00,
  0x3F, 0xFE, 0x00, 0x00,
  0x2F, 0xE4, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_007A[128] = { /* code 007A, LATIN SMALL LETTER Z */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x3F, 0xFF, 0xFF, 0xC0,
  0x3F, 0xFF, 0xFF, 0xC0,
  0x3F, 0xFF, 0xFF, 0xC0,
  0x00, 0x00, 0x7F, 0x80,
  0x00, 0x01, 0xFE, 0x00,
  0x00, 0x07, 0xF8, 0x00,
  0x00, 0x1F, 0xE0, 0x00,
  0x00, 0x7F, 0xD0, 0x00,
  0x00, 0xBF, 0x40, 0x00,
  0x02, 0xFD, 0x00, 0x00,
  0x0B, 0xF4, 0x00, 0x00,
  0x2F, 0xD0, 0x00, 0x00,
  0x3F, 0xFF, 0xFF, 0xC0,
  0x3F, 0xFF, 0xFF, 0xC0,
  0x3F, 0xFF, 0xFF, 0xC0,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_007B[ 96] = { /* code 007B, LEFT CURLY BRACKET */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x1B, 0xF0,
  0x00, 0x7F, 0xF0,
  0x00, 0xBF, 0xF0,
  0x00, 0xBD, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0xFC, 0x00,
  0x01, 0xF8, 0x00,
  0x07, 0xF8, 0x00,
  0x3F, 0xE0, 0x00,
  0x3F, 0xC0, 0x00,
  0x3F, 0xE0, 0x00,
  0x07, 0xF8, 0x00,
  0x01, 0xF8, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0xFE, 0x00,
  0x00, 0xBF, 0xF0,
  0x00, 0x7F, 0xF0,
  0x00, 0x1B, 0xF0,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_007C[ 64] = { /* code 007C, VERTICAL LINE */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x0F, 0xC0,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_007D[ 96] = { /* code 007D, RIGHT CURLY BRACKET */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3F, 0x90, 0x00,
  0x3F, 0xF4, 0x00,
  0x3F, 0xF8, 0x00,
  0x01, 0xF8, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0xBD, 0x00,
  0x00, 0xBF, 0x40,
  0x00, 0x2F, 0xF0,
  0x00, 0x1F, 0xF0,
  0x00, 0x3F, 0xF0,
  0x00, 0xBF, 0x40,
  0x00, 0xBD, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0xFC, 0x00,
  0x02, 0xF8, 0x00,
  0x3F, 0xF8, 0x00,
  0x3F, 0xF4, 0x00,
  0x3F, 0x90, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_32_007E[128] = { /* code 007E, TILDE */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x06, 0xF9, 0x00, 0x04,
  0x2F, 0xFF, 0xE4, 0x6C,
  0x3F, 0xFF, 0xFF, 0xFC,
  0x3F, 0xFF, 0xFF, 0xFC,
  0x39, 0x06, 0xFF, 0xF8,
  0x10, 0x00, 0x6F, 0x90,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO GUI_FontAA2_32_CharInfo[95] = {
   {   8,   8,  2, acGUI_FontAA2_32_0020 } /* code 0020 */
  ,{   8,   8,  2, acGUI_FontAA2_32_0021 } /* code 0021 */
  ,{  13,  13,  4, acGUI_FontAA2_32_0022 } /* code 0022 */
  ,{  15,  15,  4, acGUI_FontAA2_32_0023 } /* code 0023 */
  ,{  15,  15,  4, acGUI_FontAA2_32_0024 } /* code 0024 */
  ,{  24,  24,  6, acGUI_FontAA2_32_0025 } /* code 0025 */
  ,{  20,  20,  5, acGUI_FontAA2_32_0026 } /* code 0026 */
  ,{   6,   6,  2, acGUI_FontAA2_32_0027 } /* code 0027 */
  ,{   9,   9,  3, acGUI_FontAA2_32_0028 } /* code 0028 */
  ,{   9,   9,  3, acGUI_FontAA2_32_0029 } /* code 0029 */
  ,{  11,  11,  3, acGUI_FontAA2_32_002A } /* code 002A */
  ,{  16,  16,  4, acGUI_FontAA2_32_002B } /* code 002B */
  ,{   8,   8,  2, acGUI_FontAA2_32_002C } /* code 002C */
  ,{   9,   9,  3, acGUI_FontAA2_32_002D } /* code 002D */
  ,{   8,   8,  2, acGUI_FontAA2_32_002E } /* code 002E */
  ,{   8,   8,  2, acGUI_FontAA2_32_002F } /* code 002F */
  ,{  15,  15,  4, acGUI_FontAA2_32_0030 } /* code 0030 */
  ,{  15,  15,  4, acGUI_FontAA2_32_0031 } /* code 0031 */
  ,{  15,  15,  4, acGUI_FontAA2_32_0032 } /* code 0032 */
  ,{  15,  15,  4, acGUI_FontAA2_32_0033 } /* code 0033 */
  ,{  15,  15,  4, acGUI_FontAA2_32_0034 } /* code 0034 */
  ,{  15,  15,  4, acGUI_FontAA2_32_0035 } /* code 0035 */
  ,{  15,  15,  4, acGUI_FontAA2_32_0036 } /* code 0036 */
  ,{  15,  15,  4, acGUI_FontAA2_32_0037 } /* code 0037 */
  ,{  15,  15,  4, acGUI_FontAA2_32_0038 } /* code 0038 */
  ,{  15,  15,  4, acGUI_FontAA2_32_0039 } /* code 0039 */
  ,{  10,  10,  3, acGUI_FontAA2_32_003A } /* code 003A */
  ,{  10,  10,  3, acGUI_FontAA2_32_003B } /* code 003B */
  ,{  16,  16,  4, acGUI_FontAA2_32_003C } /* code 003C */
  ,{  16,  16,  4, acGUI_FontAA2_32_003D } /* code 003D */
  ,{  16,  16,  4, acGUI_FontAA2_32_003E } /* code 003E */
  ,{  17,  17,  5, acGUI_FontAA2_32_003F } /* code 003F */
  ,{  26,  26,  7, acGUI_FontAA2_32_0040 } /* code 0040 */
  ,{  19,  19,  5, acGUI_FontAA2_32_0041 } /* code 0041 */
  ,{  20,  20,  5, acGUI_FontAA2_32_0042 } /* code 0042 */
  ,{  20,  20,  5, acGUI_FontAA2_32_0043 } /* code 0043 */
  ,{  20,  20,  5, acGUI_FontAA2_32_0044 } /* code 0044 */
  ,{  18,  18,  5, acGUI_FontAA2_32_0045 } /* code 0045 */
  ,{  17,  17,  5, acGUI_FontAA2_32_0046 } /* code 0046 */
  ,{  21,  21,  6, acGUI_FontAA2_32_0047 } /* code 0047 */
  ,{  20,  20,  5, acGUI_FontAA2_32_0048 } /* code 0048 */
  ,{   8,   8,  2, acGUI_FontAA2_32_0049 } /* code 0049 */
  ,{  15,  15,  4, acGUI_FontAA2_32_004A } /* code 004A */
  ,{  20,  20,  5, acGUI_FontAA2_32_004B } /* code 004B */
  ,{  17,  17,  5, acGUI_FontAA2_32_004C } /* code 004C */
  ,{  21,  21,  6, acGUI_FontAA2_32_004D } /* code 004D */
  ,{  20,  20,  5, acGUI_FontAA2_32_004E } /* code 004E */
  ,{  21,  21,  6, acGUI_FontAA2_32_004F } /* code 004F */
  ,{  18,  18,  5, acGUI_FontAA2_32_0050 } /* code 0050 */
  ,{  21,  21,  6, acGUI_FontAA2_32_0051 } /* code 0051 */
  ,{  20,  20,  5, acGUI_FontAA2_32_0052 } /* code 0052 */
  ,{  18,  18,  5, acGUI_FontAA2_32_0053 } /* code 0053 */
  ,{  18,  18,  5, acGUI_FontAA2_32_0054 } /* code 0054 */
  ,{  20,  20,  5, acGUI_FontAA2_32_0055 } /* code 0055 */
  ,{  18,  18,  5, acGUI_FontAA2_32_0056 } /* code 0056 */
  ,{  25,  25,  7, acGUI_FontAA2_32_0057 } /* code 0057 */
  ,{  18,  18,  5, acGUI_FontAA2_32_0058 } /* code 0058 */
  ,{  18,  18,  5, acGUI_FontAA2_32_0059 } /* code 0059 */
  ,{  17,  17,  5, acGUI_FontAA2_32_005A } /* code 005A */
  ,{   9,   9,  3, acGUI_FontAA2_32_005B } /* code 005B */
  ,{   8,   8,  2, acGUI_FontAA2_32_005C } /* code 005C */
  ,{   9,   9,  3, acGUI_FontAA2_32_005D } /* code 005D */
  ,{  16,  16,  4, acGUI_FontAA2_32_005E } /* code 005E */
  ,{  15,  15,  4, acGUI_FontAA2_32_005F } /* code 005F */
  ,{   9,   9,  3, acGUI_FontAA2_32_0060 } /* code 0060 */
  ,{  15,  15,  4, acGUI_FontAA2_32_0061 } /* code 0061 */
  ,{  17,  17,  5, acGUI_FontAA2_32_0062 } /* code 0062 */
  ,{  15,  15,  4, acGUI_FontAA2_32_0063 } /* code 0063 */
  ,{  17,  17,  5, acGUI_FontAA2_32_0064 } /* code 0064 */
  ,{  15,  15,  4, acGUI_FontAA2_32_0065 } /* code 0065 */
  ,{   9,   9,  3, acGUI_FontAA2_32_0066 } /* code 0066 */
  ,{  17,  17,  5, acGUI_FontAA2_32_0067 } /* code 0067 */
  ,{  17,  17,  5, acGUI_FontAA2_32_0068 } /* code 0068 */
  ,{   8,   8,  2, acGUI_FontAA2_32_0069 } /* code 0069 */
  ,{   8,   8,  2, acGUI_FontAA2_32_006A } /* code 006A */
  ,{  15,  15,  4, acGUI_FontAA2_32_006B } /* code 006B */
  ,{   8,   8,  2, acGUI_FontAA2_32_006C } /* code 006C */
  ,{  26,  26,  7, acGUI_FontAA2_32_006D } /* code 006D */
  ,{  17,  17,  5, acGUI_FontAA2_32_006E } /* code 006E */
  ,{  17,  17,  5, acGUI_FontAA2_32_006F } /* code 006F */
  ,{  17,  17,  5, acGUI_FontAA2_32_0070 } /* code 0070 */
  ,{  17,  17,  5, acGUI_FontAA2_32_0071 } /* code 0071 */
  ,{  11,  11,  3, acGUI_FontAA2_32_0072 } /* code 0072 */
  ,{  15,  15,  4, acGUI_FontAA2_32_0073 } /* code 0073 */
  ,{   9,   9,  3, acGUI_FontAA2_32_0074 } /* code 0074 */
  ,{  17,  17,  5, acGUI_FontAA2_32_0075 } /* code 0075 */
  ,{  15,  15,  4, acGUI_FontAA2_32_0076 } /* code 0076 */
  ,{  21,  21,  6, acGUI_FontAA2_32_0077 } /* code 0077 */
  ,{  15,  15,  4, acGUI_FontAA2_32_0078 } /* code 0078 */
  ,{  15,  15,  4, acGUI_FontAA2_32_0079 } /* code 0079 */
  ,{  14,  14,  4, acGUI_FontAA2_32_007A } /* code 007A */
  ,{  11,  11,  3, acGUI_FontAA2_32_007B } /* code 007B */
  ,{   7,   7,  2, acGUI_FontAA2_32_007C } /* code 007C */
  ,{  11,  11,  3, acGUI_FontAA2_32_007D } /* code 007D */
  ,{  16,  16,  4, acGUI_FontAA2_32_007E } /* code 007E */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontAA2_32_Prop1 = {
   0x0020 /* first character */
  ,0x007E /* last character  */
  ,&GUI_FontAA2_32_CharInfo[  0] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP *)0 /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_FontAA2_32 = {
   GUI_FONTTYPE_PROP_AA2 /* type of font    */
  ,32 /* height of font  */
  ,32 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_FontAA2_32_Prop1}
  ,25 /* Baseline */
  ,15 /* Height of lowercase characters */
  ,20 /* Height of capital characters */
};

