/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2014  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.24 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software has been licensed to  ARM LIMITED whose registered office
is situated at  110 Fulbourn Road,  Cambridge CB1 9NJ,  England solely
for  the  purposes  of  creating  libraries  for  ARM7, ARM9, Cortex-M
series,  and   Cortex-R4   processor-based  devices,  sublicensed  and
distributed as part of the  MDK-ARM  Professional  under the terms and
conditions  of  the   End  User  License  supplied  with  the  MDK-ARM
Professional. 
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
File        : AA2_21.c
Purpose     : Font file
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI.H"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/* The following line needs to be included in any file selecting the
   font. A good place would be GUIConf.H
*/
extern GUI_CONST_STORAGE GUI_FONT GUI_FontAA2_21;

/* Start of unicode area <Basic Latin> */
GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0020[ 42] = { /* code 0020, SPACE */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0021[ 42] = { /* code 0021, EXCLAMATION MARK */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x00, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0022[ 42] = { /* code 0022, QUOTATION MARK */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x3C, 0xF0,
  0x3C, 0xF0,
  0x3C, 0xF0,
  0x28, 0xA0,
  0x28, 0xA0,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0023[ 63] = { /* code 0023, NUMBER SIGN */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0xE0, 0xE0,
  0x01, 0xE1, 0xE0,
  0x02, 0xD2, 0xD0,
  0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0,
  0x07, 0x87, 0x80,
  0x0B, 0x8B, 0x80,
  0x0B, 0x4B, 0x40,
  0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0,
  0x1E, 0x1E, 0x00,
  0x2D, 0x2D, 0x00,
  0x2C, 0x2C, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0024[ 63] = { /* code 0024, DOLLAR SIGN */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x30, 0x00,
  0x06, 0xFE, 0x40,
  0x1F, 0xFF, 0xD0,
  0x3D, 0x31, 0xE0,
  0x3C, 0x30, 0x00,
  0x2E, 0x70, 0x00,
  0x0B, 0xF9, 0x00,
  0x01, 0xBF, 0x80,
  0x00, 0x3B, 0xE0,
  0x00, 0x31, 0xF0,
  0x3C, 0x30, 0xF0,
  0x2E, 0x32, 0xE0,
  0x0F, 0xFF, 0xD0,
  0x06, 0xFE, 0x40,
  0x00, 0x30, 0x00,
  0x00, 0x30, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0025[ 84] = { /* code 0025, PERCENT SIGN */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x0B, 0xE0, 0x0E, 0x00,
  0x2D, 0x78, 0x2D, 0x00,
  0x3C, 0x3C, 0x38, 0x00,
  0x3C, 0x3C, 0xB4, 0x00,
  0x3C, 0x3C, 0xF0, 0x00,
  0x2D, 0x7A, 0xE0, 0x00,
  0x0B, 0xE3, 0xCB, 0xE0,
  0x00, 0x07, 0xAD, 0x78,
  0x00, 0x0B, 0x3C, 0x3C,
  0x00, 0x1E, 0x3C, 0x3C,
  0x00, 0x2C, 0x3C, 0x3C,
  0x00, 0x78, 0x2D, 0x78,
  0x00, 0xB4, 0x0B, 0xE0,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0026[ 63] = { /* code 0026, AMPERSAND */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0xBE, 0x00,
  0x02, 0xFF, 0x80,
  0x03, 0xD7, 0xC0,
  0x03, 0xC3, 0x80,
  0x02, 0xDB, 0x40,
  0x01, 0xF8, 0x00,
  0x0B, 0xB8, 0x00,
  0x2E, 0x2D, 0x38,
  0x2C, 0x0B, 0xB8,
  0x3C, 0x03, 0xF4,
  0x2E, 0x06, 0xF4,
  0x1F, 0xFF, 0xAD,
  0x06, 0xF9, 0x0A,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0027[ 21] = { /* code 0027, APOSTROPHE */
  0x00,
  0x00,
  0x00,
  0x00,
  0xF0,
  0xF0,
  0xF0,
  0xA0,
  0xA0,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0028[ 42] = { /* code 0028, LEFT PARENTHESIS */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x60,
  0x01, 0xC0,
  0x03, 0x80,
  0x0B, 0x00,
  0x0E, 0x00,
  0x2D, 0x00,
  0x2D, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x2D, 0x00,
  0x2D, 0x00,
  0x0E, 0x00,
  0x0B, 0x00,
  0x03, 0x80,
  0x01, 0xC0,
  0x00, 0x60
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0029[ 42] = { /* code 0029, RIGHT PARENTHESIS */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x90, 0x00,
  0x34, 0x00,
  0x2C, 0x00,
  0x0E, 0x00,
  0x0B, 0x00,
  0x07, 0x80,
  0x07, 0x80,
  0x03, 0xC0,
  0x03, 0xC0,
  0x03, 0xC0,
  0x07, 0x80,
  0x07, 0x80,
  0x0B, 0x00,
  0x0E, 0x00,
  0x2C, 0x00,
  0x34, 0x00,
  0x90, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_002A[ 42] = { /* code 002A, ASTERISK */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x03, 0x00,
  0x2A, 0xA0,
  0x0B, 0x90,
  0x0A, 0x80,
  0x08, 0x80,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_002B[ 63] = { /* code 002B, PLUS SIGN */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x3F, 0xFF, 0xFC,
  0x3F, 0xFF, 0xFC,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_002C[ 42] = { /* code 002C, COMMA */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x07, 0x00,
  0x09, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_002D[ 42] = { /* code 002D, HYPHEN-MINUS */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0xFF, 0xC0,
  0xFF, 0xC0,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_002E[ 42] = { /* code 002E, FULL STOP */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_002F[ 42] = { /* code 002F, SOLIDUS */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0xC0,
  0x01, 0xC0,
  0x02, 0xC0,
  0x03, 0xC0,
  0x07, 0x80,
  0x0B, 0x40,
  0x0F, 0x00,
  0x1E, 0x00,
  0x2D, 0x00,
  0x3C, 0x00,
  0x78, 0x00,
  0xB4, 0x00,
  0xB0, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0030[ 63] = { /* code 0030, DIGIT ZERO */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x06, 0xF9, 0x00,
  0x0F, 0xFF, 0x40,
  0x2E, 0x0B, 0x80,
  0x2D, 0x07, 0x80,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x2D, 0x07, 0x80,
  0x2E, 0x0B, 0x80,
  0x1F, 0xFF, 0x00,
  0x06, 0xF9, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0031[ 63] = { /* code 0031, DIGIT ONE */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x2C, 0x00,
  0x00, 0xBC, 0x00,
  0x02, 0xFC, 0x00,
  0x0F, 0x7C, 0x00,
  0x08, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0032[ 63] = { /* code 0032, DIGIT TWO */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x06, 0xF9, 0x00,
  0x1F, 0xFF, 0x40,
  0x2E, 0x0B, 0x80,
  0x3C, 0x03, 0xC0,
  0x00, 0x03, 0x80,
  0x00, 0x07, 0x80,
  0x00, 0x1E, 0x00,
  0x00, 0x78, 0x00,
  0x01, 0xE0, 0x00,
  0x07, 0x80, 0x00,
  0x1E, 0x00, 0x00,
  0x2F, 0xFF, 0xC0,
  0x3F, 0xFF, 0xC0,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0033[ 63] = { /* code 0033, DIGIT THREE */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x06, 0xE8, 0x00,
  0x1F, 0xFE, 0x00,
  0x2D, 0x1F, 0x00,
  0x00, 0x0F, 0x00,
  0x00, 0x1E, 0x00,
  0x00, 0xB8, 0x00,
  0x00, 0xAE, 0x00,
  0x00, 0x07, 0x80,
  0x00, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x2E, 0x0B, 0x80,
  0x0F, 0xFF, 0x40,
  0x06, 0xF9, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0034[ 63] = { /* code 0034, DIGIT FOUR */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x2C, 0x00,
  0x00, 0xBC, 0x00,
  0x01, 0xFC, 0x00,
  0x02, 0xFC, 0x00,
  0x0B, 0x7C, 0x00,
  0x1E, 0x3C, 0x00,
  0x3C, 0x3C, 0x00,
  0xB4, 0x3C, 0x00,
  0xFF, 0xFF, 0xC0,
  0xFF, 0xFF, 0xC0,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0035[ 63] = { /* code 0035, DIGIT FIVE */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x0F, 0xFF, 0x00,
  0x1F, 0xFF, 0x00,
  0x1E, 0x00, 0x00,
  0x2D, 0x00, 0x00,
  0x2D, 0xB9, 0x00,
  0x2F, 0xFF, 0x40,
  0x3D, 0x0B, 0x80,
  0x00, 0x03, 0xC0,
  0x00, 0x03, 0xC0,
  0x3C, 0x03, 0x80,
  0x2E, 0x0B, 0x80,
  0x1F, 0xFE, 0x00,
  0x06, 0xF8, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0036[ 63] = { /* code 0036, DIGIT SIX */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x02, 0xBA, 0x00,
  0x0B, 0xFF, 0x80,
  0x1E, 0x07, 0x80,
  0x2D, 0x00, 0x00,
  0x2D, 0x00, 0x00,
  0x3C, 0xB9, 0x00,
  0x3E, 0xFF, 0x40,
  0x3E, 0x0B, 0x80,
  0x3C, 0x03, 0xC0,
  0x2C, 0x03, 0xC0,
  0x1E, 0x0B, 0x80,
  0x0B, 0xFF, 0x40,
  0x02, 0xF9, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0037[ 63] = { /* code 0037, DIGIT SEVEN */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3F, 0xFF, 0xC0,
  0x3F, 0xFF, 0xC0,
  0x00, 0x07, 0x40,
  0x00, 0x0E, 0x00,
  0x00, 0x2D, 0x00,
  0x00, 0x38, 0x00,
  0x00, 0xB4, 0x00,
  0x00, 0xF0, 0x00,
  0x01, 0xE0, 0x00,
  0x02, 0xE0, 0x00,
  0x02, 0xD0, 0x00,
  0x02, 0xC0, 0x00,
  0x03, 0xC0, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0038[ 63] = { /* code 0038, DIGIT EIGHT */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x06, 0xF9, 0x00,
  0x1F, 0xFF, 0x40,
  0x2D, 0x07, 0x80,
  0x3C, 0x03, 0xC0,
  0x2D, 0x07, 0x80,
  0x0B, 0xFE, 0x00,
  0x0B, 0xFE, 0x00,
  0x2E, 0x0B, 0x80,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x2D, 0x0B, 0x80,
  0x1F, 0xFF, 0x40,
  0x06, 0xF9, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0039[ 63] = { /* code 0039, DIGIT NINE */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x06, 0xF8, 0x00,
  0x1F, 0xFF, 0x40,
  0x2E, 0x0B, 0x80,
  0x3C, 0x03, 0x80,
  0x3C, 0x03, 0xC0,
  0x2E, 0x0B, 0xC0,
  0x1F, 0xFB, 0xC0,
  0x06, 0xE3, 0xC0,
  0x00, 0x07, 0x80,
  0x00, 0x07, 0x80,
  0x2D, 0x0B, 0x40,
  0x2F, 0xFE, 0x00,
  0x0A, 0xE8, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_003A[ 42] = { /* code 003A, COLON */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_003B[ 42] = { /* code 003B, SEMICOLON */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x07, 0x00,
  0x09, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_003C[ 63] = { /* code 003C, LESS-THAN SIGN */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x60,
  0x00, 0x06, 0xF0,
  0x00, 0xBE, 0x90,
  0x1B, 0xE4, 0x00,
  0x3E, 0x00, 0x00,
  0x1B, 0xE4, 0x00,
  0x00, 0xBE, 0x90,
  0x00, 0x06, 0xF0,
  0x00, 0x00, 0x60,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_003D[ 63] = { /* code 003D, EQUALS SIGN */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3F, 0xFF, 0xF0,
  0x3F, 0xFF, 0xF0,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3F, 0xFF, 0xF0,
  0x3F, 0xFF, 0xF0,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_003E[ 63] = { /* code 003E, GREATER-THAN SIGN */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x24, 0x00, 0x00,
  0x3E, 0x40, 0x00,
  0x1A, 0xF8, 0x00,
  0x00, 0x6F, 0x90,
  0x00, 0x02, 0xF0,
  0x00, 0x6F, 0x90,
  0x1A, 0xF8, 0x00,
  0x3E, 0x40, 0x00,
  0x24, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_003F[ 63] = { /* code 003F, QUESTION MARK */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x06, 0xF9, 0x00,
  0x1F, 0xFF, 0x40,
  0x2E, 0x0B, 0x80,
  0x3C, 0x03, 0xC0,
  0x00, 0x07, 0x80,
  0x00, 0x1F, 0x40,
  0x00, 0xBD, 0x00,
  0x01, 0xE0, 0x00,
  0x02, 0xD0, 0x00,
  0x03, 0xC0, 0x00,
  0x00, 0x00, 0x00,
  0x03, 0xC0, 0x00,
  0x03, 0xC0, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0040[105] = { /* code 0040, COMMERCIAL AT */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x06, 0xFF, 0x90, 0x00,
  0x00, 0x7F, 0xFF, 0xFD, 0x00,
  0x01, 0xF9, 0x00, 0x6F, 0x40,
  0x07, 0xD1, 0xB8, 0xEB, 0xC0,
  0x0B, 0x4B, 0xFE, 0xE2, 0xE0,
  0x1E, 0x0F, 0x4B, 0xD1, 0xE0,
  0x2D, 0x2E, 0x03, 0xC0, 0xF0,
  0x2C, 0x2D, 0x03, 0x80, 0xF0,
  0x3C, 0x3C, 0x07, 0x81, 0xE0,
  0x3C, 0x3C, 0x0B, 0x43, 0xD0,
  0x2D, 0x2E, 0x1F, 0x1B, 0x80,
  0x2E, 0x1F, 0xFF, 0xFE, 0x00,
  0x1F, 0x0B, 0x9B, 0xE4, 0x00,
  0x0B, 0x90, 0x00, 0x02, 0xE0,
  0x02, 0xF9, 0x00, 0x5B, 0x80,
  0x00, 0xBF, 0xFF, 0xFE, 0x00,
  0x00, 0x1A, 0xFF, 0xA0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0041[ 63] = { /* code 0041, LATIN CAPITAL LETTER A */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0xFC, 0x00,
  0x01, 0xFD, 0x00,
  0x02, 0xEE, 0x00,
  0x03, 0xCF, 0x00,
  0x07, 0x8B, 0x40,
  0x0B, 0x47, 0x80,
  0x0F, 0x03, 0xC0,
  0x1F, 0xFF, 0xD0,
  0x2F, 0xFF, 0xE0,
  0x3C, 0x00, 0xF0,
  0x78, 0x00, 0xB4,
  0xB4, 0x00, 0x78,
  0xF0, 0x00, 0x3C,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0042[ 63] = { /* code 0042, LATIN CAPITAL LETTER B */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3F, 0xFF, 0x90,
  0x3F, 0xFF, 0xF4,
  0x3C, 0x00, 0xB8,
  0x3C, 0x00, 0x3C,
  0x3C, 0x00, 0xB8,
  0x3F, 0xFF, 0xE0,
  0x3F, 0xFF, 0xE0,
  0x3C, 0x00, 0x78,
  0x3C, 0x00, 0x3C,
  0x3C, 0x00, 0x3C,
  0x3C, 0x00, 0xB8,
  0x3F, 0xFF, 0xF4,
  0x3F, 0xFF, 0x90,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0043[ 84] = { /* code 0043, LATIN CAPITAL LETTER C */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0xAF, 0x90, 0x00,
  0x07, 0xFF, 0xF8, 0x00,
  0x0F, 0x90, 0x7E, 0x00,
  0x1E, 0x00, 0x1F, 0x00,
  0x2D, 0x00, 0x04, 0x00,
  0x3C, 0x00, 0x00, 0x00,
  0x3C, 0x00, 0x00, 0x00,
  0x3C, 0x00, 0x00, 0x00,
  0x2D, 0x00, 0x01, 0x00,
  0x1E, 0x00, 0x1E, 0x00,
  0x0F, 0x90, 0x7D, 0x00,
  0x06, 0xFF, 0xF8, 0x00,
  0x00, 0x6F, 0x90, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0044[ 84] = { /* code 0044, LATIN CAPITAL LETTER D */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x3F, 0xFF, 0x90, 0x00,
  0x3F, 0xFF, 0xF4, 0x00,
  0x3C, 0x01, 0xBC, 0x00,
  0x3C, 0x00, 0x2E, 0x00,
  0x3C, 0x00, 0x1E, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x1E, 0x00,
  0x3C, 0x00, 0x2E, 0x00,
  0x3C, 0x01, 0xBC, 0x00,
  0x3F, 0xFF, 0xF4, 0x00,
  0x3F, 0xFE, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0045[ 63] = { /* code 0045, LATIN CAPITAL LETTER E */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3F, 0xFF, 0xFC,
  0x3F, 0xFF, 0xFC,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3F, 0xFF, 0xF0,
  0x3F, 0xFF, 0xF0,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3F, 0xFF, 0xFC,
  0x3F, 0xFF, 0xFC,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0046[ 63] = { /* code 0046, LATIN CAPITAL LETTER F */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3F, 0xFF, 0xF0,
  0x3F, 0xFF, 0xF0,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3F, 0xFF, 0xC0,
  0x3F, 0xFF, 0xC0,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0047[ 84] = { /* code 0047, LATIN CAPITAL LETTER G */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x6F, 0xE4, 0x00,
  0x02, 0xFF, 0xFE, 0x00,
  0x0B, 0x90, 0x1F, 0x40,
  0x1E, 0x00, 0x07, 0x80,
  0x2D, 0x00, 0x00, 0x00,
  0x3C, 0x00, 0x00, 0x00,
  0x3C, 0x03, 0xFF, 0xC0,
  0x3C, 0x03, 0xFF, 0xC0,
  0x2D, 0x00, 0x03, 0xC0,
  0x1E, 0x00, 0x03, 0xC0,
  0x0B, 0x90, 0x1B, 0xC0,
  0x02, 0xFF, 0xFF, 0x40,
  0x00, 0x6F, 0xE4, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0048[ 84] = { /* code 0048, LATIN CAPITAL LETTER H */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3F, 0xFF, 0xFF, 0x00,
  0x3F, 0xFF, 0xFF, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0049[ 21] = { /* code 0049, LATIN CAPITAL LETTER I */
  0x00,
  0x00,
  0x00,
  0x00,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_004A[ 63] = { /* code 004A, LATIN CAPITAL LETTER J */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x0F, 0x00,
  0x00, 0x0F, 0x00,
  0x00, 0x0F, 0x00,
  0x00, 0x0F, 0x00,
  0x00, 0x0F, 0x00,
  0x00, 0x0F, 0x00,
  0x00, 0x0F, 0x00,
  0x00, 0x0F, 0x00,
  0x00, 0x0F, 0x00,
  0x2C, 0x0F, 0x00,
  0x2D, 0x2E, 0x00,
  0x2F, 0xFE, 0x00,
  0x0B, 0xE8, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_004B[ 63] = { /* code 004B, LATIN CAPITAL LETTER K */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3C, 0x00, 0xBD,
  0x3C, 0x02, 0xF4,
  0x3C, 0x0B, 0xD0,
  0x3C, 0x2F, 0x40,
  0x3C, 0xB8, 0x00,
  0x3F, 0xF4, 0x00,
  0x3F, 0xFD, 0x00,
  0x3E, 0x2E, 0x00,
  0x3C, 0x1F, 0x80,
  0x3C, 0x07, 0xD0,
  0x3C, 0x02, 0xF4,
  0x3C, 0x00, 0xB8,
  0x3C, 0x00, 0x2E,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_004C[ 63] = { /* code 004C, LATIN CAPITAL LETTER L */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3F, 0xFF, 0xC0,
  0x3F, 0xFF, 0xC0,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_004D[ 84] = { /* code 004D, LATIN CAPITAL LETTER M */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x3A, 0x40, 0x06, 0xB0,
  0x3F, 0x80, 0x0B, 0xF0,
  0x3E, 0xC0, 0x0E, 0xF0,
  0x3E, 0xD0, 0x1E, 0xF0,
  0x3D, 0xE0, 0x2D, 0xF0,
  0x3C, 0xE0, 0x2C, 0xF0,
  0x3C, 0xB4, 0x78, 0xF0,
  0x3C, 0x78, 0xB4, 0xF0,
  0x3C, 0x38, 0xB0, 0xF0,
  0x3C, 0x2C, 0xE0, 0xF0,
  0x3C, 0x2E, 0xE0, 0xF0,
  0x3C, 0x1F, 0xD0, 0xF0,
  0x3C, 0x0F, 0xC0, 0xF0,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_004E[ 84] = { /* code 004E, LATIN CAPITAL LETTER N */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x3D, 0x00, 0x0F, 0x00,
  0x3F, 0x40, 0x0F, 0x00,
  0x3F, 0x80, 0x0F, 0x00,
  0x3E, 0xE0, 0x0F, 0x00,
  0x3C, 0xB4, 0x0F, 0x00,
  0x3C, 0x78, 0x0F, 0x00,
  0x3C, 0x2E, 0x0F, 0x00,
  0x3C, 0x0B, 0x4F, 0x00,
  0x3C, 0x07, 0x8F, 0x00,
  0x3C, 0x02, 0xEF, 0x00,
  0x3C, 0x00, 0xBF, 0x00,
  0x3C, 0x00, 0x7F, 0x00,
  0x3C, 0x00, 0x1F, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_004F[ 84] = { /* code 004F, LATIN CAPITAL LETTER O */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x6F, 0xA0, 0x00,
  0x02, 0xFF, 0xF9, 0x00,
  0x0B, 0x90, 0x6E, 0x00,
  0x1E, 0x00, 0x0B, 0x40,
  0x2D, 0x00, 0x07, 0x80,
  0x3C, 0x00, 0x03, 0xC0,
  0x3C, 0x00, 0x03, 0xC0,
  0x3C, 0x00, 0x03, 0xC0,
  0x2D, 0x00, 0x07, 0x80,
  0x1E, 0x00, 0x0B, 0x40,
  0x0B, 0x90, 0x6E, 0x00,
  0x06, 0xFF, 0xF9, 0x00,
  0x00, 0xAF, 0xA0, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0050[ 63] = { /* code 0050, LATIN CAPITAL LETTER P */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3F, 0xFF, 0x90,
  0x3F, 0xFF, 0xF4,
  0x3C, 0x00, 0xB8,
  0x3C, 0x00, 0x3C,
  0x3C, 0x00, 0x3C,
  0x3C, 0x00, 0xB8,
  0x3F, 0xFF, 0xF4,
  0x3F, 0xFF, 0x90,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0051[ 84] = { /* code 0051, LATIN CAPITAL LETTER Q */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0xAF, 0xA0, 0x00,
  0x06, 0xFF, 0xFD, 0x00,
  0x0B, 0x90, 0x6F, 0x00,
  0x1E, 0x00, 0x0B, 0x80,
  0x2D, 0x00, 0x07, 0x80,
  0x3C, 0x00, 0x03, 0xC0,
  0x3C, 0x00, 0x03, 0xC0,
  0x3C, 0x00, 0x03, 0x80,
  0x2D, 0x00, 0x07, 0x80,
  0x1E, 0x02, 0x9B, 0x00,
  0x0B, 0x91, 0xBD, 0x00,
  0x07, 0xFF, 0xFD, 0x00,
  0x00, 0xAF, 0x9B, 0x80,
  0x00, 0x00, 0x00, 0x40,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0052[ 84] = { /* code 0052, LATIN CAPITAL LETTER R */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x3F, 0xFF, 0xE4, 0x00,
  0x3F, 0xFF, 0xFD, 0x00,
  0x3C, 0x00, 0x2E, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x2E, 0x00,
  0x3F, 0xFF, 0xFD, 0x00,
  0x3F, 0xFF, 0xE4, 0x00,
  0x3C, 0x07, 0x80, 0x00,
  0x3C, 0x02, 0xE0, 0x00,
  0x3C, 0x00, 0xB8, 0x00,
  0x3C, 0x00, 0x7D, 0x00,
  0x3C, 0x00, 0x2E, 0x00,
  0x3C, 0x00, 0x0B, 0x80,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0053[ 63] = { /* code 0053, LATIN CAPITAL LETTER S */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x02, 0xBE, 0x80,
  0x1F, 0xFF, 0xF0,
  0x2E, 0x01, 0xB8,
  0x3C, 0x00, 0x3C,
  0x2D, 0x00, 0x00,
  0x1F, 0xA5, 0x00,
  0x02, 0xBF, 0x90,
  0x00, 0x1A, 0xB4,
  0x00, 0x00, 0x3C,
  0x3C, 0x00, 0x3C,
  0x2E, 0x40, 0xB8,
  0x0B, 0xFF, 0xF4,
  0x02, 0xBF, 0x80,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0054[ 63] = { /* code 0054, LATIN CAPITAL LETTER T */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3F, 0xFF, 0xFC,
  0x3F, 0xFF, 0xFC,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0055[ 84] = { /* code 0055, LATIN CAPITAL LETTER U */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x3C, 0x00, 0x0F, 0x00,
  0x2D, 0x00, 0x1E, 0x00,
  0x2F, 0x40, 0x7E, 0x00,
  0x0B, 0xFF, 0xF8, 0x00,
  0x01, 0xBF, 0x90, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0056[ 63] = { /* code 0056, LATIN CAPITAL LETTER V */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0xE0, 0x00, 0x2C,
  0xB4, 0x00, 0x78,
  0x78, 0x00, 0xB4,
  0x38, 0x00, 0xB0,
  0x2D, 0x01, 0xE0,
  0x1E, 0x02, 0xD0,
  0x0E, 0x02, 0xC0,
  0x0B, 0x47, 0x80,
  0x07, 0x8B, 0x40,
  0x03, 0x8B, 0x00,
  0x02, 0xDE, 0x00,
  0x01, 0xFD, 0x00,
  0x00, 0xFC, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0057[105] = { /* code 0057, LATIN CAPITAL LETTER W */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0xB0, 0x07, 0xF4, 0x03, 0x80,
  0xB4, 0x07, 0xF4, 0x07, 0x80,
  0x78, 0x0B, 0xB8, 0x0B, 0x40,
  0x78, 0x0B, 0x38, 0x0B, 0x40,
  0x3C, 0x0E, 0x2C, 0x0F, 0x00,
  0x2D, 0x1E, 0x2D, 0x1E, 0x00,
  0x2E, 0x2D, 0x1E, 0x2E, 0x00,
  0x1E, 0x2D, 0x1E, 0x2D, 0x00,
  0x0F, 0x3C, 0x0F, 0x3C, 0x00,
  0x0B, 0x78, 0x0B, 0x7C, 0x00,
  0x0B, 0xB8, 0x0B, 0xB8, 0x00,
  0x07, 0xF4, 0x07, 0xF8, 0x00,
  0x07, 0xF4, 0x03, 0xF4, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0058[ 63] = { /* code 0058, LATIN CAPITAL LETTER X */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x2E, 0x02, 0xE0,
  0x0F, 0x4B, 0xC0,
  0x0B, 0x8F, 0x80,
  0x02, 0xEE, 0x00,
  0x01, 0xFD, 0x00,
  0x00, 0xB8, 0x00,
  0x00, 0xFC, 0x00,
  0x02, 0xEE, 0x00,
  0x07, 0xDF, 0x40,
  0x0B, 0x8B, 0x80,
  0x2F, 0x03, 0xE0,
  0x3D, 0x01, 0xF0,
  0xB8, 0x00, 0xB8,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0059[ 63] = { /* code 0059, LATIN CAPITAL LETTER Y */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0xB8, 0x00, 0x2E,
  0x3D, 0x00, 0x7C,
  0x1F, 0x00, 0xF4,
  0x0B, 0x82, 0xE0,
  0x03, 0xD7, 0xC0,
  0x01, 0xEB, 0x40,
  0x00, 0xBE, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x3C, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_005A[ 63] = { /* code 005A, LATIN CAPITAL LETTER Z */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3F, 0xFF, 0xE0,
  0x3F, 0xFF, 0xE0,
  0x00, 0x03, 0xC0,
  0x00, 0x0B, 0x40,
  0x00, 0x2E, 0x00,
  0x00, 0x78, 0x00,
  0x00, 0xF0, 0x00,
  0x02, 0xD0, 0x00,
  0x0B, 0x80, 0x00,
  0x1E, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0xBF, 0xFF, 0xF0,
  0xBF, 0xFF, 0xF0,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_005B[ 42] = { /* code 005B, LEFT SQUARE BRACKET */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x3F, 0xC0,
  0x3F, 0xC0,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3F, 0xC0,
  0x3F, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_005C[ 42] = { /* code 005C, REVERSE SOLIDUS */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0xB0, 0x00,
  0xB4, 0x00,
  0x78, 0x00,
  0x3C, 0x00,
  0x2D, 0x00,
  0x1E, 0x00,
  0x0F, 0x00,
  0x0B, 0x40,
  0x07, 0x80,
  0x03, 0xC0,
  0x02, 0xC0,
  0x01, 0xC0,
  0x00, 0xC0,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_005D[ 42] = { /* code 005D, RIGHT SQUARE BRACKET */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0xFF, 0x00,
  0xFF, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_005E[ 42] = { /* code 005E, CIRCUMFLEX ACCENT */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x07, 0x40,
  0x0B, 0x80,
  0x0E, 0xC0,
  0x2C, 0xE0,
  0x38, 0xB0,
  0x74, 0x74,
  0xB0, 0x38,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_005F[ 63] = { /* code 005F, LOW LINE */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0060[ 42] = { /* code 0060, GRAVE ACCENT */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x2D, 0x00,
  0x0A, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0061[ 63] = { /* code 0061, LATIN SMALL LETTER A */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x06, 0xFE, 0x00,
  0x1F, 0xFF, 0x80,
  0x2D, 0x07, 0xC0,
  0x01, 0x6B, 0xC0,
  0x0B, 0xFF, 0xC0,
  0x2E, 0x97, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3D, 0x0B, 0xC0,
  0x2F, 0xFF, 0xC0,
  0x0B, 0xE7, 0xC0,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0062[ 63] = { /* code 0062, LATIN SMALL LETTER B */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0xB9, 0x00,
  0x3E, 0xFF, 0x00,
  0x3E, 0x0B, 0x80,
  0x3D, 0x07, 0x80,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3D, 0x07, 0x80,
  0x3E, 0x0B, 0x80,
  0x3E, 0xFF, 0x00,
  0x3C, 0xB9, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0063[ 63] = { /* code 0063, LATIN SMALL LETTER C */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x06, 0xF8, 0x00,
  0x0F, 0xFE, 0x00,
  0x2E, 0x1F, 0x00,
  0x2C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x2C, 0x00, 0x00,
  0x2E, 0x1F, 0x00,
  0x1F, 0xFE, 0x00,
  0x06, 0xF9, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0064[ 63] = { /* code 0064, LATIN SMALL LETTER D */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x03, 0xC0,
  0x00, 0x03, 0xC0,
  0x00, 0x03, 0xC0,
  0x06, 0xE3, 0xC0,
  0x0F, 0xFB, 0xC0,
  0x2E, 0x0B, 0xC0,
  0x2D, 0x07, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x2D, 0x07, 0xC0,
  0x2E, 0x0B, 0xC0,
  0x0F, 0xFB, 0xC0,
  0x06, 0xE3, 0xC0,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0065[ 63] = { /* code 0065, LATIN SMALL LETTER E */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x02, 0xF8, 0x00,
  0x0F, 0xFE, 0x00,
  0x2E, 0x0B, 0x80,
  0x2C, 0x03, 0x80,
  0x3F, 0xFF, 0xC0,
  0x3F, 0xFF, 0xC0,
  0x2C, 0x00, 0x00,
  0x2E, 0x07, 0x80,
  0x0F, 0xFF, 0x40,
  0x06, 0xF9, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0066[ 42] = { /* code 0066, LATIN SMALL LETTER F */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x1B, 0xC0,
  0x3F, 0xC0,
  0x3C, 0x00,
  0xFF, 0xC0,
  0xFF, 0xC0,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0067[ 63] = { /* code 0067, LATIN SMALL LETTER G */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x06, 0xE7, 0xC0,
  0x0F, 0xFF, 0xC0,
  0x2E, 0x0B, 0xC0,
  0x2D, 0x07, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x2D, 0x07, 0xC0,
  0x2E, 0x0B, 0xC0,
  0x0F, 0xFF, 0xC0,
  0x06, 0xE7, 0xC0,
  0x00, 0x03, 0xC0,
  0x3D, 0x0B, 0x80,
  0x2F, 0xFF, 0x40,
  0x0A, 0xF9, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0068[ 63] = { /* code 0068, LATIN SMALL LETTER H */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0xBE, 0x00,
  0x3E, 0xFF, 0x80,
  0x3E, 0x0B, 0xC0,
  0x3D, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0069[ 21] = { /* code 0069, LATIN SMALL LETTER I */
  0x00,
  0x00,
  0x00,
  0x00,
  0x3C,
  0x3C,
  0x00,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_006A[ 21] = { /* code 006A, LATIN SMALL LETTER J */
  0x00,
  0x00,
  0x00,
  0x00,
  0x3C,
  0x3C,
  0x00,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x7C,
  0xF8,
  0xE4
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_006B[ 63] = { /* code 006B, LATIN SMALL LETTER K */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x0B, 0x40,
  0x3C, 0x2E, 0x00,
  0x3C, 0xB8, 0x00,
  0x3E, 0xD0, 0x00,
  0x3F, 0xE0, 0x00,
  0x3E, 0xF4, 0x00,
  0x3C, 0x78, 0x00,
  0x3C, 0x2D, 0x00,
  0x3C, 0x1F, 0x00,
  0x3C, 0x0B, 0x80,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_006C[ 21] = { /* code 006C, LATIN SMALL LETTER L */
  0x00,
  0x00,
  0x00,
  0x00,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_006D[ 84] = { /* code 006D, LATIN SMALL LETTER M */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x3C, 0xB8, 0x6E, 0x00,
  0x3E, 0xFD, 0xBF, 0x80,
  0x3E, 0x1F, 0x87, 0xC0,
  0x3D, 0x0F, 0x03, 0xC0,
  0x3C, 0x0F, 0x03, 0xC0,
  0x3C, 0x0F, 0x03, 0xC0,
  0x3C, 0x0F, 0x03, 0xC0,
  0x3C, 0x0F, 0x03, 0xC0,
  0x3C, 0x0F, 0x03, 0xC0,
  0x3C, 0x0F, 0x03, 0xC0,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_006E[ 63] = { /* code 006E, LATIN SMALL LETTER N */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3D, 0xBE, 0x00,
  0x3F, 0xFF, 0x80,
  0x3E, 0x0B, 0xC0,
  0x3D, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_006F[ 63] = { /* code 006F, LATIN SMALL LETTER O */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x06, 0xF9, 0x00,
  0x0F, 0xFF, 0x00,
  0x2E, 0x0B, 0x80,
  0x2D, 0x07, 0x80,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x2D, 0x07, 0x80,
  0x2E, 0x0B, 0x80,
  0x0F, 0xFF, 0x00,
  0x06, 0xF9, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0070[ 63] = { /* code 0070, LATIN SMALL LETTER P */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3C, 0xB9, 0x00,
  0x3E, 0xFF, 0x00,
  0x3E, 0x0B, 0x80,
  0x3D, 0x07, 0x80,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3D, 0x07, 0x80,
  0x3E, 0x0B, 0x80,
  0x3E, 0xFF, 0x00,
  0x3D, 0xB9, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00,
  0x3C, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0071[ 63] = { /* code 0071, LATIN SMALL LETTER Q */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x06, 0xE3, 0xC0,
  0x0F, 0xFB, 0xC0,
  0x2E, 0x0B, 0xC0,
  0x2D, 0x07, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x2D, 0x07, 0xC0,
  0x2E, 0x0B, 0xC0,
  0x0F, 0xFB, 0xC0,
  0x06, 0xE7, 0xC0,
  0x00, 0x03, 0xC0,
  0x00, 0x03, 0xC0,
  0x00, 0x03, 0xC0,
  0x00, 0x03, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0072[ 42] = { /* code 0072, LATIN SMALL LETTER R */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x3D, 0xE0,
  0x3E, 0xE0,
  0x3E, 0x00,
  0x3D, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0073[ 63] = { /* code 0073, LATIN SMALL LETTER S */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x0B, 0xE8, 0x00,
  0x2F, 0xFE, 0x00,
  0x3D, 0x1F, 0x00,
  0x3E, 0x40, 0x00,
  0x1F, 0xE4, 0x00,
  0x01, 0xBD, 0x00,
  0x00, 0x2F, 0x00,
  0x3D, 0x1F, 0x00,
  0x2F, 0xFE, 0x00,
  0x0B, 0xF8, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0074[ 42] = { /* code 0074, LATIN SMALL LETTER T */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x2C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3C, 0x00,
  0x3F, 0x00,
  0x2F, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0075[ 63] = { /* code 0075, LATIN SMALL LETTER U */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x03, 0xC0,
  0x3C, 0x07, 0xC0,
  0x3D, 0x0B, 0xC0,
  0x2F, 0xFB, 0xC0,
  0x0B, 0xE3, 0xC0,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0076[ 63] = { /* code 0076, LATIN SMALL LETTER V */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0xE0, 0x02, 0xC0,
  0xB4, 0x07, 0x80,
  0x78, 0x0B, 0x40,
  0x2C, 0x0F, 0x00,
  0x2D, 0x1E, 0x00,
  0x0E, 0x2C, 0x00,
  0x0B, 0x78, 0x00,
  0x07, 0xF4, 0x00,
  0x02, 0xE0, 0x00,
  0x02, 0xD0, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0077[ 84] = { /* code 0077, LATIN SMALL LETTER W */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0xE0, 0x1D, 0x02, 0xC0,
  0xF0, 0x2E, 0x03, 0xC0,
  0xB4, 0x3F, 0x07, 0x80,
  0x78, 0x7B, 0x4B, 0x40,
  0x38, 0xB3, 0x8B, 0x00,
  0x2C, 0xE2, 0xCE, 0x00,
  0x1E, 0xD1, 0xED, 0x00,
  0x0F, 0xD0, 0xFC, 0x00,
  0x0B, 0x80, 0xB8, 0x00,
  0x07, 0x80, 0xB4, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0078[ 42] = { /* code 0078, LATIN SMALL LETTER X */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0xB4, 0x1E,
  0x38, 0x2D,
  0x2D, 0x78,
  0x0F, 0xF0,
  0x07, 0xD0,
  0x07, 0xD0,
  0x0E, 0xB0,
  0x2D, 0x78,
  0x38, 0x2C,
  0xB4, 0x1E,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_0079[ 63] = { /* code 0079, LATIN SMALL LETTER Y */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0xE0, 0x03, 0x80,
  0xB4, 0x07, 0x80,
  0x78, 0x0B, 0x40,
  0x2D, 0x0F, 0x00,
  0x1E, 0x1E, 0x00,
  0x0B, 0x6D, 0x00,
  0x07, 0xBC, 0x00,
  0x02, 0xF8, 0x00,
  0x01, 0xF4, 0x00,
  0x00, 0xF4, 0x00,
  0x01, 0xE0, 0x00,
  0x02, 0xD0, 0x00,
  0x3F, 0x80, 0x00,
  0x3E, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_007A[ 42] = { /* code 007A, LATIN SMALL LETTER Z */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0xFF, 0xFF,
  0xFF, 0xFF,
  0x00, 0x2E,
  0x00, 0xB8,
  0x02, 0xE0,
  0x1F, 0x80,
  0x7E, 0x00,
  0xF8, 0x00,
  0xFF, 0xFF,
  0xFF, 0xFF,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_007B[ 42] = { /* code 007B, LEFT CURLY BRACKET */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x06, 0xF0,
  0x0B, 0xF0,
  0x0F, 0x40,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x2E, 0x00,
  0xF8, 0x00,
  0xF8, 0x00,
  0x2E, 0x00,
  0x0E, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x40,
  0x0B, 0xF0,
  0x02, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_007C[ 42] = { /* code 007C, VERTICAL LINE */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_007D[ 42] = { /* code 007D, RIGHT CURLY BRACKET */
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0xF9, 0x00,
  0xFE, 0x00,
  0x1F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0B, 0x80,
  0x02, 0xF0,
  0x02, 0xF0,
  0x0B, 0x80,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x1F, 0x00,
  0xFE, 0x00,
  0xF8, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontAA2_21_007E[ 63] = { /* code 007E, TILDE */
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x2E, 0x80, 0x10,
  0xBF, 0xE4, 0x70,
  0xD1, 0xBF, 0xE0,
  0x40, 0x1B, 0x80,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO GUI_FontAA2_21_CharInfo[95] = {
   {   5,   5,  2, acGUI_FontAA2_21_0020 } /* code 0020 */
  ,{   6,   6,  2, acGUI_FontAA2_21_0021 } /* code 0021 */
  ,{   6,   6,  2, acGUI_FontAA2_21_0022 } /* code 0022 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0023 } /* code 0023 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0024 } /* code 0024 */
  ,{  16,  16,  4, acGUI_FontAA2_21_0025 } /* code 0025 */
  ,{  12,  12,  3, acGUI_FontAA2_21_0026 } /* code 0026 */
  ,{   3,   3,  1, acGUI_FontAA2_21_0027 } /* code 0027 */
  ,{   6,   6,  2, acGUI_FontAA2_21_0028 } /* code 0028 */
  ,{   6,   6,  2, acGUI_FontAA2_21_0029 } /* code 0029 */
  ,{   7,   7,  2, acGUI_FontAA2_21_002A } /* code 002A */
  ,{  11,  11,  3, acGUI_FontAA2_21_002B } /* code 002B */
  ,{   5,   5,  2, acGUI_FontAA2_21_002C } /* code 002C */
  ,{   6,   6,  2, acGUI_FontAA2_21_002D } /* code 002D */
  ,{   5,   5,  2, acGUI_FontAA2_21_002E } /* code 002E */
  ,{   5,   5,  2, acGUI_FontAA2_21_002F } /* code 002F */
  ,{  10,  10,  3, acGUI_FontAA2_21_0030 } /* code 0030 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0031 } /* code 0031 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0032 } /* code 0032 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0033 } /* code 0033 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0034 } /* code 0034 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0035 } /* code 0035 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0036 } /* code 0036 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0037 } /* code 0037 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0038 } /* code 0038 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0039 } /* code 0039 */
  ,{   5,   5,  2, acGUI_FontAA2_21_003A } /* code 003A */
  ,{   5,   5,  2, acGUI_FontAA2_21_003B } /* code 003B */
  ,{  11,  11,  3, acGUI_FontAA2_21_003C } /* code 003C */
  ,{  11,  11,  3, acGUI_FontAA2_21_003D } /* code 003D */
  ,{  11,  11,  3, acGUI_FontAA2_21_003E } /* code 003E */
  ,{  10,  10,  3, acGUI_FontAA2_21_003F } /* code 003F */
  ,{  18,  18,  5, acGUI_FontAA2_21_0040 } /* code 0040 */
  ,{  11,  11,  3, acGUI_FontAA2_21_0041 } /* code 0041 */
  ,{  12,  12,  3, acGUI_FontAA2_21_0042 } /* code 0042 */
  ,{  13,  13,  4, acGUI_FontAA2_21_0043 } /* code 0043 */
  ,{  13,  13,  4, acGUI_FontAA2_21_0044 } /* code 0044 */
  ,{  12,  12,  3, acGUI_FontAA2_21_0045 } /* code 0045 */
  ,{  11,  11,  3, acGUI_FontAA2_21_0046 } /* code 0046 */
  ,{  14,  14,  4, acGUI_FontAA2_21_0047 } /* code 0047 */
  ,{  13,  13,  4, acGUI_FontAA2_21_0048 } /* code 0048 */
  ,{   4,   4,  1, acGUI_FontAA2_21_0049 } /* code 0049 */
  ,{   9,   9,  3, acGUI_FontAA2_21_004A } /* code 004A */
  ,{  12,  12,  3, acGUI_FontAA2_21_004B } /* code 004B */
  ,{  10,  10,  3, acGUI_FontAA2_21_004C } /* code 004C */
  ,{  15,  15,  4, acGUI_FontAA2_21_004D } /* code 004D */
  ,{  13,  13,  4, acGUI_FontAA2_21_004E } /* code 004E */
  ,{  14,  14,  4, acGUI_FontAA2_21_004F } /* code 004F */
  ,{  12,  12,  3, acGUI_FontAA2_21_0050 } /* code 0050 */
  ,{  14,  14,  4, acGUI_FontAA2_21_0051 } /* code 0051 */
  ,{  13,  13,  4, acGUI_FontAA2_21_0052 } /* code 0052 */
  ,{  12,  12,  3, acGUI_FontAA2_21_0053 } /* code 0053 */
  ,{  12,  12,  3, acGUI_FontAA2_21_0054 } /* code 0054 */
  ,{  13,  13,  4, acGUI_FontAA2_21_0055 } /* code 0055 */
  ,{  11,  11,  3, acGUI_FontAA2_21_0056 } /* code 0056 */
  ,{  17,  17,  5, acGUI_FontAA2_21_0057 } /* code 0057 */
  ,{  11,  11,  3, acGUI_FontAA2_21_0058 } /* code 0058 */
  ,{  12,  12,  3, acGUI_FontAA2_21_0059 } /* code 0059 */
  ,{  11,  11,  3, acGUI_FontAA2_21_005A } /* code 005A */
  ,{   5,   5,  2, acGUI_FontAA2_21_005B } /* code 005B */
  ,{   5,   5,  2, acGUI_FontAA2_21_005C } /* code 005C */
  ,{   5,   5,  2, acGUI_FontAA2_21_005D } /* code 005D */
  ,{   7,   7,  2, acGUI_FontAA2_21_005E } /* code 005E */
  ,{  10,  10,  3, acGUI_FontAA2_21_005F } /* code 005F */
  ,{   6,   6,  2, acGUI_FontAA2_21_0060 } /* code 0060 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0061 } /* code 0061 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0062 } /* code 0062 */
  ,{   9,   9,  3, acGUI_FontAA2_21_0063 } /* code 0063 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0064 } /* code 0064 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0065 } /* code 0065 */
  ,{   5,   5,  2, acGUI_FontAA2_21_0066 } /* code 0066 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0067 } /* code 0067 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0068 } /* code 0068 */
  ,{   4,   4,  1, acGUI_FontAA2_21_0069 } /* code 0069 */
  ,{   4,   4,  1, acGUI_FontAA2_21_006A } /* code 006A */
  ,{   9,   9,  3, acGUI_FontAA2_21_006B } /* code 006B */
  ,{   4,   4,  1, acGUI_FontAA2_21_006C } /* code 006C */
  ,{  14,  14,  4, acGUI_FontAA2_21_006D } /* code 006D */
  ,{  10,  10,  3, acGUI_FontAA2_21_006E } /* code 006E */
  ,{  10,  10,  3, acGUI_FontAA2_21_006F } /* code 006F */
  ,{  10,  10,  3, acGUI_FontAA2_21_0070 } /* code 0070 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0071 } /* code 0071 */
  ,{   6,   6,  2, acGUI_FontAA2_21_0072 } /* code 0072 */
  ,{   9,   9,  3, acGUI_FontAA2_21_0073 } /* code 0073 */
  ,{   5,   5,  2, acGUI_FontAA2_21_0074 } /* code 0074 */
  ,{  10,  10,  3, acGUI_FontAA2_21_0075 } /* code 0075 */
  ,{   9,   9,  3, acGUI_FontAA2_21_0076 } /* code 0076 */
  ,{  13,  13,  4, acGUI_FontAA2_21_0077 } /* code 0077 */
  ,{   8,   8,  2, acGUI_FontAA2_21_0078 } /* code 0078 */
  ,{   9,   9,  3, acGUI_FontAA2_21_0079 } /* code 0079 */
  ,{   8,   8,  2, acGUI_FontAA2_21_007A } /* code 007A */
  ,{   6,   6,  2, acGUI_FontAA2_21_007B } /* code 007B */
  ,{   6,   6,  2, acGUI_FontAA2_21_007C } /* code 007C */
  ,{   6,   6,  2, acGUI_FontAA2_21_007D } /* code 007D */
  ,{  11,  11,  3, acGUI_FontAA2_21_007E } /* code 007E */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontAA2_21_Prop1 = {
   0x0020 /* first character */
  ,0x007E /* last character  */
  ,&GUI_FontAA2_21_CharInfo[  0] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP *)0 /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_FontAA2_21 = {
   GUI_FONTTYPE_PROP_AA2 /* type of font    */
  ,21 /* height of font  */
  ,21 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_FontAA2_21_Prop1}
  ,17 /* Baseline */
  ,10 /* Height of lowercase characters */
  ,13 /* Height of capital characters */
};

