/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2014  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.24 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software has been licensed to  ARM LIMITED whose registered office
is situated at  110 Fulbourn Road,  Cambridge CB1 9NJ,  England solely
for  the  purposes  of  creating  libraries  for  ARM7, ARM9, Cortex-M
series,  and   Cortex-R4   processor-based  devices,  sublicensed  and
distributed as part of the  MDK-ARM  Professional  under the terms and
conditions  of  the   End  User  License  supplied  with  the  MDK-ARM
Professional. 
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
File        : F24B_AA.c
Content     : Font (AA4), Height 24
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI.H"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/* The following line needs to be included in any file selecting the
   font. A good place would be GUIConf.H
*/
extern GUI_CONST_STORAGE GUI_FONT GUI_FontF24B_AA;

/* Start of unicode area <Basic Latin> */
GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0020[  1] = { /* code 0020, SPACE */
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0021[ 30] = { /* code 0021, EXCLAMATION MARK */
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xDF, 0xD0,
  0xCF, 0xC0,
  0xBF, 0xB0,
  0x9F, 0x90,
  0x7F, 0x80,
  0x6F, 0x70,
  0x5F, 0x50,
  0x00, 0x00,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0022[ 20] = { /* code 0022, QUOTATION MARK */
  0xFF, 0xF0, 0xFF, 0xF0,
  0xFF, 0xF0, 0xFF, 0xF0,
  0xFF, 0xF0, 0xFF, 0xF0,
  0xCF, 0xC0, 0xCF, 0xC0,
  0x9F, 0x90, 0x9F, 0x90
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0023[ 90] = { /* code 0023, NUMBER SIGN */
  0x00, 0x01, 0xFE, 0x01, 0xFE, 0x00,
  0x00, 0x04, 0xFB, 0x04, 0xFB, 0x00,
  0x00, 0x07, 0xF8, 0x07, 0xF8, 0x00,
  0x00, 0x0A, 0xF5, 0x0A, 0xF5, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x5F, 0xB0, 0x5F, 0xB0, 0x00,
  0x00, 0x7F, 0x80, 0x7F, 0x80, 0x00,
  0x00, 0xAF, 0x50, 0xAF, 0x50, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x05, 0xFB, 0x05, 0xFB, 0x00, 0x00,
  0x08, 0xF8, 0x08, 0xF8, 0x00, 0x00,
  0x0B, 0xF5, 0x0B, 0xF5, 0x00, 0x00,
  0x0E, 0xF2, 0x0E, 0xF2, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0024[ 90] = { /* code 0024, DOLLAR SIGN */
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x02, 0xAE, 0xFE, 0x91, 0x00,
  0x2E, 0xFF, 0xFF, 0xFD, 0x10,
  0xAF, 0xF6, 0xF7, 0xFF, 0x80,
  0xEF, 0xF0, 0xF0, 0xFF, 0xE0,
  0xFF, 0xF1, 0xF0, 0x00, 0x00,
  0xBF, 0xFB, 0xF0, 0x00, 0x00,
  0x4F, 0xFF, 0xFB, 0x60, 0x00,
  0x06, 0xEF, 0xFF, 0xFD, 0x20,
  0x00, 0x17, 0xFF, 0xFF, 0xA0,
  0x00, 0x00, 0xF4, 0xFF, 0xE0,
  0x00, 0x00, 0xF0, 0xFF, 0xF0,
  0xEF, 0xF1, 0xF0, 0xFF, 0xE0,
  0x9F, 0xF7, 0xF3, 0xFF, 0x90,
  0x2E, 0xFF, 0xFF, 0xFE, 0x20,
  0x02, 0xAE, 0xFE, 0x92, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0025[128] = { /* code 0025, PERCENT SIGN */
  0x09, 0xEE, 0x90, 0x00, 0x02, 0xFD, 0x00, 0x00,
  0x7F, 0xFF, 0xF7, 0x00, 0x08, 0xF7, 0x00, 0x00,
  0xDF, 0x44, 0xFD, 0x00, 0x1E, 0xE1, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x7F, 0x80, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0xDF, 0x20, 0x00, 0x00,
  0xDF, 0x44, 0xFD, 0x05, 0xFA, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0xF7, 0x0B, 0xF4, 0x00, 0x00, 0x00,
  0x09, 0xEE, 0x90, 0x3F, 0xC0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xAF, 0x60, 0x9E, 0xE9, 0x00,
  0x00, 0x00, 0x01, 0xFE, 0x07, 0xFF, 0xFF, 0x70,
  0x00, 0x00, 0x08, 0xF7, 0x0D, 0xF4, 0x4F, 0xD0,
  0x00, 0x00, 0x0E, 0xF1, 0x0F, 0xF0, 0x0F, 0xF0,
  0x00, 0x00, 0x6F, 0x90, 0x0F, 0xF0, 0x0F, 0xF0,
  0x00, 0x00, 0xCF, 0x30, 0x0D, 0xF4, 0x4F, 0xD0,
  0x00, 0x04, 0xFB, 0x00, 0x07, 0xFF, 0xFF, 0x70,
  0x00, 0x0B, 0xF4, 0x00, 0x00, 0x9E, 0xE9, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0026[105] = { /* code 0026, AMPERSAND */
  0x00, 0x06, 0xCF, 0xFC, 0x50, 0x00, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xF6, 0x00, 0x00,
  0x00, 0xEF, 0xF3, 0x4F, 0xFD, 0x00, 0x00,
  0x00, 0xFF, 0xF1, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0xBF, 0xF7, 0x7F, 0xFB, 0x00, 0x00,
  0x00, 0x3F, 0xFF, 0xFF, 0xD1, 0x00, 0x00,
  0x00, 0x1B, 0xFF, 0xFA, 0x10, 0x00, 0x00,
  0x04, 0xEF, 0xFF, 0xFB, 0x00, 0x00, 0x00,
  0x3F, 0xFF, 0xAE, 0xFF, 0x63, 0xD9, 0x00,
  0xBF, 0xF8, 0x06, 0xFF, 0xFC, 0xFD, 0x00,
  0xFF, 0xF1, 0x00, 0xBF, 0xFF, 0xF8, 0x00,
  0xEF, 0xF1, 0x00, 0x2E, 0xFF, 0xF3, 0x00,
  0x9F, 0xF9, 0x11, 0x8F, 0xFF, 0xFD, 0x30,
  0x1D, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xB0,
  0x01, 0x7C, 0xFF, 0xEA, 0x30, 0x7C, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0027[ 10] = { /* code 0027, APOSTROPHE */
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xCF, 0xC0,
  0x9F, 0x90
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0028[ 57] = { /* code 0028, LEFT PARENTHESIS */
  0x00, 0x5F, 0xC0,
  0x00, 0xDF, 0x70,
  0x06, 0xFF, 0x20,
  0x0D, 0xFC, 0x00,
  0x3F, 0xF8, 0x00,
  0x7F, 0xF5, 0x00,
  0xBF, 0xF3, 0x00,
  0xDF, 0xF1, 0x00,
  0xFF, 0xF0, 0x00,
  0xFF, 0xF0, 0x00,
  0xFF, 0xF0, 0x00,
  0xDF, 0xF2, 0x00,
  0xAF, 0xF3, 0x00,
  0x7F, 0xF5, 0x00,
  0x2F, 0xF8, 0x00,
  0x0C, 0xFC, 0x00,
  0x06, 0xFF, 0x10,
  0x00, 0xDF, 0x70,
  0x00, 0x5F, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0029[ 57] = { /* code 0029, RIGHT PARENTHESIS */
  0xCF, 0x50, 0x00,
  0x7F, 0xD0, 0x00,
  0x2F, 0xF6, 0x00,
  0x0C, 0xFD, 0x00,
  0x08, 0xFF, 0x30,
  0x05, 0xFF, 0x70,
  0x03, 0xFF, 0xB0,
  0x01, 0xFF, 0xD0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xE0,
  0x01, 0xFF, 0xD0,
  0x03, 0xFF, 0xA0,
  0x05, 0xFF, 0x70,
  0x08, 0xFF, 0x20,
  0x0C, 0xFC, 0x00,
  0x1F, 0xF6, 0x00,
  0x6F, 0xD0, 0x00,
  0xCF, 0x50, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_002A[ 32] = { /* code 002A, ASTERISK */
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0E, 0xD0, 0x00,
  0x99, 0x3C, 0xC3, 0xA9,
  0xDF, 0xFF, 0xFF, 0xFD,
  0x25, 0xAF, 0xFB, 0x52,
  0x02, 0xEE, 0xEE, 0x20,
  0x0C, 0xF6, 0x6F, 0xC0,
  0x02, 0xB0, 0x0A, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_002B[ 66] = { /* code 002B, PLUS SIGN */
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_002C[ 12] = { /* code 002C, COMMA */
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0x01, 0xD0,
  0x2B, 0x80,
  0xA9, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_002D[  9] = { /* code 002D, HYPHEN-MINUS */
  0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_002E[  6] = { /* code 002E, FULL STOP */
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_002F[ 45] = { /* code 002F, SOLIDUS */
  0x00, 0x03, 0xFD,
  0x00, 0x07, 0xF9,
  0x00, 0x0B, 0xF5,
  0x00, 0x0E, 0xF1,
  0x00, 0x4F, 0xC0,
  0x00, 0x8F, 0x80,
  0x00, 0xCF, 0x40,
  0x01, 0xFF, 0x00,
  0x05, 0xFB, 0x00,
  0x09, 0xF7, 0x00,
  0x0D, 0xF3, 0x00,
  0x2F, 0xE0, 0x00,
  0x6F, 0xA0, 0x00,
  0xAF, 0x60, 0x00,
  0xEF, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0030[ 80] = { /* code 0030, DIGIT ZERO */
  0x00, 0x7D, 0xFD, 0x70, 0x00,
  0x09, 0xFF, 0xFF, 0xF9, 0x00,
  0x3F, 0xFA, 0x0A, 0xFF, 0x30,
  0x8F, 0xF4, 0x04, 0xFF, 0x80,
  0xCF, 0xF2, 0x02, 0xFF, 0xC0,
  0xEF, 0xF0, 0x00, 0xFF, 0xD0,
  0xFF, 0xF0, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0xFF, 0xF0,
  0xEF, 0xF0, 0x00, 0xFF, 0xD0,
  0xCF, 0xF2, 0x02, 0xFF, 0xC0,
  0x9F, 0xF4, 0x04, 0xFF, 0x80,
  0x3F, 0xFA, 0x0A, 0xFF, 0x30,
  0x0A, 0xFF, 0xFF, 0xF9, 0x00,
  0x00, 0x8E, 0xFD, 0x70, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0031[ 60] = { /* code 0031, DIGIT ONE */
  0x00, 0x00, 0xAF, 0xF0,
  0x00, 0x05, 0xFF, 0xF0,
  0x00, 0x6F, 0xFF, 0xF0,
  0x3B, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFD, 0xFF, 0xF0,
  0xFF, 0xB1, 0xFF, 0xF0,
  0xC5, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0032[ 75] = { /* code 0032, DIGIT TWO */
  0x02, 0xAE, 0xFE, 0xA2, 0x00,
  0x3E, 0xFF, 0xFF, 0xFE, 0x20,
  0xBF, 0xF7, 0x07, 0xFF, 0x90,
  0xBD, 0xF1, 0x01, 0xFF, 0xE0,
  0x00, 0x00, 0x01, 0xFF, 0xF0,
  0x00, 0x00, 0x05, 0xFF, 0xC0,
  0x00, 0x00, 0x1D, 0xFF, 0x60,
  0x00, 0x00, 0xBF, 0xFD, 0x00,
  0x00, 0x09, 0xFF, 0xF4, 0x00,
  0x00, 0x6F, 0xFF, 0x50, 0x00,
  0x03, 0xFF, 0xF7, 0x00, 0x00,
  0x0D, 0xFF, 0x80, 0x00, 0x00,
  0x5F, 0xF9, 0x00, 0x00, 0x00,
  0xBF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xEF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0033[ 75] = { /* code 0033, DIGIT THREE */
  0x02, 0x9E, 0xFE, 0xA2, 0x00,
  0x2E, 0xFF, 0xFF, 0xFE, 0x20,
  0xAF, 0xF8, 0x07, 0xFF, 0xB0,
  0x9C, 0xE1, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x02, 0xFF, 0xE0,
  0x00, 0x00, 0x2B, 0xFF, 0x70,
  0x00, 0x0B, 0xFF, 0xF7, 0x00,
  0x00, 0x0E, 0xFF, 0xFA, 0x10,
  0x00, 0x01, 0x1A, 0xFF, 0x80,
  0x00, 0x00, 0x02, 0xFF, 0xE0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xBD, 0xE1, 0x01, 0xFF, 0xD0,
  0xAF, 0xF7, 0x06, 0xFF, 0x70,
  0x2E, 0xFF, 0xFF, 0xFB, 0x10,
  0x02, 0x9E, 0xFD, 0x81, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0034[ 90] = { /* code 0034, DIGIT FOUR */
  0x00, 0x00, 0x01, 0xDF, 0xF0, 0x00,
  0x00, 0x00, 0x08, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x3F, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0xCF, 0xFF, 0xF0, 0x00,
  0x00, 0x07, 0xFB, 0xFF, 0xF0, 0x00,
  0x00, 0x2F, 0xE2, 0xFF, 0xF0, 0x00,
  0x00, 0xBF, 0x60, 0xFF, 0xF0, 0x00,
  0x06, 0xFB, 0x00, 0xFF, 0xF0, 0x00,
  0x1E, 0xE2, 0x00, 0xFF, 0xF0, 0x00,
  0xAF, 0x60, 0x00, 0xFF, 0xF0, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0035[ 75] = { /* code 0035, DIGIT FIVE */
  0x02, 0xFF, 0xFF, 0xFF, 0x00,
  0x06, 0xFF, 0xFF, 0xFF, 0x00,
  0x0A, 0xFF, 0x60, 0x00, 0x00,
  0x0E, 0xFF, 0x30, 0x00, 0x00,
  0x2F, 0xFE, 0x00, 0x00, 0x00,
  0x7F, 0xFE, 0xDF, 0xB2, 0x00,
  0xAF, 0xFF, 0xFF, 0xFE, 0x20,
  0xAD, 0xE4, 0x0A, 0xFF, 0x90,
  0x00, 0x00, 0x02, 0xFF, 0xD0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xBD, 0xE1, 0x03, 0xFF, 0xB0,
  0xAF, 0xF9, 0x0A, 0xFF, 0x60,
  0x2E, 0xFF, 0xFF, 0xFA, 0x00,
  0x02, 0xAE, 0xFD, 0x70, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0036[ 75] = { /* code 0036, DIGIT SIX */
  0x00, 0x6C, 0xFF, 0xC5, 0x00,
  0x0A, 0xFF, 0xFF, 0xFF, 0x50,
  0x4F, 0xFA, 0x0A, 0xFF, 0xC0,
  0x9F, 0xF2, 0x03, 0xD9, 0x40,
  0xCF, 0xE0, 0x00, 0x00, 0x00,
  0xEF, 0xC7, 0xEF, 0xA2, 0x00,
  0xFF, 0xFF, 0xFF, 0xFD, 0x10,
  0xFF, 0xF9, 0x09, 0xFF, 0x80,
  0xFF, 0xF2, 0x03, 0xFF, 0xD0,
  0xEF, 0xF0, 0x00, 0xFF, 0xF0,
  0xCF, 0xF0, 0x00, 0xFF, 0xF0,
  0x9F, 0xF3, 0x02, 0xFF, 0xC0,
  0x3F, 0xFB, 0x09, 0xFF, 0x70,
  0x08, 0xFF, 0xFF, 0xFB, 0x00,
  0x00, 0x6D, 0xFC, 0x70, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0037[ 75] = { /* code 0037, DIGIT SEVEN */
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x01, 0xDF, 0x90,
  0x00, 0x00, 0x1C, 0xFC, 0x00,
  0x00, 0x00, 0xAF, 0xF2, 0x00,
  0x00, 0x05, 0xFF, 0x80, 0x00,
  0x00, 0x0D, 0xFF, 0x10, 0x00,
  0x00, 0x5F, 0xF9, 0x00, 0x00,
  0x00, 0xBF, 0xF3, 0x00, 0x00,
  0x01, 0xFF, 0xD0, 0x00, 0x00,
  0x06, 0xFF, 0x90, 0x00, 0x00,
  0x09, 0xFF, 0x60, 0x00, 0x00,
  0x0C, 0xFF, 0x30, 0x00, 0x00,
  0x0D, 0xFF, 0x10, 0x00, 0x00,
  0x0F, 0xFF, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0038[ 75] = { /* code 0038, DIGIT EIGHT */
  0x03, 0xAE, 0xFE, 0xA3, 0x00,
  0x3E, 0xFF, 0xFF, 0xFE, 0x30,
  0xBF, 0xF8, 0x07, 0xFF, 0xB0,
  0xFF, 0xF1, 0x01, 0xFF, 0xF0,
  0xEF, 0xF2, 0x01, 0xFF, 0xE0,
  0x7F, 0xF9, 0x08, 0xFF, 0x70,
  0x06, 0xDF, 0xFF, 0xD6, 0x00,
  0x07, 0xFF, 0xFF, 0xE7, 0x00,
  0x6F, 0xF9, 0x09, 0xFF, 0x60,
  0xDF, 0xF2, 0x01, 0xFF, 0xD0,
  0xFF, 0xF0, 0x00, 0xFF, 0xF0,
  0xEF, 0xF2, 0x02, 0xFF, 0xE0,
  0x9F, 0xF9, 0x09, 0xFF, 0x90,
  0x1E, 0xFF, 0xFF, 0xFE, 0x20,
  0x01, 0x9D, 0xFE, 0x92, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0039[ 75] = { /* code 0039, DIGIT NINE */
  0x00, 0x5B, 0xFD, 0x60, 0x00,
  0x0A, 0xFF, 0xFF, 0xF8, 0x00,
  0x6F, 0xF9, 0x0B, 0xFF, 0x30,
  0xCF, 0xF2, 0x03, 0xFF, 0x80,
  0xFF, 0xF0, 0x00, 0xFF, 0xC0,
  0xFF, 0xF0, 0x00, 0xFF, 0xE0,
  0xDF, 0xF3, 0x02, 0xFF, 0xF0,
  0x8F, 0xF9, 0x09, 0xFF, 0xF0,
  0x1D, 0xFF, 0xFF, 0xFF, 0xF0,
  0x02, 0xBF, 0xE7, 0xCF, 0xD0,
  0x00, 0x00, 0x00, 0xEF, 0xC0,
  0x69, 0xD1, 0x02, 0xFF, 0x80,
  0xCF, 0xF9, 0x1A, 0xFF, 0x30,
  0x4F, 0xFF, 0xFF, 0xF8, 0x00,
  0x04, 0xBF, 0xFB, 0x50, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_003A[ 22] = { /* code 003A, COLON */
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_003B[ 28] = { /* code 003B, SEMICOLON */
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0x01, 0xD0,
  0x2B, 0x80,
  0xA9, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_003C[ 55] = { /* code 003C, LESS-THAN SIGN */
  0x00, 0x00, 0x00, 0x00, 0x5C,
  0x00, 0x00, 0x01, 0x7E, 0xFF,
  0x00, 0x03, 0xAF, 0xFF, 0xFF,
  0x05, 0xCF, 0xFF, 0xFC, 0x72,
  0xEF, 0xFF, 0xC7, 0x20, 0x00,
  0xFF, 0xE5, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0xD8, 0x30, 0x00,
  0x05, 0xBF, 0xFF, 0xFD, 0x83,
  0x00, 0x03, 0xAF, 0xFF, 0xFF,
  0x00, 0x00, 0x01, 0x7E, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x5C
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_003D[ 40] = { /* code 003D, EQUALS SIGN */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_003E[ 55] = { /* code 003E, GREATER-THAN SIGN */
  0xC5, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xE7, 0x10, 0x00, 0x00,
  0xFF, 0xFF, 0xFA, 0x30, 0x00,
  0x27, 0xCF, 0xFF, 0xFC, 0x50,
  0x00, 0x02, 0x7C, 0xFF, 0xFE,
  0x00, 0x00, 0x00, 0x5E, 0xFF,
  0x00, 0x03, 0x8D, 0xFF, 0xFD,
  0x38, 0xDF, 0xFF, 0xFB, 0x50,
  0xFF, 0xFF, 0xF9, 0x30, 0x00,
  0xFF, 0xE7, 0x10, 0x00, 0x00,
  0xC5, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_003F[ 75] = { /* code 003F, QUESTION MARK */
  0x01, 0x7C, 0xFF, 0xC7, 0x10,
  0x1C, 0xFF, 0xFF, 0xFF, 0xC1,
  0x9F, 0xFB, 0x21, 0xAF, 0xF9,
  0xEF, 0xF2, 0x00, 0x1F, 0xFE,
  0x00, 0x00, 0x00, 0x1F, 0xFF,
  0x00, 0x00, 0x00, 0xAF, 0xFB,
  0x00, 0x00, 0x1C, 0xFF, 0xE2,
  0x00, 0x01, 0xDF, 0xFE, 0x20,
  0x00, 0x0A, 0xFF, 0xD2, 0x00,
  0x00, 0x0E, 0xFF, 0x30, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0040[200] = { /* code 0040, COMMERCIAL AT */
  0x00, 0x00, 0x02, 0x7B, 0xEF, 0xFD, 0xA4, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC2, 0x00, 0x00,
  0x00, 0x1C, 0xFF, 0xA4, 0x10, 0x03, 0x7E, 0xFE, 0x20, 0x00,
  0x00, 0xBF, 0xD3, 0x00, 0x00, 0x00, 0x01, 0xBF, 0xC0, 0x00,
  0x06, 0xFE, 0x10, 0x5D, 0xF9, 0x3F, 0xF9, 0x1D, 0xF5, 0x00,
  0x0E, 0xF5, 0x05, 0xFF, 0xFF, 0xAF, 0xF6, 0x06, 0xFA, 0x00,
  0x5F, 0xC0, 0x1E, 0xFF, 0xFF, 0xFF, 0xF3, 0x02, 0xFE, 0x00,
  0x9F, 0x70, 0x6F, 0xFC, 0x15, 0xFF, 0xE0, 0x00, 0xFF, 0x00,
  0xCF, 0x30, 0xBF, 0xF5, 0x00, 0xFF, 0xB0, 0x01, 0xFF, 0x00,
  0xFF, 0x10, 0xEF, 0xF1, 0x01, 0xFF, 0x80, 0x04, 0xFC, 0x00,
  0xFF, 0x00, 0xFF, 0xF0, 0x05, 0xFF, 0x50, 0x0B, 0xF7, 0x00,
  0xFF, 0x00, 0xFF, 0xF5, 0x2D, 0xFF, 0x30, 0x5F, 0xE1, 0x00,
  0xCF, 0x30, 0xBF, 0xFF, 0xFF, 0xFF, 0x17, 0xFF, 0x40, 0x00,
  0x9F, 0x70, 0x4F, 0xFF, 0xFB, 0xFF, 0xFF, 0xF6, 0x00, 0x00,
  0x4F, 0xE1, 0x06, 0xEE, 0x62, 0xDF, 0xD9, 0x20, 0x00, 0x00,
  0x0C, 0xF9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xB0,
  0x03, 0xFF, 0x91, 0x00, 0x00, 0x00, 0x00, 0x3E, 0xFE, 0x30,
  0x00, 0x5F, 0xFE, 0x84, 0x10, 0x02, 0x5A, 0xFF, 0xF5, 0x00,
  0x00, 0x03, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x30, 0x00,
  0x00, 0x00, 0x03, 0x8B, 0xDF, 0xFE, 0xC9, 0x40, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0041[105] = { /* code 0041, LATIN CAPITAL LETTER A */
  0x00, 0x00, 0xBF, 0xFF, 0xB0, 0x00, 0x00,
  0x00, 0x01, 0xFF, 0xFF, 0xF1, 0x00, 0x00,
  0x00, 0x05, 0xFF, 0xFF, 0xF5, 0x00, 0x00,
  0x00, 0x09, 0xFF, 0xBF, 0xF9, 0x00, 0x00,
  0x00, 0x0E, 0xFF, 0x2F, 0xFE, 0x00, 0x00,
  0x00, 0x3F, 0xFB, 0x0B, 0xFF, 0x30, 0x00,
  0x00, 0x7F, 0xF7, 0x07, 0xFF, 0x70, 0x00,
  0x00, 0xCF, 0xF3, 0x02, 0xFF, 0xC0, 0x00,
  0x01, 0xFF, 0xD0, 0x00, 0xDF, 0xF1, 0x00,
  0x06, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x00,
  0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x00,
  0x0E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0x4F, 0xFB, 0x00, 0x00, 0x0B, 0xFF, 0x40,
  0x8F, 0xF6, 0x00, 0x00, 0x07, 0xFF, 0x80,
  0xDF, 0xF2, 0x00, 0x00, 0x03, 0xFF, 0xD0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0042[ 90] = { /* code 0042, LATIN CAPITAL LETTER B */
  0xFF, 0xFF, 0xFF, 0xFE, 0xB3, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x30,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0,
  0xFF, 0xF0, 0x00, 0x06, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xE0,
  0xFF, 0xF0, 0x00, 0x07, 0xFF, 0xB0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x30,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x20,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3,
  0xFF, 0xF0, 0x00, 0x02, 0x8F, 0xFB,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x01, 0x7F, 0xFE,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2,
  0xFF, 0xFF, 0xFF, 0xFF, 0xD9, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0043[ 90] = { /* code 0043, LATIN CAPITAL LETTER C */
  0x00, 0x05, 0xBE, 0xFE, 0xB4, 0x00,
  0x00, 0xAF, 0xFF, 0xFF, 0xFF, 0x80,
  0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6,
  0x3F, 0xFF, 0x81, 0x04, 0xDF, 0xFD,
  0x9F, 0xF9, 0x00, 0x00, 0x3D, 0x83,
  0xCF, 0xF3, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF1, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xF3, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF9, 0x00, 0x00, 0x3D, 0x83,
  0x3F, 0xFF, 0x81, 0x04, 0xDF, 0xFC,
  0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5,
  0x01, 0xBF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x06, 0xBE, 0xFE, 0xA4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0044[ 90] = { /* code 0044, LATIN CAPITAL LETTER D */
  0xFF, 0xFF, 0xFF, 0xFC, 0x81, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x20,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0xFF, 0xF0, 0x00, 0x27, 0xFF, 0xF4,
  0xFF, 0xF0, 0x00, 0x00, 0x9F, 0xFA,
  0xFF, 0xF0, 0x00, 0x00, 0x3F, 0xFD,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x3F, 0xFD,
  0xFF, 0xF0, 0x00, 0x00, 0x7F, 0xFA,
  0xFF, 0xF0, 0x00, 0x16, 0xEF, 0xF5,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x20,
  0xFF, 0xFF, 0xFF, 0xFC, 0x71, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0045[ 90] = { /* code 0045, LATIN CAPITAL LETTER E */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0046[ 75] = { /* code 0046, LATIN CAPITAL LETTER F */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0047[105] = { /* code 0047, LATIN CAPITAL LETTER G */
  0x00, 0x01, 0x7A, 0xDF, 0xDB, 0x71, 0x00,
  0x00, 0x6E, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x06, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5,
  0x1E, 0xFF, 0xD5, 0x10, 0x16, 0xEF, 0xFD,
  0x7F, 0xFC, 0x10, 0x00, 0x00, 0x4D, 0x83,
  0xCF, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF, 0xFF, 0xFF,
  0xEF, 0xF1, 0x00, 0x0F, 0xFF, 0xFF, 0xFF,
  0xCF, 0xF5, 0x00, 0x0F, 0xFF, 0xFF, 0xFF,
  0x7F, 0xFD, 0x10, 0x00, 0x00, 0x0F, 0xFF,
  0x1E, 0xFF, 0xD5, 0x10, 0x14, 0x9F, 0xFF,
  0x06, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0x00, 0x6E, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x01, 0x7C, 0xEF, 0xEC, 0x71, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0048[ 90] = { /* code 0048, LATIN CAPITAL LETTER H */
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0049[ 30] = { /* code 0049, LATIN CAPITAL LETTER I */
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_004A[ 75] = { /* code 004A, LATIN CAPITAL LETTER J */
  0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xEF, 0xF3, 0x00, 0x2F, 0xFF,
  0xAF, 0xFB, 0x11, 0x8F, 0xFC,
  0x5F, 0xFF, 0xFF, 0xFF, 0xF7,
  0x0A, 0xFF, 0xFF, 0xFF, 0xB1,
  0x00, 0x7D, 0xFF, 0xC7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_004B[105] = { /* code 004B, LATIN CAPITAL LETTER K */
  0xFF, 0xF0, 0x00, 0x01, 0xDF, 0xFE, 0x20,
  0xFF, 0xF0, 0x00, 0x0B, 0xFF, 0xE2, 0x00,
  0xFF, 0xF0, 0x00, 0x9F, 0xFE, 0x30, 0x00,
  0xFF, 0xF0, 0x06, 0xFF, 0xF4, 0x00, 0x00,
  0xFF, 0xF0, 0x4F, 0xFF, 0x50, 0x00, 0x00,
  0xFF, 0xF2, 0xEF, 0xFB, 0x00, 0x00, 0x00,
  0xFF, 0xFC, 0xFF, 0xFF, 0x30, 0x00, 0x00,
  0xFF, 0xFF, 0xFB, 0xFF, 0xB0, 0x00, 0x00,
  0xFF, 0xFF, 0xA0, 0xBF, 0xF4, 0x00, 0x00,
  0xFF, 0xFB, 0x00, 0x4F, 0xFB, 0x00, 0x00,
  0xFF, 0xF1, 0x00, 0x0B, 0xFF, 0x40, 0x00,
  0xFF, 0xF0, 0x00, 0x04, 0xFF, 0xB0, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0xBF, 0xF4, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x4F, 0xFB, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x0B, 0xFF, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_004C[ 75] = { /* code 004C, LATIN CAPITAL LETTER L */
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_004D[120] = { /* code 004D, LATIN CAPITAL LETTER M */
  0xFF, 0xFF, 0xE0, 0x00, 0x00, 0xEF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF3, 0x00, 0x03, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF7, 0x00, 0x07, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFE, 0xFB, 0x00, 0x0B, 0xFE, 0xFF, 0xF0,
  0xFF, 0xFA, 0xFE, 0x00, 0x0F, 0xFA, 0xFF, 0xF0,
  0xFF, 0xF6, 0xFF, 0x40, 0x4F, 0xF6, 0xFF, 0xF0,
  0xFF, 0xF6, 0xBF, 0x80, 0x8F, 0xB6, 0xFF, 0xF0,
  0xFF, 0xF5, 0x8F, 0xC0, 0xCF, 0x85, 0xFF, 0xF0,
  0xFF, 0xF4, 0x5F, 0xF1, 0xFF, 0x54, 0xFF, 0xF0,
  0xFF, 0xF4, 0x1F, 0xF9, 0xFF, 0x24, 0xFF, 0xF0,
  0xFF, 0xF3, 0x0D, 0xFF, 0xFD, 0x03, 0xFF, 0xF0,
  0xFF, 0xF2, 0x0A, 0xFF, 0xFA, 0x02, 0xFF, 0xF0,
  0xFF, 0xF2, 0x07, 0xFF, 0xF7, 0x02, 0xFF, 0xF0,
  0xFF, 0xF1, 0x03, 0xFF, 0xF3, 0x01, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0xFF, 0xF0, 0x00, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_004E[ 90] = { /* code 004E, LATIN CAPITAL LETTER N */
  0xFF, 0xF7, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xFE, 0x10, 0x00, 0x0F, 0xFF,
  0xFF, 0xFF, 0x70, 0x00, 0x0F, 0xFF,
  0xFF, 0xFF, 0xE1, 0x00, 0x0F, 0xFF,
  0xFF, 0xFA, 0xF8, 0x00, 0x0F, 0xFF,
  0xFF, 0xF3, 0xFF, 0x10, 0x0F, 0xFF,
  0xFF, 0xF0, 0xAF, 0x80, 0x0F, 0xFF,
  0xFF, 0xF0, 0x2F, 0xF1, 0x0F, 0xFF,
  0xFF, 0xF0, 0x09, 0xF9, 0x0F, 0xFF,
  0xFF, 0xF0, 0x02, 0xFF, 0x2F, 0xFF,
  0xFF, 0xF0, 0x00, 0x8F, 0x9F, 0xFF,
  0xFF, 0xF0, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x08, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x01, 0xEF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x7F, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_004F[105] = { /* code 004F, LATIN CAPITAL LETTER O */
  0x00, 0x04, 0xAD, 0xFF, 0xD9, 0x30, 0x00,
  0x00, 0x8F, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x3F, 0xFF, 0xB3, 0x00, 0x3B, 0xFF, 0xF2,
  0x8F, 0xFC, 0x00, 0x00, 0x00, 0xBF, 0xF8,
  0xCF, 0xF4, 0x00, 0x00, 0x00, 0x4F, 0xFC,
  0xFF, 0xF1, 0x00, 0x00, 0x00, 0x1F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF1, 0x00, 0x00, 0x00, 0x1F, 0xFF,
  0xCF, 0xF5, 0x00, 0x00, 0x00, 0x5F, 0xFC,
  0x9F, 0xFC, 0x10, 0x00, 0x01, 0xCF, 0xF8,
  0x3F, 0xFF, 0xC4, 0x00, 0x4C, 0xFF, 0xF3,
  0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x8F, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x03, 0xAD, 0xFF, 0xDA, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0050[ 90] = { /* code 0050, LATIN CAPITAL LETTER P */
  0xFF, 0xFF, 0xFF, 0xFD, 0xA2, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x20,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0,
  0xFF, 0xF0, 0x00, 0x17, 0xFF, 0xE0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x17, 0xFF, 0xE0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x90,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x10,
  0xFF, 0xFF, 0xFF, 0xFD, 0x81, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0051[128] = { /* code 0051, LATIN CAPITAL LETTER Q */
  0x00, 0x03, 0xAD, 0xFF, 0xDA, 0x40, 0x00, 0x00,
  0x00, 0x9F, 0xFF, 0xFF, 0xFF, 0xF9, 0x00, 0x00,
  0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0x3F, 0xFF, 0xB3, 0x00, 0x3B, 0xFF, 0xF3, 0x00,
  0x8F, 0xFC, 0x00, 0x00, 0x00, 0xBF, 0xF9, 0x00,
  0xCF, 0xF4, 0x00, 0x00, 0x00, 0x4F, 0xFC, 0x00,
  0xFF, 0xF1, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00,
  0xFF, 0xF1, 0x00, 0x00, 0x00, 0x2F, 0xFF, 0x00,
  0xCF, 0xF4, 0x00, 0x5B, 0x30, 0x6F, 0xFC, 0x00,
  0x8F, 0xFC, 0x00, 0xCF, 0xF8, 0xDF, 0xF9, 0x00,
  0x3F, 0xFF, 0xB3, 0x3A, 0xFF, 0xFF, 0xF3, 0x00,
  0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0, 0x00,
  0x00, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x30,
  0x00, 0x03, 0x9D, 0xFF, 0xEA, 0x8E, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x8D, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0052[ 90] = { /* code 0052, LATIN CAPITAL LETTER R */
  0xFF, 0xFF, 0xFF, 0xFE, 0xB3, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x30,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0,
  0xFF, 0xF0, 0x00, 0x06, 0xFF, 0xE0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x17, 0xFF, 0xD0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x10,
  0xFF, 0xFF, 0xFF, 0xFE, 0x50, 0x00,
  0xFF, 0xF0, 0x19, 0xFF, 0xB0, 0x00,
  0xFF, 0xF0, 0x00, 0xBF, 0xF7, 0x00,
  0xFF, 0xF0, 0x00, 0x2E, 0xFF, 0x20,
  0xFF, 0xF0, 0x00, 0x07, 0xFF, 0x90,
  0xFF, 0xF0, 0x00, 0x01, 0xEF, 0xF3,
  0xFF, 0xF0, 0x00, 0x00, 0x7F, 0xFB
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0053[ 90] = { /* code 0053, LATIN CAPITAL LETTER S */
  0x01, 0x7C, 0xFF, 0xEB, 0x50, 0x00,
  0x0C, 0xFF, 0xFF, 0xFF, 0xFA, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0xCF, 0xF9, 0x10, 0x2B, 0xFF, 0xC0,
  0xFF, 0xF0, 0x00, 0x02, 0xFF, 0xF0,
  0xCF, 0xFB, 0x40, 0x00, 0x00, 0x00,
  0x5F, 0xFF, 0xFF, 0xB7, 0x10, 0x00,
  0x06, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x00, 0x17, 0xBE, 0xFF, 0xFF, 0x60,
  0x00, 0x00, 0x00, 0x4A, 0xFF, 0xD0,
  0xEF, 0xF2, 0x00, 0x00, 0xFF, 0xF0,
  0xAF, 0xFB, 0x30, 0x19, 0xFF, 0xE0,
  0x4F, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x08, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0x00, 0x5B, 0xEF, 0xFC, 0x60, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0054[ 90] = { /* code 0054, LATIN CAPITAL LETTER T */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0055[ 90] = { /* code 0055, LATIN CAPITAL LETTER U */
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xDF, 0xF4, 0x00, 0x00, 0x3F, 0xFD,
  0xBF, 0xFE, 0x40, 0x03, 0xDF, 0xFB,
  0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6,
  0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0,
  0x00, 0x5B, 0xEF, 0xFE, 0xB5, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0056[105] = { /* code 0056, LATIN CAPITAL LETTER V */
  0xDF, 0xF3, 0x00, 0x00, 0x03, 0xFF, 0xD0,
  0x8F, 0xF7, 0x00, 0x00, 0x07, 0xFF, 0x80,
  0x3F, 0xFC, 0x00, 0x00, 0x0C, 0xFF, 0x30,
  0x0D, 0xFF, 0x20, 0x00, 0x2F, 0xFD, 0x00,
  0x08, 0xFF, 0x70, 0x00, 0x7F, 0xF8, 0x00,
  0x04, 0xFF, 0xB0, 0x00, 0xBF, 0xF4, 0x00,
  0x00, 0xEF, 0xF1, 0x01, 0xFF, 0xE0, 0x00,
  0x00, 0x9F, 0xF6, 0x06, 0xFF, 0x90, 0x00,
  0x00, 0x5F, 0xFB, 0x0B, 0xFF, 0x50, 0x00,
  0x00, 0x0E, 0xFF, 0x1F, 0xFE, 0x00, 0x00,
  0x00, 0x0A, 0xFF, 0xBF, 0xFA, 0x00, 0x00,
  0x00, 0x05, 0xFF, 0xFF, 0xF5, 0x00, 0x00,
  0x00, 0x01, 0xFF, 0xFF, 0xF1, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0xFF, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0xFF, 0x60, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0057[150] = { /* code 0057, LATIN CAPITAL LETTER W */
  0xDF, 0xF2, 0x00, 0x03, 0xFF, 0xF2, 0x00, 0x02, 0xFF, 0xD0,
  0xAF, 0xF6, 0x00, 0x06, 0xFF, 0xF5, 0x00, 0x06, 0xFF, 0xA0,
  0x6F, 0xF9, 0x00, 0x0A, 0xFF, 0xF9, 0x00, 0x09, 0xFF, 0x60,
  0x2F, 0xFD, 0x00, 0x0D, 0xFF, 0xFD, 0x00, 0x0D, 0xFF, 0x30,
  0x0E, 0xFF, 0x20, 0x2F, 0xFA, 0xFF, 0x10, 0x1F, 0xFE, 0x00,
  0x0A, 0xFF, 0x50, 0x6F, 0xF3, 0xFF, 0x50, 0x5F, 0xFB, 0x00,
  0x07, 0xFF, 0x90, 0x9F, 0xE0, 0xDF, 0x80, 0x8F, 0xF7, 0x00,
  0x03, 0xFF, 0xC0, 0xDF, 0xA0, 0xAF, 0xC0, 0xCF, 0xF3, 0x00,
  0x00, 0xEF, 0xF2, 0xFF, 0x70, 0x7F, 0xF1, 0xFF, 0xF0, 0x00,
  0x00, 0xBF, 0xF9, 0xFF, 0x30, 0x3F, 0xF8, 0xFF, 0xB0, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0x00, 0x0F, 0xFE, 0xFF, 0x80, 0x00,
  0x00, 0x4F, 0xFF, 0xFC, 0x00, 0x0C, 0xFF, 0xFF, 0x40, 0x00,
  0x00, 0x0F, 0xFF, 0xF8, 0x00, 0x08, 0xFF, 0xFF, 0x10, 0x00,
  0x00, 0x0B, 0xFF, 0xF5, 0x00, 0x05, 0xFF, 0xFC, 0x00, 0x00,
  0x00, 0x08, 0xFF, 0xF2, 0x00, 0x02, 0xFF, 0xF9, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0058[105] = { /* code 0058, LATIN CAPITAL LETTER X */
  0x3F, 0xFC, 0x00, 0x00, 0x0C, 0xFF, 0x30,
  0x09, 0xFF, 0x60, 0x00, 0x6F, 0xF9, 0x00,
  0x01, 0xEF, 0xE1, 0x01, 0xEF, 0xE1, 0x00,
  0x00, 0x6F, 0xF9, 0x09, 0xFF, 0x60, 0x00,
  0x00, 0x0C, 0xFF, 0x7F, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFF, 0xFF, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x2F, 0xFF, 0x20, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x03, 0xFF, 0xFF, 0xF3, 0x00, 0x00,
  0x00, 0x0C, 0xFF, 0x7F, 0xFC, 0x00, 0x00,
  0x00, 0x6F, 0xF9, 0x09, 0xFF, 0x60, 0x00,
  0x01, 0xEF, 0xE1, 0x01, 0xEF, 0xE1, 0x00,
  0x09, 0xFF, 0x60, 0x00, 0x6F, 0xF9, 0x00,
  0x3F, 0xFC, 0x00, 0x00, 0x0C, 0xFF, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0059[120] = { /* code 0059, LATIN CAPITAL LETTER Y */
  0x3F, 0xFC, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0x30,
  0x08, 0xFF, 0x70, 0x00, 0x00, 0x7F, 0xF8, 0x00,
  0x01, 0xDF, 0xF2, 0x00, 0x02, 0xFF, 0xD1, 0x00,
  0x00, 0x4F, 0xFB, 0x00, 0x0B, 0xFF, 0x40, 0x00,
  0x00, 0x0A, 0xFF, 0x50, 0x5F, 0xFA, 0x00, 0x00,
  0x00, 0x01, 0xEF, 0xE2, 0xEF, 0xE1, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0xFE, 0xFF, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xFF, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x02, 0xFF, 0xF2, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_005A[ 90] = { /* code 005A, LATIN CAPITAL LETTER Z */
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x0C, 0xFF, 0x90,
  0x00, 0x00, 0x00, 0xAF, 0xFB, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0xD1, 0x00,
  0x00, 0x00, 0x5F, 0xFE, 0x20, 0x00,
  0x00, 0x03, 0xFF, 0xF4, 0x00, 0x00,
  0x00, 0x2E, 0xFF, 0x60, 0x00, 0x00,
  0x01, 0xDF, 0xF9, 0x00, 0x00, 0x00,
  0x0B, 0xFF, 0xB0, 0x00, 0x00, 0x00,
  0x9F, 0xFD, 0x10, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_005B[ 57] = { /* code 005B, LEFT SQUARE BRACKET */
  0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00,
  0xFF, 0xF0, 0x00,
  0xFF, 0xF0, 0x00,
  0xFF, 0xF0, 0x00,
  0xFF, 0xF0, 0x00,
  0xFF, 0xF0, 0x00,
  0xFF, 0xF0, 0x00,
  0xFF, 0xF0, 0x00,
  0xFF, 0xF0, 0x00,
  0xFF, 0xF0, 0x00,
  0xFF, 0xF0, 0x00,
  0xFF, 0xF0, 0x00,
  0xFF, 0xF0, 0x00,
  0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_005C[ 45] = { /* code 005C, REVERSE SOLIDUS */
  0xEF, 0x20, 0x00,
  0xAF, 0x60, 0x00,
  0x6F, 0xA0, 0x00,
  0x2F, 0xE0, 0x00,
  0x0D, 0xF3, 0x00,
  0x09, 0xF7, 0x00,
  0x05, 0xFB, 0x00,
  0x01, 0xFF, 0x00,
  0x00, 0xCF, 0x40,
  0x00, 0x8F, 0x80,
  0x00, 0x4F, 0xC0,
  0x00, 0x0E, 0xF1,
  0x00, 0x0B, 0xF5,
  0x00, 0x07, 0xF9,
  0x00, 0x03, 0xFD
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_005D[ 57] = { /* code 005D, RIGHT SQUARE BRACKET */
  0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_005E[ 40] = { /* code 005E, CIRCUMFLEX ACCENT */
  0x00, 0x06, 0xFF, 0x70, 0x00,
  0x00, 0x0C, 0xFF, 0xE0, 0x00,
  0x00, 0x5F, 0xFF, 0xF6, 0x00,
  0x00, 0xCF, 0xDD, 0xFD, 0x00,
  0x05, 0xFF, 0x66, 0xFF, 0x50,
  0x0C, 0xFF, 0x11, 0xFF, 0xC0,
  0x4F, 0xF9, 0x00, 0x9F, 0xF4,
  0xBF, 0xF3, 0x00, 0x3F, 0xFB
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_005F[ 12] = { /* code 005F, LOW LINE */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0060[  6] = { /* code 0060, GRAVE ACCENT */
  0xAF, 0xB0,
  0x1E, 0xF4,
  0x05, 0xFB
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0061[ 55] = { /* code 0061, LATIN SMALL LETTER A */
  0x04, 0xBE, 0xFF, 0xC4, 0x00,
  0x4F, 0xFF, 0xFF, 0xFF, 0x50,
  0xDF, 0x60, 0x06, 0xFF, 0xC0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x28, 0xAD, 0xFF, 0xF0,
  0x1A, 0xFF, 0xFF, 0xFF, 0xF0,
  0xAF, 0xFC, 0x62, 0xFF, 0xF0,
  0xFF, 0xF1, 0x01, 0xFF, 0xF0,
  0xEF, 0xF5, 0x19, 0xFF, 0xF0,
  0x8F, 0xFF, 0xFF, 0xEF, 0xF3,
  0x08, 0xEF, 0xD7, 0x2F, 0xFA
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0062[ 75] = { /* code 0062, LATIN SMALL LETTER B */
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF2, 0xBF, 0xE9, 0x10,
  0xFF, 0xFE, 0xFF, 0xFF, 0xD1,
  0xFF, 0xFC, 0x11, 0xCF, 0xF7,
  0xFF, 0xF3, 0x00, 0x4F, 0xFC,
  0xFF, 0xF0, 0x00, 0x1F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF1, 0x00, 0x1F, 0xFE,
  0xFF, 0xF5, 0x00, 0x4F, 0xFC,
  0xFF, 0xFD, 0x21, 0xCF, 0xF7,
  0xFF, 0xFD, 0xFF, 0xFF, 0xC0,
  0xFF, 0xF2, 0xBF, 0xE9, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0063[ 55] = { /* code 0063, LATIN SMALL LETTER C */
  0x00, 0x5B, 0xFE, 0xB4, 0x00,
  0x0A, 0xFF, 0xFF, 0xFF, 0x40,
  0x6F, 0xFC, 0x21, 0x9F, 0xC0,
  0xBF, 0xF3, 0x00, 0x2B, 0x40,
  0xEF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xEF, 0xF1, 0x00, 0x00, 0x00,
  0xBF, 0xF4, 0x00, 0x2B, 0x40,
  0x6F, 0xFC, 0x21, 0xAF, 0xD0,
  0x0A, 0xFF, 0xFF, 0xFF, 0x40,
  0x00, 0x6B, 0xFE, 0xB4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0064[ 75] = { /* code 0064, LATIN SMALL LETTER D */
  0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x01, 0x9E, 0xFB, 0x2F, 0xFF,
  0x1D, 0xFF, 0xFF, 0xEF, 0xFF,
  0x7F, 0xFC, 0x21, 0xCF, 0xFF,
  0xCF, 0xF4, 0x00, 0x4F, 0xFF,
  0xFF, 0xF0, 0x00, 0x1F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xEF, 0xF1, 0x00, 0x1F, 0xFF,
  0xCF, 0xF4, 0x00, 0x4F, 0xFF,
  0x7F, 0xFC, 0x12, 0xCF, 0xFF,
  0x0C, 0xFF, 0xFF, 0xDF, 0xFF,
  0x01, 0x9E, 0xFB, 0x2F, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0065[ 55] = { /* code 0065, LATIN SMALL LETTER E */
  0x01, 0x9E, 0xFE, 0x92, 0x00,
  0x1D, 0xFF, 0xFF, 0xFE, 0x20,
  0x8F, 0xF5, 0x07, 0xFF, 0x80,
  0xCF, 0xF1, 0x01, 0xFF, 0xC0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xCF, 0xF3, 0x00, 0x00, 0x00,
  0x8F, 0xFB, 0x05, 0xFF, 0xC0,
  0x2D, 0xFF, 0xFF, 0xFE, 0x30,
  0x01, 0x8D, 0xFE, 0xB3, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0066[ 60] = { /* code 0066, LATIN SMALL LETTER F */
  0x01, 0x9E, 0xFE, 0xB0,
  0x0B, 0xFF, 0xFF, 0xA0,
  0x0F, 0xFF, 0x30, 0x10,
  0x0F, 0xFF, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0xFF, 0x00,
  0x0F, 0xFF, 0x00, 0x00,
  0x0F, 0xFF, 0x00, 0x00,
  0x0F, 0xFF, 0x00, 0x00,
  0x0F, 0xFF, 0x00, 0x00,
  0x0F, 0xFF, 0x00, 0x00,
  0x0F, 0xFF, 0x00, 0x00,
  0x0F, 0xFF, 0x00, 0x00,
  0x0F, 0xFF, 0x00, 0x00,
  0x0F, 0xFF, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0067[ 75] = { /* code 0067, LATIN SMALL LETTER G */
  0x01, 0x9E, 0xFB, 0x2F, 0xFF,
  0x0C, 0xFF, 0xFF, 0xDF, 0xFF,
  0x7F, 0xFC, 0x12, 0xDF, 0xFF,
  0xCF, 0xF4, 0x00, 0x4F, 0xFF,
  0xEF, 0xF1, 0x00, 0x1F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xEF, 0xF1, 0x00, 0x1F, 0xFF,
  0xCF, 0xF4, 0x00, 0x4F, 0xFF,
  0x7F, 0xFC, 0x12, 0xDF, 0xFF,
  0x0C, 0xFF, 0xFF, 0xCF, 0xFF,
  0x01, 0xAE, 0xFA, 0x1F, 0xFF,
  0x00, 0x00, 0x00, 0x0F, 0xFD,
  0xFF, 0xF4, 0x01, 0x8F, 0xFA,
  0x9F, 0xFF, 0xFF, 0xFF, 0xE2,
  0x07, 0xCE, 0xFF, 0xDA, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0068[ 75] = { /* code 0068, LATIN SMALL LETTER H */
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF1, 0x8E, 0xFD, 0x60,
  0xFF, 0xFB, 0xFF, 0xFF, 0xF6,
  0xFF, 0xFC, 0x20, 0x7F, 0xFC,
  0xFF, 0xF3, 0x00, 0x1F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0069[ 30] = { /* code 0069, LATIN SMALL LETTER I */
  0xFF, 0xF0,
  0xFF, 0xF0,
  0x00, 0x00,
  0x00, 0x00,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_006A[ 57] = { /* code 006A, LATIN SMALL LETTER J */
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x03, 0xFF, 0xD0,
  0xAF, 0xFF, 0x90,
  0xBF, 0xE9, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_006B[ 75] = { /* code 006B, LATIN SMALL LETTER K */
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x01, 0xDF, 0xE2,
  0xFF, 0xF0, 0x1C, 0xFF, 0x30,
  0xFF, 0xF0, 0xBF, 0xF5, 0x00,
  0xFF, 0xFA, 0xFF, 0x70, 0x00,
  0xFF, 0xFF, 0xFF, 0x60, 0x00,
  0xFF, 0xFF, 0xFF, 0xD0, 0x00,
  0xFF, 0xF4, 0xAF, 0xF5, 0x00,
  0xFF, 0xF0, 0x3F, 0xFC, 0x00,
  0xFF, 0xF0, 0x0A, 0xFF, 0x50,
  0xFF, 0xF0, 0x04, 0xFF, 0xB0,
  0xFF, 0xF0, 0x00, 0xBF, 0xF4
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_006C[ 30] = { /* code 006C, LATIN SMALL LETTER L */
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_006D[ 88] = { /* code 006D, LATIN SMALL LETTER M */
  0xFF, 0xF2, 0xAF, 0xE7, 0x04, 0xCF, 0xE6, 0x00,
  0xFF, 0xFE, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0x60,
  0xFF, 0xFA, 0x15, 0xFF, 0xFB, 0x16, 0xFF, 0xD0,
  0xFF, 0xF3, 0x00, 0xFF, 0xF3, 0x01, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0xFF, 0xF0, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0xFF, 0xF0, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0xFF, 0xF0, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0xFF, 0xF0, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0xFF, 0xF0, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0xFF, 0xF0, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0xFF, 0xF0, 0x00, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_006E[ 55] = { /* code 006E, LATIN SMALL LETTER N */
  0xFF, 0xF1, 0x9E, 0xFD, 0x70,
  0xFF, 0xFD, 0xFF, 0xFF, 0xF7,
  0xFF, 0xFC, 0x20, 0x9F, 0xFD,
  0xFF, 0xF3, 0x00, 0x2F, 0xFF,
  0xFF, 0xF1, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_006F[ 55] = { /* code 006F, LATIN SMALL LETTER O */
  0x00, 0x5B, 0xFF, 0xB5, 0x00,
  0x08, 0xFF, 0xFF, 0xFF, 0x80,
  0x4F, 0xFD, 0x22, 0xDF, 0xF4,
  0xAF, 0xF4, 0x00, 0x4F, 0xFB,
  0xEF, 0xF1, 0x00, 0x1F, 0xFE,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xEF, 0xF1, 0x00, 0x1F, 0xFE,
  0xBF, 0xF4, 0x00, 0x4F, 0xFB,
  0x5F, 0xFD, 0x22, 0xDF, 0xF4,
  0x09, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x5B, 0xFF, 0xC5, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0070[ 75] = { /* code 0070, LATIN SMALL LETTER P */
  0xFF, 0xF2, 0xBF, 0xEA, 0x10,
  0xFF, 0xFE, 0xFF, 0xFF, 0xC0,
  0xFF, 0xFC, 0x21, 0xCF, 0xF7,
  0xFF, 0xF4, 0x00, 0x4F, 0xFC,
  0xFF, 0xF1, 0x00, 0x1F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF1, 0x00, 0x1F, 0xFE,
  0xFF, 0xF5, 0x00, 0x4F, 0xFC,
  0xFF, 0xFD, 0x21, 0xCF, 0xF7,
  0xFF, 0xFD, 0xFF, 0xFF, 0xB0,
  0xFF, 0xF1, 0xAF, 0xE9, 0x10,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0071[ 75] = { /* code 0071, LATIN SMALL LETTER Q */
  0x01, 0x9E, 0xFB, 0x3F, 0xFF,
  0x1D, 0xFF, 0xFF, 0xEF, 0xFF,
  0x7F, 0xFC, 0x21, 0xCF, 0xFF,
  0xCF, 0xF4, 0x00, 0x4F, 0xFF,
  0xFF, 0xF1, 0x00, 0x1F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xEF, 0xF1, 0x00, 0x1F, 0xFF,
  0xBF, 0xF3, 0x00, 0x5F, 0xFF,
  0x6F, 0xFC, 0x12, 0xDF, 0xFF,
  0x0C, 0xFF, 0xFF, 0xEF, 0xFF,
  0x01, 0x9E, 0xFA, 0x2F, 0xFF,
  0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x0F, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0072[ 44] = { /* code 0072, LATIN SMALL LETTER R */
  0xFF, 0xF4, 0xDF, 0xB0,
  0xFF, 0xFE, 0xFF, 0xB0,
  0xFF, 0xFC, 0x11, 0x30,
  0xFF, 0xF4, 0x00, 0x00,
  0xFF, 0xF2, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0073[ 55] = { /* code 0073, LATIN SMALL LETTER S */
  0x05, 0xCF, 0xFE, 0xB4, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0x40,
  0xEF, 0xF3, 0x05, 0xFF, 0xD0,
  0xFF, 0xF8, 0x10, 0x00, 0x00,
  0xBF, 0xFF, 0xFB, 0x60, 0x00,
  0x18, 0xDF, 0xFF, 0xFB, 0x10,
  0x00, 0x03, 0x8E, 0xFF, 0xC0,
  0x00, 0x00, 0x02, 0xFF, 0xF0,
  0xCF, 0xF5, 0x04, 0xFF, 0xC0,
  0x4F, 0xFF, 0xFF, 0xFF, 0x40,
  0x03, 0xAE, 0xFE, 0xB4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0074[ 45] = { /* code 0074, LATIN SMALL LETTER T */
  0x00, 0x1A, 0x00,
  0x05, 0xEF, 0x00,
  0x0F, 0xFF, 0x00,
  0x0F, 0xFF, 0x00,
  0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF,
  0x0F, 0xFF, 0x00,
  0x0F, 0xFF, 0x00,
  0x0F, 0xFF, 0x00,
  0x0F, 0xFF, 0x00,
  0x0F, 0xFF, 0x00,
  0x0F, 0xFF, 0x00,
  0x0E, 0xFF, 0x21,
  0x0B, 0xFF, 0xFB,
  0x02, 0xBF, 0xFB
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0075[ 55] = { /* code 0075, LATIN SMALL LETTER U */
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x1F, 0xFF,
  0xFF, 0xF1, 0x00, 0x3F, 0xFF,
  0xCF, 0xF9, 0x02, 0xCF, 0xFF,
  0x7F, 0xFF, 0xFF, 0xDF, 0xFF,
  0x07, 0xDF, 0xE9, 0x2F, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0076[ 66] = { /* code 0076, LATIN SMALL LETTER V */
  0x5F, 0xFA, 0x00, 0x0A, 0xFF, 0x50,
  0x0E, 0xFE, 0x00, 0x0E, 0xFE, 0x00,
  0x09, 0xFF, 0x30, 0x3F, 0xFA, 0x00,
  0x04, 0xFF, 0x70, 0x7F, 0xF4, 0x00,
  0x00, 0xDF, 0xB0, 0xBF, 0xE0, 0x00,
  0x00, 0x8F, 0xF1, 0xFF, 0x90, 0x00,
  0x00, 0x3F, 0xF8, 0xFF, 0x30, 0x00,
  0x00, 0x0D, 0xFE, 0xFD, 0x00, 0x00,
  0x00, 0x08, 0xFF, 0xF8, 0x00, 0x00,
  0x00, 0x02, 0xFF, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0xD0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0077[ 88] = { /* code 0077, LATIN SMALL LETTER W */
  0xDF, 0xB0, 0x00, 0xDF, 0xE0, 0x00, 0xBF, 0xD0,
  0x8F, 0xF0, 0x02, 0xFF, 0xF2, 0x00, 0xFF, 0x80,
  0x4F, 0xF4, 0x06, 0xFF, 0xF6, 0x04, 0xFF, 0x40,
  0x0E, 0xF8, 0x09, 0xFF, 0xF9, 0x08, 0xFE, 0x00,
  0x0A, 0xFC, 0x0D, 0xFB, 0xFD, 0x0C, 0xFA, 0x00,
  0x06, 0xFF, 0x2F, 0xF3, 0xFF, 0x2F, 0xF6, 0x00,
  0x02, 0xFF, 0xAF, 0xD0, 0xDF, 0xAF, 0xF2, 0x00,
  0x00, 0xCF, 0xFF, 0xA0, 0x9F, 0xFF, 0xC0, 0x00,
  0x00, 0x8F, 0xFF, 0x60, 0x6F, 0xFF, 0x80, 0x00,
  0x00, 0x3F, 0xFF, 0x20, 0x2F, 0xFF, 0x30, 0x00,
  0x00, 0x0E, 0xFE, 0x00, 0x0D, 0xFE, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0078[ 66] = { /* code 0078, LATIN SMALL LETTER X */
  0x3F, 0xFC, 0x00, 0x0C, 0xFF, 0x30,
  0x08, 0xFF, 0x70, 0x7F, 0xF8, 0x00,
  0x00, 0xDF, 0xE4, 0xFF, 0xD0, 0x00,
  0x00, 0x3F, 0xFF, 0xFF, 0x30, 0x00,
  0x00, 0x09, 0xFF, 0xF9, 0x00, 0x00,
  0x00, 0x03, 0xFF, 0xF2, 0x00, 0x00,
  0x00, 0x0B, 0xFF, 0xF9, 0x00, 0x00,
  0x00, 0x5F, 0xFE, 0xFF, 0x40, 0x00,
  0x01, 0xEF, 0xD2, 0xEF, 0xD0, 0x00,
  0x09, 0xFF, 0x50, 0x6F, 0xF8, 0x00,
  0x3F, 0xFC, 0x00, 0x0C, 0xFF, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_0079[105] = { /* code 0079, LATIN SMALL LETTER Y */
  0x1F, 0xFE, 0x00, 0x00, 0x0E, 0xFF, 0x10,
  0x0A, 0xFF, 0x40, 0x00, 0x4F, 0xFA, 0x00,
  0x04, 0xFF, 0xA0, 0x00, 0xAF, 0xF4, 0x00,
  0x00, 0xDF, 0xE0, 0x00, 0xEF, 0xD0, 0x00,
  0x00, 0x7F, 0xF5, 0x05, 0xFF, 0x70, 0x00,
  0x00, 0x2F, 0xFA, 0x0A, 0xFF, 0x20, 0x00,
  0x00, 0x0B, 0xFF, 0x2F, 0xFB, 0x00, 0x00,
  0x00, 0x05, 0xFF, 0xCF, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0xEF, 0xFF, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x8F, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xFF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x2F, 0xFC, 0x00, 0x00, 0x00,
  0x00, 0x11, 0xBF, 0xF6, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0xEF, 0xEA, 0x20, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_007A[ 44] = { /* code 007A, LATIN SMALL LETTER Z */
  0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x6F, 0xFA,
  0x00, 0x02, 0xEF, 0xD1,
  0x00, 0x0C, 0xFF, 0x40,
  0x00, 0x8F, 0xF8, 0x00,
  0x03, 0xFF, 0xC0, 0x00,
  0x1D, 0xFE, 0x30, 0x00,
  0xAF, 0xF6, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_007B[ 76] = { /* code 007B, LEFT CURLY BRACKET */
  0x00, 0x06, 0xCF, 0xF0,
  0x00, 0x7F, 0xFF, 0xF0,
  0x00, 0xCF, 0xFF, 0xF0,
  0x00, 0xFF, 0xF4, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x03, 0xFF, 0xD0, 0x00,
  0x1B, 0xFF, 0x80, 0x00,
  0xFF, 0xF9, 0x00, 0x00,
  0xFF, 0xFA, 0x10, 0x00,
  0x1A, 0xFF, 0x90, 0x00,
  0x02, 0xFF, 0xE0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF3, 0x00,
  0x00, 0xEF, 0xFF, 0xF0,
  0x00, 0x9F, 0xFF, 0xF0,
  0x00, 0x07, 0xDF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_007C[ 19] = { /* code 007C, VERTICAL LINE */
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_007D[ 76] = { /* code 007D, RIGHT CURLY BRACKET */
  0xFF, 0xC7, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00,
  0xFF, 0xFF, 0xC0, 0x00,
  0x04, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xDF, 0xF3, 0x00,
  0x00, 0x7F, 0xFB, 0x10,
  0x00, 0x09, 0xFF, 0xF0,
  0x00, 0x1A, 0xFF, 0xF0,
  0x00, 0xAF, 0xFA, 0x10,
  0x00, 0xEF, 0xF2, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x03, 0xFF, 0xF0, 0x00,
  0xFF, 0xFF, 0xD0, 0x00,
  0xFF, 0xFF, 0x90, 0x00,
  0xFF, 0xD7, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF24B_AA_007E[ 24] = { /* code 007E, TILDE */
  0x5B, 0xFF, 0xD9, 0x51, 0x03, 0xB0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xB3, 0x01, 0x48, 0xCF, 0xFB, 0x40
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontF24B_AA_CharInfo[95] = {
   {   1,   1,   0,  19,   6, acGUI_FontF24B_AA_0020 } /* code 0020, SPACE */
  ,{   3,  15,   2,   4,   7, acGUI_FontF24B_AA_0021 } /* code 0021, EXCLAMATION MARK */
  ,{   7,   5,   1,   4,   9, acGUI_FontF24B_AA_0022 } /* code 0022, QUOTATION MARK */
  ,{  11,  15,   0,   4,  11, acGUI_FontF24B_AA_0023 } /* code 0023, NUMBER SIGN */
  ,{   9,  18,   1,   3,  11, acGUI_FontF24B_AA_0024 } /* code 0024, DOLLAR SIGN */
  ,{  15,  16,   1,   4,  17, acGUI_FontF24B_AA_0025 } /* code 0025, PERCENT SIGN */
  ,{  13,  15,   1,   4,  14, acGUI_FontF24B_AA_0026 } /* code 0026, AMPERSAND */
  ,{   3,   5,   1,   4,   5, acGUI_FontF24B_AA_0027 } /* code 0027, APOSTROPHE */
  ,{   5,  19,   1,   4,   7, acGUI_FontF24B_AA_0028 } /* code 0028, LEFT PARENTHESIS */
  ,{   5,  19,   1,   4,   7, acGUI_FontF24B_AA_0029 } /* code 0029, RIGHT PARENTHESIS */
  ,{   8,   8,   0,   4,   8, acGUI_FontF24B_AA_002A } /* code 002A, ASTERISK */
  ,{  11,  11,   1,   6,  12, acGUI_FontF24B_AA_002B } /* code 002B, PLUS SIGN */
  ,{   3,   6,   1,  16,   6, acGUI_FontF24B_AA_002C } /* code 002C, COMMA */
  ,{   6,   3,   1,  12,   7, acGUI_FontF24B_AA_002D } /* code 002D, HYPHEN-MINUS */
  ,{   3,   3,   1,  16,   6, acGUI_FontF24B_AA_002E } /* code 002E, FULL STOP */
  ,{   6,  15,   0,   4,   6, acGUI_FontF24B_AA_002F } /* code 002F, SOLIDUS */
  ,{   9,  16,   1,   4,  11, acGUI_FontF24B_AA_0030 } /* code 0030, DIGIT ZERO */
  ,{   7,  15,   1,   4,  11, acGUI_FontF24B_AA_0031 } /* code 0031, DIGIT ONE */
  ,{   9,  15,   1,   4,  11, acGUI_FontF24B_AA_0032 } /* code 0032, DIGIT TWO */
  ,{   9,  15,   1,   4,  11, acGUI_FontF24B_AA_0033 } /* code 0033, DIGIT THREE */
  ,{  11,  15,   0,   4,  11, acGUI_FontF24B_AA_0034 } /* code 0034, DIGIT FOUR */
  ,{   9,  15,   1,   4,  11, acGUI_FontF24B_AA_0035 } /* code 0035, DIGIT FIVE */
  ,{   9,  15,   1,   4,  11, acGUI_FontF24B_AA_0036 } /* code 0036, DIGIT SIX */
  ,{   9,  15,   1,   4,  11, acGUI_FontF24B_AA_0037 } /* code 0037, DIGIT SEVEN */
  ,{   9,  15,   1,   4,  11, acGUI_FontF24B_AA_0038 } /* code 0038, DIGIT EIGHT */
  ,{   9,  15,   1,   4,  11, acGUI_FontF24B_AA_0039 } /* code 0039, DIGIT NINE */
  ,{   3,  11,   2,   8,   7, acGUI_FontF24B_AA_003A } /* code 003A, COLON */
  ,{   3,  14,   2,   8,   7, acGUI_FontF24B_AA_003B } /* code 003B, SEMICOLON */
  ,{  10,  11,   1,   6,  12, acGUI_FontF24B_AA_003C } /* code 003C, LESS-THAN SIGN */
  ,{  10,   8,   1,   8,  12, acGUI_FontF24B_AA_003D } /* code 003D, EQUALS SIGN */
  ,{  10,  11,   1,   6,  12, acGUI_FontF24B_AA_003E } /* code 003E, GREATER-THAN SIGN */
  ,{  10,  15,   1,   4,  12, acGUI_FontF24B_AA_003F } /* code 003F, QUESTION MARK */
  ,{  19,  20,   1,   4,  20, acGUI_FontF24B_AA_0040 } /* code 0040, COMMERCIAL AT */
  ,{  13,  15,   0,   4,  13, acGUI_FontF24B_AA_0041 } /* code 0041, LATIN CAPITAL LETTER A */
  ,{  12,  15,   1,   4,  14, acGUI_FontF24B_AA_0042 } /* code 0042, LATIN CAPITAL LETTER B */
  ,{  12,  15,   1,   4,  14, acGUI_FontF24B_AA_0043 } /* code 0043, LATIN CAPITAL LETTER C */
  ,{  12,  15,   1,   4,  14, acGUI_FontF24B_AA_0044 } /* code 0044, LATIN CAPITAL LETTER D */
  ,{  11,  15,   1,   4,  13, acGUI_FontF24B_AA_0045 } /* code 0045, LATIN CAPITAL LETTER E */
  ,{  10,  15,   1,   4,  12, acGUI_FontF24B_AA_0046 } /* code 0046, LATIN CAPITAL LETTER F */
  ,{  14,  15,   1,   4,  16, acGUI_FontF24B_AA_0047 } /* code 0047, LATIN CAPITAL LETTER G */
  ,{  12,  15,   1,   4,  14, acGUI_FontF24B_AA_0048 } /* code 0048, LATIN CAPITAL LETTER H */
  ,{   3,  15,   1,   4,   5, acGUI_FontF24B_AA_0049 } /* code 0049, LATIN CAPITAL LETTER I */
  ,{  10,  15,   0,   4,  11, acGUI_FontF24B_AA_004A } /* code 004A, LATIN CAPITAL LETTER J */
  ,{  13,  15,   1,   4,  14, acGUI_FontF24B_AA_004B } /* code 004B, LATIN CAPITAL LETTER K */
  ,{  10,  15,   1,   4,  12, acGUI_FontF24B_AA_004C } /* code 004C, LATIN CAPITAL LETTER L */
  ,{  15,  15,   1,   4,  17, acGUI_FontF24B_AA_004D } /* code 004D, LATIN CAPITAL LETTER M */
  ,{  12,  15,   1,   4,  14, acGUI_FontF24B_AA_004E } /* code 004E, LATIN CAPITAL LETTER N */
  ,{  14,  15,   1,   4,  16, acGUI_FontF24B_AA_004F } /* code 004F, LATIN CAPITAL LETTER O */
  ,{  11,  15,   1,   4,  13, acGUI_FontF24B_AA_0050 } /* code 0050, LATIN CAPITAL LETTER P */
  ,{  15,  16,   1,   4,  16, acGUI_FontF24B_AA_0051 } /* code 0051, LATIN CAPITAL LETTER Q */
  ,{  12,  15,   1,   4,  14, acGUI_FontF24B_AA_0052 } /* code 0052, LATIN CAPITAL LETTER R */
  ,{  11,  15,   1,   4,  13, acGUI_FontF24B_AA_0053 } /* code 0053, LATIN CAPITAL LETTER S */
  ,{  11,  15,   1,   4,  13, acGUI_FontF24B_AA_0054 } /* code 0054, LATIN CAPITAL LETTER T */
  ,{  12,  15,   1,   4,  14, acGUI_FontF24B_AA_0055 } /* code 0055, LATIN CAPITAL LETTER U */
  ,{  13,  15,   0,   4,  13, acGUI_FontF24B_AA_0056 } /* code 0056, LATIN CAPITAL LETTER V */
  ,{  19,  15,   0,   4,  19, acGUI_FontF24B_AA_0057 } /* code 0057, LATIN CAPITAL LETTER W */
  ,{  13,  15,   0,   4,  13, acGUI_FontF24B_AA_0058 } /* code 0058, LATIN CAPITAL LETTER X */
  ,{  15,  15,  -1,   4,  13, acGUI_FontF24B_AA_0059 } /* code 0059, LATIN CAPITAL LETTER Y */
  ,{  11,  15,   0,   4,  11, acGUI_FontF24B_AA_005A } /* code 005A, LATIN CAPITAL LETTER Z */
  ,{   5,  19,   1,   4,   7, acGUI_FontF24B_AA_005B } /* code 005B, LEFT SQUARE BRACKET */
  ,{   6,  15,   0,   4,   6, acGUI_FontF24B_AA_005C } /* code 005C, REVERSE SOLIDUS */
  ,{   5,  19,   1,   4,   7, acGUI_FontF24B_AA_005D } /* code 005D, RIGHT SQUARE BRACKET */
  ,{  10,   8,   1,   4,  12, acGUI_FontF24B_AA_005E } /* code 005E, CIRCUMFLEX ACCENT */
  ,{  11,   2,   0,  21,  11, acGUI_FontF24B_AA_005F } /* code 005F, LOW LINE */
  ,{   4,   3,   0,   4,   7, acGUI_FontF24B_AA_0060 } /* code 0060, GRAVE ACCENT */
  ,{  10,  11,   1,   8,  11, acGUI_FontF24B_AA_0061 } /* code 0061, LATIN SMALL LETTER A */
  ,{  10,  15,   1,   4,  12, acGUI_FontF24B_AA_0062 } /* code 0062, LATIN SMALL LETTER B */
  ,{   9,  11,   1,   8,  11, acGUI_FontF24B_AA_0063 } /* code 0063, LATIN SMALL LETTER C */
  ,{  10,  15,   1,   4,  12, acGUI_FontF24B_AA_0064 } /* code 0064, LATIN SMALL LETTER D */
  ,{   9,  11,   1,   8,  11, acGUI_FontF24B_AA_0065 } /* code 0065, LATIN SMALL LETTER E */
  ,{   7,  15,   0,   4,   7, acGUI_FontF24B_AA_0066 } /* code 0066, LATIN SMALL LETTER F */
  ,{  10,  15,   1,   8,  12, acGUI_FontF24B_AA_0067 } /* code 0067, LATIN SMALL LETTER G */
  ,{  10,  15,   1,   4,  12, acGUI_FontF24B_AA_0068 } /* code 0068, LATIN SMALL LETTER H */
  ,{   3,  15,   1,   4,   5, acGUI_FontF24B_AA_0069 } /* code 0069, LATIN SMALL LETTER I */
  ,{   5,  19,  -1,   4,   5, acGUI_FontF24B_AA_006A } /* code 006A, LATIN SMALL LETTER J */
  ,{  10,  15,   1,   4,  11, acGUI_FontF24B_AA_006B } /* code 006B, LATIN SMALL LETTER K */
  ,{   3,  15,   1,   4,   5, acGUI_FontF24B_AA_006C } /* code 006C, LATIN SMALL LETTER L */
  ,{  15,  11,   1,   8,  17, acGUI_FontF24B_AA_006D } /* code 006D, LATIN SMALL LETTER M */
  ,{  10,  11,   1,   8,  12, acGUI_FontF24B_AA_006E } /* code 006E, LATIN SMALL LETTER N */
  ,{  10,  11,   1,   8,  12, acGUI_FontF24B_AA_006F } /* code 006F, LATIN SMALL LETTER O */
  ,{  10,  15,   1,   8,  12, acGUI_FontF24B_AA_0070 } /* code 0070, LATIN SMALL LETTER P */
  ,{  10,  15,   1,   8,  12, acGUI_FontF24B_AA_0071 } /* code 0071, LATIN SMALL LETTER Q */
  ,{   7,  11,   1,   8,   8, acGUI_FontF24B_AA_0072 } /* code 0072, LATIN SMALL LETTER R */
  ,{   9,  11,   1,   8,  11, acGUI_FontF24B_AA_0073 } /* code 0073, LATIN SMALL LETTER S */
  ,{   6,  15,   0,   4,   7, acGUI_FontF24B_AA_0074 } /* code 0074, LATIN SMALL LETTER T */
  ,{  10,  11,   1,   8,  12, acGUI_FontF24B_AA_0075 } /* code 0075, LATIN SMALL LETTER U */
  ,{  11,  11,   0,   8,  11, acGUI_FontF24B_AA_0076 } /* code 0076, LATIN SMALL LETTER V */
  ,{  15,  11,   0,   8,  15, acGUI_FontF24B_AA_0077 } /* code 0077, LATIN SMALL LETTER W */
  ,{  11,  11,   0,   8,  11, acGUI_FontF24B_AA_0078 } /* code 0078, LATIN SMALL LETTER X */
  ,{  13,  15,  -1,   8,  11, acGUI_FontF24B_AA_0079 } /* code 0079, LATIN SMALL LETTER Y */
  ,{   8,  11,   1,   8,  10, acGUI_FontF24B_AA_007A } /* code 007A, LATIN SMALL LETTER Z */
  ,{   7,  19,   1,   4,   8, acGUI_FontF24B_AA_007B } /* code 007B, LEFT CURLY BRACKET */
  ,{   2,  19,   2,   4,   6, acGUI_FontF24B_AA_007C } /* code 007C, VERTICAL LINE */
  ,{   7,  19,   0,   4,   8, acGUI_FontF24B_AA_007D } /* code 007D, RIGHT CURLY BRACKET */
  ,{  11,   4,   0,  10,  12, acGUI_FontF24B_AA_007E } /* code 007E, TILDE */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontF24B_AA_Prop1 = {
   0x0020 /* first character */
  ,0x007E /* last character  */
  ,&GUI_FontF24B_AA_CharInfo[  0] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT GUI_FontF24B_AA = {
   GUI_FONTTYPE_PROP_AA4_EXT /* type of font    */
  ,24 /* height of font  */
  ,24 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_FontF24B_AA_Prop1}
  ,24 /* Baseline */
  ,11 /* Height of lowercase characters */
  ,15 /* Height of capital characters */
};

/*************************** End of file ****************************/
