/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2014  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.24 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software has been licensed to  ARM LIMITED whose registered office
is situated at  110 Fulbourn Road,  Cambridge CB1 9NJ,  England solely
for  the  purposes  of  creating  libraries  for  ARM7, ARM9, Cortex-M
series,  and   Cortex-R4   processor-based  devices,  sublicensed  and
distributed as part of the  MDK-ARM  Professional  under the terms and
conditions  of  the   End  User  License  supplied  with  the  MDK-ARM
Professional. 
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
File        : F19B_AA.c
Content     : Font (AA4), Height 19
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI.H"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/* The following line needs to be included in any file selecting the
   font. A good place would be GUIConf.H
*/
extern GUI_CONST_STORAGE GUI_FONT GUI_FontF19B_AA;

/* Start of unicode area <Basic Latin> */
GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0020[  1] = { /* code 0020, SPACE */
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0021[ 12] = { /* code 0021, EXCLAMATION MARK */
  0xFF,
  0xFF,
  0xFF,
  0xEE,
  0xDD,
  0xCC,
  0xBB,
  0x99,
  0x89,
  0x00,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0022[ 12] = { /* code 0022, QUOTATION MARK */
  0xFF, 0x00, 0xFF,
  0xFF, 0x00, 0xFF,
  0xEE, 0x00, 0xEE,
  0xBC, 0x00, 0xBC
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0023[ 48] = { /* code 0023, NUMBER SIGN */
  0x01, 0xFE, 0x1F, 0xE0,
  0x04, 0xFC, 0x4F, 0xC0,
  0x06, 0xF9, 0x6F, 0x90,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0,
  0x0E, 0xF2, 0xEF, 0x20,
  0x1F, 0xE1, 0xFE, 0x00,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0,
  0x9F, 0x79, 0xF7, 0x00,
  0xBF, 0x4B, 0xF4, 0x00,
  0xEF, 0x2E, 0xF2, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0024[ 56] = { /* code 0024, DOLLAR SIGN */
  0x00, 0x0F, 0x00, 0x00,
  0x07, 0xEF, 0xE7, 0x00,
  0x7F, 0xFF, 0xFF, 0x70,
  0xEF, 0x4F, 0x5F, 0xD0,
  0xFF, 0x0F, 0x00, 0x00,
  0xCF, 0xBF, 0x00, 0x00,
  0x4F, 0xFF, 0xC4, 0x00,
  0x03, 0xAF, 0xFF, 0x60,
  0x00, 0x0F, 0x8F, 0xE0,
  0xEF, 0x1F, 0x0F, 0xF0,
  0xAF, 0x7F, 0x3F, 0xD0,
  0x4F, 0xFF, 0xFF, 0x60,
  0x06, 0xDF, 0xD6, 0x00,
  0x00, 0x0F, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0025[ 96] = { /* code 0025, PERCENT SIGN */
  0x1B, 0xFF, 0xB1, 0x00, 0x03, 0xFC, 0x00, 0x00,
  0xBF, 0x44, 0xFB, 0x00, 0x0C, 0xF4, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x6F, 0xA0, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x01, 0xEF, 0x20, 0x00, 0x00,
  0xBF, 0x44, 0xFB, 0x08, 0xF7, 0x00, 0x00, 0x00,
  0x1B, 0xFF, 0xB1, 0x2F, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0x51, 0xBF, 0xFB, 0x10,
  0x00, 0x00, 0x04, 0xFB, 0x0B, 0xF4, 0x4F, 0xB0,
  0x00, 0x00, 0x0D, 0xF2, 0x0F, 0xF0, 0x0F, 0xF0,
  0x00, 0x00, 0x7F, 0x80, 0x0F, 0xF0, 0x0F, 0xF0,
  0x00, 0x02, 0xEE, 0x10, 0x0B, 0xF4, 0x4F, 0xB0,
  0x00, 0x0A, 0xF6, 0x00, 0x01, 0xBF, 0xFB, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0026[ 72] = { /* code 0026, AMPERSAND */
  0x01, 0x9E, 0xFE, 0x81, 0x00, 0x00,
  0x0A, 0xFF, 0xFF, 0xFA, 0x00, 0x00,
  0x0F, 0xF3, 0x04, 0xFF, 0x00, 0x00,
  0x0C, 0xF7, 0x05, 0xFD, 0x00, 0x00,
  0x04, 0xFF, 0xDF, 0xE4, 0x00, 0x00,
  0x03, 0xEF, 0xFE, 0x20, 0x00, 0x00,
  0x4F, 0xE9, 0xFF, 0x71, 0x85, 0x00,
  0xCF, 0x40, 0x8F, 0xFC, 0xFD, 0x00,
  0xFF, 0x00, 0x08, 0xFF, 0xF6, 0x00,
  0xDF, 0x80, 0x17, 0xFF, 0xFA, 0x10,
  0x6F, 0xFF, 0xFF, 0xFD, 0xFF, 0xA0,
  0x05, 0xBF, 0xFD, 0x60, 0x6C, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0027[  4] = { /* code 0027, APOSTROPHE */
  0xFF,
  0xFF,
  0xEE,
  0xBC
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0028[ 30] = { /* code 0028, LEFT PARENTHESIS */
  0x04, 0xFB,
  0x0B, 0xF5,
  0x2F, 0xE0,
  0x7F, 0x90,
  0xBF, 0x50,
  0xDF, 0x20,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xDF, 0x20,
  0xAF, 0x50,
  0x6F, 0x90,
  0x2F, 0xD0,
  0x0B, 0xF4,
  0x04, 0xFB
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0029[ 30] = { /* code 0029, RIGHT PARENTHESIS */
  0xBF, 0x40,
  0x5F, 0xB0,
  0x0E, 0xF2,
  0x09, 0xF7,
  0x05, 0xFB,
  0x02, 0xFD,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFE,
  0x02, 0xFC,
  0x05, 0xFA,
  0x09, 0xF6,
  0x0D, 0xF2,
  0x4F, 0xB0,
  0xBF, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_002A[ 12] = { /* code 002A, ASTERISK */
  0x00, 0xF0, 0x00,
  0xBA, 0xC7, 0xA0,
  0x1A, 0xEB, 0x10,
  0x7C, 0x1C, 0x70
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_002B[ 32] = { /* code 002B, PLUS SIGN */
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_002C[  5] = { /* code 002C, COMMA */
  0xFF,
  0xFF,
  0x0F,
  0x7B,
  0xB2
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_002D[  4] = { /* code 002D, HYPHEN-MINUS */
  0xFF, 0xFF,
  0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_002E[  2] = { /* code 002E, FULL STOP */
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_002F[ 24] = { /* code 002F, SOLIDUS */
  0x02, 0xFE,
  0x04, 0xFB,
  0x07, 0xF9,
  0x09, 0xF6,
  0x0C, 0xF4,
  0x0E, 0xF1,
  0x2F, 0xE0,
  0x4F, 0xB0,
  0x7F, 0x90,
  0x9F, 0x60,
  0xCF, 0x40,
  0xEF, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0030[ 48] = { /* code 0030, DIGIT ZERO */
  0x02, 0xBF, 0xFB, 0x20,
  0x1E, 0xFF, 0xFF, 0xE1,
  0x8F, 0xB1, 0x1B, 0xF7,
  0xCF, 0x30, 0x03, 0xFC,
  0xEF, 0x10, 0x01, 0xFE,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xEF, 0x10, 0x01, 0xFE,
  0xCF, 0x30, 0x03, 0xFC,
  0x7F, 0xB1, 0x1B, 0xF8,
  0x1E, 0xFF, 0xFF, 0xE1,
  0x02, 0xAF, 0xFB, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0031[ 36] = { /* code 0031, DIGIT ONE */
  0x00, 0x1E, 0xF0,
  0x00, 0xAF, 0xF0,
  0x3C, 0xFF, 0xF0,
  0xFF, 0x6F, 0xF0,
  0xC4, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0032[ 48] = { /* code 0032, DIGIT TWO */
  0x04, 0xBF, 0xFC, 0x50,
  0x4F, 0xFF, 0xFF, 0xF6,
  0xBF, 0x91, 0x07, 0xFD,
  0xCE, 0x10, 0x00, 0xFF,
  0x00, 0x00, 0x04, 0xFC,
  0x00, 0x00, 0x1D, 0xF6,
  0x00, 0x02, 0xDF, 0xA0,
  0x00, 0x3E, 0xFA, 0x00,
  0x03, 0xEF, 0x80, 0x00,
  0x1E, 0xF7, 0x00, 0x00,
  0x8F, 0xFF, 0xFF, 0xFF,
  0xEF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0033[ 48] = { /* code 0033, DIGIT THREE */
  0x05, 0xCF, 0xFD, 0x80,
  0x7F, 0xFF, 0xFF, 0xF8,
  0xBE, 0x61, 0x04, 0xFF,
  0x00, 0x00, 0x16, 0xFD,
  0x00, 0x0B, 0xFF, 0xE3,
  0x00, 0x0E, 0xFF, 0xE3,
  0x00, 0x01, 0x09, 0xFB,
  0x00, 0x00, 0x01, 0xFF,
  0xBE, 0x20, 0x01, 0xFF,
  0xBF, 0xA1, 0x1A, 0xFB,
  0x3E, 0xFF, 0xFF, 0xE3,
  0x03, 0xBF, 0xFB, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0034[ 48] = { /* code 0034, DIGIT FOUR */
  0x00, 0x00, 0x2E, 0xF0,
  0x00, 0x00, 0xBF, 0xF0,
  0x00, 0x06, 0xFF, 0xF0,
  0x00, 0x2E, 0xEF, 0xF0,
  0x00, 0xBF, 0x5F, 0xF0,
  0x05, 0xFA, 0x0F, 0xF0,
  0x1E, 0xE1, 0x0F, 0xF0,
  0xAF, 0x60, 0x0F, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0035[ 48] = { /* code 0035, DIGIT FIVE */
  0x1F, 0xFF, 0xFF, 0xF0,
  0x3F, 0xFF, 0xFF, 0xF0,
  0x6F, 0xA0, 0x00, 0x00,
  0x8F, 0x80, 0x00, 0x00,
  0xAF, 0xDF, 0xFB, 0x30,
  0xCF, 0xFF, 0xFF, 0xF4,
  0xBE, 0x60, 0x19, 0xFB,
  0x00, 0x00, 0x01, 0xFF,
  0xBE, 0x20, 0x01, 0xFE,
  0xBF, 0xB1, 0x19, 0xFA,
  0x3F, 0xFF, 0xFF, 0xE2,
  0x03, 0xBF, 0xFB, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0036[ 48] = { /* code 0036, DIGIT SIX */
  0x01, 0x8D, 0xFE, 0x91,
  0x0B, 0xFF, 0xFF, 0xF8,
  0x6F, 0xB2, 0x05, 0xEC,
  0xBF, 0x20, 0x00, 0x00,
  0xEE, 0x6C, 0xFB, 0x30,
  0xFF, 0xFF, 0xFF, 0xF4,
  0xFF, 0x91, 0x19, 0xFB,
  0xEF, 0x10, 0x01, 0xFF,
  0xCF, 0x10, 0x00, 0xFF,
  0x7F, 0xA2, 0x08, 0xFB,
  0x1D, 0xFF, 0xFF, 0xF4,
  0x01, 0x9E, 0xFB, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0037[ 48] = { /* code 0037, DIGIT SEVEN */
  0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x1D, 0xF5,
  0x00, 0x00, 0x9F, 0x70,
  0x00, 0x02, 0xFD, 0x00,
  0x00, 0x08, 0xF7, 0x00,
  0x00, 0x0E, 0xF2, 0x00,
  0x00, 0x4F, 0xB0, 0x00,
  0x00, 0x8F, 0x70, 0x00,
  0x00, 0xBF, 0x40, 0x00,
  0x00, 0xDF, 0x10, 0x00,
  0x00, 0xFF, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0038[ 48] = { /* code 0038, DIGIT EIGHT */
  0x06, 0xCF, 0xFC, 0x60,
  0x7F, 0xFF, 0xFF, 0xF7,
  0xEF, 0x71, 0x17, 0xFE,
  0xFF, 0x00, 0x00, 0xFF,
  0xBF, 0x71, 0x17, 0xFB,
  0x2C, 0xFF, 0xFF, 0xC1,
  0x3D, 0xFF, 0xFF, 0xD3,
  0xBF, 0x71, 0x18, 0xFC,
  0xFF, 0x00, 0x00, 0xFF,
  0xEF, 0x71, 0x17, 0xFD,
  0x6F, 0xFF, 0xFF, 0xF6,
  0x05, 0xCF, 0xFC, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0039[ 48] = { /* code 0039, DIGIT NINE */
  0x04, 0xBF, 0xE9, 0x10,
  0x4F, 0xFF, 0xFF, 0xD1,
  0xBF, 0x80, 0x2A, 0xF7,
  0xFF, 0x10, 0x01, 0xFC,
  0xFF, 0x10, 0x01, 0xFE,
  0xBF, 0x91, 0x19, 0xFF,
  0x4F, 0xFF, 0xFF, 0xFF,
  0x03, 0xBF, 0xB6, 0xEE,
  0x00, 0x00, 0x02, 0xFB,
  0xCE, 0x50, 0x2B, 0xF6,
  0x8F, 0xFF, 0xFF, 0xB0,
  0x08, 0xEF, 0xD8, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_003A[  9] = { /* code 003A, COLON */
  0xFF,
  0xFF,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_003B[ 12] = { /* code 003B, SEMICOLON */
  0xFF,
  0xFF,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0xFF,
  0xFF,
  0x1F,
  0x7B,
  0xB2
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_003C[ 36] = { /* code 003C, LESS-THAN SIGN */
  0x00, 0x00, 0x00, 0x4B,
  0x00, 0x00, 0x4B, 0xFF,
  0x00, 0x4B, 0xFF, 0xA3,
  0x4B, 0xFE, 0x82, 0x00,
  0xFF, 0xD2, 0x00, 0x00,
  0x4B, 0xFF, 0x92, 0x00,
  0x00, 0x4B, 0xFF, 0xA3,
  0x00, 0x00, 0x4B, 0xFF,
  0x00, 0x00, 0x00, 0x4B
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_003D[ 20] = { /* code 003D, EQUALS SIGN */
  0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_003E[ 36] = { /* code 003E, GREATER-THAN SIGN */
  0xB4, 0x00, 0x00, 0x00,
  0xFF, 0xB4, 0x00, 0x00,
  0x3A, 0xFF, 0xB4, 0x00,
  0x00, 0x29, 0xFF, 0xB4,
  0x00, 0x00, 0x2D, 0xFF,
  0x00, 0x29, 0xFF, 0xA3,
  0x3A, 0xFF, 0xB3, 0x00,
  0xFF, 0xB4, 0x00, 0x00,
  0xB4, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_003F[ 48] = { /* code 003F, QUESTION MARK */
  0x03, 0xBF, 0xFB, 0x40,
  0x2E, 0xFF, 0xFF, 0xF4,
  0xAF, 0xB2, 0x07, 0xFC,
  0xEF, 0x20, 0x00, 0xFF,
  0x00, 0x00, 0x09, 0xFC,
  0x00, 0x01, 0xBF, 0xE3,
  0x00, 0x09, 0xFE, 0x30,
  0x00, 0x0E, 0xF4, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0040[128] = { /* code 0040, COMMERCIAL AT */
  0x00, 0x00, 0x39, 0xDF, 0xFE, 0xA5, 0x00, 0x00,
  0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xB1, 0x00,
  0x01, 0xDF, 0xE7, 0x30, 0x02, 0x7E, 0xFC, 0x00,
  0x09, 0xFD, 0x27, 0xDF, 0xB4, 0xFC, 0xEF, 0x60,
  0x3F, 0xF2, 0x8F, 0xFF, 0xFE, 0xFA, 0x6F, 0xB0,
  0x8F, 0x94, 0xFE, 0x40, 0x6F, 0xF8, 0x1F, 0xF0,
  0xCF, 0x4A, 0xF7, 0x00, 0x0F, 0xF6, 0x0F, 0xF0,
  0xFF, 0x1E, 0xF1, 0x00, 0x2F, 0xF4, 0x3F, 0xD0,
  0xFF, 0x0F, 0xF0, 0x00, 0x7F, 0xF2, 0x7F, 0x80,
  0xEF, 0x1E, 0xF6, 0x05, 0xEF, 0xF3, 0xEE, 0x10,
  0xBF, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x00,
  0x7F, 0xC0, 0x8E, 0xE8, 0x7F, 0xEA, 0x20, 0x00,
  0x1E, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xB0,
  0x05, 0xFF, 0xD6, 0x30, 0x01, 0x4A, 0xFE, 0x20,
  0x00, 0x4E, 0xFF, 0xFF, 0xFF, 0xFF, 0xD3, 0x00,
  0x00, 0x01, 0x6B, 0xDF, 0xFE, 0xB6, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0041[ 72] = { /* code 0041, LATIN CAPITAL LETTER A */
  0x00, 0x01, 0xEF, 0xE1, 0x00, 0x00,
  0x00, 0x05, 0xFF, 0xF5, 0x00, 0x00,
  0x00, 0x0A, 0xF9, 0xFA, 0x00, 0x00,
  0x00, 0x1F, 0xE1, 0xEF, 0x10, 0x00,
  0x00, 0x6F, 0x90, 0x9F, 0x60, 0x00,
  0x00, 0xBF, 0x40, 0x4F, 0xB0, 0x00,
  0x02, 0xFE, 0x00, 0x0D, 0xF2, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x0B, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0x2F, 0xD0, 0x00, 0x00, 0xEF, 0x20,
  0x7F, 0x80, 0x00, 0x00, 0x9F, 0x70,
  0xCF, 0x30, 0x00, 0x00, 0x3F, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0042[ 60] = { /* code 0042, LATIN CAPITAL LETTER B */
  0xFF, 0xFF, 0xFF, 0xD8, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0xFF, 0x00, 0x00, 0x6F, 0xE0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x7F, 0xC0,
  0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0xFF, 0xFF, 0xFF, 0xFF, 0xE3,
  0xFF, 0x00, 0x00, 0x29, 0xFC,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x17, 0xFD,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF6,
  0xFF, 0xFF, 0xFF, 0xFC, 0x60
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0043[ 60] = { /* code 0043, LATIN CAPITAL LETTER C */
  0x00, 0x6B, 0xEF, 0xEA, 0x20,
  0x09, 0xFF, 0xFF, 0xFF, 0xE3,
  0x4F, 0xF7, 0x10, 0x4D, 0xFC,
  0xAF, 0x70, 0x00, 0x03, 0xB4,
  0xDF, 0x20, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0x20, 0x00, 0x00, 0x00,
  0xAF, 0x70, 0x00, 0x03, 0xB4,
  0x5F, 0xF7, 0x10, 0x4D, 0xFC,
  0x0A, 0xFF, 0xFF, 0xFF, 0xE3,
  0x00, 0x6C, 0xFF, 0xDA, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0044[ 60] = { /* code 0044, LATIN CAPITAL LETTER D */
  0xFF, 0xFF, 0xFF, 0xC6, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0x90,
  0xFF, 0x00, 0x02, 0x7F, 0xF4,
  0xFF, 0x00, 0x00, 0x07, 0xFA,
  0xFF, 0x00, 0x00, 0x02, 0xFD,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x02, 0xFE,
  0xFF, 0x00, 0x00, 0x06, 0xFA,
  0xFF, 0x00, 0x01, 0x5E, 0xF4,
  0xFF, 0xFF, 0xFF, 0xFF, 0x90,
  0xFF, 0xFF, 0xFF, 0xC6, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0045[ 60] = { /* code 0045, LATIN CAPITAL LETTER E */
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0046[ 48] = { /* code 0046, LATIN CAPITAL LETTER F */
  0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0047[ 60] = { /* code 0047, LATIN CAPITAL LETTER G */
  0x00, 0x4B, 0xEF, 0xEB, 0x30,
  0x08, 0xFF, 0xFF, 0xFF, 0xF4,
  0x4F, 0xE6, 0x10, 0x3D, 0xFD,
  0xAF, 0x60, 0x00, 0x03, 0xB4,
  0xDF, 0x20, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x0F, 0xFF, 0xFF,
  0xDF, 0x20, 0x0F, 0xFF, 0xFF,
  0xAF, 0x60, 0x00, 0x00, 0xFF,
  0x4F, 0xE6, 0x10, 0x38, 0xFF,
  0x08, 0xFF, 0xFF, 0xFF, 0xE6,
  0x00, 0x4B, 0xEF, 0xD7, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0048[ 60] = { /* code 0048, LATIN CAPITAL LETTER H */
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0049[ 12] = { /* code 0049, LATIN CAPITAL LETTER I */
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_004A[ 48] = { /* code 004A, LATIN CAPITAL LETTER J */
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x10, 0x01, 0xFF,
  0xCF, 0x91, 0x3A, 0xFC,
  0x5F, 0xFF, 0xFF, 0xF5,
  0x05, 0xCF, 0xFB, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_004B[ 72] = { /* code 004B, LATIN CAPITAL LETTER K */
  0xFF, 0x00, 0x00, 0x07, 0xFD, 0x10,
  0xFF, 0x00, 0x00, 0x7F, 0xD1, 0x00,
  0xFF, 0x00, 0x05, 0xFD, 0x10, 0x00,
  0xFF, 0x00, 0x5F, 0xD1, 0x00, 0x00,
  0xFF, 0x03, 0xFF, 0x20, 0x00, 0x00,
  0xFF, 0x3E, 0xEF, 0x90, 0x00, 0x00,
  0xFF, 0xEB, 0x2E, 0xF3, 0x00, 0x00,
  0xFF, 0xB1, 0x06, 0xFC, 0x00, 0x00,
  0xFF, 0x10, 0x00, 0xCF, 0x60, 0x00,
  0xFF, 0x00, 0x00, 0x3F, 0xE1, 0x00,
  0xFF, 0x00, 0x00, 0x09, 0xF9, 0x00,
  0xFF, 0x00, 0x00, 0x01, 0xEF, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_004C[ 48] = { /* code 004C, LATIN CAPITAL LETTER L */
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_004D[ 72] = { /* code 004D, LATIN CAPITAL LETTER M */
  0xFF, 0xF2, 0x00, 0x02, 0xFF, 0xF0,
  0xFF, 0xF7, 0x00, 0x07, 0xFF, 0xF0,
  0xFF, 0xFB, 0x00, 0x0B, 0xFF, 0xF0,
  0xFF, 0xBF, 0x10, 0x1F, 0xBF, 0xF0,
  0xFF, 0x7F, 0x60, 0x6F, 0x7F, 0xF0,
  0xFF, 0x2F, 0xA0, 0xAF, 0x2F, 0xF0,
  0xFF, 0x0D, 0xE1, 0xED, 0x0F, 0xF0,
  0xFF, 0x09, 0xF8, 0xF9, 0x0F, 0xF0,
  0xFF, 0x04, 0xFF, 0xF4, 0x0F, 0xF0,
  0xFF, 0x01, 0xFF, 0xF1, 0x0F, 0xF0,
  0xFF, 0x00, 0xBF, 0xB0, 0x0F, 0xF0,
  0xFF, 0x00, 0x7F, 0x70, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_004E[ 60] = { /* code 004E, LATIN CAPITAL LETTER N */
  0xFF, 0x70, 0x00, 0x00, 0xFF,
  0xFF, 0xE2, 0x00, 0x00, 0xFF,
  0xFF, 0xFB, 0x00, 0x00, 0xFF,
  0xFF, 0xAF, 0x50, 0x00, 0xFF,
  0xFF, 0x1E, 0xE1, 0x00, 0xFF,
  0xFF, 0x05, 0xF9, 0x00, 0xFF,
  0xFF, 0x00, 0xAF, 0x40, 0xFF,
  0xFF, 0x00, 0x2E, 0xD1, 0xFF,
  0xFF, 0x00, 0x06, 0xF8, 0xFF,
  0xFF, 0x00, 0x00, 0xBF, 0xFF,
  0xFF, 0x00, 0x00, 0x2E, 0xFF,
  0xFF, 0x00, 0x00, 0x06, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_004F[ 60] = { /* code 004F, LATIN CAPITAL LETTER O */
  0x00, 0x6C, 0xFF, 0xC5, 0x00,
  0x08, 0xFF, 0xFF, 0xFF, 0x80,
  0x4F, 0xF6, 0x11, 0x6F, 0xF4,
  0xAF, 0x70, 0x00, 0x07, 0xFA,
  0xDF, 0x20, 0x00, 0x02, 0xFD,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xEF, 0x10, 0x00, 0x01, 0xFD,
  0xAF, 0x70, 0x00, 0x07, 0xFA,
  0x4F, 0xF7, 0x11, 0x6F, 0xF4,
  0x08, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x5C, 0xFF, 0xC5, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0050[ 60] = { /* code 0050, LATIN CAPITAL LETTER P */
  0xFF, 0xFF, 0xFF, 0xC7, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0xFF, 0x00, 0x02, 0x8F, 0xE0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x02, 0x9F, 0xD0,
  0xFF, 0xFF, 0xFF, 0xFF, 0x50,
  0xFF, 0xFF, 0xFE, 0xB4, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0051[ 65] = { /* code 0051, LATIN CAPITAL LETTER Q */
  0x00, 0x5C, 0xFF, 0xC6, 0x00,
  0x08, 0xFF, 0xFF, 0xFF, 0x80,
  0x4F, 0xE6, 0x11, 0x6E, 0xF3,
  0xAF, 0x70, 0x00, 0x07, 0xF9,
  0xDF, 0x20, 0x00, 0x02, 0xFD,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xEF, 0x10, 0x00, 0x00, 0xFE,
  0xAF, 0x70, 0xA9, 0x16, 0xFB,
  0x5F, 0xE5, 0x4E, 0xFF, 0xF5,
  0x0A, 0xFF, 0xFF, 0xFF, 0xC0,
  0x00, 0x7D, 0xFD, 0x7B, 0xF5,
  0x00, 0x00, 0x00, 0x01, 0xA9
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0052[ 72] = { /* code 0052, LATIN CAPITAL LETTER R */
  0xFF, 0xFF, 0xFF, 0xFC, 0x70, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0xFF, 0x00, 0x00, 0x19, 0xFE, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0xFF, 0x00, 0x00, 0x29, 0xFC, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x00,
  0xFF, 0xFF, 0xFF, 0xF8, 0x20, 0x00,
  0xFF, 0x00, 0x5E, 0xFC, 0x10, 0x00,
  0xFF, 0x00, 0x04, 0xFF, 0xB0, 0x00,
  0xFF, 0x00, 0x00, 0x7F, 0xF5, 0x00,
  0xFF, 0x00, 0x00, 0x0B, 0xFE, 0x10,
  0xFF, 0x00, 0x00, 0x02, 0xEF, 0xA0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0053[ 60] = { /* code 0053, LATIN CAPITAL LETTER S */
  0x04, 0xBE, 0xFE, 0xA3, 0x00,
  0x6F, 0xFF, 0xFF, 0xFE, 0x30,
  0xDF, 0x71, 0x02, 0xBF, 0xB0,
  0xFF, 0x30, 0x00, 0x2F, 0xE0,
  0xBF, 0xFA, 0x50, 0x00, 0x00,
  0x1C, 0xFF, 0xFE, 0x92, 0x00,
  0x00, 0x5B, 0xFF, 0xFF, 0x40,
  0x00, 0x00, 0x15, 0xBF, 0xC0,
  0xEF, 0x20, 0x00, 0x1F, 0xF0,
  0xAF, 0xB3, 0x01, 0x9F, 0xD0,
  0x2E, 0xFF, 0xFF, 0xFF, 0x50,
  0x02, 0xAE, 0xFE, 0xB4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0054[ 60] = { /* code 0054, LATIN CAPITAL LETTER T */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0055[ 60] = { /* code 0055, LATIN CAPITAL LETTER U */
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xDF, 0x30, 0x00, 0x02, 0xFD,
  0xAF, 0xD3, 0x00, 0x3B, 0xFB,
  0x2E, 0xFF, 0xFF, 0xFF, 0xE3,
  0x02, 0x9D, 0xFF, 0xEA, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0056[ 84] = { /* code 0056, LATIN CAPITAL LETTER V */
  0x0E, 0xF1, 0x00, 0x00, 0x01, 0xFE, 0x00,
  0x08, 0xF7, 0x00, 0x00, 0x07, 0xF8, 0x00,
  0x02, 0xFD, 0x00, 0x00, 0x0D, 0xF2, 0x00,
  0x00, 0xBF, 0x40, 0x00, 0x4F, 0xB0, 0x00,
  0x00, 0x6F, 0xA0, 0x00, 0xAF, 0x60, 0x00,
  0x00, 0x0E, 0xF1, 0x01, 0xFE, 0x10, 0x00,
  0x00, 0x09, 0xF7, 0x07, 0xF9, 0x00, 0x00,
  0x00, 0x03, 0xFD, 0x0D, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0x9F, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0xFF, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x09, 0xFA, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0057[ 96] = { /* code 0057, LATIN CAPITAL LETTER W */
  0xDF, 0x30, 0x00, 0xEF, 0xE0, 0x00, 0x3F, 0xD0,
  0x8F, 0x70, 0x03, 0xFF, 0xF3, 0x00, 0x7F, 0x80,
  0x4F, 0xC0, 0x05, 0xFF, 0xF5, 0x00, 0xCF, 0x40,
  0x0E, 0xF2, 0x08, 0xFD, 0xF8, 0x01, 0xFE, 0x00,
  0x0A, 0xF6, 0x0B, 0xF6, 0xFB, 0x06, 0xFA, 0x00,
  0x06, 0xFA, 0x0E, 0xF1, 0xFE, 0x0A, 0xF6, 0x00,
  0x01, 0xFE, 0x3F, 0xC0, 0xCF, 0x2E, 0xF2, 0x00,
  0x00, 0xCF, 0x9F, 0x90, 0xAF, 0x9F, 0xC0, 0x00,
  0x00, 0x7F, 0xFF, 0x60, 0x7F, 0xFF, 0x80, 0x00,
  0x00, 0x3F, 0xFF, 0x30, 0x4F, 0xFF, 0x30, 0x00,
  0x00, 0x0D, 0xFF, 0x00, 0x1F, 0xFE, 0x00, 0x00,
  0x00, 0x09, 0xFC, 0x00, 0x0D, 0xFA, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0058[ 72] = { /* code 0058, LATIN CAPITAL LETTER X */
  0x3F, 0xE2, 0x00, 0x02, 0xEF, 0x30,
  0x08, 0xFB, 0x00, 0x0A, 0xF8, 0x00,
  0x00, 0xDF, 0x60, 0x5F, 0xD0, 0x00,
  0x00, 0x3F, 0xE2, 0xEF, 0x30, 0x00,
  0x00, 0x09, 0xFE, 0xF9, 0x00, 0x00,
  0x00, 0x01, 0xDF, 0xD1, 0x00, 0x00,
  0x00, 0x01, 0xDF, 0xD1, 0x00, 0x00,
  0x00, 0x09, 0xFF, 0xF9, 0x00, 0x00,
  0x00, 0x3F, 0xE2, 0xEF, 0x40, 0x00,
  0x00, 0xDF, 0x50, 0x5F, 0xD0, 0x00,
  0x08, 0xFB, 0x00, 0x0B, 0xF8, 0x00,
  0x3F, 0xE2, 0x00, 0x02, 0xEF, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0059[ 72] = { /* code 0059, LATIN CAPITAL LETTER Y */
  0x3F, 0xE1, 0x00, 0x00, 0x1E, 0xF3,
  0x08, 0xFA, 0x00, 0x00, 0xAF, 0x80,
  0x00, 0xDF, 0x40, 0x04, 0xFD, 0x00,
  0x00, 0x3F, 0xD0, 0x0D, 0xF4, 0x00,
  0x00, 0x09, 0xF7, 0x7F, 0x90, 0x00,
  0x00, 0x01, 0xDF, 0xFD, 0x10, 0x00,
  0x00, 0x00, 0x4F, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_005A[ 60] = { /* code 005A, LATIN CAPITAL LETTER Z */
  0x0F, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xA0,
  0x00, 0x00, 0x06, 0xFE, 0x10,
  0x00, 0x00, 0x2E, 0xF5, 0x00,
  0x00, 0x00, 0xBF, 0xA0, 0x00,
  0x00, 0x06, 0xFE, 0x20, 0x00,
  0x00, 0x2E, 0xF6, 0x00, 0x00,
  0x00, 0xAF, 0xB0, 0x00, 0x00,
  0x05, 0xFE, 0x20, 0x00, 0x00,
  0x1E, 0xF6, 0x00, 0x00, 0x00,
  0xAF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_005B[ 30] = { /* code 005B, LEFT SQUARE BRACKET */
  0xFF, 0xFF,
  0xFF, 0xFF,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0xFF,
  0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_005C[ 24] = { /* code 005C, REVERSE SOLIDUS */
  0xEF, 0x10,
  0xCF, 0x40,
  0x9F, 0x60,
  0x7F, 0x90,
  0x4F, 0xB0,
  0x2F, 0xE0,
  0x0E, 0xF1,
  0x0C, 0xF4,
  0x09, 0xF6,
  0x07, 0xF9,
  0x04, 0xFB,
  0x02, 0xFE
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_005D[ 30] = { /* code 005D, RIGHT SQUARE BRACKET */
  0xFF, 0xFF,
  0xFF, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0xFF, 0xFF,
  0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_005E[ 24] = { /* code 005E, CIRCUMFLEX ACCENT */
  0x00, 0x2F, 0xF4, 0x00,
  0x00, 0xAF, 0xFB, 0x00,
  0x03, 0xFD, 0xDF, 0x40,
  0x0A, 0xF6, 0x6F, 0xB0,
  0x3F, 0xC0, 0x0C, 0xF4,
  0xBF, 0x40, 0x04, 0xFB
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_005F[ 10] = { /* code 005F, LOW LINE */
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0060[  4] = { /* code 0060, GRAVE ACCENT */
  0x8F, 0x40,
  0x08, 0xB0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0061[ 36] = { /* code 0061, LATIN SMALL LETTER A */
  0x08, 0xEF, 0xEB, 0x20,
  0x8F, 0xFF, 0xFF, 0xC0,
  0xEF, 0x50, 0x3F, 0xF0,
  0x01, 0x58, 0xCF, 0xF0,
  0x4E, 0xFF, 0xFF, 0xF0,
  0xDF, 0x84, 0x2F, 0xF0,
  0xFF, 0x30, 0x6F, 0xF0,
  0xBF, 0xFF, 0xFE, 0xF2,
  0x1B, 0xFE, 0x93, 0xF9
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0062[ 48] = { /* code 0062, LATIN SMALL LETTER B */
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x4D, 0xFC, 0x40,
  0xFF, 0xFF, 0xFF, 0xF4,
  0xFF, 0xA1, 0x1A, 0xFB,
  0xFF, 0x20, 0x02, 0xFE,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x20, 0x02, 0xFE,
  0xFF, 0xB1, 0x1A, 0xFA,
  0xFF, 0xFF, 0xFF, 0xF3,
  0xFF, 0x4C, 0xFD, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0063[ 36] = { /* code 0063, LATIN SMALL LETTER C */
  0x04, 0xCF, 0xFB, 0x20,
  0x3F, 0xFF, 0xFF, 0xB0,
  0xBF, 0x91, 0x4F, 0xE0,
  0xEF, 0x10, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xEF, 0x10, 0x00, 0x00,
  0xBF, 0x90, 0x4F, 0xD0,
  0x3F, 0xFF, 0xFF, 0x70,
  0x04, 0xCF, 0xE8, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0064[ 48] = { /* code 0064, LATIN SMALL LETTER D */
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x04, 0xCF, 0xD4, 0xFF,
  0x4F, 0xFF, 0xFF, 0xFF,
  0xBF, 0xA1, 0x1A, 0xFF,
  0xEF, 0x20, 0x02, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xEF, 0x20, 0x02, 0xFF,
  0xAF, 0xA1, 0x1A, 0xFF,
  0x3F, 0xFF, 0xFF, 0xFF,
  0x04, 0xDF, 0xD4, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0065[ 36] = { /* code 0065, LATIN SMALL LETTER E */
  0x04, 0xDF, 0xD5, 0x00,
  0x3F, 0xFF, 0xFF, 0x40,
  0xAF, 0x50, 0x4F, 0xB0,
  0xEF, 0xFF, 0xFF, 0xE0,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xEF, 0x10, 0x00, 0x00,
  0xBF, 0x90, 0x5F, 0xD0,
  0x4F, 0xFF, 0xFF, 0x50,
  0x05, 0xCF, 0xE7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0066[ 36] = { /* code 0066, LATIN SMALL LETTER F */
  0x04, 0xCF, 0xFB,
  0x0E, 0xFF, 0xFA,
  0x0F, 0xF1, 0x01,
  0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0067[ 48] = { /* code 0067, LATIN SMALL LETTER G */
  0x04, 0xDF, 0xB2, 0xFF,
  0x4F, 0xFF, 0xFD, 0xFF,
  0xBF, 0xA1, 0x1B, 0xFF,
  0xEF, 0x20, 0x02, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xEF, 0x20, 0x02, 0xFF,
  0xBF, 0xA1, 0x1B, 0xFF,
  0x3F, 0xFF, 0xFC, 0xFF,
  0x05, 0xDF, 0xA1, 0xFF,
  0xFF, 0x40, 0x16, 0xFD,
  0xAF, 0xFF, 0xFF, 0xF7,
  0x19, 0xDF, 0xFD, 0x80
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0068[ 48] = { /* code 0068, LATIN SMALL LETTER H */
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x19, 0xFE, 0x91,
  0xFF, 0xAF, 0xFF, 0xFA,
  0xFF, 0xB2, 0x06, 0xFE,
  0xFF, 0x20, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0069[ 12] = { /* code 0069, LATIN SMALL LETTER I */
  0xFF,
  0xFF,
  0x00,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_006A[ 30] = { /* code 006A, LATIN SMALL LETTER J */
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0x00,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x02, 0xFF,
  0xAF, 0xFC,
  0xCF, 0xD3
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_006B[ 48] = { /* code 006B, LATIN SMALL LETTER K */
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x5F, 0xE2,
  0xFF, 0x05, 0xFE, 0x30,
  0xFF, 0x5F, 0xF4, 0x00,
  0xFF, 0xFF, 0xC0, 0x00,
  0xFF, 0xFF, 0xF5, 0x00,
  0xFF, 0x86, 0xFC, 0x00,
  0xFF, 0x00, 0xDF, 0x40,
  0xFF, 0x00, 0x5F, 0xB0,
  0xFF, 0x00, 0x0B, 0xF4
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_006C[ 12] = { /* code 006C, LATIN SMALL LETTER L */
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_006D[ 54] = { /* code 006D, LATIN SMALL LETTER M */
  0xFF, 0x5C, 0xFC, 0x14, 0xDF, 0xB2,
  0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFB,
  0xFF, 0x90, 0x5F, 0xF9, 0x05, 0xFF,
  0xFF, 0x10, 0x0F, 0xF2, 0x00, 0xFF,
  0xFF, 0x00, 0x0F, 0xF0, 0x00, 0xFF,
  0xFF, 0x00, 0x0F, 0xF0, 0x00, 0xFF,
  0xFF, 0x00, 0x0F, 0xF0, 0x00, 0xFF,
  0xFF, 0x00, 0x0F, 0xF0, 0x00, 0xFF,
  0xFF, 0x00, 0x0F, 0xF0, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_006E[ 36] = { /* code 006E, LATIN SMALL LETTER N */
  0xFF, 0x3B, 0xFE, 0xA1,
  0xFF, 0xFF, 0xFF, 0xFA,
  0xFF, 0xB2, 0x07, 0xFE,
  0xFF, 0x20, 0x01, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_006F[ 36] = { /* code 006F, LATIN SMALL LETTER O */
  0x03, 0xBF, 0xFB, 0x20,
  0x2E, 0xFF, 0xFF, 0xE2,
  0x9F, 0xB1, 0x1B, 0xF9,
  0xEF, 0x20, 0x02, 0xFE,
  0xFF, 0x00, 0x00, 0xFF,
  0xEF, 0x20, 0x02, 0xFE,
  0xAF, 0xB1, 0x1B, 0xF9,
  0x2E, 0xFF, 0xFF, 0xE2,
  0x03, 0xBF, 0xFB, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0070[ 48] = { /* code 0070, LATIN SMALL LETTER P */
  0xFF, 0x5D, 0xFD, 0x40,
  0xFF, 0xFF, 0xFF, 0xF3,
  0xFF, 0xA1, 0x1A, 0xFB,
  0xFF, 0x20, 0x02, 0xFE,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x20, 0x02, 0xFE,
  0xFF, 0xB1, 0x1A, 0xFA,
  0xFF, 0xFF, 0xFF, 0xF3,
  0xFF, 0x4C, 0xFC, 0x40,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0071[ 48] = { /* code 0071, LATIN SMALL LETTER Q */
  0x04, 0xCF, 0xD5, 0xFF,
  0x4F, 0xFF, 0xFF, 0xFF,
  0xBF, 0xA1, 0x1A, 0xFF,
  0xEF, 0x20, 0x02, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xEF, 0x20, 0x03, 0xFF,
  0xAF, 0xA1, 0x2B, 0xFF,
  0x3F, 0xFF, 0xFF, 0xFF,
  0x04, 0xCF, 0xC4, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0072[ 27] = { /* code 0072, LATIN SMALL LETTER R */
  0xFF, 0x5E, 0xC0,
  0xFF, 0xFF, 0xB0,
  0xFF, 0x80, 0x20,
  0xFF, 0x20, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0073[ 36] = { /* code 0073, LATIN SMALL LETTER S */
  0x01, 0xAE, 0xFE, 0x91,
  0x0B, 0xFF, 0xFF, 0xF9,
  0x0F, 0xF2, 0x05, 0xFE,
  0x0D, 0xFD, 0x95, 0x10,
  0x02, 0xCF, 0xFF, 0xE5,
  0x00, 0x03, 0x8B, 0xFE,
  0x0F, 0xF5, 0x03, 0xFF,
  0x0A, 0xFF, 0xFF, 0xFA,
  0x01, 0x9E, 0xFE, 0x91
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0074[ 36] = { /* code 0074, LATIN SMALL LETTER T */
  0x04, 0xB0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF1, 0x10,
  0x0D, 0xFF, 0xA0,
  0x05, 0xEF, 0xB0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0075[ 36] = { /* code 0075, LATIN SMALL LETTER U */
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x10, 0x02, 0xFF,
  0xEF, 0x70, 0x2A, 0xFF,
  0xAF, 0xFF, 0xFF, 0xFF,
  0x1A, 0xFF, 0xB4, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0076[ 45] = { /* code 0076, LATIN SMALL LETTER V */
  0x5F, 0xA0, 0x00, 0xAF, 0x50,
  0x0E, 0xF1, 0x01, 0xFE, 0x00,
  0x0A, 0xF5, 0x05, 0xFA, 0x00,
  0x04, 0xFA, 0x0A, 0xF5, 0x00,
  0x00, 0xEF, 0x1F, 0xE0, 0x00,
  0x00, 0x9F, 0xAF, 0xA0, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x0D, 0xFE, 0x00, 0x00,
  0x00, 0x08, 0xF9, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0077[ 63] = { /* code 0077, LATIN SMALL LETTER W */
  0xDF, 0x20, 0x0C, 0xFD, 0x00, 0x2F, 0xD0,
  0x9F, 0x60, 0x2F, 0xFF, 0x20, 0x6F, 0x90,
  0x5F, 0xA0, 0x7F, 0xFF, 0x70, 0xAF, 0x50,
  0x1F, 0xE0, 0xBF, 0xCF, 0xB0, 0xEF, 0x10,
  0x0C, 0xF3, 0xFF, 0x3F, 0xF3, 0xFC, 0x00,
  0x08, 0xFC, 0xFB, 0x0B, 0xFC, 0xF8, 0x00,
  0x04, 0xFF, 0xF7, 0x07, 0xFF, 0xF4, 0x00,
  0x01, 0xFF, 0xF2, 0x02, 0xFF, 0xF1, 0x00,
  0x00, 0xCF, 0xC0, 0x00, 0xBF, 0xC0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0078[ 45] = { /* code 0078, LATIN SMALL LETTER X */
  0x3F, 0xE1, 0x01, 0xDF, 0x30,
  0x08, 0xF8, 0x09, 0xF7, 0x00,
  0x01, 0xDF, 0x6F, 0xC0, 0x00,
  0x00, 0x4F, 0xFF, 0x30, 0x00,
  0x00, 0x0D, 0xFC, 0x00, 0x00,
  0x00, 0x6F, 0xFF, 0x60, 0x00,
  0x01, 0xEF, 0x9F, 0xE1, 0x00,
  0x09, 0xF9, 0x0A, 0xF9, 0x00,
  0x3F, 0xE1, 0x01, 0xEF, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_0079[ 72] = { /* code 0079, LATIN SMALL LETTER Y */
  0x1F, 0xE0, 0x00, 0x00, 0xEF, 0x10,
  0x0A, 0xF6, 0x00, 0x06, 0xFA, 0x00,
  0x04, 0xFC, 0x00, 0x0C, 0xF3, 0x00,
  0x00, 0xDF, 0x40, 0x4F, 0xC0, 0x00,
  0x00, 0x7F, 0xA0, 0xAF, 0x60, 0x00,
  0x00, 0x2F, 0xF4, 0xFE, 0x10, 0x00,
  0x00, 0x0B, 0xFE, 0xF9, 0x00, 0x00,
  0x00, 0x04, 0xFF, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0xEF, 0xC0, 0x00, 0x00,
  0x00, 0x02, 0xEF, 0x60, 0x00, 0x00,
  0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00,
  0x00, 0xEF, 0xC3, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_007A[ 36] = { /* code 007A, LATIN SMALL LETTER Z */
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x8F, 0x70,
  0x00, 0x08, 0xF8, 0x00,
  0x00, 0x8F, 0x80, 0x00,
  0x08, 0xF8, 0x00, 0x00,
  0x7F, 0x80, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_007B[ 45] = { /* code 007B, LEFT CURLY BRACKET */
  0x00, 0x3B, 0xFF,
  0x00, 0xCF, 0xFF,
  0x00, 0xFF, 0x30,
  0x00, 0xFF, 0x00,
  0x01, 0xFF, 0x00,
  0x18, 0xFD, 0x00,
  0xFF, 0xE4, 0x00,
  0xFF, 0xE3, 0x00,
  0x18, 0xFB, 0x00,
  0x01, 0xFE, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xEF, 0x30,
  0x00, 0xBF, 0xFF,
  0x00, 0x2B, 0xEF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_007C[ 15] = { /* code 007C, VERTICAL LINE */
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_007D[ 45] = { /* code 007D, RIGHT CURLY BRACKET */
  0xFF, 0xB3, 0x00,
  0xFF, 0xFC, 0x00,
  0x03, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x10,
  0x00, 0xCF, 0x81,
  0x00, 0x4E, 0xFF,
  0x00, 0x3E, 0xFF,
  0x00, 0xBF, 0x71,
  0x00, 0xFF, 0x10,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x03, 0xFE, 0x00,
  0xFF, 0xFB, 0x00,
  0xFE, 0xB2, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_007E[ 12] = { /* code 007E, TILDE */
  0x6E, 0xFB, 0x61, 0x29,
  0xFF, 0xFF, 0xFF, 0xFF,
  0x91, 0x15, 0xBF, 0xD6
};

/* Start of unicode area <Latin-1 Supplement> */
GUI_CONST_STORAGE unsigned char acGUI_FontF19B_AA_00B0[ 15] = { /* code 00B0, DEGREE SIGN */
  0x2C, 0xFC, 0x20,
  0xC7, 0x07, 0xC0,
  0xF0, 0x00, 0xF0,
  0xC7, 0x07, 0xC0,
  0x2C, 0xFC, 0x20
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontF19B_AA_CharInfo[96] = {
   {   1,   1,   0,  15,   4, acGUI_FontF19B_AA_0020 } /* code 0020, SPACE */
  ,{   2,  12,   1,   3,   4, acGUI_FontF19B_AA_0021 } /* code 0021, EXCLAMATION MARK */
  ,{   6,   4,   1,   3,   8, acGUI_FontF19B_AA_0022 } /* code 0022, QUOTATION MARK */
  ,{   7,  12,   1,   3,   9, acGUI_FontF19B_AA_0023 } /* code 0023, NUMBER SIGN */
  ,{   7,  14,   1,   2,   9, acGUI_FontF19B_AA_0024 } /* code 0024, DOLLAR SIGN */
  ,{  15,  12,   0,   3,  16, acGUI_FontF19B_AA_0025 } /* code 0025, PERCENT SIGN */
  ,{  11,  12,   1,   3,  12, acGUI_FontF19B_AA_0026 } /* code 0026, AMPERSAND */
  ,{   2,   4,   1,   3,   4, acGUI_FontF19B_AA_0027 } /* code 0027, APOSTROPHE */
  ,{   4,  15,   1,   3,   5, acGUI_FontF19B_AA_0028 } /* code 0028, LEFT PARENTHESIS */
  ,{   4,  15,   0,   3,   5, acGUI_FontF19B_AA_0029 } /* code 0029, RIGHT PARENTHESIS */
  ,{   5,   4,   0,   3,   6, acGUI_FontF19B_AA_002A } /* code 002A, ASTERISK */
  ,{   8,   8,   0,   5,   9, acGUI_FontF19B_AA_002B } /* code 002B, PLUS SIGN */
  ,{   2,   5,   1,  13,   4, acGUI_FontF19B_AA_002C } /* code 002C, COMMA */
  ,{   4,   2,   1,  10,   5, acGUI_FontF19B_AA_002D } /* code 002D, HYPHEN-MINUS */
  ,{   2,   2,   1,  13,   4, acGUI_FontF19B_AA_002E } /* code 002E, FULL STOP */
  ,{   4,  12,   0,   3,   4, acGUI_FontF19B_AA_002F } /* code 002F, SOLIDUS */
  ,{   8,  12,   0,   3,   9, acGUI_FontF19B_AA_0030 } /* code 0030, DIGIT ZERO */
  ,{   5,  12,   1,   3,   9, acGUI_FontF19B_AA_0031 } /* code 0031, DIGIT ONE */
  ,{   8,  12,   0,   3,   9, acGUI_FontF19B_AA_0032 } /* code 0032, DIGIT TWO */
  ,{   8,  12,   0,   3,   9, acGUI_FontF19B_AA_0033 } /* code 0033, DIGIT THREE */
  ,{   8,  12,   0,   3,   9, acGUI_FontF19B_AA_0034 } /* code 0034, DIGIT FOUR */
  ,{   8,  12,   0,   3,   9, acGUI_FontF19B_AA_0035 } /* code 0035, DIGIT FIVE */
  ,{   8,  12,   0,   3,   9, acGUI_FontF19B_AA_0036 } /* code 0036, DIGIT SIX */
  ,{   8,  12,   0,   3,   9, acGUI_FontF19B_AA_0037 } /* code 0037, DIGIT SEVEN */
  ,{   8,  12,   0,   3,   9, acGUI_FontF19B_AA_0038 } /* code 0038, DIGIT EIGHT */
  ,{   8,  12,   0,   3,   9, acGUI_FontF19B_AA_0039 } /* code 0039, DIGIT NINE */
  ,{   2,   9,   2,   6,   6, acGUI_FontF19B_AA_003A } /* code 003A, COLON */
  ,{   2,  12,   2,   6,   6, acGUI_FontF19B_AA_003B } /* code 003B, SEMICOLON */
  ,{   8,   9,   0,   5,   9, acGUI_FontF19B_AA_003C } /* code 003C, LESS-THAN SIGN */
  ,{   8,   5,   0,   6,   9, acGUI_FontF19B_AA_003D } /* code 003D, EQUALS SIGN */
  ,{   8,   9,   0,   5,   9, acGUI_FontF19B_AA_003E } /* code 003E, GREATER-THAN SIGN */
  ,{   8,  12,   1,   3,  10, acGUI_FontF19B_AA_003F } /* code 003F, QUESTION MARK */
  ,{  15,  16,   1,   3,  16, acGUI_FontF19B_AA_0040 } /* code 0040, COMMERCIAL AT */
  ,{  11,  12,   0,   3,  11, acGUI_FontF19B_AA_0041 } /* code 0041, LATIN CAPITAL LETTER A */
  ,{  10,  12,   1,   3,  12, acGUI_FontF19B_AA_0042 } /* code 0042, LATIN CAPITAL LETTER B */
  ,{  10,  12,   1,   3,  12, acGUI_FontF19B_AA_0043 } /* code 0043, LATIN CAPITAL LETTER C */
  ,{  10,  12,   1,   3,  12, acGUI_FontF19B_AA_0044 } /* code 0044, LATIN CAPITAL LETTER D */
  ,{   9,  12,   1,   3,  11, acGUI_FontF19B_AA_0045 } /* code 0045, LATIN CAPITAL LETTER E */
  ,{   8,  12,   1,   3,  10, acGUI_FontF19B_AA_0046 } /* code 0046, LATIN CAPITAL LETTER F */
  ,{  10,  12,   1,   3,  12, acGUI_FontF19B_AA_0047 } /* code 0047, LATIN CAPITAL LETTER G */
  ,{  10,  12,   1,   3,  12, acGUI_FontF19B_AA_0048 } /* code 0048, LATIN CAPITAL LETTER H */
  ,{   2,  12,   1,   3,   4, acGUI_FontF19B_AA_0049 } /* code 0049, LATIN CAPITAL LETTER I */
  ,{   8,  12,   0,   3,   9, acGUI_FontF19B_AA_004A } /* code 004A, LATIN CAPITAL LETTER J */
  ,{  11,  12,   1,   3,  12, acGUI_FontF19B_AA_004B } /* code 004B, LATIN CAPITAL LETTER K */
  ,{   8,  12,   1,   3,  10, acGUI_FontF19B_AA_004C } /* code 004C, LATIN CAPITAL LETTER L */
  ,{  11,  12,   1,   3,  13, acGUI_FontF19B_AA_004D } /* code 004D, LATIN CAPITAL LETTER M */
  ,{  10,  12,   1,   3,  12, acGUI_FontF19B_AA_004E } /* code 004E, LATIN CAPITAL LETTER N */
  ,{  10,  12,   1,   3,  12, acGUI_FontF19B_AA_004F } /* code 004F, LATIN CAPITAL LETTER O */
  ,{   9,  12,   1,   3,  11, acGUI_FontF19B_AA_0050 } /* code 0050, LATIN CAPITAL LETTER P */
  ,{  10,  13,   1,   3,  12, acGUI_FontF19B_AA_0051 } /* code 0051, LATIN CAPITAL LETTER Q */
  ,{  11,  12,   1,   3,  12, acGUI_FontF19B_AA_0052 } /* code 0052, LATIN CAPITAL LETTER R */
  ,{   9,  12,   1,   3,  11, acGUI_FontF19B_AA_0053 } /* code 0053, LATIN CAPITAL LETTER S */
  ,{  10,  12,   0,   3,  10, acGUI_FontF19B_AA_0054 } /* code 0054, LATIN CAPITAL LETTER T */
  ,{  10,  12,   1,   3,  12, acGUI_FontF19B_AA_0055 } /* code 0055, LATIN CAPITAL LETTER U */
  ,{  13,  12,  -1,   3,  11, acGUI_FontF19B_AA_0056 } /* code 0056, LATIN CAPITAL LETTER V */
  ,{  15,  12,   0,   3,  15, acGUI_FontF19B_AA_0057 } /* code 0057, LATIN CAPITAL LETTER W */
  ,{  11,  12,   0,   3,  11, acGUI_FontF19B_AA_0058 } /* code 0058, LATIN CAPITAL LETTER X */
  ,{  12,  12,  -1,   3,  10, acGUI_FontF19B_AA_0059 } /* code 0059, LATIN CAPITAL LETTER Y */
  ,{   9,  12,   0,   3,   9, acGUI_FontF19B_AA_005A } /* code 005A, LATIN CAPITAL LETTER Z */
  ,{   4,  15,   1,   3,   5, acGUI_FontF19B_AA_005B } /* code 005B, LEFT SQUARE BRACKET */
  ,{   4,  12,   0,   3,   4, acGUI_FontF19B_AA_005C } /* code 005C, REVERSE SOLIDUS */
  ,{   4,  15,   0,   3,   5, acGUI_FontF19B_AA_005D } /* code 005D, RIGHT SQUARE BRACKET */
  ,{   8,   6,   0,   3,   9, acGUI_FontF19B_AA_005E } /* code 005E, CIRCUMFLEX ACCENT */
  ,{   9,   2,   0,  16,   9, acGUI_FontF19B_AA_005F } /* code 005F, LOW LINE */
  ,{   3,   2,   0,   3,   5, acGUI_FontF19B_AA_0060 } /* code 0060, GRAVE ACCENT */
  ,{   8,   9,   1,   6,   9, acGUI_FontF19B_AA_0061 } /* code 0061, LATIN SMALL LETTER A */
  ,{   8,  12,   1,   3,  10, acGUI_FontF19B_AA_0062 } /* code 0062, LATIN SMALL LETTER B */
  ,{   7,   9,   1,   6,   9, acGUI_FontF19B_AA_0063 } /* code 0063, LATIN SMALL LETTER C */
  ,{   8,  12,   1,   3,  10, acGUI_FontF19B_AA_0064 } /* code 0064, LATIN SMALL LETTER D */
  ,{   7,   9,   1,   6,   9, acGUI_FontF19B_AA_0065 } /* code 0065, LATIN SMALL LETTER E */
  ,{   6,  12,   0,   3,   5, acGUI_FontF19B_AA_0066 } /* code 0066, LATIN SMALL LETTER F */
  ,{   8,  12,   1,   6,  10, acGUI_FontF19B_AA_0067 } /* code 0067, LATIN SMALL LETTER G */
  ,{   8,  12,   1,   3,  10, acGUI_FontF19B_AA_0068 } /* code 0068, LATIN SMALL LETTER H */
  ,{   2,  12,   1,   3,   4, acGUI_FontF19B_AA_0069 } /* code 0069, LATIN SMALL LETTER I */
  ,{   4,  15,  -1,   3,   4, acGUI_FontF19B_AA_006A } /* code 006A, LATIN SMALL LETTER J */
  ,{   8,  12,   1,   3,   9, acGUI_FontF19B_AA_006B } /* code 006B, LATIN SMALL LETTER K */
  ,{   2,  12,   1,   3,   4, acGUI_FontF19B_AA_006C } /* code 006C, LATIN SMALL LETTER L */
  ,{  12,   9,   1,   6,  14, acGUI_FontF19B_AA_006D } /* code 006D, LATIN SMALL LETTER M */
  ,{   8,   9,   1,   6,  10, acGUI_FontF19B_AA_006E } /* code 006E, LATIN SMALL LETTER N */
  ,{   8,   9,   1,   6,  10, acGUI_FontF19B_AA_006F } /* code 006F, LATIN SMALL LETTER O */
  ,{   8,  12,   1,   6,  10, acGUI_FontF19B_AA_0070 } /* code 0070, LATIN SMALL LETTER P */
  ,{   8,  12,   1,   6,  10, acGUI_FontF19B_AA_0071 } /* code 0071, LATIN SMALL LETTER Q */
  ,{   5,   9,   1,   6,   6, acGUI_FontF19B_AA_0072 } /* code 0072, LATIN SMALL LETTER R */
  ,{   8,   9,   0,   6,   9, acGUI_FontF19B_AA_0073 } /* code 0073, LATIN SMALL LETTER S */
  ,{   5,  12,   0,   3,   5, acGUI_FontF19B_AA_0074 } /* code 0074, LATIN SMALL LETTER T */
  ,{   8,   9,   1,   6,  10, acGUI_FontF19B_AA_0075 } /* code 0075, LATIN SMALL LETTER U */
  ,{   9,   9,   0,   6,   9, acGUI_FontF19B_AA_0076 } /* code 0076, LATIN SMALL LETTER V */
  ,{  13,   9,   0,   6,  13, acGUI_FontF19B_AA_0077 } /* code 0077, LATIN SMALL LETTER W */
  ,{   9,   9,   0,   6,   9, acGUI_FontF19B_AA_0078 } /* code 0078, LATIN SMALL LETTER X */
  ,{  11,  12,  -1,   6,   9, acGUI_FontF19B_AA_0079 } /* code 0079, LATIN SMALL LETTER Y */
  ,{   7,   9,   1,   6,   9, acGUI_FontF19B_AA_007A } /* code 007A, LATIN SMALL LETTER Z */
  ,{   6,  15,   0,   3,   6, acGUI_FontF19B_AA_007B } /* code 007B, LEFT CURLY BRACKET */
  ,{   2,  15,   1,   3,   4, acGUI_FontF19B_AA_007C } /* code 007C, VERTICAL LINE */
  ,{   6,  15,   0,   3,   6, acGUI_FontF19B_AA_007D } /* code 007D, RIGHT CURLY BRACKET */
  ,{   8,   3,   1,   8,   9, acGUI_FontF19B_AA_007E } /* code 007E, TILDE */
  ,{   5,   5,   0,   3,   6, acGUI_FontF19B_AA_00B0 } /* code 00B0, DEGREE SIGN */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontF19B_AA_Prop2 = {
   0x00B0 /* first character */
  ,0x00B0 /* last character  */
  ,&GUI_FontF19B_AA_CharInfo[ 95] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontF19B_AA_Prop1 = {
   0x0020 /* first character */
  ,0x007E /* last character  */
  ,&GUI_FontF19B_AA_CharInfo[  0] /* address of first character */
  ,&GUI_FontF19B_AA_Prop2 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT GUI_FontF19B_AA = {
   GUI_FONTTYPE_PROP_AA4_EXT /* type of font    */
  ,19 /* height of font  */
  ,19 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_FontF19B_AA_Prop1}
  ,19 /* Baseline */
  ,9 /* Height of lowercase characters */
  ,12 /* Height of capital characters */
};

/*************************** End of file ****************************/
