/*------------------------------------------------------------------------------
 * MDK Middleware - Component ::USB:Host
 * Copyright (c) 2004-2014 ARM Germany GmbH. All rights reserved.
 *------------------------------------------------------------------------------
 * Name:    USBH_User_CustomClass.c
 * Purpose: USB Host Custom Class User module
 * Rev.:    V6.00
 *----------------------------------------------------------------------------*/
/**
 * \addtogroup usbh_custom_classFunctions
 *
 */


//! [code_USBH_User_CustomClass]

#include <stdint.h>

#include "rl_usbh.h"

// These commented variable declarations are a part of example code
// uint8_t            ctrl;
// ARM_USBH_EP_HANDLE ep_hndl;

/// \brief Callback function called when custom class device is connected and needs
///        to configure resources used by custom class device instance
/// \param[in]     ptr_dev           pointer to device structure.
/// \param[in]     ptr_cfg_desc      pointer to configuration descriptor.
/// \return        value >= 0        index of configured custom class device instance.
/// \return        value <  0        configuration failed.
int8_t USBH_CustomClass_Configure (USBH_DEV *ptr_dev, USB_CONFIGURATION_DESCRIPTOR *ptr_cfg_desc) {
  // Add code for configuring device
  //
  // for example add endpoint to system:
  //
  // USB_ENDPOINT_DESCRIPTOR *ptr_ep_desc;
  // ctrl        = ptr_dev->ctrl;
  // ptr_ep_desc = (USB_ENDPOINT_DESCRIPTOR *)((uint32_t)ptr_if_desc + ptr_if_desc->bLength);
  // ep_hndl     = USBH_DriverEndpointCreate (ptr_dev->ctrl, ptr_dev->dev_addr, ptr_dev->dev_speed, 0, 0, ptr_ep_desc->bEndpointAddress, ptr_ep_desc->bmAttributes & USB_ENDPOINT_TYPE_MASK, ptr_ep_desc->wMaxPacketSize & 0x7FF, ptr_ep_desc->bInterval);
  return 0;
}

/// \brief Callback function called when custom class device is disconnected and needs
///        to unconfigure resources used by custom class device instance
/// \param[in]     instance          index of custom class device instance.
/// \return                          status code that indicates the execution status of the function as defined with \ref usbStatus.
usbStatus USBH_CustomClass_Unconfigure (int8_t instance) {
  // Add code for unconfiguring device
  //
  // for example delete endpoint from system:
  //
  // USBH_DriverEndpointDelete (ctrl, ep_hndl)
  return usbOK;
}

/// \brief Callback function called when custom class device is connected and needs
///        to initialize custom class device instance
/// \param[in]     instance          index of custom class device instance.
/// \return                          status code that indicates the execution status of the function as defined with \ref usbStatus.
usbStatus USBH_CustomClass_Initialize (int8_t instance) {
  // Add code for initializing device
  return usbOK;
}

/// \brief Callback function called when custom class device is disconnected and needs
///        to uninitialize custom class device instance
/// \param[in]     instance          index of custom class device instance.
/// \return                          status code that indicates the execution status of the function as defined with \ref usbStatus.
usbStatus USBH_CustomClass_Uninitialize (int8_t instance) {
  // Add code for de-initializing device
  return usbOK;
}

//! [code_USBH_User_CustomClass]
