/*------------------------------------------------------------------------------
 * MDK Middleware - Component ::USB:Host
 * Copyright (c) 2004-2014 ARM Germany GmbH. All rights reserved.
 *------------------------------------------------------------------------------
 * Name:    usbh_config_hc_2.c
 * Purpose: USB Host Host Controller 2 Data and Settings
 * Rev.:    V6.00
 *----------------------------------------------------------------------------*/

#if     (USBH2_HC_IF == 0)              // Custom

#if     (USBH2_HC_MEM_POOL_RELOC == 1)
#define  __AT_MEM2(x)                               __attribute__((at(x)))
#else
#define  __AT_MEM2(x)
#endif
#define  __ALIGNED_MEM2(x)                          __attribute__((aligned(x)))

         USBH_EP_TID_t        usbh2_ep_tid           [USBH2_HC_ENDPOINT_NUM];

extern   ARM_DRIVER_USBH                              USBHn_DRIVER(USBH2_HC_NUM);
const    ARM_DRIVER_USBH     *usbh2_hcd_ptr  =       &USBHn_DRIVER(USBH2_HC_NUM);
const    ARM_DRIVER_USBH_HCI *usbh2_hci_hcd_ptr =     NULL;

         uint32_t             usbh2_mem_pool        [(USBH2_HC_MEM_POOL_SIZE + 8 + 4 +3)/4] __AT_MEM2(USBH2_HC_MEM_POOL_ADDR);
const    uint32_t             usbh2_mem_pool_size = ((USBH2_HC_MEM_POOL_SIZE + 8 + 4 +3)/4)*4;

         USBH_HC_t            usbh2_hc       =      { USBH2_HC_ENDPOINT_NUM };
         USBH_HC_t           *usbh2_hc_ptr   =       &usbh2_hc;
         USBH_OHCI_t         *usbh2_ohci_ptr =        NULL;
         USBH_EHCI_t         *usbh2_ehci_ptr =        NULL;

#elif   (USBH2_HC_IF == 1)              // OHCI

#if     (USBH2_HC_OHCI_MEM_POOL_RELOC == 1)
#define  __AT_MEM2(x)                               __attribute__((at(x)))
#else
#define  __AT_MEM2(x)
#endif
#define  __ALIGNED_MEM2(x)                          __attribute__((aligned(x)))

         USBH_EP_TID_t        usbh2_ep_tid           [USBH2_HC_OHCI_ENDPOINT_NUM];

extern   ARM_DRIVER_USBH                              USBHn_DRIVER_OHCI_LIB(2);
const    ARM_DRIVER_USBH     *usbh2_hcd_ptr =        &USBHn_DRIVER_OHCI_LIB(2);

extern   ARM_DRIVER_USBH_HCI                          USBHn_DRIVER_HCI(USBH2_HC_NUM);
const    ARM_DRIVER_USBH_HCI *usbh2_hci_hcd_ptr =    &USBHn_DRIVER_HCI(USBH2_HC_NUM);

#define  USBH2_OHCI_MEM_HCCA                         (USBH2_HC_OHCI_MEM_POOL_ADDR)
#define  USBH2_OHCI_MEM_HCCA_SIZE                    (256)
#define  USBH2_OHCI_MEM_ED                           (USBH2_OHCI_MEM_HCCA + USBH2_OHCI_MEM_HCCA_SIZE)
#define  USBH2_OHCI_MEM_ED_SIZE                      (USBH2_HC_OHCI_ENDPOINT_NUM*16)
#define  USBH2_OHCI_MEM_TD                           (USBH2_OHCI_MEM_ED   + USBH2_OHCI_MEM_ED_SIZE)
#define  USBH2_OHCI_MEM_TD_SIZE                      (USBH2_HC_OHCI_TRANSFER_NUM*16)
#define  USBH2_OHCI_MEM_POOL_ADDR                    (USBH2_OHCI_MEM_HCCA + USBH2_OHCI_MEM_HCCA_SIZE + USBH2_OHCI_MEM_ED_SIZE + USBH2_OHCI_MEM_TD_SIZE)
#define  USBH2_OHCI_MEM_POOL_SIZE                    (USBH2_HC_OHCI_MEM_POOL_SIZE + 8 + 4)

         uint32_t             usbh2_ohci_hcca       [(USBH2_OHCI_MEM_HCCA_SIZE +3)/4] __AT_MEM2(USBH2_OHCI_MEM_HCCA);
         uint32_t             usbh2_ohci_ed         [(USBH2_OHCI_MEM_ED_SIZE   +3)/4] __AT_MEM2(USBH2_OHCI_MEM_ED);
         uint32_t             usbh2_ohci_td         [(USBH2_OHCI_MEM_TD_SIZE   +3)/4] __AT_MEM2(USBH2_OHCI_MEM_TD);
         uint32_t             usbh2_mem_pool        [(USBH2_OHCI_MEM_POOL_SIZE +3)/4] __AT_MEM2(USBH2_OHCI_MEM_POOL_ADDR);
const    uint32_t             usbh2_mem_pool_size = ((USBH2_OHCI_MEM_POOL_SIZE +3)/4)*4;

         USBH_OHCI_t          usbh2_ohci = {         (uint32_t *)USBH2_HC_OHCI_BASE_ADDRESS,
                                                      USBH2_HC_OHCI_ENDPOINT_NUM,
                                                      USBH2_HC_OHCI_TRANSFER_NUM,
                                                      0,
                                                     &usbh2_ohci_hcca[0],
                                                     &usbh2_ohci_ed[0],
                                                     &usbh2_ohci_td[0],
                                                      NULL };
         USBH_HC_t           *usbh2_hc_ptr   =        NULL;
         USBH_OHCI_t         *usbh2_ohci_ptr =       &usbh2_ohci;
         USBH_EHCI_t         *usbh2_ehci_ptr =        NULL;

#elif   (USBH2_HC_IF == 2)              // NXP EHCI with extensions for full/low-speed support

#if     (USBH2_HC_EHCI_MEM_POOL_RELOC == 1)
#define  __AT_MEM2(x)                               __attribute__((at(x)))
#else
#define  __AT_MEM2(x)
#endif
#define  __ALIGNED_MEM2(x)                          __attribute__((aligned(x)))

         USBH_EP_TID_t        usbh2_ep_tid           [USBH2_HC_EHCI_ENDPOINT_NUM];

extern   ARM_DRIVER_USBH                              USBHn_DRIVER_EHCI_LIB(2);
const    ARM_DRIVER_USBH     *usbh2_hcd_ptr =        &USBHn_DRIVER_EHCI_LIB(2);

extern   ARM_DRIVER_USBH_HCI                          USBHn_DRIVER_HCI(USBH2_HC_NUM);
const    ARM_DRIVER_USBH_HCI *usbh2_hci_hcd_ptr =    &USBHn_DRIVER_HCI(USBH2_HC_NUM);

#define  USBH2_EHCI_MEM_PFL                          (USBH2_HC_EHCI_MEM_POOL_ADDR + (((_USBH2_HC_EHCI_MEM_POOL_SIZE + 3)/4)*4))
#define  USBH2_EHCI_MEM_PFL_SIZE                     (4096)
#define  USBH2_EHCI_MEM_QH                           (USBH2_EHCI_MEM_PFL  + USBH2_EHCI_MEM_PFL_SIZE)
#define  USBH2_EHCI_MEM_QH_SIZE                      (USBH2_HC_EHCI_ENDPOINT_NUM*64)
#define  USBH2_EHCI_MEM_QTD                          (USBH2_EHCI_MEM_QH   + USBH2_EHCI_MEM_QH_SIZE)
#define  USBH2_EHCI_MEM_QTD_SIZE                     (USBH2_HC_EHCI_TRANSFER_NUM*32)
#define  USBH2_EHCI_MEM_POOL_ADDR                    (USBH2_EHCI_MEM_PFL + USBH2_EHCI_MEM_PFL_SIZE + USBH2_OHCI_MEM_QH_SIZE + USBH2_OHCI_MEM_QTD_SIZE)
#define  USBH2_EHCI_MEM_POOL_SIZE                    (USBH2_HC_EHCI_MEM_POOL_SIZE + 8 + 4)

         uint32_t             usbh2_ehci_pfl        [(USBH2_EHCI_MEM_PFL_SIZE     +3)/4] __AT_MEM2(USBH2_EHCI_MEM_PFL) __ALIGNED_MEM2(4096);
         uint32_t             usbh2_ehci_qh         [(USBH2_EHCI_MEM_QH_SIZE      +3)/4] __AT_MEM2(USBH2_EHCI_MEM_QH);
         uint32_t             usbh2_ehci_qtd        [(USBH2_EHCI_MEM_QTD_SIZE     +3)/4] __AT_MEM2(USBH2_EHCI_MEM_QTD) __ALIGNED_MEM2(32);
         uint32_t             usbh2_mem_pool        [(USBH2_HC_EHCI_MEM_POOL_SIZE +3)/4] __AT_MEM2(USBH2_EHCI_MEM_POOL_ADDR);
const    uint32_t             usbh2_mem_pool_size = ((USBH2_HC_EHCI_MEM_POOL_SIZE +3)/4)*4;

         USBH_EHCI_t          usbh2_ehci = {         (uint32_t *)USBH2_HC_EHCI_BASE_ADDRESS,
                                                      USBH2_HC_EHCI_ENDPOINT_NUM,
                                                      USBH2_HC_EHCI_TRANSFER_NUM,
                                                      0,
                                                      0,
                                                      1024,
                                                     &usbh2_ehci_pfl[0],
                                                     &usbh2_ehci_qh[0],
                                                     &usbh2_ehci_qtd[0],
                                                      NULL,
                                                      NULL,
                                                      NULL };
         USBH_HC_t           *usbh2_hc_ptr   =        NULL;
         USBH_EHCI_t         *usbh2_ehci_ptr =       &usbh2_ehci;
         USBH_OHCI_t         *usbh2_ohci_ptr =        NULL;
#endif
