/*------------------------------------------------------------------------------
 * MDK Middleware - Component ::USB:Host
 * Copyright (c) 2004-2014 ARM Germany GmbH. All rights reserved.
 *------------------------------------------------------------------------------
 * Name:    usbh_config_hc_0.c
 * Purpose: USB Host Host Controller 0 Data and Settings
 * Rev.:    V6.00
 *----------------------------------------------------------------------------*/

#if     (USBH0_HC_IF == 0)              // Custom

#if     (USBH0_HC_MEM_POOL_RELOC == 1)
#define  __AT_MEM0(x)                               __attribute__((at(x)))
#else
#define  __AT_MEM0(x)
#endif
#define  __ALIGNED_MEM0(x)                          __attribute__((aligned(x)))

         USBH_EP_TID_t        usbh0_ep_tid           [USBH0_HC_ENDPOINT_NUM];

extern   ARM_DRIVER_USBH                              USBHn_DRIVER(USBH0_HC_NUM);
const    ARM_DRIVER_USBH     *usbh0_hcd_ptr  =       &USBHn_DRIVER(USBH0_HC_NUM);
const    ARM_DRIVER_USBH_HCI *usbh0_hci_hcd_ptr =     NULL;

         uint32_t             usbh0_mem_pool        [(USBH0_HC_MEM_POOL_SIZE + 8 + 4 +3)/4] __AT_MEM0(USBH0_HC_MEM_POOL_ADDR);
const    uint32_t             usbh0_mem_pool_size = ((USBH0_HC_MEM_POOL_SIZE + 8 + 4 +3)/4)*4;

         USBH_HC_t            usbh0_hc       =      { USBH0_HC_ENDPOINT_NUM };
         USBH_HC_t           *usbh0_hc_ptr   =       &usbh0_hc;
         USBH_OHCI_t         *usbh0_ohci_ptr =        NULL;
         USBH_EHCI_t         *usbh0_ehci_ptr =        NULL;

#elif   (USBH0_HC_IF == 1)              // OHCI

#if     (USBH0_HC_OHCI_MEM_POOL_RELOC == 1)
#define  __AT_MEM0(x)                               __attribute__((at(x)))
#else
#define  __AT_MEM0(x)
#endif
#define  __ALIGNED_MEM0(x)                          __attribute__((aligned(x)))

         USBH_EP_TID_t        usbh0_ep_tid           [USBH0_HC_OHCI_ENDPOINT_NUM];

extern   ARM_DRIVER_USBH                              USBHn_DRIVER_OHCI_LIB(0);
const    ARM_DRIVER_USBH     *usbh0_hcd_ptr =        &USBHn_DRIVER_OHCI_LIB(0);

extern   ARM_DRIVER_USBH_HCI                          USBHn_DRIVER_HCI(USBH0_HC_NUM);
const    ARM_DRIVER_USBH_HCI *usbh0_hci_hcd_ptr =    &USBHn_DRIVER_HCI(USBH0_HC_NUM);

#define  USBH0_OHCI_MEM_HCCA                         (USBH0_HC_OHCI_MEM_POOL_ADDR)
#define  USBH0_OHCI_MEM_HCCA_SIZE                    (256)
#define  USBH0_OHCI_MEM_ED                           (USBH0_OHCI_MEM_HCCA + USBH0_OHCI_MEM_HCCA_SIZE)
#define  USBH0_OHCI_MEM_ED_SIZE                      (USBH0_HC_OHCI_ENDPOINT_NUM*16)
#define  USBH0_OHCI_MEM_TD                           (USBH0_OHCI_MEM_ED   + USBH0_OHCI_MEM_ED_SIZE)
#define  USBH0_OHCI_MEM_TD_SIZE                      (USBH0_HC_OHCI_TRANSFER_NUM*16)
#define  USBH0_OHCI_MEM_POOL_ADDR                    (USBH0_OHCI_MEM_HCCA + USBH0_OHCI_MEM_HCCA_SIZE + USBH0_OHCI_MEM_ED_SIZE + USBH0_OHCI_MEM_TD_SIZE)
#define  USBH0_OHCI_MEM_POOL_SIZE                    (USBH0_HC_OHCI_MEM_POOL_SIZE + 8 + 4)

         uint32_t             usbh0_ohci_hcca       [(USBH0_OHCI_MEM_HCCA_SIZE +3)/4] __AT_MEM0(USBH0_OHCI_MEM_HCCA);
         uint32_t             usbh0_ohci_ed         [(USBH0_OHCI_MEM_ED_SIZE   +3)/4] __AT_MEM0(USBH0_OHCI_MEM_ED);
         uint32_t             usbh0_ohci_td         [(USBH0_OHCI_MEM_TD_SIZE   +3)/4] __AT_MEM0(USBH0_OHCI_MEM_TD);
         uint32_t             usbh0_mem_pool        [(USBH0_OHCI_MEM_POOL_SIZE +3)/4] __AT_MEM0(USBH0_OHCI_MEM_POOL_ADDR);
const    uint32_t             usbh0_mem_pool_size = ((USBH0_OHCI_MEM_POOL_SIZE +3)/4)*4;

         USBH_OHCI_t          usbh0_ohci = {         (uint32_t *)USBH0_HC_OHCI_BASE_ADDRESS,
                                                      USBH0_HC_OHCI_ENDPOINT_NUM,
                                                      USBH0_HC_OHCI_TRANSFER_NUM,
                                                      0,
                                                     &usbh0_ohci_hcca[0],
                                                     &usbh0_ohci_ed[0],
                                                     &usbh0_ohci_td[0],
                                                      NULL };
         USBH_HC_t           *usbh0_hc_ptr   =        NULL;
         USBH_OHCI_t         *usbh0_ohci_ptr =       &usbh0_ohci;
         USBH_EHCI_t         *usbh0_ehci_ptr =        NULL;

#elif   (USBH0_HC_IF == 2)              // NXP EHCI with extensions for full/low-speed support

#if     (USBH0_HC_EHCI_MEM_POOL_RELOC == 1)
#define  __AT_MEM0(x)                               __attribute__((at(x)))
#else
#define  __AT_MEM0(x)
#endif
#define  __ALIGNED_MEM0(x)                          __attribute__((aligned(x)))

         USBH_EP_TID_t        usbh0_ep_tid           [USBH0_HC_EHCI_ENDPOINT_NUM];

extern   ARM_DRIVER_USBH                              USBHn_DRIVER_EHCI_LIB(0);
const    ARM_DRIVER_USBH     *usbh0_hcd_ptr =        &USBHn_DRIVER_EHCI_LIB(0);

extern   ARM_DRIVER_USBH_HCI                          USBHn_DRIVER_HCI(USBH0_HC_NUM);
const    ARM_DRIVER_USBH_HCI *usbh0_hci_hcd_ptr =    &USBHn_DRIVER_HCI(USBH0_HC_NUM);

#define  USBH0_EHCI_MEM_PFL                          (USBH0_HC_EHCI_MEM_POOL_ADDR + (((_USBH0_HC_EHCI_MEM_POOL_SIZE + 3)/4)*4))
#define  USBH0_EHCI_MEM_PFL_SIZE                     (4096)
#define  USBH0_EHCI_MEM_QH                           (USBH0_EHCI_MEM_PFL  + USBH0_EHCI_MEM_PFL_SIZE)
#define  USBH0_EHCI_MEM_QH_SIZE                      (USBH0_HC_EHCI_ENDPOINT_NUM*64)
#define  USBH0_EHCI_MEM_QTD                          (USBH0_EHCI_MEM_QH   + USBH0_EHCI_MEM_QH_SIZE)
#define  USBH0_EHCI_MEM_QTD_SIZE                     (USBH0_HC_EHCI_TRANSFER_NUM*32)
#define  USBH0_EHCI_MEM_POOL_ADDR                    (USBH0_EHCI_MEM_PFL + USBH0_EHCI_MEM_PFL_SIZE + USBH0_OHCI_MEM_QH_SIZE + USBH0_OHCI_MEM_QTD_SIZE)
#define  USBH0_EHCI_MEM_POOL_SIZE                    (USBH0_HC_EHCI_MEM_POOL_SIZE + 8 + 4)

         uint32_t             usbh0_ehci_pfl        [(USBH0_EHCI_MEM_PFL_SIZE     +3)/4] __AT_MEM0(USBH0_EHCI_MEM_PFL) __ALIGNED_MEM0(4096);
         uint32_t             usbh0_ehci_qh         [(USBH0_EHCI_MEM_QH_SIZE      +3)/4] __AT_MEM0(USBH0_EHCI_MEM_QH);
         uint32_t             usbh0_ehci_qtd        [(USBH0_EHCI_MEM_QTD_SIZE     +3)/4] __AT_MEM0(USBH0_EHCI_MEM_QTD) __ALIGNED_MEM0(32);
         uint32_t             usbh0_mem_pool        [(USBH0_HC_EHCI_MEM_POOL_SIZE +3)/4] __AT_MEM0(USBH0_EHCI_MEM_POOL_ADDR);
const    uint32_t             usbh0_mem_pool_size = ((USBH0_HC_EHCI_MEM_POOL_SIZE +3)/4)*4;

         USBH_EHCI_t          usbh0_ehci = {         (uint32_t *)USBH0_HC_EHCI_BASE_ADDRESS,
                                                      USBH0_HC_EHCI_ENDPOINT_NUM,
                                                      USBH0_HC_EHCI_TRANSFER_NUM,
                                                      0,
                                                      0,
                                                      1024,
                                                     &usbh0_ehci_pfl[0],
                                                     &usbh0_ehci_qh[0],
                                                     &usbh0_ehci_qtd[0],
                                                      NULL,
                                                      NULL,
                                                      NULL };
         USBH_HC_t           *usbh0_hc_ptr   =        NULL;
         USBH_EHCI_t         *usbh0_ehci_ptr =       &usbh0_ehci;
         USBH_OHCI_t         *usbh0_ohci_ptr =        NULL;
#endif
