/*------------------------------------------------------------------------------
 * MDK Middleware - Component ::USB:Device
 * Copyright (c) 2004-2014 ARM Germany GmbH. All rights reserved.
 *------------------------------------------------------------------------------
 * Name:    usbd_config_def_3.h
 * Purpose: USB Device 3 Definitions
 * Rev.:    V6.00
 *----------------------------------------------------------------------------*/

#define USBD3_EP_MAX                   (0)

#define USBD3_DEV_STR_CNT              (3+USBD3_STR_DESC_SER_EN)

#if    (defined(RTE_USB_Device_CustomClass_0) && (USBD_CUSTOM_CLASS0_DEV == 3))              // USB Device 3 Custom Class 0
#define USBD3_CUSTOM_CLASS0             1
#define USBD3_CUSTOM_CLASS0_IF_CNT    ((USBD_CUSTOM_CLASS0_IF0_EN*(USBD_CUSTOM_CLASS0_IF0_ALT == 0))+\
                                       (USBD_CUSTOM_CLASS0_IF1_EN*(USBD_CUSTOM_CLASS0_IF1_ALT == 0))+\
                                       (USBD_CUSTOM_CLASS0_IF2_EN*(USBD_CUSTOM_CLASS0_IF2_ALT == 0))+\
                                       (USBD_CUSTOM_CLASS0_IF3_EN*(USBD_CUSTOM_CLASS0_IF3_ALT == 0)))
#define USBD3_CUSTOM_CLASS0_IF0_EP_CNT ((USBD_CUSTOM_CLASS0_IF0_EN) *           \
                                       (USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT_EN + \
                                        USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN_EN  + \
                                        USBD_CUSTOM_CLASS0_IF0_EP_INT_OUT_EN  + \
                                        USBD_CUSTOM_CLASS0_IF0_EP_INT_IN_EN   + \
                                        USBD_CUSTOM_CLASS0_IF0_EP_ISO_OUT_EN  + \
                                        USBD_CUSTOM_CLASS0_IF0_EP_ISO_IN_EN))
#define USBD3_CUSTOM_CLASS0_IF0_EP_MSK ((USBD_CUSTOM_CLASS0_IF0_EN) *           \
                                       (USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT_EN * (1 << USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT ) | \
                                        USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN_EN  * (1 << USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN  ) | \
                                        USBD_CUSTOM_CLASS0_IF0_EP_INT_OUT_EN  * (1 << USBD_CUSTOM_CLASS0_IF0_EP_INT_OUT  ) | \
                                        USBD_CUSTOM_CLASS0_IF0_EP_INT_IN_EN   * (1 << USBD_CUSTOM_CLASS0_IF0_EP_INT_IN   ) | \
                                        USBD_CUSTOM_CLASS0_IF0_EP_ISO_OUT_EN  * (1 << USBD_CUSTOM_CLASS0_IF0_EP_ISO_OUT  ) | \
                                        USBD_CUSTOM_CLASS0_IF0_EP_ISO_IN_EN   * (1 << USBD_CUSTOM_CLASS0_IF0_EP_ISO_IN   ) ))
#define USBD3_CUSTOM_CLASS0_IF1_EP_CNT ((USBD_CUSTOM_CLASS0_IF1_EN) *           \
                                       (USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT_EN + \
                                        USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN_EN  + \
                                        USBD_CUSTOM_CLASS0_IF1_EP_INT_OUT_EN  + \
                                        USBD_CUSTOM_CLASS0_IF1_EP_INT_IN_EN   + \
                                        USBD_CUSTOM_CLASS0_IF1_EP_ISO_OUT_EN  + \
                                        USBD_CUSTOM_CLASS0_IF1_EP_ISO_IN_EN))
#define USBD3_CUSTOM_CLASS0_IF1_EP_MSK ((USBD_CUSTOM_CLASS0_IF1_EN) *           \
                                       (USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT_EN * (1 << USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT ) | \
                                        USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN_EN  * (1 << USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN  ) | \
                                        USBD_CUSTOM_CLASS0_IF1_EP_INT_OUT_EN  * (1 << USBD_CUSTOM_CLASS0_IF1_EP_INT_OUT  ) | \
                                        USBD_CUSTOM_CLASS0_IF1_EP_INT_IN_EN   * (1 << USBD_CUSTOM_CLASS0_IF1_EP_INT_IN   ) | \
                                        USBD_CUSTOM_CLASS0_IF1_EP_ISO_OUT_EN  * (1 << USBD_CUSTOM_CLASS0_IF1_EP_ISO_OUT  ) | \
                                        USBD_CUSTOM_CLASS0_IF1_EP_ISO_IN_EN   * (1 << USBD_CUSTOM_CLASS0_IF1_EP_ISO_IN   ) ))
#define USBD3_CUSTOM_CLASS0_IF2_EP_CNT ((USBD_CUSTOM_CLASS0_IF2_EN) *           \
                                       (USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT_EN + \
                                        USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN_EN  + \
                                        USBD_CUSTOM_CLASS0_IF2_EP_INT_OUT_EN  + \
                                        USBD_CUSTOM_CLASS0_IF2_EP_INT_IN_EN   + \
                                        USBD_CUSTOM_CLASS0_IF2_EP_ISO_OUT_EN  + \
                                        USBD_CUSTOM_CLASS0_IF2_EP_ISO_IN_EN))
#define USBD3_CUSTOM_CLASS0_IF2_EP_MSK ((USBD_CUSTOM_CLASS0_IF2_EN) *           \
                                       (USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT_EN * (1 << USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT ) | \
                                        USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN_EN  * (1 << USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN  ) | \
                                        USBD_CUSTOM_CLASS0_IF2_EP_INT_OUT_EN  * (1 << USBD_CUSTOM_CLASS0_IF2_EP_INT_OUT  ) | \
                                        USBD_CUSTOM_CLASS0_IF2_EP_INT_IN_EN   * (1 << USBD_CUSTOM_CLASS0_IF2_EP_INT_IN   ) | \
                                        USBD_CUSTOM_CLASS0_IF2_EP_ISO_OUT_EN  * (1 << USBD_CUSTOM_CLASS0_IF2_EP_ISO_OUT  ) | \
                                        USBD_CUSTOM_CLASS0_IF2_EP_ISO_IN_EN   * (1 << USBD_CUSTOM_CLASS0_IF2_EP_ISO_IN   ) ))
#define USBD3_CUSTOM_CLASS0_IF3_EP_CNT ((USBD_CUSTOM_CLASS0_IF3_EN) *           \
                                       (USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT_EN + \
                                        USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN_EN  + \
                                        USBD_CUSTOM_CLASS0_IF3_EP_INT_OUT_EN  + \
                                        USBD_CUSTOM_CLASS0_IF3_EP_INT_IN_EN   + \
                                        USBD_CUSTOM_CLASS0_IF3_EP_ISO_OUT_EN  + \
                                        USBD_CUSTOM_CLASS0_IF3_EP_ISO_IN_EN))
#define USBD3_CUSTOM_CLASS0_IF3_EP_MSK ((USBD_CUSTOM_CLASS0_IF3_EN) *           \
                                       (USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT_EN * (1 << USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT ) | \
                                        USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN_EN  * (1 << USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN  ) | \
                                        USBD_CUSTOM_CLASS0_IF3_EP_INT_OUT_EN  * (1 << USBD_CUSTOM_CLASS0_IF3_EP_INT_OUT  ) | \
                                        USBD_CUSTOM_CLASS0_IF3_EP_INT_IN_EN   * (1 << USBD_CUSTOM_CLASS0_IF3_EP_INT_IN   ) | \
                                        USBD_CUSTOM_CLASS0_IF3_EP_ISO_OUT_EN  * (1 << USBD_CUSTOM_CLASS0_IF3_EP_ISO_OUT  ) | \
                                        USBD_CUSTOM_CLASS0_IF3_EP_ISO_IN_EN   * (1 << USBD_CUSTOM_CLASS0_IF3_EP_ISO_IN   ) ))
#define USBD3_CUSTOM_CLASS0_EP_CNT      (USBD3_CUSTOM_CLASS0_IF0_EP_CNT+USBD3_CUSTOM_CLASS0_IF1_EP_CNT+USBD3_CUSTOM_CLASS0_IF2_EP_CNT+USBD3_CUSTOM_CLASS0_IF3_EP_CNT)
#define USBD3_CUSTOM_CLASS0_EP_MSK      (USBD3_CUSTOM_CLASS0_IF0_EP_MSK|USBD3_CUSTOM_CLASS0_IF1_EP_MSK|USBD3_CUSTOM_CLASS0_IF2_EP_MSK|USBD3_CUSTOM_CLASS0_IF3_EP_MSK)
#define USBD3_CUSTOM_CLASS0_IF_DESC_CNT (USBD_CUSTOM_CLASS0_IF0_EN+USBD_CUSTOM_CLASS0_IF1_EN+USBD_CUSTOM_CLASS0_IF2_EN+USBD_CUSTOM_CLASS0_IF3_EN)
#define USBD3_CUSTOM_CLASS0_STR_CNT     (USBD_CUSTOM_CLASS0_IF0_EN+USBD_CUSTOM_CLASS0_IF1_EN+USBD_CUSTOM_CLASS0_IF2_EN+USBD_CUSTOM_CLASS0_IF3_EN)
#define USBD_CUSTOM_CLASS0_IF_CNT       (USBD3_CUSTOM_CLASS0_IF_CNT)
#define USBD_CUSTOM_CLASS0_IF0_EP_CNT   (USBD3_CUSTOM_CLASS0_IF0_EP_CNT)
#define USBD_CUSTOM_CLASS0_IF1_EP_CNT   (USBD3_CUSTOM_CLASS0_IF1_EP_CNT)
#define USBD_CUSTOM_CLASS0_IF2_EP_CNT   (USBD3_CUSTOM_CLASS0_IF2_EP_CNT)
#define USBD_CUSTOM_CLASS0_IF3_EP_CNT   (USBD3_CUSTOM_CLASS0_IF3_EP_CNT)
#define USBD_CUSTOM_CLASS0_EP_CNT       (USBD3_CUSTOM_CLASS0_EP_CNT)
#define USBD_CUSTOM_CLASS0_EP_MSK       (USBD3_CUSTOM_CLASS0_EP_MSK)
#define USBD_CUSTOM_CLASS0_IF_DESC_CNT  (USBD3_CUSTOM_CLASS0_IF_DESC_CNT)
#define USBD_CUSTOM_CLASS0_IF0_STR_IDX  (USBD3_DEV_STR_CNT)
#define USBD_CUSTOM_CLASS0_IF1_STR_IDX  (USBD3_DEV_STR_CNT+USBD_CUSTOM_CLASS0_IF0_EN)
#define USBD_CUSTOM_CLASS0_IF2_STR_IDX  (USBD3_DEV_STR_CNT+USBD_CUSTOM_CLASS0_IF0_EN+USBD_CUSTOM_CLASS0_IF1_EN)
#define USBD_CUSTOM_CLASS0_IF3_STR_IDX  (USBD3_DEV_STR_CNT+USBD_CUSTOM_CLASS0_IF0_EN+USBD_CUSTOM_CLASS0_IF1_EN+USBD_CUSTOM_CLASS0_IF2_EN)
#define USBD_CUSTOM_CLASS0_STR_CNT      (USBD3_CUSTOM_CLASS0_STR_CNT)
#if    (USBD_CUSTOM_CLASS0_IF0_EN == 1)
#if   ((USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT_EN) > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN  * USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF0_EP_INT_OUT  * USBD_CUSTOM_CLASS0_IF0_EP_INT_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF0_EP_INT_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF0_EP_INT_IN   * USBD_CUSTOM_CLASS0_IF0_EP_INT_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF0_EP_INT_IN)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF0_EP_ISO_OUT  * USBD_CUSTOM_CLASS0_IF0_EP_ISO_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF0_EP_ISO_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF0_EP_ISO_IN   * USBD_CUSTOM_CLASS0_IF0_EP_ISO_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF0_EP_ISO_IN)
#endif
#endif
#if    (USBD_CUSTOM_CLASS0_IF1_EN == 1)
#if   ((USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT_EN) > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN  * USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF1_EP_INT_OUT  * USBD_CUSTOM_CLASS0_IF1_EP_INT_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF1_EP_INT_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF1_EP_INT_IN   * USBD_CUSTOM_CLASS0_IF1_EP_INT_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF1_EP_INT_IN)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF1_EP_ISO_OUT  * USBD_CUSTOM_CLASS0_IF1_EP_ISO_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF1_EP_ISO_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF1_EP_ISO_IN   * USBD_CUSTOM_CLASS0_IF1_EP_ISO_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF1_EP_ISO_IN)
#endif
#endif
#if    (USBD_CUSTOM_CLASS0_IF2_EN == 1)
#if   ((USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT_EN) > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN  * USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF2_EP_INT_OUT  * USBD_CUSTOM_CLASS0_IF2_EP_INT_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF2_EP_INT_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF2_EP_INT_IN   * USBD_CUSTOM_CLASS0_IF2_EP_INT_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF2_EP_INT_IN)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF2_EP_ISO_OUT  * USBD_CUSTOM_CLASS0_IF2_EP_ISO_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF2_EP_ISO_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF2_EP_ISO_IN   * USBD_CUSTOM_CLASS0_IF2_EP_ISO_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF2_EP_ISO_IN)
#endif
#endif
#if    (USBD_CUSTOM_CLASS0_IF3_EN == 1)
#if   ((USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT_EN) > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN  * USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF3_EP_INT_OUT  * USBD_CUSTOM_CLASS0_IF3_EP_INT_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF3_EP_INT_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF3_EP_INT_IN   * USBD_CUSTOM_CLASS0_IF3_EP_INT_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF3_EP_INT_IN)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF3_EP_ISO_OUT  * USBD_CUSTOM_CLASS0_IF3_EP_ISO_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF3_EP_ISO_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS0_IF3_EP_ISO_IN   * USBD_CUSTOM_CLASS0_IF3_EP_ISO_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS0_IF3_EP_ISO_IN)
#endif
#endif
#if    (USBD_CUSTOM_CLASS0_IF0_EN == 1)
#if   (((USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT_EN) ==  1) || ((USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN_EN) ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_custom_class_ep_thread_id[0][1]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT_EN) ==  2) || ((USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN_EN) ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_custom_class_ep_thread_id[0][2]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT_EN) ==  3) || ((USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN_EN) ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_custom_class_ep_thread_id[0][3]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT_EN) ==  4) || ((USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN_EN) ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_custom_class_ep_thread_id[0][4]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT_EN) ==  5) || ((USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN_EN) ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_custom_class_ep_thread_id[0][5]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT_EN) ==  6) || ((USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN_EN) ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_custom_class_ep_thread_id[0][6]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT_EN) ==  7) || ((USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN_EN) ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_custom_class_ep_thread_id[0][7]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT_EN) ==  8) || ((USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN_EN) ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_custom_class_ep_thread_id[0][8]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT_EN) ==  9) || ((USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN_EN) ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_custom_class_ep_thread_id[0][9]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT_EN) == 10) || ((USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN_EN) == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_custom_class_ep_thread_id[0][10]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT_EN) == 11) || ((USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN_EN) == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_custom_class_ep_thread_id[0][11]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT_EN) == 12) || ((USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN_EN) == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_custom_class_ep_thread_id[0][12]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT_EN) == 13) || ((USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN_EN) == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_custom_class_ep_thread_id[0][13]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT_EN) == 14) || ((USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN_EN) == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_custom_class_ep_thread_id[0][14]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF0_EP_BULK_OUT_EN) == 15) || ((USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF0_EP_BULK_IN_EN) == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_custom_class_ep_thread_id[0][15]
#endif
#endif
#if    (USBD_CUSTOM_CLASS0_IF1_EN == 1)
#if   (((USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT_EN) ==  1) || ((USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN_EN) ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_custom_class_ep_thread_id[0][1]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT_EN) ==  2) || ((USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN_EN) ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_custom_class_ep_thread_id[0][2]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT_EN) ==  3) || ((USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN_EN) ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_custom_class_ep_thread_id[0][3]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT_EN) ==  4) || ((USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN_EN) ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_custom_class_ep_thread_id[0][4]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT_EN) ==  5) || ((USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN_EN) ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_custom_class_ep_thread_id[0][5]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT_EN) ==  6) || ((USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN_EN) ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_custom_class_ep_thread_id[0][6]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT_EN) ==  7) || ((USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN_EN) ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_custom_class_ep_thread_id[0][7]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT_EN) ==  8) || ((USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN_EN) ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_custom_class_ep_thread_id[0][8]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT_EN) ==  9) || ((USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN_EN) ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_custom_class_ep_thread_id[0][9]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT_EN) == 10) || ((USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN_EN) == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_custom_class_ep_thread_id[0][10]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT_EN) == 11) || ((USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN_EN) == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_custom_class_ep_thread_id[0][11]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT_EN) == 12) || ((USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN_EN) == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_custom_class_ep_thread_id[0][12]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT_EN) == 13) || ((USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN_EN) == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_custom_class_ep_thread_id[0][13]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT_EN) == 14) || ((USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN_EN) == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_custom_class_ep_thread_id[0][14]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF1_EP_BULK_OUT_EN) == 15) || ((USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF1_EP_BULK_IN_EN) == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_custom_class_ep_thread_id[0][15]
#endif
#endif
#if    (USBD_CUSTOM_CLASS0_IF2_EN == 1)
#if   (((USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT_EN) ==  1) || ((USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN_EN) ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_custom_class_ep_thread_id[0][1]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT_EN) ==  2) || ((USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN_EN) ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_custom_class_ep_thread_id[0][2]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT_EN) ==  3) || ((USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN_EN) ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_custom_class_ep_thread_id[0][3]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT_EN) ==  4) || ((USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN_EN) ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_custom_class_ep_thread_id[0][4]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT_EN) ==  5) || ((USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN_EN) ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_custom_class_ep_thread_id[0][5]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT_EN) ==  6) || ((USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN_EN) ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_custom_class_ep_thread_id[0][6]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT_EN) ==  7) || ((USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN_EN) ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_custom_class_ep_thread_id[0][7]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT_EN) ==  8) || ((USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN_EN) ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_custom_class_ep_thread_id[0][8]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT_EN) ==  9) || ((USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN_EN) ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_custom_class_ep_thread_id[0][9]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT_EN) == 10) || ((USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN_EN) == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_custom_class_ep_thread_id[0][10]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT_EN) == 11) || ((USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN_EN) == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_custom_class_ep_thread_id[0][11]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT_EN) == 12) || ((USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN_EN) == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_custom_class_ep_thread_id[0][12]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT_EN) == 13) || ((USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN_EN) == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_custom_class_ep_thread_id[0][13]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT_EN) == 14) || ((USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN_EN) == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_custom_class_ep_thread_id[0][14]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF2_EP_BULK_OUT_EN) == 15) || ((USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF2_EP_BULK_IN_EN) == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_custom_class_ep_thread_id[0][15]
#endif
#endif
#if    (USBD_CUSTOM_CLASS0_IF3_EN == 1)
#if   (((USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT_EN) ==  1) || ((USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN_EN) ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_custom_class_ep_thread_id[0][1]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT_EN) ==  2) || ((USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN_EN) ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_custom_class_ep_thread_id[0][2]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT_EN) ==  3) || ((USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN_EN) ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_custom_class_ep_thread_id[0][3]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT_EN) ==  4) || ((USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN_EN) ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_custom_class_ep_thread_id[0][4]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT_EN) ==  5) || ((USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN_EN) ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_custom_class_ep_thread_id[0][5]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT_EN) ==  6) || ((USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN_EN) ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_custom_class_ep_thread_id[0][6]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT_EN) ==  7) || ((USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN_EN) ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_custom_class_ep_thread_id[0][7]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT_EN) ==  8) || ((USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN_EN) ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_custom_class_ep_thread_id[0][8]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT_EN) ==  9) || ((USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN_EN) ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_custom_class_ep_thread_id[0][9]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT_EN) == 10) || ((USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN_EN) == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_custom_class_ep_thread_id[0][10]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT_EN) == 11) || ((USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN_EN) == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_custom_class_ep_thread_id[0][11]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT_EN) == 12) || ((USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN_EN) == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_custom_class_ep_thread_id[0][12]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT_EN) == 13) || ((USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN_EN) == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_custom_class_ep_thread_id[0][13]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT_EN) == 14) || ((USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN_EN) == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_custom_class_ep_thread_id[0][14]
#endif
#if   (((USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS0_IF3_EP_BULK_OUT_EN) == 15) || ((USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS0_IF3_EP_BULK_IN_EN) == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_custom_class_ep_thread_id[0][15]
#endif
#define USBD3_CUSTOM_CLASS0_IF_EP_CNT  (USBD3_CUSTOM_CLASS0_IF0_EP_CNT+USBD3_CUSTOM_CLASS0_IF1_EP_CNT+USBD3_CUSTOM_CLASS0_IF2_EP_CNT+USBD3_CUSTOM_CLASS0_IF3_EP_CNT)
#endif
#else
#define USBD3_CUSTOM_CLASS0             0
#define USBD3_CUSTOM_CLASS0_IF_CNT      0
#define USBD3_CUSTOM_CLASS0_EP_CNT      0
#define USBD3_CUSTOM_CLASS0_IF_DESC_CNT 0
#define USBD3_CUSTOM_CLASS0_STR_CNT     0
#endif

#if    (defined(RTE_USB_Device_CustomClass_1) && (USBD_CUSTOM_CLASS1_DEV == 3))              // USB Device 3 Custom Class 1
#define USBD3_CUSTOM_CLASS1             1
#define USBD3_CUSTOM_CLASS1_IF_CNT    ((USBD_CUSTOM_CLASS1_IF0_EN*(USBD_CUSTOM_CLASS1_IF0_ALT == 0))+\
                                       (USBD_CUSTOM_CLASS1_IF1_EN*(USBD_CUSTOM_CLASS1_IF1_ALT == 0))+\
                                       (USBD_CUSTOM_CLASS1_IF2_EN*(USBD_CUSTOM_CLASS1_IF2_ALT == 0))+\
                                       (USBD_CUSTOM_CLASS1_IF3_EN*(USBD_CUSTOM_CLASS1_IF3_ALT == 0)))
#define USBD3_CUSTOM_CLASS1_IF0_EP_CNT ((USBD_CUSTOM_CLASS1_IF0_EN) *           \
                                       (USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT_EN + \
                                        USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN_EN  + \
                                        USBD_CUSTOM_CLASS1_IF0_EP_INT_OUT_EN  + \
                                        USBD_CUSTOM_CLASS1_IF0_EP_INT_IN_EN   + \
                                        USBD_CUSTOM_CLASS1_IF0_EP_ISO_OUT_EN  + \
                                        USBD_CUSTOM_CLASS1_IF0_EP_ISO_IN_EN))
#define USBD3_CUSTOM_CLASS1_IF0_EP_MSK ((USBD_CUSTOM_CLASS1_IF0_EN) *           \
                                       (USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT_EN * (1 << USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT ) | \
                                        USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN_EN  * (1 << USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN  ) | \
                                        USBD_CUSTOM_CLASS1_IF0_EP_INT_OUT_EN  * (1 << USBD_CUSTOM_CLASS1_IF0_EP_INT_OUT  ) | \
                                        USBD_CUSTOM_CLASS1_IF0_EP_INT_IN_EN   * (1 << USBD_CUSTOM_CLASS1_IF0_EP_INT_IN   ) | \
                                        USBD_CUSTOM_CLASS1_IF0_EP_ISO_OUT_EN  * (1 << USBD_CUSTOM_CLASS1_IF0_EP_ISO_OUT  ) | \
                                        USBD_CUSTOM_CLASS1_IF0_EP_ISO_IN_EN   * (1 << USBD_CUSTOM_CLASS1_IF0_EP_ISO_IN   ) ))
#define USBD3_CUSTOM_CLASS1_IF1_EP_CNT ((USBD_CUSTOM_CLASS1_IF1_EN) *           \
                                       (USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT_EN + \
                                        USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN_EN  + \
                                        USBD_CUSTOM_CLASS1_IF1_EP_INT_OUT_EN  + \
                                        USBD_CUSTOM_CLASS1_IF1_EP_INT_IN_EN   + \
                                        USBD_CUSTOM_CLASS1_IF1_EP_ISO_OUT_EN  + \
                                        USBD_CUSTOM_CLASS1_IF1_EP_ISO_IN_EN))
#define USBD3_CUSTOM_CLASS1_IF1_EP_MSK ((USBD_CUSTOM_CLASS1_IF1_EN) *           \
                                       (USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT_EN * (1 << USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT ) | \
                                        USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN_EN  * (1 << USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN  ) | \
                                        USBD_CUSTOM_CLASS1_IF1_EP_INT_OUT_EN  * (1 << USBD_CUSTOM_CLASS1_IF1_EP_INT_OUT  ) | \
                                        USBD_CUSTOM_CLASS1_IF1_EP_INT_IN_EN   * (1 << USBD_CUSTOM_CLASS1_IF1_EP_INT_IN   ) | \
                                        USBD_CUSTOM_CLASS1_IF1_EP_ISO_OUT_EN  * (1 << USBD_CUSTOM_CLASS1_IF1_EP_ISO_OUT  ) | \
                                        USBD_CUSTOM_CLASS1_IF1_EP_ISO_IN_EN   * (1 << USBD_CUSTOM_CLASS1_IF1_EP_ISO_IN   ) ))
#define USBD3_CUSTOM_CLASS1_IF2_EP_CNT ((USBD_CUSTOM_CLASS1_IF2_EN) *           \
                                       (USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT_EN + \
                                        USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN_EN  + \
                                        USBD_CUSTOM_CLASS1_IF2_EP_INT_OUT_EN  + \
                                        USBD_CUSTOM_CLASS1_IF2_EP_INT_IN_EN   + \
                                        USBD_CUSTOM_CLASS1_IF2_EP_ISO_OUT_EN  + \
                                        USBD_CUSTOM_CLASS1_IF2_EP_ISO_IN_EN))
#define USBD3_CUSTOM_CLASS1_IF2_EP_MSK ((USBD_CUSTOM_CLASS1_IF2_EN) *           \
                                       (USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT_EN * (1 << USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT ) | \
                                        USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN_EN  * (1 << USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN  ) | \
                                        USBD_CUSTOM_CLASS1_IF2_EP_INT_OUT_EN  * (1 << USBD_CUSTOM_CLASS1_IF2_EP_INT_OUT  ) | \
                                        USBD_CUSTOM_CLASS1_IF2_EP_INT_IN_EN   * (1 << USBD_CUSTOM_CLASS1_IF2_EP_INT_IN   ) | \
                                        USBD_CUSTOM_CLASS1_IF2_EP_ISO_OUT_EN  * (1 << USBD_CUSTOM_CLASS1_IF2_EP_ISO_OUT  ) | \
                                        USBD_CUSTOM_CLASS1_IF2_EP_ISO_IN_EN   * (1 << USBD_CUSTOM_CLASS1_IF2_EP_ISO_IN   ) ))
#define USBD3_CUSTOM_CLASS1_IF3_EP_CNT ((USBD_CUSTOM_CLASS1_IF3_EN) *           \
                                       (USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT_EN + \
                                        USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN_EN  + \
                                        USBD_CUSTOM_CLASS1_IF3_EP_INT_OUT_EN  + \
                                        USBD_CUSTOM_CLASS1_IF3_EP_INT_IN_EN   + \
                                        USBD_CUSTOM_CLASS1_IF3_EP_ISO_OUT_EN  + \
                                        USBD_CUSTOM_CLASS1_IF3_EP_ISO_IN_EN))
#define USBD3_CUSTOM_CLASS1_IF3_EP_MSK ((USBD_CUSTOM_CLASS1_IF3_EN) *           \
                                       (USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT_EN * (1 << USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT ) | \
                                        USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN_EN  * (1 << USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN  ) | \
                                        USBD_CUSTOM_CLASS1_IF3_EP_INT_OUT_EN  * (1 << USBD_CUSTOM_CLASS1_IF3_EP_INT_OUT  ) | \
                                        USBD_CUSTOM_CLASS1_IF3_EP_INT_IN_EN   * (1 << USBD_CUSTOM_CLASS1_IF3_EP_INT_IN   ) | \
                                        USBD_CUSTOM_CLASS1_IF3_EP_ISO_OUT_EN  * (1 << USBD_CUSTOM_CLASS1_IF3_EP_ISO_OUT  ) | \
                                        USBD_CUSTOM_CLASS1_IF3_EP_ISO_IN_EN   * (1 << USBD_CUSTOM_CLASS1_IF3_EP_ISO_IN   ) ))
#define USBD3_CUSTOM_CLASS1_EP_CNT      (USBD3_CUSTOM_CLASS1_IF0_EP_CNT+USBD3_CUSTOM_CLASS1_IF1_EP_CNT+USBD3_CUSTOM_CLASS1_IF2_EP_CNT+USBD3_CUSTOM_CLASS1_IF3_EP_CNT)
#define USBD3_CUSTOM_CLASS1_EP_MSK      (USBD3_CUSTOM_CLASS1_IF0_EP_MSK|USBD3_CUSTOM_CLASS1_IF1_EP_MSK|USBD3_CUSTOM_CLASS1_IF2_EP_MSK|USBD3_CUSTOM_CLASS1_IF3_EP_MSK)
#define USBD3_CUSTOM_CLASS1_IF_DESC_CNT (USBD_CUSTOM_CLASS1_IF0_EN+USBD_CUSTOM_CLASS1_IF1_EN+USBD_CUSTOM_CLASS1_IF2_EN+USBD_CUSTOM_CLASS1_IF3_EN)
#define USBD3_CUSTOM_CLASS1_STR_CNT     (USBD_CUSTOM_CLASS1_IF1_EN+USBD_CUSTOM_CLASS1_IF1_EN+USBD_CUSTOM_CLASS1_IF2_EN+USBD_CUSTOM_CLASS1_IF3_EN)
#define USBD_CUSTOM_CLASS1_IF_CNT       (USBD3_CUSTOM_CLASS1_IF_CNT)
#define USBD_CUSTOM_CLASS1_IF0_EP_CNT   (USBD3_CUSTOM_CLASS1_IF0_EP_CNT)
#define USBD_CUSTOM_CLASS1_IF1_EP_CNT   (USBD3_CUSTOM_CLASS1_IF1_EP_CNT)
#define USBD_CUSTOM_CLASS1_IF2_EP_CNT   (USBD3_CUSTOM_CLASS1_IF2_EP_CNT)
#define USBD_CUSTOM_CLASS1_IF3_EP_CNT   (USBD3_CUSTOM_CLASS1_IF3_EP_CNT)
#define USBD_CUSTOM_CLASS1_EP_CNT       (USBD3_CUSTOM_CLASS1_EP_CNT)
#define USBD_CUSTOM_CLASS1_EP_MSK       (USBD3_CUSTOM_CLASS1_EP_MSK)
#define USBD_CUSTOM_CLASS1_IF_DESC_CNT  (USBD3_CUSTOM_CLASS1_IF_DESC_CNT)
#define USBD_CUSTOM_CLASS1_IF0_STR_IDX  (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS0_STR_CNT)
#define USBD_CUSTOM_CLASS1_IF1_STR_IDX  (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS0_STR_CNT+USBD_CUSTOM_CLASS1_IF0_EN)
#define USBD_CUSTOM_CLASS1_IF2_STR_IDX  (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS0_STR_CNT+USBD_CUSTOM_CLASS1_IF0_EN+USBD_CUSTOM_CLASS1_IF1_EN)
#define USBD_CUSTOM_CLASS1_IF3_STR_IDX  (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS0_STR_CNT+USBD_CUSTOM_CLASS1_IF0_EN+USBD_CUSTOM_CLASS1_IF1_EN+USBD_CUSTOM_CLASS1_IF2_EN)
#define USBD_CUSTOM_CLASS1_STR_CNT      (USBD3_CUSTOM_CLASS1_STR_CNT)
#if    (USBD_CUSTOM_CLASS1_IF0_EN == 1)
#if   ((USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT_EN) > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN  * USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF0_EP_INT_OUT  * USBD_CUSTOM_CLASS1_IF0_EP_INT_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF0_EP_INT_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF0_EP_INT_IN   * USBD_CUSTOM_CLASS1_IF0_EP_INT_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF0_EP_INT_IN)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF0_EP_ISO_OUT  * USBD_CUSTOM_CLASS1_IF0_EP_ISO_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF0_EP_ISO_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF0_EP_ISO_IN   * USBD_CUSTOM_CLASS1_IF0_EP_ISO_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF0_EP_ISO_IN)
#endif
#endif
#if    (USBD_CUSTOM_CLASS1_IF1_EN == 1)
#if   ((USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT_EN) > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN  * USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF1_EP_INT_OUT  * USBD_CUSTOM_CLASS1_IF1_EP_INT_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF1_EP_INT_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF1_EP_INT_IN   * USBD_CUSTOM_CLASS1_IF1_EP_INT_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF1_EP_INT_IN)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF1_EP_ISO_OUT  * USBD_CUSTOM_CLASS1_IF1_EP_ISO_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF1_EP_ISO_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF1_EP_ISO_IN   * USBD_CUSTOM_CLASS1_IF1_EP_ISO_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF1_EP_ISO_IN)
#endif
#endif
#if    (USBD_CUSTOM_CLASS1_IF2_EN == 1)
#if   ((USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT_EN) > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN  * USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF2_EP_INT_OUT  * USBD_CUSTOM_CLASS1_IF2_EP_INT_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF2_EP_INT_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF2_EP_INT_IN   * USBD_CUSTOM_CLASS1_IF2_EP_INT_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF2_EP_INT_IN)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF2_EP_ISO_OUT  * USBD_CUSTOM_CLASS1_IF2_EP_ISO_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF2_EP_ISO_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF2_EP_ISO_IN   * USBD_CUSTOM_CLASS1_IF2_EP_ISO_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF2_EP_ISO_IN)
#endif
#endif
#if    (USBD_CUSTOM_CLASS1_IF3_EN == 1)
#if   ((USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT_EN) > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN  * USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF3_EP_INT_OUT  * USBD_CUSTOM_CLASS1_IF3_EP_INT_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF3_EP_INT_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF3_EP_INT_IN   * USBD_CUSTOM_CLASS1_IF3_EP_INT_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF3_EP_INT_IN)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF3_EP_ISO_OUT  * USBD_CUSTOM_CLASS1_IF3_EP_ISO_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF3_EP_ISO_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS1_IF3_EP_ISO_IN   * USBD_CUSTOM_CLASS1_IF3_EP_ISO_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS1_IF3_EP_ISO_IN)
#endif
#endif
#if    (USBD_CUSTOM_CLASS1_IF0_EN == 1)
#if   (((USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT_EN) ==  1) || ((USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN_EN) ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_custom_class_ep_thread_id[1][1]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT_EN) ==  2) || ((USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN_EN) ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_custom_class_ep_thread_id[1][2]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT_EN) ==  3) || ((USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN_EN) ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_custom_class_ep_thread_id[1][3]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT_EN) ==  4) || ((USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN_EN) ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_custom_class_ep_thread_id[1][4]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT_EN) ==  5) || ((USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN_EN) ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_custom_class_ep_thread_id[1][5]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT_EN) ==  6) || ((USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN_EN) ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_custom_class_ep_thread_id[1][6]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT_EN) ==  7) || ((USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN_EN) ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_custom_class_ep_thread_id[1][7]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT_EN) ==  8) || ((USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN_EN) ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_custom_class_ep_thread_id[1][8]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT_EN) ==  9) || ((USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN_EN) ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_custom_class_ep_thread_id[1][9]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT_EN) == 10) || ((USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN_EN) == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_custom_class_ep_thread_id[1][10]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT_EN) == 11) || ((USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN_EN) == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_custom_class_ep_thread_id[1][11]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT_EN) == 12) || ((USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN_EN) == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_custom_class_ep_thread_id[1][12]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT_EN) == 13) || ((USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN_EN) == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_custom_class_ep_thread_id[1][13]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT_EN) == 14) || ((USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN_EN) == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_custom_class_ep_thread_id[1][14]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF0_EP_BULK_OUT_EN) == 15) || ((USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF0_EP_BULK_IN_EN) == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_custom_class_ep_thread_id[1][15]
#endif
#endif
#if    (USBD_CUSTOM_CLASS1_IF1_EN == 1)
#if   (((USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT_EN) ==  1) || ((USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN_EN) ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_custom_class_ep_thread_id[1][1]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT_EN) ==  2) || ((USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN_EN) ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_custom_class_ep_thread_id[1][2]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT_EN) ==  3) || ((USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN_EN) ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_custom_class_ep_thread_id[1][3]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT_EN) ==  4) || ((USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN_EN) ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_custom_class_ep_thread_id[1][4]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT_EN) ==  5) || ((USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN_EN) ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_custom_class_ep_thread_id[1][5]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT_EN) ==  6) || ((USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN_EN) ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_custom_class_ep_thread_id[1][6]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT_EN) ==  7) || ((USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN_EN) ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_custom_class_ep_thread_id[1][7]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT_EN) ==  8) || ((USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN_EN) ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_custom_class_ep_thread_id[1][8]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT_EN) ==  9) || ((USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN_EN) ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_custom_class_ep_thread_id[1][9]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT_EN) == 10) || ((USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN_EN) == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_custom_class_ep_thread_id[1][10]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT_EN) == 11) || ((USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN_EN) == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_custom_class_ep_thread_id[1][11]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT_EN) == 12) || ((USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN_EN) == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_custom_class_ep_thread_id[1][12]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT_EN) == 13) || ((USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN_EN) == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_custom_class_ep_thread_id[1][13]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT_EN) == 14) || ((USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN_EN) == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_custom_class_ep_thread_id[1][14]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF1_EP_BULK_OUT_EN) == 15) || ((USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF1_EP_BULK_IN_EN) == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_custom_class_ep_thread_id[1][15]
#endif
#endif
#if    (USBD_CUSTOM_CLASS1_IF2_EN == 1)
#if   (((USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT_EN) ==  1) || ((USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN_EN) ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_custom_class_ep_thread_id[1][1]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT_EN) ==  2) || ((USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN_EN) ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_custom_class_ep_thread_id[1][2]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT_EN) ==  3) || ((USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN_EN) ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_custom_class_ep_thread_id[1][3]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT_EN) ==  4) || ((USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN_EN) ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_custom_class_ep_thread_id[1][4]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT_EN) ==  5) || ((USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN_EN) ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_custom_class_ep_thread_id[1][5]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT_EN) ==  6) || ((USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN_EN) ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_custom_class_ep_thread_id[1][6]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT_EN) ==  7) || ((USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN_EN) ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_custom_class_ep_thread_id[1][7]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT_EN) ==  8) || ((USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN_EN) ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_custom_class_ep_thread_id[1][8]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT_EN) ==  9) || ((USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN_EN) ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_custom_class_ep_thread_id[1][9]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT_EN) == 10) || ((USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN_EN) == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_custom_class_ep_thread_id[1][10]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT_EN) == 11) || ((USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN_EN) == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_custom_class_ep_thread_id[1][11]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT_EN) == 12) || ((USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN_EN) == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_custom_class_ep_thread_id[1][12]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT_EN) == 13) || ((USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN_EN) == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_custom_class_ep_thread_id[1][13]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT_EN) == 14) || ((USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN_EN) == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_custom_class_ep_thread_id[1][14]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF2_EP_BULK_OUT_EN) == 15) || ((USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF2_EP_BULK_IN_EN) == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_custom_class_ep_thread_id[1][15]
#endif
#endif
#if    (USBD_CUSTOM_CLASS1_IF3_EN == 1)
#if   (((USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT_EN) ==  1) || ((USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN_EN) ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_custom_class_ep_thread_id[1][1]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT_EN) ==  2) || ((USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN_EN) ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_custom_class_ep_thread_id[1][2]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT_EN) ==  3) || ((USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN_EN) ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_custom_class_ep_thread_id[1][3]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT_EN) ==  4) || ((USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN_EN) ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_custom_class_ep_thread_id[1][4]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT_EN) ==  5) || ((USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN_EN) ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_custom_class_ep_thread_id[1][5]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT_EN) ==  6) || ((USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN_EN) ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_custom_class_ep_thread_id[1][6]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT_EN) ==  7) || ((USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN_EN) ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_custom_class_ep_thread_id[1][7]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT_EN) ==  8) || ((USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN_EN) ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_custom_class_ep_thread_id[1][8]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT_EN) ==  9) || ((USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN_EN) ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_custom_class_ep_thread_id[1][9]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT_EN) == 10) || ((USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN_EN) == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_custom_class_ep_thread_id[1][10]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT_EN) == 11) || ((USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN_EN) == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_custom_class_ep_thread_id[1][11]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT_EN) == 12) || ((USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN_EN) == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_custom_class_ep_thread_id[1][12]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT_EN) == 13) || ((USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN_EN) == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_custom_class_ep_thread_id[1][13]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT_EN) == 14) || ((USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN_EN) == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_custom_class_ep_thread_id[1][14]
#endif
#if   (((USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS1_IF3_EP_BULK_OUT_EN) == 15) || ((USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS1_IF3_EP_BULK_IN_EN) == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_custom_class_ep_thread_id[1][15]
#endif
#define USBD3_CUSTOM_CLASS1_IF_EP_CNT  (USBD3_CUSTOM_CLASS1_IF0_EP_CNT+USBD3_CUSTOM_CLASS1_IF1_EP_CNT+USBD3_CUSTOM_CLASS1_IF2_EP_CNT+USBD3_CUSTOM_CLASS1_IF3_EP_CNT)
#endif
#else
#define USBD3_CUSTOM_CLASS1             0
#define USBD3_CUSTOM_CLASS1_IF_CNT      0
#define USBD3_CUSTOM_CLASS1_EP_CNT      0
#define USBD3_CUSTOM_CLASS1_IF_DESC_CNT 0
#define USBD3_CUSTOM_CLASS1_STR_CNT     0
#endif

#if    (defined(RTE_USB_Device_CustomClass_2) && (USBD_CUSTOM_CLASS2_DEV == 3))              // USB Device 3 Custom Class 2
#define USBD3_CUSTOM_CLASS2             1
#define USBD3_CUSTOM_CLASS2_IF_CNT    ((USBD_CUSTOM_CLASS2_IF0_EN*(USBD_CUSTOM_CLASS2_IF0_ALT == 0))+\
                                       (USBD_CUSTOM_CLASS2_IF1_EN*(USBD_CUSTOM_CLASS2_IF1_ALT == 0))+\
                                       (USBD_CUSTOM_CLASS2_IF2_EN*(USBD_CUSTOM_CLASS2_IF2_ALT == 0))+\
                                       (USBD_CUSTOM_CLASS2_IF3_EN*(USBD_CUSTOM_CLASS2_IF3_ALT == 0)))
#define USBD3_CUSTOM_CLASS2_IF0_EP_CNT ((USBD_CUSTOM_CLASS2_IF0_EN) *           \
                                       (USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT_EN + \
                                        USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN_EN  + \
                                        USBD_CUSTOM_CLASS2_IF0_EP_INT_OUT_EN  + \
                                        USBD_CUSTOM_CLASS2_IF0_EP_INT_IN_EN   + \
                                        USBD_CUSTOM_CLASS2_IF0_EP_ISO_OUT_EN  + \
                                        USBD_CUSTOM_CLASS2_IF0_EP_ISO_IN_EN))
#define USBD3_CUSTOM_CLASS2_IF0_EP_MSK ((USBD_CUSTOM_CLASS2_IF0_EN) *           \
                                       (USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT_EN * (1 << USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT ) | \
                                        USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN_EN  * (1 << USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN  ) | \
                                        USBD_CUSTOM_CLASS2_IF0_EP_INT_OUT_EN  * (1 << USBD_CUSTOM_CLASS2_IF0_EP_INT_OUT  ) | \
                                        USBD_CUSTOM_CLASS2_IF0_EP_INT_IN_EN   * (1 << USBD_CUSTOM_CLASS2_IF0_EP_INT_IN   ) | \
                                        USBD_CUSTOM_CLASS2_IF0_EP_ISO_OUT_EN  * (1 << USBD_CUSTOM_CLASS2_IF0_EP_ISO_OUT  ) | \
                                        USBD_CUSTOM_CLASS2_IF0_EP_ISO_IN_EN   * (1 << USBD_CUSTOM_CLASS2_IF0_EP_ISO_IN   ) ))
#define USBD3_CUSTOM_CLASS2_IF1_EP_CNT ((USBD_CUSTOM_CLASS2_IF1_EN) *           \
                                       (USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT_EN + \
                                        USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN_EN  + \
                                        USBD_CUSTOM_CLASS2_IF1_EP_INT_OUT_EN  + \
                                        USBD_CUSTOM_CLASS2_IF1_EP_INT_IN_EN   + \
                                        USBD_CUSTOM_CLASS2_IF1_EP_ISO_OUT_EN  + \
                                        USBD_CUSTOM_CLASS2_IF1_EP_ISO_IN_EN))
#define USBD3_CUSTOM_CLASS2_IF1_EP_MSK ((USBD_CUSTOM_CLASS2_IF1_EN) *           \
                                       (USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT_EN * (1 << USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT ) | \
                                        USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN_EN  * (1 << USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN  ) | \
                                        USBD_CUSTOM_CLASS2_IF1_EP_INT_OUT_EN  * (1 << USBD_CUSTOM_CLASS2_IF1_EP_INT_OUT  ) | \
                                        USBD_CUSTOM_CLASS2_IF1_EP_INT_IN_EN   * (1 << USBD_CUSTOM_CLASS2_IF1_EP_INT_IN   ) | \
                                        USBD_CUSTOM_CLASS2_IF1_EP_ISO_OUT_EN  * (1 << USBD_CUSTOM_CLASS2_IF1_EP_ISO_OUT  ) | \
                                        USBD_CUSTOM_CLASS2_IF1_EP_ISO_IN_EN   * (1 << USBD_CUSTOM_CLASS2_IF1_EP_ISO_IN   ) ))
#define USBD3_CUSTOM_CLASS2_IF2_EP_CNT ((USBD_CUSTOM_CLASS2_IF2_EN) *           \
                                       (USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT_EN + \
                                        USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN_EN  + \
                                        USBD_CUSTOM_CLASS2_IF2_EP_INT_OUT_EN  + \
                                        USBD_CUSTOM_CLASS2_IF2_EP_INT_IN_EN   + \
                                        USBD_CUSTOM_CLASS2_IF2_EP_ISO_OUT_EN  + \
                                        USBD_CUSTOM_CLASS2_IF2_EP_ISO_IN_EN))
#define USBD3_CUSTOM_CLASS2_IF2_EP_MSK ((USBD_CUSTOM_CLASS2_IF2_EN) *           \
                                       (USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT_EN * (1 << USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT ) | \
                                        USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN_EN  * (1 << USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN  ) | \
                                        USBD_CUSTOM_CLASS2_IF2_EP_INT_OUT_EN  * (1 << USBD_CUSTOM_CLASS2_IF2_EP_INT_OUT  ) | \
                                        USBD_CUSTOM_CLASS2_IF2_EP_INT_IN_EN   * (1 << USBD_CUSTOM_CLASS2_IF2_EP_INT_IN   ) | \
                                        USBD_CUSTOM_CLASS2_IF2_EP_ISO_OUT_EN  * (1 << USBD_CUSTOM_CLASS2_IF2_EP_ISO_OUT  ) | \
                                        USBD_CUSTOM_CLASS2_IF2_EP_ISO_IN_EN   * (1 << USBD_CUSTOM_CLASS2_IF2_EP_ISO_IN   ) ))
#define USBD3_CUSTOM_CLASS2_IF3_EP_CNT ((USBD_CUSTOM_CLASS2_IF3_EN) *           \
                                       (USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT_EN + \
                                        USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN_EN  + \
                                        USBD_CUSTOM_CLASS2_IF3_EP_INT_OUT_EN  + \
                                        USBD_CUSTOM_CLASS2_IF3_EP_INT_IN_EN   + \
                                        USBD_CUSTOM_CLASS2_IF3_EP_ISO_OUT_EN  + \
                                        USBD_CUSTOM_CLASS2_IF3_EP_ISO_IN_EN))
#define USBD3_CUSTOM_CLASS2_IF3_EP_MSK ((USBD_CUSTOM_CLASS2_IF3_EN) *           \
                                       (USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT_EN * (1 << USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT ) | \
                                        USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN_EN  * (1 << USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN  ) | \
                                        USBD_CUSTOM_CLASS2_IF3_EP_INT_OUT_EN  * (1 << USBD_CUSTOM_CLASS2_IF3_EP_INT_OUT  ) | \
                                        USBD_CUSTOM_CLASS2_IF3_EP_INT_IN_EN   * (1 << USBD_CUSTOM_CLASS2_IF3_EP_INT_IN   ) | \
                                        USBD_CUSTOM_CLASS2_IF3_EP_ISO_OUT_EN  * (1 << USBD_CUSTOM_CLASS2_IF3_EP_ISO_OUT  ) | \
                                        USBD_CUSTOM_CLASS2_IF3_EP_ISO_IN_EN   * (1 << USBD_CUSTOM_CLASS2_IF3_EP_ISO_IN   ) ))
#define USBD3_CUSTOM_CLASS2_EP_CNT      (USBD3_CUSTOM_CLASS2_IF0_EP_CNT+USBD3_CUSTOM_CLASS2_IF1_EP_CNT+USBD3_CUSTOM_CLASS2_IF2_EP_CNT+USBD3_CUSTOM_CLASS2_IF3_EP_CNT)
#define USBD3_CUSTOM_CLASS2_EP_MSK      (USBD3_CUSTOM_CLASS2_IF0_EP_MSK|USBD3_CUSTOM_CLASS2_IF1_EP_MSK|USBD3_CUSTOM_CLASS2_IF2_EP_MSK|USBD3_CUSTOM_CLASS2_IF3_EP_MSK)
#define USBD3_CUSTOM_CLASS2_IF_DESC_CNT (USBD_CUSTOM_CLASS2_IF0_EN+USBD_CUSTOM_CLASS2_IF1_EN+USBD_CUSTOM_CLASS2_IF2_EN+USBD_CUSTOM_CLASS2_IF3_EN)
#define USBD3_CUSTOM_CLASS2_STR_CNT     (USBD_CUSTOM_CLASS2_IF1_EN+USBD_CUSTOM_CLASS2_IF1_EN+USBD_CUSTOM_CLASS2_IF2_EN+USBD_CUSTOM_CLASS2_IF3_EN)
#define USBD_CUSTOM_CLASS2_IF_CNT       (USBD3_CUSTOM_CLASS2_IF_CNT)
#define USBD_CUSTOM_CLASS2_IF0_EP_CNT   (USBD3_CUSTOM_CLASS2_IF0_EP_CNT)
#define USBD_CUSTOM_CLASS2_IF1_EP_CNT   (USBD3_CUSTOM_CLASS2_IF1_EP_CNT)
#define USBD_CUSTOM_CLASS2_IF2_EP_CNT   (USBD3_CUSTOM_CLASS2_IF2_EP_CNT)
#define USBD_CUSTOM_CLASS2_IF3_EP_CNT   (USBD3_CUSTOM_CLASS2_IF3_EP_CNT)
#define USBD_CUSTOM_CLASS2_EP_CNT       (USBD3_CUSTOM_CLASS2_EP_CNT)
#define USBD_CUSTOM_CLASS2_EP_MSK       (USBD3_CUSTOM_CLASS2_EP_MSK)
#define USBD_CUSTOM_CLASS2_IF_DESC_CNT  (USBD3_CUSTOM_CLASS2_IF_DESC_CNT)
#define USBD_CUSTOM_CLASS2_IF0_STR_IDX  (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS0_STR_CNT+USBD3_CUSTOM_CLASS1_STR_CNT)
#define USBD_CUSTOM_CLASS2_IF1_STR_IDX  (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS0_STR_CNT+USBD3_CUSTOM_CLASS1_STR_CNT+USBD_CUSTOM_CLASS2_IF0_EN)
#define USBD_CUSTOM_CLASS2_IF2_STR_IDX  (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS0_STR_CNT+USBD3_CUSTOM_CLASS1_STR_CNT+USBD_CUSTOM_CLASS2_IF0_EN+USBD_CUSTOM_CLASS2_IF1_EN)
#define USBD_CUSTOM_CLASS2_IF3_STR_IDX  (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS0_STR_CNT+USBD3_CUSTOM_CLASS1_STR_CNT+USBD_CUSTOM_CLASS2_IF0_EN+USBD_CUSTOM_CLASS2_IF1_EN+USBD_CUSTOM_CLASS2_IF2_EN)
#define USBD_CUSTOM_CLASS2_STR_CNT      (USBD3_CUSTOM_CLASS2_STR_CNT)
#if    (USBD_CUSTOM_CLASS2_IF0_EN == 1)
#if   ((USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT_EN) > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN  * USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF0_EP_INT_OUT  * USBD_CUSTOM_CLASS2_IF0_EP_INT_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF0_EP_INT_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF0_EP_INT_IN   * USBD_CUSTOM_CLASS2_IF0_EP_INT_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF0_EP_INT_IN)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF0_EP_ISO_OUT  * USBD_CUSTOM_CLASS2_IF0_EP_ISO_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF0_EP_ISO_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF0_EP_ISO_IN   * USBD_CUSTOM_CLASS2_IF0_EP_ISO_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF0_EP_ISO_IN)
#endif
#endif
#if    (USBD_CUSTOM_CLASS2_IF1_EN == 1)
#if   ((USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT_EN) > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN  * USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF1_EP_INT_OUT  * USBD_CUSTOM_CLASS2_IF1_EP_INT_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF1_EP_INT_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF1_EP_INT_IN   * USBD_CUSTOM_CLASS2_IF1_EP_INT_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF1_EP_INT_IN)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF1_EP_ISO_OUT  * USBD_CUSTOM_CLASS2_IF1_EP_ISO_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF1_EP_ISO_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF1_EP_ISO_IN   * USBD_CUSTOM_CLASS2_IF1_EP_ISO_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF1_EP_ISO_IN)
#endif
#endif
#if    (USBD_CUSTOM_CLASS2_IF2_EN == 1)
#if   ((USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT_EN) > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN  * USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF2_EP_INT_OUT  * USBD_CUSTOM_CLASS2_IF2_EP_INT_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF2_EP_INT_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF2_EP_INT_IN   * USBD_CUSTOM_CLASS2_IF2_EP_INT_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF2_EP_INT_IN)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF2_EP_ISO_OUT  * USBD_CUSTOM_CLASS2_IF2_EP_ISO_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF2_EP_ISO_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF2_EP_ISO_IN   * USBD_CUSTOM_CLASS2_IF2_EP_ISO_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF2_EP_ISO_IN)
#endif
#endif
#if    (USBD_CUSTOM_CLASS2_IF3_EN == 1)
#if   ((USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT_EN) > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN  * USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF3_EP_INT_OUT  * USBD_CUSTOM_CLASS2_IF3_EP_INT_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF3_EP_INT_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF3_EP_INT_IN   * USBD_CUSTOM_CLASS2_IF3_EP_INT_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF3_EP_INT_IN)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF3_EP_ISO_OUT  * USBD_CUSTOM_CLASS2_IF3_EP_ISO_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF3_EP_ISO_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS2_IF3_EP_ISO_IN   * USBD_CUSTOM_CLASS2_IF3_EP_ISO_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS2_IF3_EP_ISO_IN)
#endif
#endif
#if    (USBD_CUSTOM_CLASS2_IF0_EN == 1)
#if   (((USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT_EN) ==  1) || ((USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN_EN) ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_custom_class_ep_thread_id[2][1]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT_EN) ==  2) || ((USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN_EN) ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_custom_class_ep_thread_id[2][2]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT_EN) ==  3) || ((USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN_EN) ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_custom_class_ep_thread_id[2][3]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT_EN) ==  4) || ((USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN_EN) ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_custom_class_ep_thread_id[2][4]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT_EN) ==  5) || ((USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN_EN) ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_custom_class_ep_thread_id[2][5]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT_EN) ==  6) || ((USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN_EN) ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_custom_class_ep_thread_id[2][6]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT_EN) ==  7) || ((USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN_EN) ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_custom_class_ep_thread_id[2][7]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT_EN) ==  8) || ((USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN_EN) ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_custom_class_ep_thread_id[2][8]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT_EN) ==  9) || ((USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN_EN) ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_custom_class_ep_thread_id[2][9]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT_EN) == 10) || ((USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN_EN) == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_custom_class_ep_thread_id[2][10]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT_EN) == 11) || ((USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN_EN) == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_custom_class_ep_thread_id[2][11]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT_EN) == 12) || ((USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN_EN) == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_custom_class_ep_thread_id[2][12]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT_EN) == 13) || ((USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN_EN) == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_custom_class_ep_thread_id[2][13]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT_EN) == 14) || ((USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN_EN) == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_custom_class_ep_thread_id[2][14]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF0_EP_BULK_OUT_EN) == 15) || ((USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF0_EP_BULK_IN_EN) == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_custom_class_ep_thread_id[2][15]
#endif
#endif
#if    (USBD_CUSTOM_CLASS2_IF1_EN == 1)
#if   (((USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT_EN) ==  1) || ((USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN_EN) ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_custom_class_ep_thread_id[2][1]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT_EN) ==  2) || ((USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN_EN) ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_custom_class_ep_thread_id[2][2]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT_EN) ==  3) || ((USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN_EN) ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_custom_class_ep_thread_id[2][3]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT_EN) ==  4) || ((USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN_EN) ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_custom_class_ep_thread_id[2][4]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT_EN) ==  5) || ((USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN_EN) ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_custom_class_ep_thread_id[2][5]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT_EN) ==  6) || ((USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN_EN) ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_custom_class_ep_thread_id[2][6]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT_EN) ==  7) || ((USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN_EN) ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_custom_class_ep_thread_id[2][7]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT_EN) ==  8) || ((USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN_EN) ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_custom_class_ep_thread_id[2][8]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT_EN) ==  9) || ((USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN_EN) ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_custom_class_ep_thread_id[2][9]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT_EN) == 10) || ((USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN_EN) == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_custom_class_ep_thread_id[2][10]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT_EN) == 11) || ((USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN_EN) == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_custom_class_ep_thread_id[2][11]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT_EN) == 12) || ((USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN_EN) == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_custom_class_ep_thread_id[2][12]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT_EN) == 13) || ((USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN_EN) == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_custom_class_ep_thread_id[2][13]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT_EN) == 14) || ((USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN_EN) == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_custom_class_ep_thread_id[2][14]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF1_EP_BULK_OUT_EN) == 15) || ((USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF1_EP_BULK_IN_EN) == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_custom_class_ep_thread_id[2][15]
#endif
#endif
#if    (USBD_CUSTOM_CLASS2_IF2_EN == 1)
#if   (((USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT_EN) ==  1) || ((USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN_EN) ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_custom_class_ep_thread_id[2][1]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT_EN) ==  2) || ((USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN_EN) ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_custom_class_ep_thread_id[2][2]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT_EN) ==  3) || ((USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN_EN) ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_custom_class_ep_thread_id[2][3]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT_EN) ==  4) || ((USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN_EN) ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_custom_class_ep_thread_id[2][4]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT_EN) ==  5) || ((USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN_EN) ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_custom_class_ep_thread_id[2][5]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT_EN) ==  6) || ((USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN_EN) ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_custom_class_ep_thread_id[2][6]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT_EN) ==  7) || ((USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN_EN) ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_custom_class_ep_thread_id[2][7]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT_EN) ==  8) || ((USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN_EN) ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_custom_class_ep_thread_id[2][8]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT_EN) ==  9) || ((USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN_EN) ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_custom_class_ep_thread_id[2][9]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT_EN) == 10) || ((USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN_EN) == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_custom_class_ep_thread_id[2][10]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT_EN) == 11) || ((USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN_EN) == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_custom_class_ep_thread_id[2][11]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT_EN) == 12) || ((USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN_EN) == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_custom_class_ep_thread_id[2][12]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT_EN) == 13) || ((USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN_EN) == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_custom_class_ep_thread_id[2][13]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT_EN) == 14) || ((USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN_EN) == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_custom_class_ep_thread_id[2][14]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF2_EP_BULK_OUT_EN) == 15) || ((USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF2_EP_BULK_IN_EN) == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_custom_class_ep_thread_id[2][15]
#endif
#endif
#if    (USBD_CUSTOM_CLASS2_IF3_EN == 1)
#if   (((USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT_EN) ==  1) || ((USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN_EN) ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_custom_class_ep_thread_id[2][1]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT_EN) ==  2) || ((USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN_EN) ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_custom_class_ep_thread_id[2][2]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT_EN) ==  3) || ((USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN_EN) ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_custom_class_ep_thread_id[2][3]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT_EN) ==  4) || ((USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN_EN) ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_custom_class_ep_thread_id[2][4]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT_EN) ==  5) || ((USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN_EN) ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_custom_class_ep_thread_id[2][5]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT_EN) ==  6) || ((USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN_EN) ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_custom_class_ep_thread_id[2][6]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT_EN) ==  7) || ((USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN_EN) ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_custom_class_ep_thread_id[2][7]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT_EN) ==  8) || ((USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN_EN) ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_custom_class_ep_thread_id[2][8]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT_EN) ==  9) || ((USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN_EN) ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_custom_class_ep_thread_id[2][9]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT_EN) == 10) || ((USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN_EN) == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_custom_class_ep_thread_id[2][10]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT_EN) == 11) || ((USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN_EN) == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_custom_class_ep_thread_id[2][11]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT_EN) == 12) || ((USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN_EN) == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_custom_class_ep_thread_id[2][12]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT_EN) == 13) || ((USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN_EN) == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_custom_class_ep_thread_id[2][13]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT_EN) == 14) || ((USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN_EN) == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_custom_class_ep_thread_id[2][14]
#endif
#if   (((USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS2_IF3_EP_BULK_OUT_EN) == 15) || ((USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS2_IF3_EP_BULK_IN_EN) == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_custom_class_ep_thread_id[2][15]
#endif
#define USBD3_CUSTOM_CLASS2_IF_EP_CNT  (USBD3_CUSTOM_CLASS2_IF0_EP_CNT+USBD3_CUSTOM_CLASS2_IF1_EP_CNT+USBD3_CUSTOM_CLASS2_IF2_EP_CNT+USBD3_CUSTOM_CLASS2_IF3_EP_CNT)
#endif
#else
#define USBD3_CUSTOM_CLASS2             0
#define USBD3_CUSTOM_CLASS2_IF_CNT      0
#define USBD3_CUSTOM_CLASS2_EP_CNT      0
#define USBD3_CUSTOM_CLASS2_IF_DESC_CNT 0
#define USBD3_CUSTOM_CLASS2_STR_CNT     0
#endif
#if    (defined(RTE_USB_Device_CustomClass_3) && (USBD_CUSTOM_CLASS3_DEV == 3))              // USB Device 3 Custom Class 3
#define USBD3_CUSTOM_CLASS3             1
#define USBD3_CUSTOM_CLASS3_IF_CNT    ((USBD_CUSTOM_CLASS3_IF0_EN*(USBD_CUSTOM_CLASS3_IF0_ALT == 0))+\
                                       (USBD_CUSTOM_CLASS3_IF1_EN*(USBD_CUSTOM_CLASS3_IF1_ALT == 0))+\
                                       (USBD_CUSTOM_CLASS3_IF2_EN*(USBD_CUSTOM_CLASS3_IF2_ALT == 0))+\
                                       (USBD_CUSTOM_CLASS3_IF3_EN*(USBD_CUSTOM_CLASS3_IF3_ALT == 0)))
#define USBD3_CUSTOM_CLASS3_IF0_EP_CNT ((USBD_CUSTOM_CLASS3_IF0_EN) *           \
                                       (USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT_EN + \
                                        USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN_EN  + \
                                        USBD_CUSTOM_CLASS3_IF0_EP_INT_OUT_EN  + \
                                        USBD_CUSTOM_CLASS3_IF0_EP_INT_IN_EN   + \
                                        USBD_CUSTOM_CLASS3_IF0_EP_ISO_OUT_EN  + \
                                        USBD_CUSTOM_CLASS3_IF0_EP_ISO_IN_EN))
#define USBD3_CUSTOM_CLASS3_IF0_EP_MSK ((USBD_CUSTOM_CLASS3_IF0_EN) *           \
                                       (USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT_EN * (1 << USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT ) | \
                                        USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN_EN  * (1 << USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN  ) | \
                                        USBD_CUSTOM_CLASS3_IF0_EP_INT_OUT_EN  * (1 << USBD_CUSTOM_CLASS3_IF0_EP_INT_OUT  ) | \
                                        USBD_CUSTOM_CLASS3_IF0_EP_INT_IN_EN   * (1 << USBD_CUSTOM_CLASS3_IF0_EP_INT_IN   ) | \
                                        USBD_CUSTOM_CLASS3_IF0_EP_ISO_OUT_EN  * (1 << USBD_CUSTOM_CLASS3_IF0_EP_ISO_OUT  ) | \
                                        USBD_CUSTOM_CLASS3_IF0_EP_ISO_IN_EN   * (1 << USBD_CUSTOM_CLASS3_IF0_EP_ISO_IN   ) ))
#define USBD3_CUSTOM_CLASS3_IF1_EP_CNT ((USBD_CUSTOM_CLASS3_IF1_EN) *           \
                                       (USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT_EN + \
                                        USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN_EN  + \
                                        USBD_CUSTOM_CLASS3_IF1_EP_INT_OUT_EN  + \
                                        USBD_CUSTOM_CLASS3_IF1_EP_INT_IN_EN   + \
                                        USBD_CUSTOM_CLASS3_IF1_EP_ISO_OUT_EN  + \
                                        USBD_CUSTOM_CLASS3_IF1_EP_ISO_IN_EN))
#define USBD3_CUSTOM_CLASS3_IF1_EP_MSK ((USBD_CUSTOM_CLASS3_IF1_EN) *           \
                                       (USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT_EN * (1 << USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT ) | \
                                        USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN_EN  * (1 << USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN  ) | \
                                        USBD_CUSTOM_CLASS3_IF1_EP_INT_OUT_EN  * (1 << USBD_CUSTOM_CLASS3_IF1_EP_INT_OUT  ) | \
                                        USBD_CUSTOM_CLASS3_IF1_EP_INT_IN_EN   * (1 << USBD_CUSTOM_CLASS3_IF1_EP_INT_IN   ) | \
                                        USBD_CUSTOM_CLASS3_IF1_EP_ISO_OUT_EN  * (1 << USBD_CUSTOM_CLASS3_IF1_EP_ISO_OUT  ) | \
                                        USBD_CUSTOM_CLASS3_IF1_EP_ISO_IN_EN   * (1 << USBD_CUSTOM_CLASS3_IF1_EP_ISO_IN   ) ))
#define USBD3_CUSTOM_CLASS3_IF2_EP_CNT ((USBD_CUSTOM_CLASS3_IF2_EN) *           \
                                       (USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT_EN + \
                                        USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN_EN  + \
                                        USBD_CUSTOM_CLASS3_IF2_EP_INT_OUT_EN  + \
                                        USBD_CUSTOM_CLASS3_IF2_EP_INT_IN_EN   + \
                                        USBD_CUSTOM_CLASS3_IF2_EP_ISO_OUT_EN  + \
                                        USBD_CUSTOM_CLASS3_IF2_EP_ISO_IN_EN))
#define USBD3_CUSTOM_CLASS3_IF2_EP_MSK ((USBD_CUSTOM_CLASS3_IF2_EN) *           \
                                       (USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT_EN * (1 << USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT ) | \
                                        USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN_EN  * (1 << USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN  ) | \
                                        USBD_CUSTOM_CLASS3_IF2_EP_INT_OUT_EN  * (1 << USBD_CUSTOM_CLASS3_IF2_EP_INT_OUT  ) | \
                                        USBD_CUSTOM_CLASS3_IF2_EP_INT_IN_EN   * (1 << USBD_CUSTOM_CLASS3_IF2_EP_INT_IN   ) | \
                                        USBD_CUSTOM_CLASS3_IF2_EP_ISO_OUT_EN  * (1 << USBD_CUSTOM_CLASS3_IF2_EP_ISO_OUT  ) | \
                                        USBD_CUSTOM_CLASS3_IF2_EP_ISO_IN_EN   * (1 << USBD_CUSTOM_CLASS3_IF2_EP_ISO_IN   ) ))
#define USBD3_CUSTOM_CLASS3_IF3_EP_CNT ((USBD_CUSTOM_CLASS3_IF3_EN) *           \
                                       (USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT_EN + \
                                        USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN_EN  + \
                                        USBD_CUSTOM_CLASS3_IF3_EP_INT_OUT_EN  + \
                                        USBD_CUSTOM_CLASS3_IF3_EP_INT_IN_EN   + \
                                        USBD_CUSTOM_CLASS3_IF3_EP_ISO_OUT_EN  + \
                                        USBD_CUSTOM_CLASS3_IF3_EP_ISO_IN_EN))
#define USBD3_CUSTOM_CLASS3_IF3_EP_MSK ((USBD_CUSTOM_CLASS3_IF3_EN) *           \
                                       (USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT_EN * (1 << USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT ) | \
                                        USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN_EN  * (1 << USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN  ) | \
                                        USBD_CUSTOM_CLASS3_IF3_EP_INT_OUT_EN  * (1 << USBD_CUSTOM_CLASS3_IF3_EP_INT_OUT  ) | \
                                        USBD_CUSTOM_CLASS3_IF3_EP_INT_IN_EN   * (1 << USBD_CUSTOM_CLASS3_IF3_EP_INT_IN   ) | \
                                        USBD_CUSTOM_CLASS3_IF3_EP_ISO_OUT_EN  * (1 << USBD_CUSTOM_CLASS3_IF3_EP_ISO_OUT  ) | \
                                        USBD_CUSTOM_CLASS3_IF3_EP_ISO_IN_EN   * (1 << USBD_CUSTOM_CLASS3_IF3_EP_ISO_IN   ) ))
#define USBD3_CUSTOM_CLASS3_EP_CNT      (USBD3_CUSTOM_CLASS3_IF0_EP_CNT+USBD3_CUSTOM_CLASS3_IF1_EP_CNT+USBD3_CUSTOM_CLASS3_IF2_EP_CNT+USBD3_CUSTOM_CLASS3_IF3_EP_CNT)
#define USBD3_CUSTOM_CLASS3_EP_MSK      (USBD3_CUSTOM_CLASS3_IF0_EP_MSK|USBD3_CUSTOM_CLASS3_IF1_EP_MSK|USBD3_CUSTOM_CLASS3_IF2_EP_MSK|USBD3_CUSTOM_CLASS3_IF3_EP_MSK)
#define USBD3_CUSTOM_CLASS3_IF_DESC_CNT (USBD_CUSTOM_CLASS3_IF0_EN+USBD_CUSTOM_CLASS3_IF1_EN+USBD_CUSTOM_CLASS3_IF2_EN+USBD_CUSTOM_CLASS3_IF3_EN)
#define USBD3_CUSTOM_CLASS3_STR_CNT     (USBD_CUSTOM_CLASS3_IF1_EN+USBD_CUSTOM_CLASS3_IF1_EN+USBD_CUSTOM_CLASS3_IF2_EN+USBD_CUSTOM_CLASS3_IF3_EN)
#define USBD_CUSTOM_CLASS3_IF_CNT       (USBD3_CUSTOM_CLASS3_IF_CNT)
#define USBD_CUSTOM_CLASS3_IF0_EP_CNT   (USBD3_CUSTOM_CLASS3_IF0_EP_CNT)
#define USBD_CUSTOM_CLASS3_IF1_EP_CNT   (USBD3_CUSTOM_CLASS3_IF1_EP_CNT)
#define USBD_CUSTOM_CLASS3_IF2_EP_CNT   (USBD3_CUSTOM_CLASS3_IF2_EP_CNT)
#define USBD_CUSTOM_CLASS3_IF3_EP_CNT   (USBD3_CUSTOM_CLASS3_IF3_EP_CNT)
#define USBD_CUSTOM_CLASS3_EP_CNT       (USBD3_CUSTOM_CLASS3_EP_CNT)
#define USBD_CUSTOM_CLASS3_EP_MSK       (USBD3_CUSTOM_CLASS3_EP_MSK)
#define USBD_CUSTOM_CLASS3_IF_DESC_CNT  (USBD3_CUSTOM_CLASS3_IF_DESC_CNT)
#define USBD_CUSTOM_CLASS3_IF0_STR_IDX  (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS0_STR_CNT+USBD3_CUSTOM_CLASS1_STR_CNT+USBD3_CUSTOM_CLASS2_STR_CNT)
#define USBD_CUSTOM_CLASS3_IF1_STR_IDX  (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS0_STR_CNT+USBD3_CUSTOM_CLASS1_STR_CNT+USBD3_CUSTOM_CLASS2_STR_CNT+USBD_CUSTOM_CLASS3_IF0_EN)
#define USBD_CUSTOM_CLASS3_IF2_STR_IDX  (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS0_STR_CNT+USBD3_CUSTOM_CLASS1_STR_CNT+USBD3_CUSTOM_CLASS2_STR_CNT+USBD_CUSTOM_CLASS3_IF0_EN+USBD_CUSTOM_CLASS3_IF1_EN)
#define USBD_CUSTOM_CLASS3_IF3_STR_IDX  (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS0_STR_CNT+USBD3_CUSTOM_CLASS1_STR_CNT+USBD3_CUSTOM_CLASS2_STR_CNT+USBD_CUSTOM_CLASS3_IF0_EN+USBD_CUSTOM_CLASS3_IF1_EN+USBD_CUSTOM_CLASS3_IF2_EN)
#define USBD_CUSTOM_CLASS3_STR_CNT      (USBD3_CUSTOM_CLASS3_STR_CNT)
#if    (USBD_CUSTOM_CLASS3_IF0_EN == 1)
#if   ((USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT_EN) > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN  * USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF0_EP_INT_OUT  * USBD_CUSTOM_CLASS3_IF0_EP_INT_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF0_EP_INT_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF0_EP_INT_IN   * USBD_CUSTOM_CLASS3_IF0_EP_INT_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF0_EP_INT_IN)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF0_EP_ISO_OUT  * USBD_CUSTOM_CLASS3_IF0_EP_ISO_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF0_EP_ISO_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF0_EP_ISO_IN   * USBD_CUSTOM_CLASS3_IF0_EP_ISO_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF0_EP_ISO_IN)
#endif
#endif
#if    (USBD_CUSTOM_CLASS3_IF1_EN == 1)
#if   ((USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT_EN) > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN  * USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF1_EP_INT_OUT  * USBD_CUSTOM_CLASS3_IF1_EP_INT_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF1_EP_INT_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF1_EP_INT_IN   * USBD_CUSTOM_CLASS3_IF1_EP_INT_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF1_EP_INT_IN)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF1_EP_ISO_OUT  * USBD_CUSTOM_CLASS3_IF1_EP_ISO_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF1_EP_ISO_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF1_EP_ISO_IN   * USBD_CUSTOM_CLASS3_IF1_EP_ISO_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF1_EP_ISO_IN)
#endif
#endif
#if    (USBD_CUSTOM_CLASS3_IF2_EN == 1)
#if   ((USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT_EN) > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN  * USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF2_EP_INT_OUT  * USBD_CUSTOM_CLASS3_IF2_EP_INT_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF2_EP_INT_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF2_EP_INT_IN   * USBD_CUSTOM_CLASS3_IF2_EP_INT_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF2_EP_INT_IN)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF2_EP_ISO_OUT  * USBD_CUSTOM_CLASS3_IF2_EP_ISO_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF2_EP_ISO_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF2_EP_ISO_IN   * USBD_CUSTOM_CLASS3_IF2_EP_ISO_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF2_EP_ISO_IN)
#endif
#endif
#if    (USBD_CUSTOM_CLASS3_IF3_EN == 1)
#if   ((USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT_EN) > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN  * USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF3_EP_INT_OUT  * USBD_CUSTOM_CLASS3_IF3_EP_INT_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF3_EP_INT_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF3_EP_INT_IN   * USBD_CUSTOM_CLASS3_IF3_EP_INT_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF3_EP_INT_IN)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF3_EP_ISO_OUT  * USBD_CUSTOM_CLASS3_IF3_EP_ISO_OUT_EN)  > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF3_EP_ISO_OUT)
#endif
#if   ((USBD_CUSTOM_CLASS3_IF3_EP_ISO_IN   * USBD_CUSTOM_CLASS3_IF3_EP_ISO_IN_EN)   > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CUSTOM_CLASS3_IF3_EP_ISO_IN)
#endif
#endif
#if    (USBD_CUSTOM_CLASS3_IF0_EN == 1)
#if   (((USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT_EN) ==  1) || ((USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN_EN) ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_custom_class_ep_thread_id[3][1]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT_EN) ==  2) || ((USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN_EN) ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_custom_class_ep_thread_id[3][2]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT_EN) ==  3) || ((USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN_EN) ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_custom_class_ep_thread_id[3][3]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT_EN) ==  4) || ((USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN_EN) ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_custom_class_ep_thread_id[3][4]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT_EN) ==  5) || ((USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN_EN) ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_custom_class_ep_thread_id[3][5]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT_EN) ==  6) || ((USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN_EN) ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_custom_class_ep_thread_id[3][6]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT_EN) ==  7) || ((USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN_EN) ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_custom_class_ep_thread_id[3][7]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT_EN) ==  8) || ((USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN_EN) ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_custom_class_ep_thread_id[3][8]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT_EN) ==  9) || ((USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN_EN) ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_custom_class_ep_thread_id[3][9]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT_EN) == 10) || ((USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN_EN) == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_custom_class_ep_thread_id[3][10]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT_EN) == 11) || ((USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN_EN) == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_custom_class_ep_thread_id[3][11]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT_EN) == 12) || ((USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN_EN) == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_custom_class_ep_thread_id[3][12]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT_EN) == 13) || ((USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN_EN) == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_custom_class_ep_thread_id[3][13]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT_EN) == 14) || ((USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN_EN) == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_custom_class_ep_thread_id[3][14]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF0_EP_BULK_OUT_EN) == 15) || ((USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF0_EP_BULK_IN_EN) == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_custom_class_ep_thread_id[3][15]
#endif
#endif
#if    (USBD_CUSTOM_CLASS3_IF1_EN == 1)
#if   (((USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT_EN) ==  1) || ((USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN_EN) ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_custom_class_ep_thread_id[3][1]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT_EN) ==  2) || ((USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN_EN) ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_custom_class_ep_thread_id[3][2]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT_EN) ==  3) || ((USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN_EN) ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_custom_class_ep_thread_id[3][3]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT_EN) ==  4) || ((USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN_EN) ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_custom_class_ep_thread_id[3][4]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT_EN) ==  5) || ((USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN_EN) ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_custom_class_ep_thread_id[3][5]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT_EN) ==  6) || ((USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN_EN) ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_custom_class_ep_thread_id[3][6]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT_EN) ==  7) || ((USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN_EN) ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_custom_class_ep_thread_id[3][7]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT_EN) ==  8) || ((USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN_EN) ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_custom_class_ep_thread_id[3][8]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT_EN) ==  9) || ((USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN_EN) ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_custom_class_ep_thread_id[3][9]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT_EN) == 10) || ((USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN_EN) == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_custom_class_ep_thread_id[3][10]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT_EN) == 11) || ((USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN_EN) == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_custom_class_ep_thread_id[3][11]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT_EN) == 12) || ((USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN_EN) == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_custom_class_ep_thread_id[3][12]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT_EN) == 13) || ((USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN_EN) == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_custom_class_ep_thread_id[3][13]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT_EN) == 14) || ((USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN_EN) == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_custom_class_ep_thread_id[3][14]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF1_EP_BULK_OUT_EN) == 15) || ((USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF1_EP_BULK_IN_EN) == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_custom_class_ep_thread_id[3][15]
#endif
#endif
#if    (USBD_CUSTOM_CLASS3_IF2_EN == 1)
#if   (((USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT_EN) ==  1) || ((USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN_EN) ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_custom_class_ep_thread_id[3][1]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT_EN) ==  2) || ((USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN_EN) ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_custom_class_ep_thread_id[3][2]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT_EN) ==  3) || ((USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN_EN) ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_custom_class_ep_thread_id[3][3]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT_EN) ==  4) || ((USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN_EN) ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_custom_class_ep_thread_id[3][4]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT_EN) ==  5) || ((USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN_EN) ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_custom_class_ep_thread_id[3][5]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT_EN) ==  6) || ((USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN_EN) ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_custom_class_ep_thread_id[3][6]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT_EN) ==  7) || ((USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN_EN) ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_custom_class_ep_thread_id[3][7]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT_EN) ==  8) || ((USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN_EN) ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_custom_class_ep_thread_id[3][8]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT_EN) ==  9) || ((USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN_EN) ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_custom_class_ep_thread_id[3][9]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT_EN) == 10) || ((USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN_EN) == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_custom_class_ep_thread_id[3][10]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT_EN) == 11) || ((USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN_EN) == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_custom_class_ep_thread_id[3][11]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT_EN) == 12) || ((USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN_EN) == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_custom_class_ep_thread_id[3][12]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT_EN) == 13) || ((USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN_EN) == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_custom_class_ep_thread_id[3][13]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT_EN) == 14) || ((USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN_EN) == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_custom_class_ep_thread_id[3][14]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF2_EP_BULK_OUT_EN) == 15) || ((USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF2_EP_BULK_IN_EN) == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_custom_class_ep_thread_id[3][15]
#endif
#endif
#if    (USBD_CUSTOM_CLASS3_IF3_EN == 1)
#if   (((USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT_EN) ==  1) || ((USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN_EN) ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_custom_class_ep_thread_id[3][1]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT_EN) ==  2) || ((USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN_EN) ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_custom_class_ep_thread_id[3][2]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT_EN) ==  3) || ((USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN_EN) ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_custom_class_ep_thread_id[3][3]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT_EN) ==  4) || ((USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN_EN) ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_custom_class_ep_thread_id[3][4]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT_EN) ==  5) || ((USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN_EN) ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_custom_class_ep_thread_id[3][5]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT_EN) ==  6) || ((USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN_EN) ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_custom_class_ep_thread_id[3][6]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT_EN) ==  7) || ((USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN_EN) ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_custom_class_ep_thread_id[3][7]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT_EN) ==  8) || ((USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN_EN) ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_custom_class_ep_thread_id[3][8]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT_EN) ==  9) || ((USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN_EN) ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_custom_class_ep_thread_id[3][9]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT_EN) == 10) || ((USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN_EN) == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_custom_class_ep_thread_id[3][10]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT_EN) == 11) || ((USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN_EN) == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_custom_class_ep_thread_id[3][11]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT_EN) == 12) || ((USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN_EN) == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_custom_class_ep_thread_id[3][12]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT_EN) == 13) || ((USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN_EN) == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_custom_class_ep_thread_id[3][13]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT_EN) == 14) || ((USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN_EN) == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_custom_class_ep_thread_id[3][14]
#endif
#if   (((USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT * USBD_CUSTOM_CLASS3_IF3_EP_BULK_OUT_EN) == 15) || ((USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN * USBD_CUSTOM_CLASS3_IF3_EP_BULK_IN_EN) == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_custom_class_ep_thread_id[3][15]
#endif
#define USBD3_CUSTOM_CLASS3_IF_EP_CNT  (USBD3_CUSTOM_CLASS3_IF0_EP_CNT+USBD3_CUSTOM_CLASS3_IF1_EP_CNT+USBD3_CUSTOM_CLASS3_IF2_EP_CNT+USBD3_CUSTOM_CLASS3_IF3_EP_CNT)
#endif
#else
#define USBD3_CUSTOM_CLASS3             0
#define USBD3_CUSTOM_CLASS3_IF_CNT      0
#define USBD3_CUSTOM_CLASS3_EP_CNT      0
#define USBD3_CUSTOM_CLASS3_IF_DESC_CNT 0
#define USBD3_CUSTOM_CLASS3_STR_CNT     0
#endif

#define USBD3_CUSTOM_CLASS_CNT         (USBD3_CUSTOM_CLASS0+USBD3_CUSTOM_CLASS1+USBD3_CUSTOM_CLASS2+USBD3_CUSTOM_CLASS3)
#define USBD3_CUSTOM_CLASS_IF_CNT      (USBD3_CUSTOM_CLASS0_IF_CNT+USBD3_CUSTOM_CLASS1_IF_CNT+USBD3_CUSTOM_CLASS2_IF_CNT+USBD3_CUSTOM_CLASS3_IF_CNT)
#define USBD3_CUSTOM_CLASS_EP_CNT      (USBD3_CUSTOM_CLASS0_EP_CNT+USBD3_CUSTOM_CLASS1_EP_CNT+USBD3_CUSTOM_CLASS2_EP_CNT+USBD3_CUSTOM_CLASS3_EP_CNT)
#define USBD3_CUSTOM_CLASS_IF_DESC_CNT (USBD3_CUSTOM_CLASS0_IF_DESC_CNT+USBD3_CUSTOM_CLASS1_IF_DESC_CNT+USBD3_CUSTOM_CLASS2_IF_DESC_CNT+USBD3_CUSTOM_CLASS3_IF_DESC_CNT)
#define USBD3_CUSTOM_CLASS_STR_CNT     (USBD3_CUSTOM_CLASS0_STR_CNT+USBD3_CUSTOM_CLASS1_STR_CNT+USBD3_CUSTOM_CLASS2_STR_CNT+USBD3_CUSTOM_CLASS3_STR_CNT)

#if    (defined(RTE_USB_Device_ADC_0) && (USBD_ADC0_DEV == 3))                  // USB Device 3 Audio Class 0
#define USBD3_ADC0                      1
#define USBD3_ADC0_IF_CNT               2
#define USBD3_ADC0_IF0_EP_CNT           1
#define USBD3_ADC0_IF1_EP_CNT           0
#define USBD3_ADC0_EP_CNT              (USBD3_ADC0_IF0_EP_CNT+USBD3_ADC0_IF1_EP_CNT)
#define USBD3_ADC0_STR_CNT              3
#define USBD_ADC0_IF0_NUM              (USBD3_CUSTOM_CLASS_IF_CNT)
#define USBD_ADC0_IF1_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+1)
#define USBD_ADC0_IF_CNT               (USBD3_ADC0_IF_CNT)
#define USBD_ADC0_EP_CNT               (USBD3_ADC0_EP_CNT)
#define USBD_ADC0_IF0_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT)
#define USBD_ADC0_IF1_0_STR_IDX        (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+1)
#define USBD_ADC0_IF1_1_STR_IDX        (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+2)
#define USBD_ADC0_STR_CNT              (USBD3_ADC0_STR_CNT)
#if    (USBD_ADC0_EP_ISO_OUT > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_ADC0_EP_ISO_OUT)
#endif
#if   ((USBD_ADC0_EP_ISO_OUT ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_adc_thread_id[0]
#endif
#if   ((USBD_ADC0_EP_ISO_OUT ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_adc_thread_id[0]
#endif
#if   ((USBD_ADC0_EP_ISO_OUT ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_adc_thread_id[0]
#endif
#if   ((USBD_ADC0_EP_ISO_OUT ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_adc_thread_id[0]
#endif
#if   ((USBD_ADC0_EP_ISO_OUT ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_adc_thread_id[0]
#endif
#if   ((USBD_ADC0_EP_ISO_OUT ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_adc_thread_id[0]
#endif
#if   ((USBD_ADC0_EP_ISO_OUT ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_adc_thread_id[0]
#endif
#if   ((USBD_ADC0_EP_ISO_OUT ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_adc_thread_id[0]
#endif
#if   ((USBD_ADC0_EP_ISO_OUT ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_adc_thread_id[0]
#endif
#if   ((USBD_ADC0_EP_ISO_OUT == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_adc_thread_id[0]
#endif
#if   ((USBD_ADC0_EP_ISO_OUT == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_adc_thread_id[0]
#endif
#if   ((USBD_ADC0_EP_ISO_OUT == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_adc_thread_id[0]
#endif
#if   ((USBD_ADC0_EP_ISO_OUT == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_adc_thread_id[0]
#endif
#if   ((USBD_ADC0_EP_ISO_OUT == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_adc_thread_id[0]
#endif
#if   ((USBD_ADC0_EP_ISO_OUT == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_adc_thread_id[0]
#endif
#else
#define USBD3_ADC0                      0
#define USBD3_ADC0_IF_CNT               0
#define USBD3_ADC0_EP_CNT               0
#define USBD3_ADC0_STR_CNT              0
#endif

#if    (defined(RTE_USB_Device_ADC_1) && (USBD_ADC1_DEV == 3))                  // USB Device 3 Audio Class 1
#define USBD3_ADC1                      1
#define USBD3_ADC1_IF_CNT               2
#define USBD3_ADC1_IF0_EP_CNT           1
#define USBD3_ADC1_IF1_EP_CNT           0
#define USBD3_ADC1_EP_CNT              (USBD3_ADC1_IF0_EP_CNT+USBD3_ADC1_IF1_EP_CNT)
#define USBD3_ADC1_STR_CNT              3
#define USBD_ADC1_IF0_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC0_IF_CNT)
#define USBD_ADC1_IF1_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC0_IF_CNT+1)
#define USBD_ADC1_IF_CNT               (USBD3_ADC1_IF_CNT)
#define USBD_ADC1_EP_CNT               (USBD3_ADC1_EP_CNT)
#define USBD_ADC1_IF0_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC0_STR_CNT)
#define USBD_ADC1_IF1_0_STR_IDX        (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC0_STR_CNT+1)
#define USBD_ADC1_IF1_1_STR_IDX        (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC0_STR_CNT+2)
#define USBD_ADC1_STR_CNT              (USBD3_ADC1_STR_CNT)
#if    (USBD_ADC1_EP_ISO_OUT > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_ADC1_EP_ISO_OUT)
#endif
#if   ((USBD_ADC1_EP_ISO_OUT ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_adc_thread_id[1]
#endif
#if   ((USBD_ADC1_EP_ISO_OUT ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_adc_thread_id[1]
#endif
#if   ((USBD_ADC1_EP_ISO_OUT ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_adc_thread_id[1]
#endif
#if   ((USBD_ADC1_EP_ISO_OUT ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_adc_thread_id[1]
#endif
#if   ((USBD_ADC1_EP_ISO_OUT ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_adc_thread_id[1]
#endif
#if   ((USBD_ADC1_EP_ISO_OUT ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_adc_thread_id[1]
#endif
#if   ((USBD_ADC1_EP_ISO_OUT ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_adc_thread_id[1]
#endif
#if   ((USBD_ADC1_EP_ISO_OUT ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_adc_thread_id[1]
#endif
#if   ((USBD_ADC1_EP_ISO_OUT ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_adc_thread_id[1]
#endif
#if   ((USBD_ADC1_EP_ISO_OUT == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_adc_thread_id[1]
#endif
#if   ((USBD_ADC1_EP_ISO_OUT == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_adc_thread_id[1]
#endif
#if   ((USBD_ADC1_EP_ISO_OUT == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_adc_thread_id[1]
#endif
#if   ((USBD_ADC1_EP_ISO_OUT == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_adc_thread_id[1]
#endif
#if   ((USBD_ADC1_EP_ISO_OUT == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_adc_thread_id[1]
#endif
#if   ((USBD_ADC1_EP_ISO_OUT == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_adc_thread_id[1]
#endif
#else
#define USBD3_ADC1                      0
#define USBD3_ADC1_IF_CNT               0
#define USBD3_ADC1_EP_CNT               0
#define USBD3_ADC1_STR_CNT              0
#endif

#if    (defined(RTE_USB_Device_ADC_2) && (USBD_ADC2_DEV == 3))                  // USB Device 3 Audio Class 2
#define USBD3_ADC2                      1
#define USBD3_ADC2_IF_CNT               2
#define USBD3_ADC2_IF0_EP_CNT           1
#define USBD3_ADC2_IF1_EP_CNT           0
#define USBD3_ADC2_EP_CNT              (USBD3_ADC2_IF0_EP_CNT+USBD3_ADC2_IF1_EP_CNT)
#define USBD3_ADC2_STR_CNT              3
#define USBD_ADC2_IF0_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC0_IF_CNT+USBD3_ADC1_IF_CNT)
#define USBD_ADC2_IF1_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC0_IF_CNT+USBD3_ADC1_IF_CNT+1)
#define USBD_ADC2_IF_CNT               (USBD3_ADC2_IF_CNT)
#define USBD_ADC2_EP_CNT               (USBD3_ADC2_EP_CNT)
#define USBD_ADC2_IF0_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC0_STR_CNT+USBD3_ADC1_STR_CNT)
#define USBD_ADC2_IF1_0_STR_IDX        (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC0_STR_CNT+USBD3_ADC1_STR_CNT+1)
#define USBD_ADC2_IF1_1_STR_IDX        (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC0_STR_CNT+USBD3_ADC1_STR_CNT+2)
#define USBD_ADC2_STR_CNT              (USBD3_ADC2_STR_CNT)
#if    (USBD_ADC2_EP_ISO_OUT > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_ADC2_EP_ISO_OUT)
#endif
#if   ((USBD_ADC2_EP_ISO_OUT ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_adc_thread_id[2]
#endif
#if   ((USBD_ADC2_EP_ISO_OUT ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_adc_thread_id[2]
#endif
#if   ((USBD_ADC2_EP_ISO_OUT ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_adc_thread_id[2]
#endif
#if   ((USBD_ADC2_EP_ISO_OUT ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_adc_thread_id[2]
#endif
#if   ((USBD_ADC2_EP_ISO_OUT ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_adc_thread_id[2]
#endif
#if   ((USBD_ADC2_EP_ISO_OUT ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_adc_thread_id[2]
#endif
#if   ((USBD_ADC2_EP_ISO_OUT ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_adc_thread_id[2]
#endif
#if   ((USBD_ADC2_EP_ISO_OUT ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_adc_thread_id[2]
#endif
#if   ((USBD_ADC2_EP_ISO_OUT ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_adc_thread_id[2]
#endif
#if   ((USBD_ADC2_EP_ISO_OUT == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_adc_thread_id[2]
#endif
#if   ((USBD_ADC2_EP_ISO_OUT == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_adc_thread_id[2]
#endif
#if   ((USBD_ADC2_EP_ISO_OUT == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_adc_thread_id[2]
#endif
#if   ((USBD_ADC2_EP_ISO_OUT == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_adc_thread_id[2]
#endif
#if   ((USBD_ADC2_EP_ISO_OUT == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_adc_thread_id[2]
#endif
#if   ((USBD_ADC2_EP_ISO_OUT == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_adc_thread_id[2]
#endif
#else
#define USBD3_ADC2                      0
#define USBD3_ADC2_IF_CNT               0
#define USBD3_ADC2_EP_CNT               0
#define USBD3_ADC2_STR_CNT              0
#endif

#if    (defined(RTE_USB_Device_ADC_3) && (USBD_ADC3_DEV == 3))                  // USB Device 3 Audio Class 3
#define USBD3_ADC3                      1
#define USBD3_ADC3_IF_CNT               2
#define USBD3_ADC3_IF0_EP_CNT           1
#define USBD3_ADC3_IF1_EP_CNT           0
#define USBD3_ADC3_EP_CNT              (USBD3_ADC3_IF0_EP_CNT+USBD3_ADC3_IF1_EP_CNT)
#define USBD3_ADC3_STR_CNT              3
#define USBD_ADC3_IF0_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC0_IF_CNT+USBD3_ADC1_IF_CNT+USBD3_ADC2_IF_CNT)
#define USBD_ADC3_IF1_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC0_IF_CNT+USBD3_ADC1_IF_CNT+USBD3_ADC2_IF_CNT+1)
#define USBD_ADC3_IF_CNT               (USBD3_ADC3_IF_CNT)
#define USBD_ADC3_EP_CNT               (USBD3_ADC3_EP_CNT)
#define USBD_ADC3_IF0_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC0_STR_CNT+USBD3_ADC1_STR_CNT+USBD3_ADC2_STR_CNT)
#define USBD_ADC3_IF1_0_STR_IDX        (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC0_STR_CNT+USBD3_ADC1_STR_CNT+USBD3_ADC2_STR_CNT+1)
#define USBD_ADC3_IF1_1_STR_IDX        (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC0_STR_CNT+USBD3_ADC1_STR_CNT+USBD3_ADC2_STR_CNT+2)
#define USBD_ADC3_STR_CNT              (USBD3_ADC3_STR_CNT)
#if    (USBD_ADC3_EP_ISO_OUT > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_ADC3_EP_ISO_OUT)
#endif
#if   ((USBD_ADC3_EP_ISO_OUT ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_adc_thread_id[3]
#endif
#if   ((USBD_ADC3_EP_ISO_OUT ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_adc_thread_id[3]
#endif
#if   ((USBD_ADC3_EP_ISO_OUT ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_adc_thread_id[3]
#endif
#if   ((USBD_ADC3_EP_ISO_OUT ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_adc_thread_id[3]
#endif
#if   ((USBD_ADC3_EP_ISO_OUT ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_adc_thread_id[3]
#endif
#if   ((USBD_ADC3_EP_ISO_OUT ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_adc_thread_id[3]
#endif
#if   ((USBD_ADC3_EP_ISO_OUT ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_adc_thread_id[3]
#endif
#if   ((USBD_ADC3_EP_ISO_OUT ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_adc_thread_id[3]
#endif
#if   ((USBD_ADC3_EP_ISO_OUT ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_adc_thread_id[3]
#endif
#if   ((USBD_ADC3_EP_ISO_OUT == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_adc_thread_id[3]
#endif
#if   ((USBD_ADC3_EP_ISO_OUT == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_adc_thread_id[3]
#endif
#if   ((USBD_ADC3_EP_ISO_OUT == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_adc_thread_id[3]
#endif
#if   ((USBD_ADC3_EP_ISO_OUT == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_adc_thread_id[3]
#endif
#if   ((USBD_ADC3_EP_ISO_OUT == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_adc_thread_id[3]
#endif
#if   ((USBD_ADC3_EP_ISO_OUT == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_adc_thread_id[3]
#endif
#else
#define USBD3_ADC3                      0
#define USBD3_ADC3_IF_CNT               0
#define USBD3_ADC3_EP_CNT               0
#define USBD3_ADC3_STR_CNT              0
#endif

#define USBD3_ADC_CNT                  (USBD3_ADC0+USBD3_ADC1+USBD3_ADC2+USBD3_ADC3)
#define USBD3_ADC_IF_CNT               (USBD3_ADC0_IF_CNT+USBD3_ADC1_IF_CNT+USBD3_ADC2_IF_CNT+USBD3_ADC3_IF_CNT)
#define USBD3_ADC_EP_CNT               (USBD3_ADC0_EP_CNT+USBD3_ADC1_EP_CNT+USBD3_ADC2_EP_CNT+USBD3_ADC3_EP_CNT)
#define USBD3_ADC_STR_CNT              (USBD3_ADC0_STR_CNT+USBD3_ADC1_STR_CNT+USBD3_ADC2_STR_CNT+USBD3_ADC3_STR_CNT)

#if    (defined(RTE_USB_Device_CDC_0) && (USBD_CDC0_DEV == 3))                  // USB Device 3 Communication Device Class 0
#define USBD3_CDC0                      1
#define USBD3_CDC0_IF_CNT               2
#define USBD3_CDC0_IF0_EP_CNT           1
#define USBD3_CDC0_IF1_EP_CNT           2
#define USBD3_CDC0_EP_CNT              (USBD3_CDC0_IF0_EP_CNT+USBD3_CDC0_IF1_EP_CNT)
#define USBD3_CDC0_STR_CNT              2
#define USBD_CDC0_IF0_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC_IF_CNT)
#define USBD_CDC0_IF1_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC_IF_CNT+1)
#define USBD_CDC0_IF_CNT               (USBD3_CDC0_IF_CNT)
#define USBD_CDC0_EP_CNT               (USBD3_CDC0_EP_CNT)
#define USBD_CDC0_IF0_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC_STR_CNT)
#define USBD_CDC0_IF1_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC_STR_CNT+1)
#define USBD_CDC0_STR_CNT              (USBD3_CDC0_STR_CNT)
#if    (USBD_CDC0_EP_INT_IN > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CDC0_EP_INT_IN)
#endif
#if    (USBD_CDC0_EP_BULK_IN > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CDC0_EP_BULK_IN)
#endif
#if    (USBD_CDC0_EP_BULK_OUT > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CDC0_EP_BULK_OUT)
#endif
#if    (USBD_CDC0_EP_INT_IN ==  1)
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_cdc_int_thread_id[0]
#endif
#if    (USBD_CDC0_EP_INT_IN ==  2)
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_cdc_int_thread_id[0]
#endif
#if    (USBD_CDC0_EP_INT_IN ==  3)
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_cdc_int_thread_id[0]
#endif
#if    (USBD_CDC0_EP_INT_IN ==  4)
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_cdc_int_thread_id[0]
#endif
#if    (USBD_CDC0_EP_INT_IN ==  5)
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_cdc_int_thread_id[0]
#endif
#if    (USBD_CDC0_EP_INT_IN ==  6)
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_cdc_int_thread_id[0]
#endif
#if    (USBD_CDC0_EP_INT_IN ==  7)
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_cdc_int_thread_id[0]
#endif
#if    (USBD_CDC0_EP_INT_IN ==  8)
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_cdc_int_thread_id[0]
#endif
#if    (USBD_CDC0_EP_INT_IN ==  9)
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_cdc_int_thread_id[0]
#endif
#if    (USBD_CDC0_EP_INT_IN == 10)
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_cdc_int_thread_id[0]
#endif
#if    (USBD_CDC0_EP_INT_IN == 11)
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_cdc_int_thread_id[0]
#endif
#if    (USBD_CDC0_EP_INT_IN == 12)
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_cdc_int_thread_id[0]
#endif
#if    (USBD_CDC0_EP_INT_IN == 13)
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_cdc_int_thread_id[0]
#endif
#if    (USBD_CDC0_EP_INT_IN == 14)
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_cdc_int_thread_id[0]
#endif
#if    (USBD_CDC0_EP_INT_IN == 15)
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_cdc_int_thread_id[0]
#endif
#if   ((USBD_CDC0_EP_BULK_IN ==  1) || (USBD_CDC0_EP_BULK_OUT ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_cdc_bulk_thread_id[0]
#endif
#if   ((USBD_CDC0_EP_BULK_IN ==  2) || (USBD_CDC0_EP_BULK_OUT ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_cdc_bulk_thread_id[0]
#endif
#if   ((USBD_CDC0_EP_BULK_IN ==  3) || (USBD_CDC0_EP_BULK_OUT ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_cdc_bulk_thread_id[0]
#endif
#if   ((USBD_CDC0_EP_BULK_IN ==  4) || (USBD_CDC0_EP_BULK_OUT ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_cdc_bulk_thread_id[0]
#endif
#if   ((USBD_CDC0_EP_BULK_IN ==  5) || (USBD_CDC0_EP_BULK_OUT ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_cdc_bulk_thread_id[0]
#endif
#if   ((USBD_CDC0_EP_BULK_IN ==  6) || (USBD_CDC0_EP_BULK_OUT ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_cdc_bulk_thread_id[0]
#endif
#if   ((USBD_CDC0_EP_BULK_IN ==  7) || (USBD_CDC0_EP_BULK_OUT ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_cdc_bulk_thread_id[0]
#endif
#if   ((USBD_CDC0_EP_BULK_IN ==  8) || (USBD_CDC0_EP_BULK_OUT ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_cdc_bulk_thread_id[0]
#endif
#if   ((USBD_CDC0_EP_BULK_IN ==  9) || (USBD_CDC0_EP_BULK_OUT ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_cdc_bulk_thread_id[0]
#endif
#if   ((USBD_CDC0_EP_BULK_IN == 10) || (USBD_CDC0_EP_BULK_OUT == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_cdc_bulk_thread_id[0]
#endif
#if   ((USBD_CDC0_EP_BULK_IN == 11) || (USBD_CDC0_EP_BULK_OUT == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_cdc_bulk_thread_id[0]
#endif
#if   ((USBD_CDC0_EP_BULK_IN == 12) || (USBD_CDC0_EP_BULK_OUT == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_cdc_bulk_thread_id[0]
#endif
#if   ((USBD_CDC0_EP_BULK_IN == 13) || (USBD_CDC0_EP_BULK_OUT == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_cdc_bulk_thread_id[0]
#endif
#if   ((USBD_CDC0_EP_BULK_IN == 14) || (USBD_CDC0_EP_BULK_OUT == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_cdc_bulk_thread_id[0]
#endif
#if   ((USBD_CDC0_EP_BULK_IN == 15) || (USBD_CDC0_EP_BULK_OUT == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_cdc_bulk_thread_id[0]
#endif
#else
#define USBD3_CDC0                      0
#define USBD3_CDC0_IF_CNT               0
#define USBD3_CDC0_EP_CNT               0
#define USBD3_CDC0_STR_CNT              0
#endif

#if    (defined(RTE_USB_Device_CDC_1) && (USBD_CDC1_DEV == 3))                  // USB Device 3 Communication Device Class 1
#define USBD3_CDC1                      1
#define USBD3_CDC1_IF_CNT               2
#define USBD3_CDC1_IF0_EP_CNT           1
#define USBD3_CDC1_IF1_EP_CNT           2
#define USBD3_CDC1_EP_CNT              (USBD3_CDC1_IF0_EP_CNT+USBD3_CDC1_IF1_EP_CNT)
#define USBD3_CDC1_STR_CNT              2
#define USBD_CDC1_IF0_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC_IF_CNT+USBD3_CDC0_IF_CNT)
#define USBD_CDC1_IF1_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC_IF_CNT+USBD3_CDC0_IF_CNT+1)
#define USBD_CDC1_IF_CNT               (USBD3_CDC1_IF_CNT)
#define USBD_CDC1_EP_CNT               (USBD3_CDC1_EP_CNT)
#define USBD_CDC1_IF0_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC_STR_CNT+USBD3_CDC0_STR_CNT)
#define USBD_CDC1_IF1_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC_STR_CNT+USBD3_CDC0_STR_CNT+1)
#define USBD_CDC1_STR_CNT              (USBD3_CDC1_STR_CNT)
#if    (USBD_CDC1_EP_INT_IN > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CDC1_EP_INT_IN)
#endif
#if    (USBD_CDC1_EP_BULK_IN > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CDC1_EP_BULK_IN)
#endif
#if    (USBD_CDC1_EP_BULK_OUT > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CDC1_EP_BULK_OUT)
#endif
#if    (USBD_CDC1_EP_INT_IN ==  1)
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_cdc_int_thread_id[1]
#endif
#if    (USBD_CDC1_EP_INT_IN ==  2)
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_cdc_int_thread_id[1]
#endif
#if    (USBD_CDC1_EP_INT_IN ==  3)
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_cdc_int_thread_id[1]
#endif
#if    (USBD_CDC1_EP_INT_IN ==  4)
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_cdc_int_thread_id[1]
#endif
#if    (USBD_CDC1_EP_INT_IN ==  5)
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_cdc_int_thread_id[1]
#endif
#if    (USBD_CDC1_EP_INT_IN ==  6)
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_cdc_int_thread_id[1]
#endif
#if    (USBD_CDC1_EP_INT_IN ==  7)
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_cdc_int_thread_id[1]
#endif
#if    (USBD_CDC1_EP_INT_IN ==  8)
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_cdc_int_thread_id[1]
#endif
#if    (USBD_CDC1_EP_INT_IN ==  9)
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_cdc_int_thread_id[1]
#endif
#if    (USBD_CDC1_EP_INT_IN == 10)
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_cdc_int_thread_id[1]
#endif
#if    (USBD_CDC1_EP_INT_IN == 11)
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_cdc_int_thread_id[1]
#endif
#if    (USBD_CDC1_EP_INT_IN == 12)
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_cdc_int_thread_id[1]
#endif
#if    (USBD_CDC1_EP_INT_IN == 13)
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_cdc_int_thread_id[1]
#endif
#if    (USBD_CDC1_EP_INT_IN == 14)
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_cdc_int_thread_id[1]
#endif
#if    (USBD_CDC1_EP_INT_IN == 15)
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_cdc_int_thread_id[1]
#endif
#if   ((USBD_CDC1_EP_BULK_IN ==  1) || (USBD_CDC1_EP_BULK_OUT ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_cdc_bulk_thread_id[1]
#endif
#if   ((USBD_CDC1_EP_BULK_IN ==  2) || (USBD_CDC1_EP_BULK_OUT ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_cdc_bulk_thread_id[1]
#endif
#if   ((USBD_CDC1_EP_BULK_IN ==  3) || (USBD_CDC1_EP_BULK_OUT ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_cdc_bulk_thread_id[1]
#endif
#if   ((USBD_CDC1_EP_BULK_IN ==  4) || (USBD_CDC1_EP_BULK_OUT ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_cdc_bulk_thread_id[1]
#endif
#if   ((USBD_CDC1_EP_BULK_IN ==  5) || (USBD_CDC1_EP_BULK_OUT ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_cdc_bulk_thread_id[1]
#endif
#if   ((USBD_CDC1_EP_BULK_IN ==  6) || (USBD_CDC1_EP_BULK_OUT ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_cdc_bulk_thread_id[1]
#endif
#if   ((USBD_CDC1_EP_BULK_IN ==  7) || (USBD_CDC1_EP_BULK_OUT ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_cdc_bulk_thread_id[1]
#endif
#if   ((USBD_CDC1_EP_BULK_IN ==  8) || (USBD_CDC1_EP_BULK_OUT ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_cdc_bulk_thread_id[1]
#endif
#if   ((USBD_CDC1_EP_BULK_IN ==  9) || (USBD_CDC1_EP_BULK_OUT ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_cdc_bulk_thread_id[1]
#endif
#if   ((USBD_CDC1_EP_BULK_IN == 10) || (USBD_CDC1_EP_BULK_OUT == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_cdc_bulk_thread_id[1]
#endif
#if   ((USBD_CDC1_EP_BULK_IN == 11) || (USBD_CDC1_EP_BULK_OUT == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_cdc_bulk_thread_id[1]
#endif
#if   ((USBD_CDC1_EP_BULK_IN == 12) || (USBD_CDC1_EP_BULK_OUT == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_cdc_bulk_thread_id[1]
#endif
#if   ((USBD_CDC1_EP_BULK_IN == 13) || (USBD_CDC1_EP_BULK_OUT == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_cdc_bulk_thread_id[1]
#endif
#if   ((USBD_CDC1_EP_BULK_IN == 14) || (USBD_CDC1_EP_BULK_OUT == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_cdc_bulk_thread_id[1]
#endif
#if   ((USBD_CDC1_EP_BULK_IN == 15) || (USBD_CDC1_EP_BULK_OUT == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_cdc_bulk_thread_id[1]
#endif
#else
#define USBD3_CDC1                      0
#define USBD3_CDC1_IF_CNT               0
#define USBD3_CDC1_EP_CNT               0
#define USBD3_CDC1_STR_CNT              0
#endif

#if    (defined(RTE_USB_Device_CDC_2) && (USBD_CDC2_DEV == 3))                  // USB Device 3 Communication Device Class 2
#define USBD3_CDC2                      1
#define USBD3_CDC2_IF_CNT               2
#define USBD3_CDC2_IF0_EP_CNT           1
#define USBD3_CDC2_IF1_EP_CNT           2
#define USBD3_CDC2_EP_CNT              (USBD3_CDC2_IF0_EP_CNT+USBD3_CDC2_IF1_EP_CNT)
#define USBD3_CDC2_STR_CNT              2
#define USBD_CDC2_IF0_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC_IF_CNT+USBD3_CDC0_IF_CNT+USBD3_CDC1_IF_CNT)
#define USBD_CDC2_IF1_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC_IF_CNT+USBD3_CDC0_IF_CNT+USBD3_CDC1_IF_CNT+1)
#define USBD_CDC2_IF_CNT               (USBD3_CDC2_IF_CNT)
#define USBD_CDC2_EP_CNT               (USBD3_CDC2_EP_CNT)
#define USBD_CDC2_IF0_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC_STR_CNT+USBD3_CDC0_STR_CNT+USBD3_CDC1_STR_CNT)
#define USBD_CDC2_IF1_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC_STR_CNT+USBD3_CDC0_STR_CNT+USBD3_CDC1_STR_CNT+1)
#define USBD_CDC2_STR_CNT              (USBD3_CDC2_STR_CNT)
#if    (USBD_CDC2_EP_INT_IN > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CDC2_EP_INT_IN)
#endif
#if    (USBD_CDC2_EP_BULK_IN > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CDC2_EP_BULK_IN)
#endif
#if    (USBD_CDC2_EP_BULK_OUT > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CDC2_EP_BULK_OUT)
#endif
#if    (USBD_CDC2_EP_INT_IN ==  1)
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_cdc_int_thread_id[2]
#endif
#if    (USBD_CDC2_EP_INT_IN ==  2)
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_cdc_int_thread_id[2]
#endif
#if    (USBD_CDC2_EP_INT_IN ==  3)
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_cdc_int_thread_id[2]
#endif
#if    (USBD_CDC2_EP_INT_IN ==  4)
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_cdc_int_thread_id[2]
#endif
#if    (USBD_CDC2_EP_INT_IN ==  5)
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_cdc_int_thread_id[2]
#endif
#if    (USBD_CDC2_EP_INT_IN ==  6)
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_cdc_int_thread_id[2]
#endif
#if    (USBD_CDC2_EP_INT_IN ==  7)
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_cdc_int_thread_id[2]
#endif
#if    (USBD_CDC2_EP_INT_IN ==  8)
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_cdc_int_thread_id[2]
#endif
#if    (USBD_CDC2_EP_INT_IN ==  9)
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_cdc_int_thread_id[2]
#endif
#if    (USBD_CDC2_EP_INT_IN == 10)
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_cdc_int_thread_id[2]
#endif
#if    (USBD_CDC2_EP_INT_IN == 11)
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_cdc_int_thread_id[2]
#endif
#if    (USBD_CDC2_EP_INT_IN == 12)
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_cdc_int_thread_id[2]
#endif
#if    (USBD_CDC2_EP_INT_IN == 13)
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_cdc_int_thread_id[2]
#endif
#if    (USBD_CDC2_EP_INT_IN == 14)
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_cdc_int_thread_id[2]
#endif
#if    (USBD_CDC2_EP_INT_IN == 15)
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_cdc_int_thread_id[2]
#endif
#if   ((USBD_CDC2_EP_BULK_IN ==  1) || (USBD_CDC2_EP_BULK_OUT ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_cdc_bulk_thread_id[2]
#endif
#if   ((USBD_CDC2_EP_BULK_IN ==  2) || (USBD_CDC2_EP_BULK_OUT ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_cdc_bulk_thread_id[2]
#endif
#if   ((USBD_CDC2_EP_BULK_IN ==  3) || (USBD_CDC2_EP_BULK_OUT ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_cdc_bulk_thread_id[2]
#endif
#if   ((USBD_CDC2_EP_BULK_IN ==  4) || (USBD_CDC2_EP_BULK_OUT ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_cdc_bulk_thread_id[2]
#endif
#if   ((USBD_CDC2_EP_BULK_IN ==  5) || (USBD_CDC2_EP_BULK_OUT ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_cdc_bulk_thread_id[2]
#endif
#if   ((USBD_CDC2_EP_BULK_IN ==  6) || (USBD_CDC2_EP_BULK_OUT ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_cdc_bulk_thread_id[2]
#endif
#if   ((USBD_CDC2_EP_BULK_IN ==  7) || (USBD_CDC2_EP_BULK_OUT ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_cdc_bulk_thread_id[2]
#endif
#if   ((USBD_CDC2_EP_BULK_IN ==  8) || (USBD_CDC2_EP_BULK_OUT ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_cdc_bulk_thread_id[2]
#endif
#if   ((USBD_CDC2_EP_BULK_IN ==  9) || (USBD_CDC2_EP_BULK_OUT ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_cdc_bulk_thread_id[2]
#endif
#if   ((USBD_CDC2_EP_BULK_IN == 10) || (USBD_CDC2_EP_BULK_OUT == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_cdc_bulk_thread_id[2]
#endif
#if   ((USBD_CDC2_EP_BULK_IN == 11) || (USBD_CDC2_EP_BULK_OUT == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_cdc_bulk_thread_id[2]
#endif
#if   ((USBD_CDC2_EP_BULK_IN == 12) || (USBD_CDC2_EP_BULK_OUT == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_cdc_bulk_thread_id[2]
#endif
#if   ((USBD_CDC2_EP_BULK_IN == 13) || (USBD_CDC2_EP_BULK_OUT == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_cdc_bulk_thread_id[2]
#endif
#if   ((USBD_CDC2_EP_BULK_IN == 14) || (USBD_CDC2_EP_BULK_OUT == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_cdc_bulk_thread_id[2]
#endif
#if   ((USBD_CDC2_EP_BULK_IN == 15) || (USBD_CDC2_EP_BULK_OUT == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_cdc_bulk_thread_id[2]
#endif
#else
#define USBD3_CDC2                      0
#define USBD3_CDC2_IF_CNT               0
#define USBD3_CDC2_EP_CNT               0
#define USBD3_CDC2_STR_CNT              0
#endif

#if    (defined(RTE_USB_Device_CDC_3) && (USBD_CDC3_DEV == 3))                  // USB Device 3 Communication Device Class 3
#define USBD3_CDC3                      1
#define USBD3_CDC3_IF_CNT               2
#define USBD3_CDC3_IF0_EP_CNT           1
#define USBD3_CDC3_IF1_EP_CNT           2
#define USBD3_CDC3_EP_CNT              (USBD3_CDC3_IF0_EP_CNT+USBD3_CDC3_IF1_EP_CNT)
#define USBD3_CDC3_STR_CNT              2
#define USBD_CDC3_IF0_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC_IF_CNT+USBD3_CDC0_IF_CNT+USBD3_CDC1_IF_CNT+USBD3_CDC2_IF_CNT)
#define USBD_CDC3_IF1_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC_IF_CNT+USBD3_CDC0_IF_CNT+USBD3_CDC1_IF_CNT+USBD3_CDC2_IF_CNT+1)
#define USBD_CDC3_IF_CNT               (USBD3_CDC3_IF_CNT)
#define USBD_CDC3_EP_CNT               (USBD3_CDC3_EP_CNT)
#define USBD_CDC3_IF0_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC_STR_CNT+USBD3_CDC0_STR_CNT+USBD3_CDC1_STR_CNT+USBD3_CDC2_STR_CNT)
#define USBD_CDC3_IF1_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC_STR_CNT+USBD3_CDC0_STR_CNT+USBD3_CDC1_STR_CNT+USBD3_CDC2_STR_CNT+1)
#define USBD_CDC3_STR_CNT              (USBD3_CDC3_STR_CNT)
#if    (USBD_CDC3_EP_INT_IN > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CDC3_EP_INT_IN)
#endif
#if    (USBD_CDC3_EP_BULK_IN > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CDC3_EP_BULK_IN)
#endif
#if    (USBD_CDC3_EP_BULK_OUT > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_CDC3_EP_BULK_OUT)
#endif
#if    (USBD_CDC3_EP_INT_IN ==  1)
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_cdc_int_thread_id[3]
#endif
#if    (USBD_CDC3_EP_INT_IN ==  2)
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_cdc_int_thread_id[3]
#endif
#if    (USBD_CDC3_EP_INT_IN ==  3)
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_cdc_int_thread_id[3]
#endif
#if    (USBD_CDC3_EP_INT_IN ==  4)
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_cdc_int_thread_id[3]
#endif
#if    (USBD_CDC3_EP_INT_IN ==  5)
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_cdc_int_thread_id[3]
#endif
#if    (USBD_CDC3_EP_INT_IN ==  6)
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_cdc_int_thread_id[3]
#endif
#if    (USBD_CDC3_EP_INT_IN ==  7)
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_cdc_int_thread_id[3]
#endif
#if    (USBD_CDC3_EP_INT_IN ==  8)
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_cdc_int_thread_id[3]
#endif
#if    (USBD_CDC3_EP_INT_IN ==  9)
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_cdc_int_thread_id[3]
#endif
#if    (USBD_CDC3_EP_INT_IN == 10)
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_cdc_int_thread_id[3]
#endif
#if    (USBD_CDC3_EP_INT_IN == 11)
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_cdc_int_thread_id[3]
#endif
#if    (USBD_CDC3_EP_INT_IN == 12)
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_cdc_int_thread_id[3]
#endif
#if    (USBD_CDC3_EP_INT_IN == 13)
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_cdc_int_thread_id[3]
#endif
#if    (USBD_CDC3_EP_INT_IN == 14)
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_cdc_int_thread_id[3]
#endif
#if    (USBD_CDC3_EP_INT_IN == 15)
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_cdc_int_thread_id[3]
#endif
#if   ((USBD_CDC3_EP_BULK_IN ==  1) || (USBD_CDC3_EP_BULK_OUT ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_cdc_bulk_thread_id[3]
#endif
#if   ((USBD_CDC3_EP_BULK_IN ==  2) || (USBD_CDC3_EP_BULK_OUT ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_cdc_bulk_thread_id[3]
#endif
#if   ((USBD_CDC3_EP_BULK_IN ==  3) || (USBD_CDC3_EP_BULK_OUT ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_cdc_bulk_thread_id[3]
#endif
#if   ((USBD_CDC3_EP_BULK_IN ==  4) || (USBD_CDC3_EP_BULK_OUT ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_cdc_bulk_thread_id[3]
#endif
#if   ((USBD_CDC3_EP_BULK_IN ==  5) || (USBD_CDC3_EP_BULK_OUT ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_cdc_bulk_thread_id[3]
#endif
#if   ((USBD_CDC3_EP_BULK_IN ==  6) || (USBD_CDC3_EP_BULK_OUT ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_cdc_bulk_thread_id[3]
#endif
#if   ((USBD_CDC3_EP_BULK_IN ==  7) || (USBD_CDC3_EP_BULK_OUT ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_cdc_bulk_thread_id[3]
#endif
#if   ((USBD_CDC3_EP_BULK_IN ==  8) || (USBD_CDC3_EP_BULK_OUT ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_cdc_bulk_thread_id[3]
#endif
#if   ((USBD_CDC3_EP_BULK_IN ==  9) || (USBD_CDC3_EP_BULK_OUT ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_cdc_bulk_thread_id[3]
#endif
#if   ((USBD_CDC3_EP_BULK_IN == 10) || (USBD_CDC3_EP_BULK_OUT == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_cdc_bulk_thread_id[3]
#endif
#if   ((USBD_CDC3_EP_BULK_IN == 11) || (USBD_CDC3_EP_BULK_OUT == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_cdc_bulk_thread_id[3]
#endif
#if   ((USBD_CDC3_EP_BULK_IN == 12) || (USBD_CDC3_EP_BULK_OUT == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_cdc_bulk_thread_id[3]
#endif
#if   ((USBD_CDC3_EP_BULK_IN == 13) || (USBD_CDC3_EP_BULK_OUT == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_cdc_bulk_thread_id[3]
#endif
#if   ((USBD_CDC3_EP_BULK_IN == 14) || (USBD_CDC3_EP_BULK_OUT == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_cdc_bulk_thread_id[3]
#endif
#if   ((USBD_CDC3_EP_BULK_IN == 15) || (USBD_CDC3_EP_BULK_OUT == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_cdc_bulk_thread_id[3]
#endif
#else
#define USBD3_CDC3                      0
#define USBD3_CDC3_IF_CNT               0
#define USBD3_CDC3_EP_CNT               0
#define USBD3_CDC3_STR_CNT              0
#endif

#define USBD3_CDC_CNT                  (USBD3_CDC0+USBD3_CDC1+USBD3_CDC2+USBD3_CDC3)
#define USBD3_CDC_IF_CNT               (USBD3_CDC0_IF_CNT +USBD3_CDC1_IF_CNT +USBD3_CDC2_IF_CNT +USBD3_CDC3_IF_CNT)
#define USBD3_CDC_EP_CNT               (USBD3_CDC0_EP_CNT +USBD3_CDC1_EP_CNT +USBD3_CDC2_EP_CNT +USBD3_CDC3_EP_CNT)
#define USBD3_CDC_STR_CNT              (USBD3_CDC0_STR_CNT+USBD3_CDC1_STR_CNT+USBD3_CDC2_STR_CNT+USBD3_CDC3_STR_CNT)

#if    (defined(RTE_USB_Device_HID_0) && (USBD_HID0_DEV == 3))                  // USB Device 3 HID Class 0
#define USBD3_HID0                      1
#define USBD3_HID0_IF_CNT               1
#define USBD3_HID0_EP_CNT              (1+(USBD_HID0_EP_INT_OUT != 0))
#define USBD3_HID0_STR_CNT              1
#define USBD_HID0_IF0_NUM              (USBD3_CUSTOM_CLASS_IF_CNT +USBD3_ADC_IF_CNT+USBD3_CDC_IF_CNT)
#define USBD_HID0_IF_CNT               (USBD3_HID0_IF_CNT)
#define USBD_HID0_EP_CNT               (USBD3_HID0_EP_CNT)
#define USBD_HID0_IF0_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC_STR_CNT+USBD3_CDC_STR_CNT)
#define USBD_HID0_IF_STR_CNT           (USBD3_HID0_IF_STR_CNT)
#if    (USBD_HID0_EP_INT_IN > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_HID0_EP_INT_IN)
#endif
#if    (USBD_HID0_EP_INT_OUT > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_HID0_EP_INT_OUT)
#endif
#if   ((USBD_HID0_EP_INT_IN ==  1) || (USBD_HID0_EP_INT_OUT ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_hid_thread_id[0]
#endif
#if   ((USBD_HID0_EP_INT_IN ==  2) || (USBD_HID0_EP_INT_OUT ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_hid_thread_id[0]
#endif
#if   ((USBD_HID0_EP_INT_IN ==  3) || (USBD_HID0_EP_INT_OUT ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_hid_thread_id[0]
#endif
#if   ((USBD_HID0_EP_INT_IN ==  4) || (USBD_HID0_EP_INT_OUT ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_hid_thread_id[0]
#endif
#if   ((USBD_HID0_EP_INT_IN ==  5) || (USBD_HID0_EP_INT_OUT ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_hid_thread_id[0]
#endif
#if   ((USBD_HID0_EP_INT_IN ==  6) || (USBD_HID0_EP_INT_OUT ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_hid_thread_id[0]
#endif
#if   ((USBD_HID0_EP_INT_IN ==  7) || (USBD_HID0_EP_INT_OUT ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_hid_thread_id[0]
#endif
#if   ((USBD_HID0_EP_INT_IN ==  8) || (USBD_HID0_EP_INT_OUT ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_hid_thread_id[0]
#endif
#if   ((USBD_HID0_EP_INT_IN ==  9) || (USBD_HID0_EP_INT_OUT ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_hid_thread_id[0]
#endif
#if   ((USBD_HID0_EP_INT_IN == 10) || (USBD_HID0_EP_INT_OUT == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_hid_thread_id[0]
#endif
#if   ((USBD_HID0_EP_INT_IN == 11) || (USBD_HID0_EP_INT_OUT == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_hid_thread_id[0]
#endif
#if   ((USBD_HID0_EP_INT_IN == 12) || (USBD_HID0_EP_INT_OUT == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_hid_thread_id[0]
#endif
#if   ((USBD_HID0_EP_INT_IN == 13) || (USBD_HID0_EP_INT_OUT == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_hid_thread_id[0]
#endif
#if   ((USBD_HID0_EP_INT_IN == 14) || (USBD_HID0_EP_INT_OUT == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_hid_thread_id[0]
#endif
#if   ((USBD_HID0_EP_INT_IN == 15) || (USBD_HID0_EP_INT_OUT == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_hid_thread_id[0]
#endif
#else
#define USBD3_HID0                      0
#define USBD3_HID0_IF_CNT               0
#define USBD3_HID0_EP_CNT               0
#define USBD3_HID0_STR_CNT              0
#endif

#if    (defined(RTE_USB_Device_HID_1) && (USBD_HID1_DEV == 3))                  // USB Device 3 HID Class 1
#define USBD3_HID1                      1
#define USBD3_HID1_IF_CNT               1
#define USBD3_HID1_EP_CNT              (1+(USBD_HID1_EP_INT_OUT != 0))
#define USBD3_HID1_STR_CNT              1
#define USBD_HID1_IF0_NUM              (USBD3_CUSTOM_CLASS_IF_CNT +USBD3_ADC_IF_CNT+USBD3_CDC_IF_CNT+USBD3_HID0_IF_CNT)
#define USBD_HID1_IF_CNT               (USBD3_HID1_IF_CNT)
#define USBD_HID1_EP_CNT               (USBD3_HID1_EP_CNT)
#define USBD_HID1_IF0_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC_STR_CNT+USBD3_CDC_STR_CNT+USBD3_HID0_STR_CNT)
#define USBD_HID1_STR_CNT              (USBD3_HID1_STR_CNT)
#if    (USBD_HID1_EP_INT_IN > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_HID1_EP_INT_IN)
#endif
#if    (USBD_HID1_EP_INT_OUT > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_HID1_EP_INT_OUT)
#endif
#if   ((USBD_HID1_EP_INT_IN ==  1) || (USBD_HID1_EP_INT_OUT ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_hid_thread_id[1]
#endif
#if   ((USBD_HID1_EP_INT_IN ==  2) || (USBD_HID1_EP_INT_OUT ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_hid_thread_id[1]
#endif
#if   ((USBD_HID1_EP_INT_IN ==  3) || (USBD_HID1_EP_INT_OUT ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_hid_thread_id[1]
#endif
#if   ((USBD_HID1_EP_INT_IN ==  4) || (USBD_HID1_EP_INT_OUT ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_hid_thread_id[1]
#endif
#if   ((USBD_HID1_EP_INT_IN ==  5) || (USBD_HID1_EP_INT_OUT ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_hid_thread_id[1]
#endif
#if   ((USBD_HID1_EP_INT_IN ==  6) || (USBD_HID1_EP_INT_OUT ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_hid_thread_id[1]
#endif
#if   ((USBD_HID1_EP_INT_IN ==  7) || (USBD_HID1_EP_INT_OUT ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_hid_thread_id[1]
#endif
#if   ((USBD_HID1_EP_INT_IN ==  8) || (USBD_HID1_EP_INT_OUT ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_hid_thread_id[1]
#endif
#if   ((USBD_HID1_EP_INT_IN ==  9) || (USBD_HID1_EP_INT_OUT ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_hid_thread_id[1]
#endif
#if   ((USBD_HID1_EP_INT_IN == 10) || (USBD_HID1_EP_INT_OUT == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_hid_thread_id[1]
#endif
#if   ((USBD_HID1_EP_INT_IN == 11) || (USBD_HID1_EP_INT_OUT == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_hid_thread_id[1]
#endif
#if   ((USBD_HID1_EP_INT_IN == 12) || (USBD_HID1_EP_INT_OUT == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_hid_thread_id[1]
#endif
#if   ((USBD_HID1_EP_INT_IN == 13) || (USBD_HID1_EP_INT_OUT == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_hid_thread_id[1]
#endif
#if   ((USBD_HID1_EP_INT_IN == 14) || (USBD_HID1_EP_INT_OUT == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_hid_thread_id[1]
#endif
#if   ((USBD_HID1_EP_INT_IN == 15) || (USBD_HID1_EP_INT_OUT == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_hid_thread_id[1]
#endif
#else
#define USBD3_HID1                      0
#define USBD3_HID1_IF_CNT               0
#define USBD3_HID1_EP_CNT               0
#define USBD3_HID1_STR_CNT              0
#endif

#if    (defined(RTE_USB_Device_HID_2) && (USBD_HID2_DEV == 3))                  // USB Device 3 HID Class 2
#define USBD3_HID2                      1
#define USBD3_HID2_IF_CNT               1
#define USBD3_HID0_EP_CNT              (1+(USBD_HID2_EP_INT_OUT != 0))
#define USBD3_HID2_STR_CNT              1
#define USBD_HID2_IF0_NUM              (USBD3_CUSTOM_CLASS_IF_CNT +USBD3_ADC_IF_CNT+USBD3_CDC_IF_CNT+USBD3_HID0_IF_CNT+USBD3_HID1_IF_CNT)
#define USBD_HID2_IF_CNT               (USBD3_HID2_IF_CNT)
#define USBD_HID2_EP_CNT               (USBD3_HID2_EP_CNT)
#define USBD_HID2_IF0_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC_STR_CNT+USBD3_CDC_STR_CNT+USBD3_HID0_STR_CNT+USBD3_HID1_STR_CNT)
#define USBD_HID2_STR_CNT              (USBD3_HID2_STR_CNT)
#if    (USBD_HID2_EP_INT_IN > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_HID2_EP_INT_IN)
#endif
#if    (USBD_HID2_EP_INT_OUT > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_HID2_EP_INT_OUT)
#endif
#if   ((USBD_HID2_EP_INT_IN ==  1) || (USBD_HID2_EP_INT_OUT ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_hid_thread_id[2]
#endif
#if   ((USBD_HID2_EP_INT_IN ==  2) || (USBD_HID2_EP_INT_OUT ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_hid_thread_id[2]
#endif
#if   ((USBD_HID2_EP_INT_IN ==  3) || (USBD_HID2_EP_INT_OUT ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_hid_thread_id[2]
#endif
#if   ((USBD_HID2_EP_INT_IN ==  4) || (USBD_HID2_EP_INT_OUT ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_hid_thread_id[2]
#endif
#if   ((USBD_HID2_EP_INT_IN ==  5) || (USBD_HID2_EP_INT_OUT ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_hid_thread_id[2]
#endif
#if   ((USBD_HID2_EP_INT_IN ==  6) || (USBD_HID2_EP_INT_OUT ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_hid_thread_id[2]
#endif
#if   ((USBD_HID2_EP_INT_IN ==  7) || (USBD_HID2_EP_INT_OUT ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_hid_thread_id[2]
#endif
#if   ((USBD_HID2_EP_INT_IN ==  8) || (USBD_HID2_EP_INT_OUT ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_hid_thread_id[2]
#endif
#if   ((USBD_HID2_EP_INT_IN ==  9) || (USBD_HID2_EP_INT_OUT ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_hid_thread_id[2]
#endif
#if   ((USBD_HID2_EP_INT_IN == 10) || (USBD_HID2_EP_INT_OUT == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_hid_thread_id[2]
#endif
#if   ((USBD_HID2_EP_INT_IN == 11) || (USBD_HID2_EP_INT_OUT == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_hid_thread_id[2]
#endif
#if   ((USBD_HID2_EP_INT_IN == 12) || (USBD_HID2_EP_INT_OUT == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_hid_thread_id[2]
#endif
#if   ((USBD_HID2_EP_INT_IN == 13) || (USBD_HID2_EP_INT_OUT == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_hid_thread_id[2]
#endif
#if   ((USBD_HID2_EP_INT_IN == 14) || (USBD_HID2_EP_INT_OUT == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_hid_thread_id[2]
#endif
#if   ((USBD_HID2_EP_INT_IN == 15) || (USBD_HID2_EP_INT_OUT == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_hid_thread_id[2]
#endif
#else
#define USBD3_HID2                      0
#define USBD3_HID2_IF_CNT               0
#define USBD3_HID2_EP_CNT               0
#define USBD3_HID2_STR_CNT              0
#endif

#if    (defined(RTE_USB_Device_HID_3) && (USBD_HID3_DEV == 3))                  // USB Device 3 HID Class 3
#define USBD3_HID3                      1
#define USBD3_HID3_IF_CNT               1
#define USBD3_HID0_EP_CNT              (1+(USBD_HID3_EP_INT_OUT != 0))
#define USBD3_HID3_STR_CNT              1
#define USBD_HID3_IF0_NUM              (USBD3_CUSTOM_CLASS_IF_CNT +USBD3_ADC_IF_CNT+USBD3_CDC_IF_CNT+USBD3_HID0_IF_CNT+USBD3_HID1_IF_CNT+USBD3_HID2_IF_CNT)
#define USBD_HID3_IF_CNT               (USBD3_HID3_IF_CNT)
#define USBD_HID3_EP_CNT               (USBD3_HID3_EP_CNT)
#define USBD_HID3_IF0_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC_STR_CNT+USBD3_CDC_STR_CNT+USBD3_HID0_STR_CNT+USBD3_HID1_STR_CNT+USBD3_HID2_STR_CNT)
#define USBD_HID3_STR_CNT              (USBD3_HID3_STR_CNT)
#if    (USBD_HID3_EP_INT_IN > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_HID3_EP_INT_IN)
#endif
#if    (USBD_HID3_EP_INT_OUT > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_HID3_EP_INT_OUT)
#endif
#if   ((USBD_HID3_EP_INT_IN ==  1) || (USBD_HID3_EP_INT_OUT ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_hid_thread_id[3]
#endif
#if   ((USBD_HID3_EP_INT_IN ==  2) || (USBD_HID3_EP_INT_OUT ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_hid_thread_id[3]
#endif
#if   ((USBD_HID3_EP_INT_IN ==  3) || (USBD_HID3_EP_INT_OUT ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_hid_thread_id[3]
#endif
#if   ((USBD_HID3_EP_INT_IN ==  4) || (USBD_HID3_EP_INT_OUT ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_hid_thread_id[3]
#endif
#if   ((USBD_HID3_EP_INT_IN ==  5) || (USBD_HID3_EP_INT_OUT ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_hid_thread_id[3]
#endif
#if   ((USBD_HID3_EP_INT_IN ==  6) || (USBD_HID3_EP_INT_OUT ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_hid_thread_id[3]
#endif
#if   ((USBD_HID3_EP_INT_IN ==  7) || (USBD_HID3_EP_INT_OUT ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_hid_thread_id[3]
#endif
#if   ((USBD_HID3_EP_INT_IN ==  8) || (USBD_HID3_EP_INT_OUT ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_hid_thread_id[3]
#endif
#if   ((USBD_HID3_EP_INT_IN ==  9) || (USBD_HID3_EP_INT_OUT ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_hid_thread_id[3]
#endif
#if   ((USBD_HID3_EP_INT_IN == 10) || (USBD_HID3_EP_INT_OUT == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_hid_thread_id[3]
#endif
#if   ((USBD_HID3_EP_INT_IN == 11) || (USBD_HID3_EP_INT_OUT == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_hid_thread_id[3]
#endif
#if   ((USBD_HID3_EP_INT_IN == 12) || (USBD_HID3_EP_INT_OUT == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_hid_thread_id[3]
#endif
#if   ((USBD_HID3_EP_INT_IN == 13) || (USBD_HID3_EP_INT_OUT == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_hid_thread_id[3]
#endif
#if   ((USBD_HID3_EP_INT_IN == 14) || (USBD_HID3_EP_INT_OUT == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_hid_thread_id[3]
#endif
#if   ((USBD_HID3_EP_INT_IN == 15) || (USBD_HID3_EP_INT_OUT == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_hid_thread_id[3]
#endif
#else
#define USBD3_HID3                      0
#define USBD3_HID3_IF_CNT               0
#define USBD3_HID3_EP_CNT               0
#define USBD3_HID3_STR_CNT              0
#endif

#define USBD3_HID_CNT                  (USBD3_HID0+USBD3_HID1+USBD3_HID2+USBD3_HID3)
#define USBD3_HID_IF_CNT               (USBD3_HID0_IF_CNT +USBD3_HID1_IF_CNT +USBD3_HID2_IF_CNT +USBD3_HID3_IF_CNT)
#define USBD3_HID_EP_CNT               (USBD3_HID0_EP_CNT +USBD3_HID1_EP_CNT +USBD3_HID2_EP_CNT +USBD3_HID3_EP_CNT)
#define USBD3_HID_STR_CNT              (USBD3_HID0_STR_CNT+USBD3_HID1_STR_CNT+USBD3_HID2_STR_CNT+USBD3_HID3_STR_CNT)

#if    (defined(RTE_USB_Device_MSC_0) && (USBD_MSC0_DEV == 3))                  // USB Device 3 Mass Storage Class 0
#define USBD3_MSC0                      1
#define USBD3_MSC0_IF_CNT               1
#define USBD3_MSC0_EP_CNT               2
#define USBD3_MSC0_STR_CNT              1
#define USBD_MSC0_IF0_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC_IF_CNT+USBD3_CDC_IF_CNT+USBD3_HID_IF_CNT)
#define USBD_MSC0_IF_CNT               (USBD3_MSC0_IF_CNT)
#define USBD_MSC0_EP_CNT               (USBD3_MSC0_EP_CNT)
#define USBD_MSC0_IF0_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC_STR_CNT+USBD3_CDC_STR_CNT+USBD3_HID_STR_CNT)
#define USBD_MSC0_STR_CNT              (USBD3_MSC0_STR_CNT)
#if    (USBD_MSC0_EP_BULK_IN > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_MSC0_EP_BULK_IN)
#endif
#if    (USBD_MSC0_EP_BULK_OUT > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_MSC0_EP_BULK_OUT)
#endif
#if   ((USBD_MSC0_EP_BULK_IN ==  1) || (USBD_MSC0_EP_BULK_OUT ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_msc_thread_id[0]
#endif
#if   ((USBD_MSC0_EP_BULK_IN ==  2) || (USBD_MSC0_EP_BULK_OUT ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_msc_thread_id[0]
#endif
#if   ((USBD_MSC0_EP_BULK_IN ==  3) || (USBD_MSC0_EP_BULK_OUT ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_msc_thread_id[0]
#endif
#if   ((USBD_MSC0_EP_BULK_IN ==  4) || (USBD_MSC0_EP_BULK_OUT ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_msc_thread_id[0]
#endif
#if   ((USBD_MSC0_EP_BULK_IN ==  5) || (USBD_MSC0_EP_BULK_OUT ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_msc_thread_id[0]
#endif
#if   ((USBD_MSC0_EP_BULK_IN ==  6) || (USBD_MSC0_EP_BULK_OUT ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_msc_thread_id[0]
#endif
#if   ((USBD_MSC0_EP_BULK_IN ==  7) || (USBD_MSC0_EP_BULK_OUT ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_msc_thread_id[0]
#endif
#if   ((USBD_MSC0_EP_BULK_IN ==  8) || (USBD_MSC0_EP_BULK_OUT ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_msc_thread_id[0]
#endif
#if   ((USBD_MSC0_EP_BULK_IN ==  9) || (USBD_MSC0_EP_BULK_OUT ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_msc_thread_id[0]
#endif
#if   ((USBD_MSC0_EP_BULK_IN == 10) || (USBD_MSC0_EP_BULK_OUT == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_msc_thread_id[0]
#endif
#if   ((USBD_MSC0_EP_BULK_IN == 11) || (USBD_MSC0_EP_BULK_OUT == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_msc_thread_id[0]
#endif
#if   ((USBD_MSC0_EP_BULK_IN == 12) || (USBD_MSC0_EP_BULK_OUT == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_msc_thread_id[0]
#endif
#if   ((USBD_MSC0_EP_BULK_IN == 13) || (USBD_MSC0_EP_BULK_OUT == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_msc_thread_id[0]
#endif
#if   ((USBD_MSC0_EP_BULK_IN == 14) || (USBD_MSC0_EP_BULK_OUT == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_msc_thread_id[0]
#endif
#if   ((USBD_MSC0_EP_BULK_IN == 15) || (USBD_MSC0_EP_BULK_OUT == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_msc_thread_id[0]
#endif
#else
#define USBD3_MSC0                      0
#define USBD3_MSC0_IF_CNT               0
#define USBD3_MSC0_EP_CNT               0
#define USBD3_MSC0_STR_CNT              0
#endif

#if    (defined(RTE_USB_Device_MSC_1) && (USBD_MSC1_DEV == 3))                  // USB Device 3 Mass Storage Class 1
#define USBD3_MSC1                      1
#define USBD3_MSC1_IF_CNT               1
#define USBD3_MSC1_EP_CNT               2
#define USBD3_MSC1_STR_CNT              1
#define USBD_MSC1_IF0_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC_IF_CNT+USBD3_CDC_IF_CNT+USBD3_HID_IF_CNT+USBD3_MSC0_IF_CNT)
#define USBD_MSC1_IF_CNT               (USBD3_MSC1_IF_CNT)
#define USBD_MSC1_EP_CNT               (USBD3_MSC1_EP_CNT)
#define USBD_MSC1_IF0_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC_STR_CNT+USBD3_CDC_STR_CNT+USBD3_HID_STR_CNT+USBD3_MSC0_STR_CNT)
#define USBD_MSC1_STR_CNT              (USBD3_MSC1_STR_CNT)
#if    (USBD_MSC1_EP_BULK_IN > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_MSC1_EP_BULK_IN)
#endif
#if    (USBD_MSC1_EP_BULK_OUT > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_MSC1_EP_BULK_OUT)
#endif
#if   ((USBD_MSC1_EP_BULK_IN ==  1) || (USBD_MSC1_EP_BULK_OUT ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_msc_thread_id[1]
#endif
#if   ((USBD_MSC1_EP_BULK_IN ==  2) || (USBD_MSC1_EP_BULK_OUT ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_msc_thread_id[1]
#endif
#if   ((USBD_MSC1_EP_BULK_IN ==  3) || (USBD_MSC1_EP_BULK_OUT ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_msc_thread_id[1]
#endif
#if   ((USBD_MSC1_EP_BULK_IN ==  4) || (USBD_MSC1_EP_BULK_OUT ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_msc_thread_id[1]
#endif
#if   ((USBD_MSC1_EP_BULK_IN ==  5) || (USBD_MSC1_EP_BULK_OUT ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_msc_thread_id[1]
#endif
#if   ((USBD_MSC1_EP_BULK_IN ==  6) || (USBD_MSC1_EP_BULK_OUT ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_msc_thread_id[1]
#endif
#if   ((USBD_MSC1_EP_BULK_IN ==  7) || (USBD_MSC1_EP_BULK_OUT ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_msc_thread_id[1]
#endif
#if   ((USBD_MSC1_EP_BULK_IN ==  8) || (USBD_MSC1_EP_BULK_OUT ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_msc_thread_id[1]
#endif
#if   ((USBD_MSC1_EP_BULK_IN ==  9) || (USBD_MSC1_EP_BULK_OUT ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_msc_thread_id[1]
#endif
#if   ((USBD_MSC1_EP_BULK_IN == 10) || (USBD_MSC1_EP_BULK_OUT == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_msc_thread_id[1]
#endif
#if   ((USBD_MSC1_EP_BULK_IN == 11) || (USBD_MSC1_EP_BULK_OUT == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_msc_thread_id[1]
#endif
#if   ((USBD_MSC1_EP_BULK_IN == 12) || (USBD_MSC1_EP_BULK_OUT == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_msc_thread_id[1]
#endif
#if   ((USBD_MSC1_EP_BULK_IN == 13) || (USBD_MSC1_EP_BULK_OUT == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_msc_thread_id[1]
#endif
#if   ((USBD_MSC1_EP_BULK_IN == 14) || (USBD_MSC1_EP_BULK_OUT == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_msc_thread_id[1]
#endif
#if   ((USBD_MSC1_EP_BULK_IN == 15) || (USBD_MSC1_EP_BULK_OUT == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_msc_thread_id[1]
#endif
#else
#define USBD3_MSC1                      0
#define USBD3_MSC1_IF_CNT               0
#define USBD3_MSC1_EP_CNT               0
#define USBD3_MSC1_STR_CNT              0
#endif

#if    (defined(RTE_USB_Device_MSC_2) && (USBD_MSC2_DEV == 3))                  // USB Device 3 Mass Storage Class 2
#define USBD3_MSC2                      1
#define USBD3_MSC2_IF_CNT               1
#define USBD3_MSC2_EP_CNT               2
#define USBD3_MSC2_STR_CNT              1
#define USBD_MSC2_IF0_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC_IF_CNT+USBD3_CDC_IF_CNT+USBD3_HID_IF_CNT+USBD3_MSC0_IF_CNT+USBD3_MSC1_IF_CNT)
#define USBD_MSC2_IF_CNT               (USBD3_MSC2_IF_CNT)
#define USBD_MSC2_EP_CNT               (USBD3_MSC2_EP_CNT)
#define USBD_MSC2_IF0_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC_STR_CNT+USBD3_CDC_STR_CNT+USBD3_HID_STR_CNT+USBD3_MSC0_STR_CNT+USBD3_MSC1_STR_CNT)
#define USBD_MSC2_STR_CNT              (USBD3_MSC2_STR_CNT)
#if    (USBD_MSC2_EP_BULK_IN > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_MSC2_EP_BULK_IN)
#endif
#if    (USBD_MSC2_EP_BULK_OUT > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_MSC2_EP_BULK_OUT)
#endif
#if   ((USBD_MSC2_EP_BULK_IN ==  1) || (USBD_MSC2_EP_BULK_OUT ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_msc_thread_id[2]
#endif
#if   ((USBD_MSC2_EP_BULK_IN ==  2) || (USBD_MSC2_EP_BULK_OUT ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_msc_thread_id[2]
#endif
#if   ((USBD_MSC2_EP_BULK_IN ==  3) || (USBD_MSC2_EP_BULK_OUT ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_msc_thread_id[2]
#endif
#if   ((USBD_MSC2_EP_BULK_IN ==  4) || (USBD_MSC2_EP_BULK_OUT ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_msc_thread_id[2]
#endif
#if   ((USBD_MSC2_EP_BULK_IN ==  5) || (USBD_MSC2_EP_BULK_OUT ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_msc_thread_id[2]
#endif
#if   ((USBD_MSC2_EP_BULK_IN ==  6) || (USBD_MSC2_EP_BULK_OUT ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_msc_thread_id[2]
#endif
#if   ((USBD_MSC2_EP_BULK_IN ==  7) || (USBD_MSC2_EP_BULK_OUT ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_msc_thread_id[2]
#endif
#if   ((USBD_MSC2_EP_BULK_IN ==  8) || (USBD_MSC2_EP_BULK_OUT ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_msc_thread_id[2]
#endif
#if   ((USBD_MSC2_EP_BULK_IN ==  9) || (USBD_MSC2_EP_BULK_OUT ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_msc_thread_id[2]
#endif
#if   ((USBD_MSC2_EP_BULK_IN == 10) || (USBD_MSC2_EP_BULK_OUT == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_msc_thread_id[2]
#endif
#if   ((USBD_MSC2_EP_BULK_IN == 11) || (USBD_MSC2_EP_BULK_OUT == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_msc_thread_id[2]
#endif
#if   ((USBD_MSC2_EP_BULK_IN == 12) || (USBD_MSC2_EP_BULK_OUT == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_msc_thread_id[2]
#endif
#if   ((USBD_MSC2_EP_BULK_IN == 13) || (USBD_MSC2_EP_BULK_OUT == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_msc_thread_id[2]
#endif
#if   ((USBD_MSC2_EP_BULK_IN == 14) || (USBD_MSC2_EP_BULK_OUT == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_msc_thread_id[2]
#endif
#if   ((USBD_MSC2_EP_BULK_IN == 15) || (USBD_MSC2_EP_BULK_OUT == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_msc_thread_id[2]
#endif
#else
#define USBD3_MSC2                      0
#define USBD3_MSC2_IF_CNT               0
#define USBD3_MSC2_EP_CNT               0
#define USBD3_MSC2_STR_CNT              0
#endif

#if    (defined(RTE_USB_Device_MSC_3) && (USBD_MSC3_DEV == 3))                  // USB Device 3 Mass Storage Class 3
#define USBD3_MSC3                      1
#define USBD3_MSC3_IF_CNT               1
#define USBD3_MSC3_EP_CNT               2
#define USBD3_MSC3_STR_CNT              1
#define USBD_MSC3_IF0_NUM              (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC_IF_CNT+USBD3_CDC_IF_CNT+USBD3_HID_IF_CNT+USBD3_MSC0_IF_CNT+USBD3_MSC1_IF_CNT+USBD3_MSC2_IF_CNT)
#define USBD_MSC3_IF_CNT               (USBD3_MSC3_IF_CNT)
#define USBD_MSC3_EP_CNT               (USBD3_MSC3_EP_CNT)
#define USBD_MSC3_IF0_STR_IDX          (USBD3_DEV_STR_CNT+USBD3_CUSTOM_CLASS_STR_CNT+USBD3_ADC_STR_CNT+USBD3_CDC_STR_CNT+USBD3_HID_STR_CNT+USBD3_MSC0_STR_CNT+USBD3_MSC1_STR_CNT+USBD3_MSC2_STR_CNT)
#define USBD_MSC3_STR_CNT              (USBD3_MSC3_STR_CNT)
#if    (USBD_MSC3_EP_BULK_IN > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_MSC3_EP_BULK_IN)
#endif
#if    (USBD_MSC3_EP_BULK_OUT > USBD3_EP_MAX)
#undef  USBD3_EP_MAX
#define USBD3_EP_MAX                   (USBD_MSC3_EP_BULK_OUT)
#endif
#if   ((USBD_MSC3_EP_BULK_IN ==  1) || (USBD_MSC3_EP_BULK_OUT ==  1))
#ifdef  USBD3_EP1
#error  Endpoint 1 on Device 3 is already used!
#endif
#define USBD3_EP1                      &usbd_msc_thread_id[3]
#endif
#if   ((USBD_MSC3_EP_BULK_IN ==  2) || (USBD_MSC3_EP_BULK_OUT ==  2))
#ifdef  USBD3_EP2
#error  Endpoint 2 on Device 3 is already used!
#endif
#define USBD3_EP2                      &usbd_msc_thread_id[3]
#endif
#if   ((USBD_MSC3_EP_BULK_IN ==  3) || (USBD_MSC3_EP_BULK_OUT ==  3))
#ifdef  USBD3_EP3
#error  Endpoint 3 on Device 3 is already used!
#endif
#define USBD3_EP3                      &usbd_msc_thread_id[3]
#endif
#if   ((USBD_MSC3_EP_BULK_IN ==  4) || (USBD_MSC3_EP_BULK_OUT ==  4))
#ifdef  USBD3_EP4
#error  Endpoint 4 on Device 3 is already used!
#endif
#define USBD3_EP4                      &usbd_msc_thread_id[3]
#endif
#if   ((USBD_MSC3_EP_BULK_IN ==  5) || (USBD_MSC3_EP_BULK_OUT ==  5))
#ifdef  USBD3_EP5
#error  Endpoint 5 on Device 3 is already used!
#endif
#define USBD3_EP5                      &usbd_msc_thread_id[3]
#endif
#if   ((USBD_MSC3_EP_BULK_IN ==  6) || (USBD_MSC3_EP_BULK_OUT ==  6))
#ifdef  USBD3_EP6
#error  Endpoint 6 on Device 3 is already used!
#endif
#define USBD3_EP6                      &usbd_msc_thread_id[3]
#endif
#if   ((USBD_MSC3_EP_BULK_IN ==  7) || (USBD_MSC3_EP_BULK_OUT ==  7))
#ifdef  USBD3_EP7
#error  Endpoint 7 on Device 3 is already used!
#endif
#define USBD3_EP7                      &usbd_msc_thread_id[3]
#endif
#if   ((USBD_MSC3_EP_BULK_IN ==  8) || (USBD_MSC3_EP_BULK_OUT ==  8))
#ifdef  USBD3_EP8
#error  Endpoint 8 on Device 3 is already used!
#endif
#define USBD3_EP8                      &usbd_msc_thread_id[3]
#endif
#if   ((USBD_MSC3_EP_BULK_IN ==  9) || (USBD_MSC3_EP_BULK_OUT ==  9))
#ifdef  USBD3_EP9
#error  Endpoint 9 on Device 3 is already used!
#endif
#define USBD3_EP9                      &usbd_msc_thread_id[3]
#endif
#if   ((USBD_MSC3_EP_BULK_IN == 10) || (USBD_MSC3_EP_BULK_OUT == 10))
#ifdef  USBD3_EP10
#error  Endpoint 10 on Device 3 is already used!
#endif
#define USBD3_EP10                     &usbd_msc_thread_id[3]
#endif
#if   ((USBD_MSC3_EP_BULK_IN == 11) || (USBD_MSC3_EP_BULK_OUT == 11))
#ifdef  USBD3_EP11
#error  Endpoint 11 on Device 3 is already used!
#endif
#define USBD3_EP11                     &usbd_msc_thread_id[3]
#endif
#if   ((USBD_MSC3_EP_BULK_IN == 12) || (USBD_MSC3_EP_BULK_OUT == 12))
#ifdef  USBD3_EP12
#error  Endpoint 12 on Device 3 is already used!
#endif
#define USBD3_EP12                     &usbd_msc_thread_id[3]
#endif
#if   ((USBD_MSC3_EP_BULK_IN == 13) || (USBD_MSC3_EP_BULK_OUT == 13))
#ifdef  USBD3_EP13
#error  Endpoint 13 on Device 3 is already used!
#endif
#define USBD3_EP13                     &usbd_msc_thread_id[3]
#endif
#if   ((USBD_MSC3_EP_BULK_IN == 14) || (USBD_MSC3_EP_BULK_OUT == 14))
#ifdef  USBD3_EP14
#error  Endpoint 14 on Device 3 is already used!
#endif
#define USBD3_EP14                     &usbd_msc_thread_id[3]
#endif
#if   ((USBD_MSC3_EP_BULK_IN == 15) || (USBD_MSC3_EP_BULK_OUT == 15))
#ifdef  USBD3_EP15
#error  Endpoint 15 on Device 3 is already used!
#endif
#define USBD3_EP15                     &usbd_msc_thread_id[3]
#endif
#else
#define USBD3_MSC3                      0
#define USBD3_MSC3_IF_CNT               0
#define USBD3_MSC3_EP_CNT               0
#define USBD3_MSC3_STR_CNT              0
#endif

#define USBD3_MSC_CNT                  (USBD3_MSC0+USBD3_MSC1+USBD3_MSC2+USBD3_MSC3)
#define USBD3_MSC_IF_CNT               (USBD3_MSC0_IF_CNT +USBD3_MSC1_IF_CNT +USBD3_MSC2_IF_CNT +USBD3_MSC3_IF_CNT)
#define USBD3_MSC_EP_CNT               (USBD3_MSC0_EP_CNT +USBD3_MSC1_EP_CNT +USBD3_MSC2_EP_CNT +USBD3_MSC3_EP_CNT)
#define USBD3_MSC_STR_CNT              (USBD3_MSC0_STR_CNT+USBD3_MSC1_STR_CNT+USBD3_MSC2_STR_CNT+USBD3_MSC3_STR_CNT)

#define USBD3_ANY                     ((USBD3_CUSTOM_CLASS_CNT + USBD3_ADC_CNT + USBD3_CDC_CNT + USBD3_HID_CNT + USBD3_MSC_CNT) != 0)

#define USBD3_IF_CNT                   (USBD3_CUSTOM_CLASS_IF_CNT+USBD3_ADC_IF_CNT+USBD3_CDC_IF_CNT+USBD3_HID_IF_CNT+USBD3_MSC_IF_CNT)
#define USBD3_EP_CNT                   (USBD3_CUSTOM_CLASS_EP_CNT+USBD3_ADC_EP_CNT+USBD3_CDC_EP_CNT+USBD3_HID_EP_CNT+USBD3_MSC_EP_CNT)

#define USBD3_USE_IAD                 ((USBD3_CDC_CNT>0)|(USBD3_CUSTOM_CLASS0_IF_CNT>1)|(USBD3_CUSTOM_CLASS1_IF_CNT>1)|(USBD3_CUSTOM_CLASS2_IF_CNT>1)|(USBD3_CUSTOM_CLASS3_IF_CNT>1))

#define USBD3_CUSTOM_CLASS_DESC_LEN   ((USBD3_CUSTOM_CLASS0 *                                                           \
                                       (USBD3_USE_IAD * USB_INTERFACE_ASSOC_DESC_SIZE +                                 \
                                        USBD3_CUSTOM_CLASS0_IF_DESC_CNT * USB_INTERFACE_DESC_SIZE +                     \
                                        USBD3_CUSTOM_CLASS0_EP_CNT * USB_ENDPOINT_DESC_SIZE)) +                         \
                                       (USBD3_CUSTOM_CLASS1 *                                                           \
                                       (USBD3_USE_IAD * USB_INTERFACE_ASSOC_DESC_SIZE +                                 \
                                        USBD3_CUSTOM_CLASS1_IF_DESC_CNT * USB_INTERFACE_DESC_SIZE +                     \
                                        USBD3_CUSTOM_CLASS1_EP_CNT * USB_ENDPOINT_DESC_SIZE)) +                         \
                                       (USBD3_CUSTOM_CLASS2 *                                                           \
                                       (USBD3_USE_IAD * USB_INTERFACE_ASSOC_DESC_SIZE +                                 \
                                        USBD3_CUSTOM_CLASS2_IF_DESC_CNT * USB_INTERFACE_DESC_SIZE +                     \
                                        USBD3_CUSTOM_CLASS2_EP_CNT * USB_ENDPOINT_DESC_SIZE)) +                         \
                                       (USBD3_CUSTOM_CLASS3 *                                                           \
                                       (USBD3_USE_IAD * USB_INTERFACE_ASSOC_DESC_SIZE +                                 \
                                        USBD3_CUSTOM_CLASS3_IF_DESC_CNT * USB_INTERFACE_DESC_SIZE +                     \
                                        USBD3_CUSTOM_CLASS3_EP_CNT * USB_ENDPOINT_DESC_SIZE)))

#define USBD3_ADC_DESC_LEN             (USBD3_ADC_CNT *                                                                 \
                                       (USBD3_USE_IAD * USB_INTERFACE_ASSOC_DESC_SIZE +                                 \
                                        USBD3_ADC_IF_CNT * USB_INTERFACE_DESC_SIZE + AUDIO_CONTROL_INTERFACE_DESC_SZ(1)+\
                                        AUDIO_INPUT_TERMINAL_DESC_SIZE + AUDIO_FEATURE_UNIT_DESC_SZ(1,1) +              \
                                        AUDIO_OUTPUT_TERMINAL_DESC_SIZE + AUDIO_STREAMING_INTERFACE_DESC_SIZE +         \
                                        AUDIO_FORMAT_TYPE_I_DESC_SZ(1) + AUDIO_STANDARD_ENDPOINT_DESC_SIZE +            \
                                        AUDIO_STREAMING_ENDPOINT_DESC_SIZE))
#define USBD3_CDC_DESC_LEN             (USBD3_CDC_CNT *                                                                 \
                                       (USBD3_USE_IAD * USB_INTERFACE_ASSOC_DESC_SIZE +                                 \
                                        USB_INTERFACE_DESC_SIZE + 0x0013 + USB_ENDPOINT_DESC_SIZE +                     \
                                        USB_INTERFACE_DESC_SIZE + 2* USB_ENDPOINT_DESC_SIZE))
#if (USBD3_HID0 == 1)
#define USBD3_HID0_DESC_LEN            (USB_INTERFACE_DESC_SIZE + USB_HID_DESC_SIZE +                                   \
                                        USBD_HID0_EP_CNT * USB_ENDPOINT_DESC_SIZE)
#define USBD3_HID0_DESC_OFS            (USB_CONFIGURATION_DESC_SIZE + USB_INTERFACE_DESC_SIZE +                         \
                                        USBD3_CUSTOM_CLASS_DESC_LEN +                                                   \
                                        USBD3_ADC_DESC_LEN   +                                                          \
                                        USBD3_CDC_DESC_LEN)
#define USBD_HID0_DESC_LEN             (USBD3_HID0_DESC_LEN)
#define USBD_HID0_DESC_OFS             (USBD3_HID0_DESC_OFS)
#else
#define USBD3_HID0_DESC_LEN            (0)
#define USBD3_HID0_DESC_OFS            (0)
#endif
#if (USBD3_HID1 == 1)
#define USBD3_HID1_DESC_LEN            (USB_INTERFACE_DESC_SIZE + USB_HID_DESC_SIZE +                                   \
                                        USBD_HID1_EP_CNT * USB_ENDPOINT_DESC_SIZE)
#define USBD3_HID1_DESC_OFS            (USB_CONFIGURATION_DESC_SIZE + USB_INTERFACE_DESC_SIZE +                         \
                                        USBD3_CUSTOM_CLASS_DESC_LEN +                                                   \
                                        USBD3_ADC_DESC_LEN   +                                                          \
                                        USBD3_CDC_DESC_LEN   +                                                          \
                                        USBD3_HID0_DESC_OFS)
#define USBD_HID1_DESC_LEN             (USBD3_HID1_DESC_LEN)
#define USBD_HID1_DESC_OFS             (USBD3_HID1_DESC_OFS)
#else
#define USBD3_HID1_DESC_LEN            (0)
#define USBD3_HID1_DESC_OFS            (0)
#endif
#if (USBD3_HID2 == 1)
#define USBD3_HID2_DESC_LEN            (USB_INTERFACE_DESC_SIZE + USB_HID_DESC_SIZE +                                   \
                                        USBD_HID2_EP_CNT * USB_ENDPOINT_DESC_SIZE)
#define USBD3_HID2_DESC_OFS            (USB_CONFIGURATION_DESC_SIZE + USB_INTERFACE_DESC_SIZE +                         \
                                        USBD3_CUSTOM_CLASS_DESC_LEN +                                                   \
                                        USBD3_ADC_DESC_LEN   +                                                          \
                                        USBD3_CDC_DESC_LEN   +                                                          \
                                        USBD3_HID0_DESC_OFS  +                                                          \
                                        USBD3_HID1_DESC_OFS)
#define USBD_HID2_DESC_LEN             (USBD3_HID2_DESC_LEN)
#define USBD_HID2_DESC_OFS             (USBD3_HID2_DESC_OFS)
#else
#define USBD3_HID2_DESC_LEN            (0)
#define USBD3_HID2_DESC_OFS            (0)
#endif
#if (USBD3_HID3 == 1)
#define USBD3_HID3_DESC_LEN            (USB_INTERFACE_DESC_SIZE + USB_HID_DESC_SIZE +                                   \
                                        USBD_HID3_EP_CNT * USB_ENDPOINT_DESC_SIZE)
#define USBD3_HID3_DESC_OFS            (USB_CONFIGURATION_DESC_SIZE + USB_INTERFACE_DESC_SIZE +                         \
                                        USBD3_CUSTOM_CLASS_DESC_LEN +                                                   \
                                        USBD3_ADC_DESC_LEN   +                                                          \
                                        USBD3_CDC_DESC_LEN   +                                                          \
                                        USBD3_HID0_DESC_OFS  +                                                          \
                                        USBD3_HID1_DESC_OFS  +                                                          \
                                        USBD3_HID2_DESC_OFS)
#define USBD_HID3_DESC_LEN             (USBD3_HID3_DESC_LEN)
#define USBD_HID3_DESC_OFS             (USBD3_HID3_DESC_OFS)
#else
#define USBD3_HID3_DESC_LEN            (0)
#define USBD3_HID3_DESC_OFS            (0)
#endif
#define USBD3_HID_DESC_LEN             (USBD3_HID0_DESC_LEN +                                                           \
                                        USBD3_HID1_DESC_LEN +                                                           \
                                        USBD3_HID2_DESC_LEN +                                                           \
                                        USBD3_HID3_DESC_LEN )
#define USBD3_MSC_DESC_LEN             (USBD3_MSC_CNT    * USB_INTERFACE_DESC_SIZE +                                    \
                                        USBD3_MSC_EP_CNT * USB_ENDPOINT_DESC_SIZE)

#define USBD3_WTOTALLENGTH             (USB_CONFIGURATION_DESC_SIZE +                                                   \
                                        USBD3_CUSTOM_CLASS_DESC_LEN +                                                   \
                                        USBD3_ADC_DESC_LEN   +                                                          \
                                        USBD3_CDC_DESC_LEN   +                                                          \
                                        USBD3_HID_DESC_LEN   +                                                          \
                                        USBD3_MSC_DESC_LEN   )

#if ((USBD3_HS) || (USBD3_USE_IAD))
#define USBD3_BDC_USB                   0x0200
#else
#define USBD3_BDC_USB                   0x0110
#endif
