/*-----------------------------------------------------------------------------
 * Name:    Board_Accelerometer.h
 * Purpose: Accelerometer interface header file
 * Rev.:    1.00
 *-----------------------------------------------------------------------------*/

/* Copyright (c) 2013 - 2014 ARM LIMITED

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
   ---------------------------------------------------------------------------*/

#ifndef __ACCELEROMETER_H
#define __ACCELEROMETER_H

#include <stdint.h>

/* Accelerometer state */
typedef struct _ACCELEROMETER_STATE {
  int32_t x;                    ///< X Axis Acceleration in mg (1/1000 g)
  int32_t y;                    ///< Y Axis Acceleration in mg (1/1000 g)
  int32_t z;                    ///< Z Axis Acceleration in mg (1/1000 g)
} ACCELEROMETER_STATE;

/**
  \fn          int32_t Accelerometer_Initialize (void)
  \brief       Initialize accelerometer
  \returns
   - \b  0: function succeeded
   - \b -1: function failed
*/
/**
  \fn          int32_t Accelerometer_Uninitialize (void)
  \brief       De-initialize accelerometer
  \returns
   - \b  0: function succeeded
   - \b -1: function failed
*/
/**
  \fn          int32_t Accelerometer_GetState (ACCELEROMETER_STATE *pState)
  \brief       Get accelerometer state
  \param[out]  pState  pointer to ACCEL_STATE structure
  \returns
   - \b  0: function succeeded
   - \b -1: function failed
*/

extern int32_t Accelerometer_Initialize   (void);
extern int32_t Accelerometer_Uninitialize (void);
extern int32_t Accelerometer_GetState     (ACCELEROMETER_STATE *pState);

#endif /* __ACCELEROMETER_H */
