/*******************************************************************************
* Copyright (c) 2018 - 2021 Xilinx, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
*******************************************************************************/


#ifndef __XFPD_SLCR_SECURE_H__
#define __XFPD_SLCR_SECURE_H__


#ifdef __cplusplus
extern "C" {
#endif

/**
 *@cond nocomments
 */

/**
 * XfpdSlcrSecure Base Address
 */
#define XFPD_SLCR_SECURE_BASEADDR      0xFD690000UL

/**
 * Register: XfpdSlcrSecureCtrl
 */
#define XFPD_SLCR_SECURE_CTRL    ( ( XFPD_SLCR_SECURE_BASEADDR ) + 0x00000004UL )
#define XFPD_SLCR_SECURE_CTRL_RSTVAL   0x00000000UL

#define XFPD_SLCR_SECURE_CTRL_SLVERR_EN_SHIFT   0UL
#define XFPD_SLCR_SECURE_CTRL_SLVERR_EN_WIDTH   1UL
#define XFPD_SLCR_SECURE_CTRL_SLVERR_EN_MASK    0x00000001UL
#define XFPD_SLCR_SECURE_CTRL_SLVERR_EN_DEFVAL  0x0UL

/**
 * Register: XfpdSlcrSecureIsr
 */
#define XFPD_SLCR_SECURE_ISR    ( ( XFPD_SLCR_SECURE_BASEADDR ) + 0x00000008UL )
#define XFPD_SLCR_SECURE_ISR_RSTVAL   0x00000000UL

#define XFPD_SLCR_SECURE_ISR_ADDR_DECODE_ERR_SHIFT   0UL
#define XFPD_SLCR_SECURE_ISR_ADDR_DECODE_ERR_WIDTH   1UL
#define XFPD_SLCR_SECURE_ISR_ADDR_DECODE_ERR_MASK    0x00000001UL
#define XFPD_SLCR_SECURE_ISR_ADDR_DECODE_ERR_DEFVAL  0x0UL

/**
 * Register: XfpdSlcrSecureImr
 */
#define XFPD_SLCR_SECURE_IMR    ( ( XFPD_SLCR_SECURE_BASEADDR ) + 0x0000000CUL )
#define XFPD_SLCR_SECURE_IMR_RSTVAL   0x00000001UL

#define XFPD_SLCR_SECURE_IMR_ADDR_DECODE_ERR_SHIFT   0UL
#define XFPD_SLCR_SECURE_IMR_ADDR_DECODE_ERR_WIDTH   1UL
#define XFPD_SLCR_SECURE_IMR_ADDR_DECODE_ERR_MASK    0x00000001UL
#define XFPD_SLCR_SECURE_IMR_ADDR_DECODE_ERR_DEFVAL  0x1UL

/**
 * Register: XfpdSlcrSecureIer
 */
#define XFPD_SLCR_SECURE_IER    ( ( XFPD_SLCR_SECURE_BASEADDR ) + 0x00000010UL )
#define XFPD_SLCR_SECURE_IER_RSTVAL   0x00000000UL

#define XFPD_SLCR_SECURE_IER_ADDR_DECODE_ERR_SHIFT   0UL
#define XFPD_SLCR_SECURE_IER_ADDR_DECODE_ERR_WIDTH   1UL
#define XFPD_SLCR_SECURE_IER_ADDR_DECODE_ERR_MASK    0x00000001UL
#define XFPD_SLCR_SECURE_IER_ADDR_DECODE_ERR_DEFVAL  0x0UL

/**
 * Register: XfpdSlcrSecureIdr
 */
#define XFPD_SLCR_SECURE_IDR    ( ( XFPD_SLCR_SECURE_BASEADDR ) + 0x00000014UL )
#define XFPD_SLCR_SECURE_IDR_RSTVAL   0x00000000UL

#define XFPD_SLCR_SECURE_IDR_ADDR_DECODE_ERR_SHIFT   0UL
#define XFPD_SLCR_SECURE_IDR_ADDR_DECODE_ERR_WIDTH   1UL
#define XFPD_SLCR_SECURE_IDR_ADDR_DECODE_ERR_MASK    0x00000001UL
#define XFPD_SLCR_SECURE_IDR_ADDR_DECODE_ERR_DEFVAL  0x0UL

/**
 * Register: XfpdSlcrSecureItr
 */
#define XFPD_SLCR_SECURE_ITR    ( ( XFPD_SLCR_SECURE_BASEADDR ) + 0x00000018UL )
#define XFPD_SLCR_SECURE_ITR_RSTVAL   0x00000000UL

#define XFPD_SLCR_SECURE_ITR_ADDR_DECODE_ERR_SHIFT   0UL
#define XFPD_SLCR_SECURE_ITR_ADDR_DECODE_ERR_WIDTH   1UL
#define XFPD_SLCR_SECURE_ITR_ADDR_DECODE_ERR_MASK    0x00000001UL
#define XFPD_SLCR_SECURE_ITR_ADDR_DECODE_ERR_DEFVAL  0x0UL

/**
 * Register: XfpdSlcrSecureTzCtrlApuDual
 */
#define XFPD_SLCR_SECURE_TZ_CTRL_APU_DUAL    ( ( XFPD_SLCR_SECURE_BASEADDR ) + 0x00000104UL )
#define XFPD_SLCR_SECURE_TZ_CTRL_APU_DUAL_RSTVAL   0x00000001UL

#define XFPD_SLCR_SECURE_TZ_CTRL_APU_DUAL_N_SHIFT   0UL
#define XFPD_SLCR_SECURE_TZ_CTRL_APU_DUAL_N_WIDTH   1UL
#define XFPD_SLCR_SECURE_TZ_CTRL_APU_DUAL_N_MASK    0x00000001UL
#define XFPD_SLCR_SECURE_TZ_CTRL_APU_DUAL_N_DEFVAL  0x1UL

/**
 * Register: XfpdSlcrSecureTzCtrlXmpu
 */
#define XFPD_SLCR_SECURE_TZ_CTRL_XMPU    ( ( XFPD_SLCR_SECURE_BASEADDR ) + 0x00000108UL )
#define XFPD_SLCR_SECURE_TZ_CTRL_XMPU_RSTVAL   0x00000001UL

#define XFPD_SLCR_SECURE_TZ_CTRL_XMPU_N_SHIFT   0UL
#define XFPD_SLCR_SECURE_TZ_CTRL_XMPU_N_WIDTH   1UL
#define XFPD_SLCR_SECURE_TZ_CTRL_XMPU_N_MASK    0x00000001UL
#define XFPD_SLCR_SECURE_TZ_CTRL_XMPU_N_DEFVAL  0x1UL

/**
 * Register: XfpdSlcrSecureTzCtrl
 */
#define XFPD_SLCR_SECURE_TZ_CTRL    ( ( XFPD_SLCR_SECURE_BASEADDR ) + 0x0000010CUL )
#define XFPD_SLCR_SECURE_TZ_CTRL_RSTVAL   0x00000001UL

#define XFPD_SLCR_SECURE_TZ_CTRL_N_SHIFT   0UL
#define XFPD_SLCR_SECURE_TZ_CTRL_N_WIDTH   1UL
#define XFPD_SLCR_SECURE_TZ_CTRL_N_MASK    0x00000001UL
#define XFPD_SLCR_SECURE_TZ_CTRL_N_DEFVAL  0x1UL

/**
 * Register: XfpdSlcrSecureTzCtrlCrf
 */
#define XFPD_SLCR_SECURE_TZ_CTRL_CRF    ( ( XFPD_SLCR_SECURE_BASEADDR ) + 0x00000110UL )
#define XFPD_SLCR_SECURE_TZ_CTRL_CRF_RSTVAL   0x00000001UL

#define XFPD_SLCR_SECURE_TZ_CTRL_CRF_N_SHIFT   0UL
#define XFPD_SLCR_SECURE_TZ_CTRL_CRF_N_WIDTH   1UL
#define XFPD_SLCR_SECURE_TZ_CTRL_CRF_N_MASK    0x00000001UL
#define XFPD_SLCR_SECURE_TZ_CTRL_CRF_N_DEFVAL  0x1UL

/**
 * Register: XfpdSlcrSecureTzCtrlAfifm0
 */
#define XFPD_SLCR_SECURE_TZ_CTRL_AFIFM0    ( ( XFPD_SLCR_SECURE_BASEADDR ) + 0x00000114UL )
#define XFPD_SLCR_SECURE_TZ_CTRL_AFIFM0_RSTVAL   0x00000001UL

#define XFPD_SLCR_SECURE_TZ_CTRL_AFIFM0_AXI_N_SHIFT   0UL
#define XFPD_SLCR_SECURE_TZ_CTRL_AFIFM0_AXI_N_WIDTH   1UL
#define XFPD_SLCR_SECURE_TZ_CTRL_AFIFM0_AXI_N_MASK    0x00000001UL
#define XFPD_SLCR_SECURE_TZ_CTRL_AFIFM0_AXI_N_DEFVAL  0x1UL

/**
 * Register: XfpdSlcrSecureTzCtrlAfifm2
 */
#define XFPD_SLCR_SECURE_TZ_CTRL_AFIFM2    ( ( XFPD_SLCR_SECURE_BASEADDR ) + 0x00000118UL )
#define XFPD_SLCR_SECURE_TZ_CTRL_AFIFM2_RSTVAL   0x00000001UL

#define XFPD_SLCR_SECURE_TZ_CTRL_AFIFM2_AXI_N_SHIFT   0UL
#define XFPD_SLCR_SECURE_TZ_CTRL_AFIFM2_AXI_N_WIDTH   1UL
#define XFPD_SLCR_SECURE_TZ_CTRL_AFIFM2_AXI_N_MASK    0x00000001UL
#define XFPD_SLCR_SECURE_TZ_CTRL_AFIFM2_AXI_N_DEFVAL  0x1UL

/**
 * Register: XfpdSlcrSecureTzCtrlCci
 */
#define XFPD_SLCR_SECURE_TZ_CTRL_CCI    ( ( XFPD_SLCR_SECURE_BASEADDR ) + 0x0000011CUL )
#define XFPD_SLCR_SECURE_TZ_CTRL_CCI_RSTVAL   0x00000001UL

#define XFPD_SLCR_SECURE_TZ_CTRL_CCI_N_SHIFT   0UL
#define XFPD_SLCR_SECURE_TZ_CTRL_CCI_N_WIDTH   1UL
#define XFPD_SLCR_SECURE_TZ_CTRL_CCI_N_MASK    0x00000001UL
#define XFPD_SLCR_SECURE_TZ_CTRL_CCI_N_DEFVAL  0x1UL

/**
 * Register: XfpdSlcrSecureTzCtrlSmmu
 */
#define XFPD_SLCR_SECURE_TZ_CTRL_SMMU    ( ( XFPD_SLCR_SECURE_BASEADDR ) + 0x00000120UL )
#define XFPD_SLCR_SECURE_TZ_CTRL_SMMU_RSTVAL   0x00000001UL

#define XFPD_SLCR_SECURE_TZ_CTRL_SMMU_N_SHIFT   0UL
#define XFPD_SLCR_SECURE_TZ_CTRL_SMMU_N_WIDTH   1UL
#define XFPD_SLCR_SECURE_TZ_CTRL_SMMU_N_MASK    0x00000001UL
#define XFPD_SLCR_SECURE_TZ_CTRL_SMMU_N_DEFVAL  0x1UL

/**
 * Register: XfpdSlcrSecureTzprot
 */
#define XFPD_SLCR_SECURE_TZPROT    ( ( XFPD_SLCR_SECURE_BASEADDR ) + 0x00000FF8UL )
#define XFPD_SLCR_SECURE_TZPROT_RSTVAL   0x00000000UL

#define XFPD_SLCR_SECURE_TZPROT_ACT_SHIFT   0UL
#define XFPD_SLCR_SECURE_TZPROT_ACT_WIDTH   1UL
#define XFPD_SLCR_SECURE_TZPROT_ACT_MASK    0x00000001UL
#define XFPD_SLCR_SECURE_TZPROT_ACT_DEFVAL  0x0UL

/**
 *@endcond
 */

#ifdef __cplusplus
}
#endif

#endif /* __XFPD_SLCR_SECURE_H__ */
